/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.debugger.impl.shared.engine;

import com.intellij.java.debugger.impl.shared.engine.JavaValueTextModificationPreparatorKt;
import com.intellij.xdebugger.frame.XDescriptor;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueTextModificationPreparator;
import com.intellij.xdebugger.frame.XValueTextModificationPreparatorProvider;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/java/debugger/impl/shared/engine/JavaValueTextModificationPreparatorProvider;", "Lcom/intellij/xdebugger/frame/XValueTextModificationPreparatorProvider;", "<init>", "()V", "getTextValuePreparator", "Lcom/intellij/xdebugger/frame/XValueTextModificationPreparator;", "value", "Lcom/intellij/xdebugger/frame/XValue;", "JavaPreparator", "intellij.java.debugger.impl.shared"})
public final class JavaValueTextModificationPreparatorProvider
implements XValueTextModificationPreparatorProvider {
    @Nullable
    public XValueTextModificationPreparator getTextValuePreparator(@NotNull XValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CompletableFuture completableFuture = value.getXValueDescriptorAsync();
        if (Intrinsics.areEqual(completableFuture != null && (completableFuture = (XDescriptor)completableFuture.getNow(null)) != null ? completableFuture.getKind() : null, (Object)"JavaValue")) {
            XValueTextProvider xValueTextProvider = value instanceof XValueTextProvider ? (XValueTextProvider)value : null;
            boolean bl = xValueTextProvider != null ? xValueTextProvider.shouldShowTextValue() : false;
            if (bl && value.getModifier() != null) {
                return JavaPreparator.INSTANCE;
            }
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/java/debugger/impl/shared/engine/JavaValueTextModificationPreparatorProvider$JavaPreparator;", "Lcom/intellij/xdebugger/frame/XValueTextModificationPreparator;", "<init>", "()V", "convertToStringLiteral", "", "text", "intellij.java.debugger.impl.shared"})
    private static final class JavaPreparator
    implements XValueTextModificationPreparator {
        @NotNull
        public static final JavaPreparator INSTANCE = new JavaPreparator();

        private JavaPreparator() {
        }

        @NotNull
        public String convertToStringLiteral(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return JavaValueTextModificationPreparatorKt.convertToJavaStringLiteral(text);
        }
    }
}

