/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavadocHelper {
    private static final Pair<JavadocParameterInfo, List<JavadocParameterInfo>> EMPTY = new Pair(null, Collections.emptyList());
    private static final String PARAM_TEXT = "param";

    private JavadocHelper() {
    }

    private static boolean getJdAlignParamComments(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JavadocHelper.$$$reportNull$$$0(0);
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)psiFile);
        return ((JavaCodeStyleSettings)codeStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).JD_ALIGN_PARAM_COMMENTS;
    }

    public static void navigate(@NotNull LogicalPosition position, @NotNull Editor editor, @NotNull Project project) {
        if (position == null) {
            JavadocHelper.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            JavadocHelper.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JavadocHelper.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int endLineOffset = document.getLineEndOffset(position.line);
        LogicalPosition endLinePosition = editor.offsetToLogicalPosition(endLineOffset);
        if (endLinePosition.column < position.column && !editor.getSettings().isVirtualSpace() && !editor.isViewer()) {
            String toInsert = StringUtil.repeat((String)" ", (int)(position.column - endLinePosition.column));
            ApplicationManager.getApplication().runWriteAction(() -> {
                document.insertString(endLineOffset, (CharSequence)toInsert);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            });
        }
        caretModel.moveToLogicalPosition(position);
    }

    @NotNull
    public static LogicalPosition calculateDescriptionStartPosition(@NotNull PsiFile psiFile, @NotNull Collection<? extends JavadocParameterInfo> data, @NotNull JavadocParameterInfo anchor) {
        int column;
        if (psiFile == null) {
            JavadocHelper.$$$reportNull$$$0(4);
        }
        if (data == null) {
            JavadocHelper.$$$reportNull$$$0(5);
        }
        if (anchor == null) {
            JavadocHelper.$$$reportNull$$$0(6);
        }
        int descriptionStartColumn = -1;
        int parameterNameEndColumn = -1;
        for (JavadocParameterInfo javadocParameterInfo : data) {
            parameterNameEndColumn = Math.max(parameterNameEndColumn, javadocParameterInfo.parameterNameEndPosition.column);
            if (javadocParameterInfo.parameterDescriptionStartPosition == null) continue;
            descriptionStartColumn = Math.max(descriptionStartColumn, javadocParameterInfo.parameterDescriptionStartPosition.column);
        }
        if (JavadocHelper.getJdAlignParamComments(psiFile)) {
            column = Math.max(descriptionStartColumn, parameterNameEndColumn);
            if (column <= parameterNameEndColumn) {
                column = parameterNameEndColumn + 1;
            }
        } else {
            column = anchor.parameterNameEndPosition.column + 1;
        }
        return new LogicalPosition(anchor.parameterNameEndPosition.line, column);
    }

    @NotNull
    public static Pair<JavadocParameterInfo, List<JavadocParameterInfo>> parse(@NotNull PsiFile psiFile, @NotNull Editor editor, int offset) {
        JavadocParameterInfo info;
        PsiElement e;
        if (psiFile == null) {
            JavadocHelper.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            JavadocHelper.$$$reportNull$$$0(8);
        }
        ArrayList<JavadocParameterInfo> result = new ArrayList<JavadocParameterInfo>();
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(editor.getDocument());
        PsiElement elementAtCaret = psiFile.findElementAt(offset);
        if (elementAtCaret == null) {
            Pair<JavadocParameterInfo, List<JavadocParameterInfo>> pair = EMPTY;
            if (pair == null) {
                JavadocHelper.$$$reportNull$$$0(9);
            }
            return pair;
        }
        PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PsiDocTag.class);
        if (tag == null && elementAtCaret instanceof PsiWhiteSpace) {
            for (PsiElement e2 = elementAtCaret.getPrevSibling(); e2 != null && tag == null; e2 = e2.getPrevSibling()) {
                tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)e2, PsiDocTag.class, (boolean)false);
                if (!(e2 instanceof PsiWhiteSpace) && (!(e2 instanceof PsiDocToken) || ((PsiDocToken)e2).getTokenType() != JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS)) break;
            }
        }
        if (tag == null) {
            Pair<JavadocParameterInfo, List<JavadocParameterInfo>> pair = EMPTY;
            if (pair == null) {
                JavadocHelper.$$$reportNull$$$0(10);
            }
            return pair;
        }
        JavadocParameterInfo anchorInfo = JavadocHelper.parse(tag, editor);
        if (anchorInfo == null) {
            Pair<JavadocParameterInfo, List<JavadocParameterInfo>> pair = EMPTY;
            if (pair == null) {
                JavadocHelper.$$$reportNull$$$0(11);
            }
            return pair;
        }
        for (e = tag.getPrevSibling(); e != null && (info = JavadocHelper.parse(e, editor)) != null; e = e.getPrevSibling()) {
            result.addFirst(info);
        }
        result.add(anchorInfo);
        for (e = tag.getNextSibling(); e != null && (info = JavadocHelper.parse(e, editor)) != null; e = e.getNextSibling()) {
            result.add(info);
        }
        Pair pair = Pair.create((Object)anchorInfo, result);
        if (pair == null) {
            JavadocHelper.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @Nullable
    private static JavadocParameterInfo parse(@NotNull PsiElement element, @NotNull Editor editor) {
        ASTNode node;
        PsiDocTag tag;
        if (element == null) {
            JavadocHelper.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            JavadocHelper.$$$reportNull$$$0(14);
        }
        if ((tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class, (boolean)false)) == null || !PARAM_TEXT.equals(tag.getName())) {
            return null;
        }
        PsiDocTagValue paramRef = (PsiDocTagValue)PsiTreeUtil.getChildOfType((PsiElement)tag, PsiDocTagValue.class);
        if (paramRef == null) {
            return null;
        }
        for (PsiElement e = paramRef.getNextSibling(); e != null && (node = e.getNode()) != null; e = e.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == JavaDocTokenType.DOC_COMMENT_DATA) {
                return new JavadocParameterInfo(editor.offsetToLogicalPosition(paramRef.getTextRange().getEndOffset()), editor.offsetToLogicalPosition(e.getTextRange().getStartOffset()), editor.getDocument().getLineNumber(e.getTextRange().getEndOffset()));
            }
            if (elementType == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) break;
        }
        return new JavadocParameterInfo(editor.offsetToLogicalPosition(paramRef.getTextRange().getEndOffset()), null, editor.getDocument().getLineNumber(paramRef.getTextRange().getEndOffset()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javadoc/JavadocHelper";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javadoc/JavadocHelper";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdAlignParamComments";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateDescriptionStartPosition";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static class JavadocParameterInfo {
        @NotNull
        public final LogicalPosition parameterNameEndPosition;
        @Nullable
        public final LogicalPosition parameterDescriptionStartPosition;
        public final int lastLine;

        public JavadocParameterInfo(@NotNull LogicalPosition parameterNameEndPosition, @Nullable LogicalPosition parameterDescriptionStartPosition, int lastLine) {
            if (parameterNameEndPosition == null) {
                JavadocParameterInfo.$$$reportNull$$$0(0);
            }
            this.parameterNameEndPosition = parameterNameEndPosition;
            this.parameterDescriptionStartPosition = parameterDescriptionStartPosition;
            this.lastLine = lastLine;
        }

        public String toString() {
            return "name end: " + String.valueOf(this.parameterNameEndPosition) + ", description start: " + String.valueOf(this.parameterDescriptionStartPosition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterNameEndPosition", "com/intellij/javadoc/JavadocHelper$JavadocParameterInfo", "<init>"));
        }
    }
}

