/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.export;

import com.intellij.util.PlatformUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\b\u0010\f\u001a\u00020\u0006H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/uml/export/OpenDiagramInWebEditorService;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "diagramContentForNextRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "", "registerDiagramForNextRequest", "diagramContent", "serviceUrl", "getServiceUrl", "()Ljava/lang/String;", "getServiceName", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "buildPage", "diagramXml", "Companion", "intellij.diagram.impl"})
public final class OpenDiagramInWebEditorService
extends RestService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<String> diagramContentForNextRequest = new AtomicReference();
    @NotNull
    public static final String SERVICE_NAME = "open-diagram-in-web-editor";

    @NotNull
    public final String registerDiagramForNextRequest(@NotNull String diagramContent) {
        Intrinsics.checkNotNullParameter((Object)diagramContent, (String)"diagramContent");
        this.diagramContentForNextRequest.set(diagramContent);
        return this.getServiceUrl();
    }

    private final String getServiceUrl() {
        return "http://localhost:" + BuiltInServerManager.Companion.getInstance().getPort() + "/api/open-diagram-in-web-editor";
    }

    @NotNull
    protected String getServiceName() {
        return SERVICE_NAME;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.diagramContentForNextRequest.get() != null && super.isAccessible(request);
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object v0 = this.diagramContentForNextRequest.getAndSet(null);
        Intrinsics.checkNotNull(v0);
        String diagramContent = v0;
        String string = this.buildPage(diagramContent);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] response = byArray;
        RestService.Companion.sendResponse((HttpRequest)request, context, (HttpResponse)Responses.response((String)"text/html", (ByteBuf)Unpooled.wrappedBuffer((byte[])response)));
        return null;
    }

    private final String buildPage(String diagramXml) {
        return StringsKt.trimIndent((String)("\n      <html>\n      <head>\n        <link rel=\"preconnect\" href=\"https://fonts.gstatic.com\"/>\n        <link href=\"https://fonts.googleapis.com/css2?family=JetBrains+Mono&display=swap\" rel=\"stylesheet\" />\n        <style> \n           html { padding: 2em; }\n           body { font-family: 'JetBrains Mono', monospace; }\n           .description { font-size: 1.2em; }\n           .url_address { font-size: 1.4em; }\n        </style>\n      </head>\n      \n      <body style='padding: 3em;'>\n         <h1> Loading the diagram to the <a href=\"https://www.yworks.com/yed-live/\">yEd Live</a>...</h1>\n         \n         <p class='description'>\n           If the page does not appear shortly, please, allow the browser to open popup windows from this page.\n         </p>\n         <p class='description'>\n           yEd Live will ask you if you trust the source:\n           the IDEA embedded web server works on the address\n         </p>\n         <p class='url_address'>\n           <code>http://localhost:" + BuiltInServerManager.Companion.getInstance().getPort() + "</code>.\n         </p>\n         \n         <script id=\"diagram_content\" type=\"text/xmldata\">" + diagramXml + "</script>\n        \n         <script>\n           const APPLICATION_NAME = '" + PlatformUtils.getPlatformPrefix() + "-exported-diagram';\n           const YED_LIVE_URL = 'https://www.yworks.com/yed-live/';\n           const OPEN_DIAGRAM_EVENT_NAME = 'message';\n           const DIAGRAM_CONTENT_ELEMENT_ID = 'diagram_content';\n       \n           // try open yEd Live, this must be closely after the user interaction with the button...\n           const yedLive = window.open(YED_LIVE_URL);\n       \n           // ... and wait for page load before sending the data ('yed-live-listening')\n           const messageHandler = async (e) => {\n             if (\n               YED_LIVE_URL.startsWith(e.origin) &&\n               e.data === 'yed-live-listening'\n             ) {\n               // signal an upcoming graphml (graphml creation might take some time...)\n               // *** this is optional and just triggers a loading animation in the 'trusted source dialog' when opening from external source\n               yedLive.postMessage(\n                 {\n                   source: APPLICATION_NAME, // a hint to where it came from (we determine a document name from it currently...)\n                   sending: true,\n                 },\n                 YED_LIVE_URL\n               );\n       \n               // send the actual graphml\n               setTimeout(async () => {\n                 yedLive.postMessage(\n                   {\n                     source: APPLICATION_NAME, // a hint to where it came from (we determine a document name from it currently...)\n                     graphml: document.getElementById(DIAGRAM_CONTENT_ELEMENT_ID).innerHTML,\n                   },\n                   YED_LIVE_URL\n                 );\n                 window.close();\n               }, 500);\n             }\n             window.removeEventListener(OPEN_DIAGRAM_EVENT_NAME, messageHandler);\n           }\n           window.addEventListener(OPEN_DIAGRAM_EVENT_NAME, messageHandler);\n         </script>\n         \n      </body>\n      \n      </html>\n    "));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/uml/export/OpenDiagramInWebEditorService$Companion;", "", "<init>", "()V", "SERVICE_NAME", "", "getInstance", "Lcom/intellij/uml/export/OpenDiagramInWebEditorService;", "intellij.diagram.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OpenDiagramInWebEditorService getInstance() {
            Object object = HttpRequestHandler.Companion.getEP_NAME().findExtension(OpenDiagramInWebEditorService.class);
            Intrinsics.checkNotNull((Object)object);
            return (OpenDiagramInWebEditorService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

