/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.v2.handles;

import com.intellij.diagram.v2.handles.GraphChartUpdateHandle;
import com.intellij.diagram.v2.layout.GraphChartLayouter;
import com.intellij.diagram.v2.tweaks.GraphChartMutableViewSettings;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.uml.v2.handles.GraphChartHandleImpl;
import com.intellij.uml.v2.handles.GraphChartUpdateHandleImplKt;
import com.intellij.uml.v2.handles.GraphChartViewHandleImpl;
import com.intellij.uml.v2.layout.GraphChartLayoutServiceImplKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\r\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0017J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/uml/v2/handles/GraphChartLayoutQueryParamsImpl;", "N", "", "E", "Lcom/intellij/diagram/v2/handles/GraphChartUpdateHandle$GraphChartLayoutQueryParams;", "myMainHandle", "Lcom/intellij/uml/v2/handles/GraphChartHandleImpl;", "<init>", "(Lcom/intellij/uml/v2/handles/GraphChartHandleImpl;)V", "layouter", "Lcom/intellij/diagram/v2/layout/GraphChartLayouter;", "isAnimated", "", "animationDurationMillis", "", "fitContentOption", "Lcom/intellij/diagram/v2/handles/GraphChartUpdateHandle$GraphChartLayoutQueryParams$FitContentOption;", "myIsSealed", "animated", "withAnimationDuration", "durationMillis", "withLayouter", "withFitContent", "fitContent", "seal", "", "buildGraphLayoutServiceQuery", "Lcom/intellij/openapi/graph/services/GraphLayoutService$GraphLayoutQueryParams;", "Lorg/jetbrains/annotations/NotNull;", "run", "runAsync", "Ljava/util/concurrent/CompletionStage;", "Ljava/lang/Void;", "intellij.diagram.impl"})
final class GraphChartLayoutQueryParamsImpl<N, E>
implements GraphChartUpdateHandle.GraphChartLayoutQueryParams<N, E> {
    @NotNull
    private final GraphChartHandleImpl<N, E> myMainHandle;
    @NotNull
    private GraphChartLayouter layouter;
    private boolean isAnimated;
    private int animationDurationMillis;
    @NotNull
    private GraphChartUpdateHandle.GraphChartLayoutQueryParams.FitContentOption fitContentOption;
    private boolean myIsSealed;

    public GraphChartLayoutQueryParamsImpl(@NotNull GraphChartHandleImpl<N, E> myMainHandle) {
        Intrinsics.checkNotNullParameter(myMainHandle, (String)"myMainHandle");
        this.myMainHandle = myMainHandle;
        this.animationDurationMillis = GraphAnimationService.getInstance().getLayoutAnimationDuration();
        GraphChartMutableViewSettings viewSettings = ((GraphChartViewHandleImpl)this.myMainHandle.asViewHandle()).getChartViewSettings();
        GraphChartLayouter graphChartLayouter = viewSettings.getCurrentLayouter();
        Intrinsics.checkNotNullExpressionValue((Object)graphChartLayouter, (String)"getCurrentLayouter(...)");
        this.layouter = graphChartLayouter;
        this.fitContentOption = viewSettings.doFitContentAfterLayout() ? GraphChartUpdateHandle.GraphChartLayoutQueryParams.FitContentOption.AFTER : GraphChartUpdateHandle.GraphChartLayoutQueryParams.FitContentOption.NEVER;
    }

    @Override
    @NotNull
    public GraphChartUpdateHandle.GraphChartLayoutQueryParams<N, E> animated() {
        if (!(!this.myIsSealed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.isAnimated = true;
        return this;
    }

    @Override
    @NotNull
    public GraphChartUpdateHandle.GraphChartLayoutQueryParams<N, E> withAnimationDuration(int durationMillis) {
        if (!(!this.myIsSealed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= durationMillis)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.animationDurationMillis = durationMillis;
        return this;
    }

    @Override
    @NotNull
    public GraphChartUpdateHandle.GraphChartLayoutQueryParams<N, E> withLayouter(@NotNull GraphChartLayouter layouter) {
        Intrinsics.checkNotNullParameter((Object)layouter, (String)"layouter");
        if (!(!this.myIsSealed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.layouter = layouter;
        return this;
    }

    @Override
    @NotNull
    public GraphChartUpdateHandle.GraphChartLayoutQueryParams<N, E> withFitContent(@NotNull GraphChartUpdateHandle.GraphChartLayoutQueryParams.FitContentOption fitContent) {
        Intrinsics.checkNotNullParameter((Object)((Object)fitContent), (String)"fitContent");
        if (!(!this.myIsSealed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.fitContentOption = fitContent;
        return this;
    }

    private final void seal() {
        this.myIsSealed = true;
    }

    private final GraphLayoutService.GraphLayoutQueryParams buildGraphLayoutServiceQuery() {
        GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams = GraphLayoutService.getInstance().queryLayout(this.myMainHandle.getDiagramHandle().getGraphBuilder()).withLayouter(GraphChartLayoutServiceImplKt.getAsGraphLayouter(this.layouter)).animatedIf(this.isAnimated).withAnimationDuration(this.animationDurationMillis).withFitContent(GraphChartUpdateHandleImplKt.access$toGraphLayoutOption(this.fitContentOption));
        Intrinsics.checkNotNullExpressionValue((Object)graphLayoutQueryParams, (String)"withFitContent(...)");
        return graphLayoutQueryParams;
    }

    @Override
    @RequiresEdt
    public void run() {
        this.seal();
        this.buildGraphLayoutServiceQuery().run();
    }

    @Override
    @NotNull
    public CompletionStage<Void> runAsync() {
        this.seal();
        CompletableFuture completableFuture = this.buildGraphLayoutServiceQuery().runAsync();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }
}

