/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.debugger.engine;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JSR45PositionManager;
import com.intellij.debugger.engine.SourcesFinder;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.deployment.JspDeploymentManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.JspFileTypeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultJSPPositionManager
extends JSR45PositionManager<JavaeeFacet[]> {
    @NonNls
    private static final String JSP_STRATUM = "JSP";

    public DefaultJSPPositionManager(DebugProcess debugProcess, JavaeeFacet[] scope) {
        super(debugProcess, (Object)scope, JSP_STRATUM, (SourcesFinder)new SourceFinderAdapter());
    }

    public boolean isAcceptedFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            DefaultJSPPositionManager.$$$reportNull$$$0(0);
        }
        return JspFileTypeUtil.isJspOrJspX((FileType)fileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/javaee/web/debugger/engine/DefaultJSPPositionManager", "isAcceptedFileType"));
    }

    private static final class SourceFinderAdapter
    implements SourcesFinder<JavaeeFacet[]> {
        private final JspDeploymentManager myJspDeploymentManager = JspDeploymentManager.getInstance();

        SourceFinderAdapter() {
        }

        @Nullable
        public PsiFile findSourceFile(String relPath, Project project, JavaeeFacet[] scope) {
            if (SourceFinderAdapter.isJava(relPath)) {
                return null;
            }
            return this.myJspDeploymentManager.getDeployedJspSource(relPath, project, scope);
        }

        private static boolean isJava(String relPath) {
            for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations((FileType)StdFileTypes.JAVA)) {
                if (!matcher.acceptsCharSequence((CharSequence)relPath)) continue;
                return true;
            }
            return false;
        }
    }
}

