/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionUtil;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UMethod;

public class SpringMVCInitBinderInspection
extends SpringUastInspectionBase {
    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiMethod javaPsiMethod;
        if (method == null) {
            SpringMVCInitBinderInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringMVCInitBinderInspection.$$$reportNull$$$0(1);
        }
        if (!SpringMVCInitBinderInspection.isRelevantMethod(javaPsiMethod = method.getJavaPsi())) {
            return null;
        }
        PsiClass containingClass = javaPsiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        if (!SpringControllerUtils.isController(containingClass)) {
            return null;
        }
        PsiAnnotation annotation = javaPsiMethod.getModifierList().findAnnotation("org.springframework.web.bind.annotation.InitBinder");
        assert (annotation != null);
        PsiElement annotationSource = SpringUastInspectionUtil.INSTANCE.convertToSourcePsi((PsiElement)annotation);
        if (annotationSource == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        return new ProblemDescriptor[]{manager.createProblemDescriptor(annotationSource, SpringMvcBundle.message("SpringMVCInitBinderInspection.method.annotated.with.initbinder.must.return.void", new Object[0]), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
    }

    private static boolean isRelevantMethod(PsiMethod method) {
        return method.hasModifierProperty("public") && !method.hasModifierProperty("static") && !PsiTypes.voidType().equals((Object)method.getReturnType()) && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.web.bind.annotation.InitBinder", (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/mvc/model/jam/SpringMVCInitBinderInspection";
        objectArray[2] = "checkMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

