/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.RainbowCollector;
import com.intellij.application.options.colors.RainbowStateChangeListener;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.Internal
public final class RainbowColorsInSchemeState {
    public static final String DEFAULT_LANGUAGE_NAME = "Default";
    private final EditorColorsScheme myEditedScheme;
    private final EditorColorsScheme myOriginalScheme;

    public RainbowColorsInSchemeState(@NotNull EditorColorsScheme editedScheme, @NotNull EditorColorsScheme originalScheme) {
        if (editedScheme == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(0);
        }
        if (originalScheme == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(1);
        }
        this.myEditedScheme = editedScheme;
        this.myOriginalScheme = originalScheme;
    }

    public void apply(@Nullable EditorColorsScheme scheme) {
        if (scheme != null && scheme != this.myEditedScheme) {
            RainbowHighlighter.transferRainbowState((SchemeMetaInfo)scheme, (SchemeMetaInfo)this.myEditedScheme);
            for (TextAttributesKey key : RainbowHighlighter.RAINBOW_COLOR_KEYS) {
                Color color = this.myEditedScheme.getAttributes(key).getForegroundColor();
                if (color.equals(scheme.getAttributes(key).getForegroundColor())) continue;
                scheme.setAttributes(key, RainbowHighlighter.createRainbowAttribute((Color)color));
            }
            RainbowColorsInSchemeState.updateRainbowMarkup(scheme, this);
        }
    }

    @ApiStatus.Internal
    public static void updateRainbowMarkup(@NotNull EditorColorsScheme scheme, @NotNull Object reason) {
        Editor[] allEditors;
        if (scheme == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(2);
        }
        if (reason == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(3);
        }
        Set<String> languagesWithRainbowHighlighting = RainbowColorsInSchemeState.getRainbowOnLanguageIds(scheme);
        RainbowColorsInSchemeState.reportStatistic(languagesWithRainbowHighlighting);
        RainbowHighlighter.resetRainbowGeneratedColors((TextAttributesScheme)scheme);
        ((RainbowStateChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RainbowStateChangeListener.getTOPIC())).onRainbowStateChanged(scheme, languagesWithRainbowHighlighting);
        for (Editor editor2 : allEditors = EditorFactory.getInstance().getAllEditors()) {
            PsiFile file2;
            Project project2 = editor2.getProject();
            if (project2 == null || (file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument())) == null) continue;
            DaemonCodeAnalyzer.getInstance((Project)project2).restart(file2, reason);
        }
    }

    private static void reportStatistic(@NotNull Set<String> languagesWithRainbowHighlighting) {
        if (languagesWithRainbowHighlighting == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(4);
        }
        TreeSet<String> logCopy = new TreeSet<String>(languagesWithRainbowHighlighting);
        boolean rainbowOnByDefault = logCopy.remove(DEFAULT_LANGUAGE_NAME);
        RainbowCollector.getRAINBOW_HIGHLIGHTER_CHANGED_EVENT().log((Object)rainbowOnByDefault, logCopy.stream().toList());
    }

    @NotNull
    private static @UnmodifiableView Set<String> getRainbowOnLanguageIds(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(5);
        }
        TreeSet rainbowOnLanguages = new TreeSet();
        ColorSettingsPage.EP_NAME.forEachExtensionSafe(it -> {
            Language language;
            RainbowColorSettingsPage rcp;
            if (it instanceof RainbowColorSettingsPage && RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)scheme, (Language)(rcp = (RainbowColorSettingsPage)it).getLanguage()) && (language = rcp.getLanguage()) != Language.ANY) {
                rainbowOnLanguages.add(language != null ? language.getID() : DEFAULT_LANGUAGE_NAME);
            }
        });
        Set<String> set = Collections.unmodifiableSet(rainbowOnLanguages);
        if (set == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(6);
        }
        return set;
    }

    public boolean isModified(@Nullable Language language) {
        return language == null && this.isRainbowColorsModified() || RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)this.myEditedScheme, (Language)language) != RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)this.myOriginalScheme, (Language)language);
    }

    private boolean isRainbowColorsModified() {
        for (TextAttributesKey key : RainbowHighlighter.RAINBOW_COLOR_KEYS) {
            if (this.myEditedScheme.getAttributes(key).equals((Object)this.myOriginalScheme.getAttributes(key))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedScheme";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScheme";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languagesWithRainbowHighlighting";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/RainbowColorsInSchemeState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/RainbowColorsInSchemeState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRainbowOnLanguageIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateRainbowMarkup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportStatistic";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRainbowOnLanguageIds";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

