/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.histogram;

import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import com.intellij.diagnostic.hprof.visitors.HistogramVisitor;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "", "entries", "", "Lcom/intellij/diagnostic/hprof/histogram/HistogramEntry;", "instanceCount", "", "<init>", "(Ljava/util/List;J)V", "getEntries", "()Ljava/util/List;", "getInstanceCount", "()J", "getTotals", "Lkotlin/Pair;", "bytesCount", "getBytesCount", "prepareReport", "", "name", "topClassCount", "", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHistogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Histogram.kt\ncom/intellij/diagnostic/hprof/histogram/Histogram\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1915#2,2:151\n1915#2,2:153\n1080#2:155\n*S KotlinDebug\n*F\n+ 1 Histogram.kt\ncom/intellij/diagnostic/hprof/histogram/Histogram\n*L\n32#1:151,2\n48#1:153,2\n56#1:155\n*E\n"})
public final class Histogram {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<HistogramEntry> entries;
    private final long instanceCount;
    private final long bytesCount;

    public Histogram(@NotNull List<HistogramEntry> entries2, long instanceCount) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        this.entries = entries2;
        this.instanceCount = instanceCount;
        this.bytesCount = ((Number)this.getTotals().getSecond()).longValue();
    }

    @NotNull
    public final List<HistogramEntry> getEntries() {
        return this.entries;
    }

    public final long getInstanceCount() {
        return this.instanceCount;
    }

    private final Pair<Long, Long> getTotals() {
        long totalInstances = 0L;
        long totalBytes = 0L;
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistogramEntry it = (HistogramEntry)element$iv;
            boolean bl = false;
            totalBytes += it.getTotalBytes();
            totalInstances += it.getTotalInstances();
        }
        return new Pair((Object)totalInstances, (Object)totalBytes);
    }

    public final long getBytesCount() {
        return this.bytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String prepareReport(@NotNull String name2, int topClassCount) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        StringBuilder result2 = new StringBuilder();
        result2.append("Histogram. Top " + topClassCount + " by instance count:").append('\n');
        Function1 appendToResult = arg_0 -> Histogram.prepareReport$lambda$0(result2, arg_0);
        int counter = 0;
        counter = 1;
        Closeable closeable = new TruncatingPrintBuffer(topClassCount, 0, (Function1<? super String, ? extends Object>)appendToResult);
        Throwable throwable = null;
        try {
            TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = this.entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry entry = (HistogramEntry)element$iv;
                boolean bl2 = false;
                buffer2.println(Histogram.Companion.formatEntryLine(counter, entry));
                ++counter;
            }
            buffer2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        result2.append(Histogram.Companion.getSummaryLine(this, name2)).append('\n');
        result2.append('\n');
        result2.append("Top 10 by bytes count:").append('\n');
        Iterable $this$sortedByDescending$iv = this.entries;
        boolean $i$f$sortedByDescending = false;
        List entriesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
            }
        });
        for (int i2 = 0; i2 < 10; ++i2) {
            HistogramEntry entry = (HistogramEntry)entriesByBytes.get(i2);
            result2.append(Histogram.Companion.formatEntryLine(i2 + 1, entry)).append('\n');
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit prepareReport$lambda$0(StringBuilder $result, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        $result.append(s).append('\n');
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\"\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/diagnostic/hprof/histogram/Histogram$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "prepareMergedHistogramReport", "", "mainHistogram", "mainHistogramName", "secondaryHistogram", "secondaryHistogramName", "options", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$HistogramOptions;", "getSummaryLine", "histogram", "histogramName", "formatEntryLineMerged", "counter", "", "entry", "Lcom/intellij/diagnostic/hprof/histogram/HistogramEntry;", "entry2", "formatEntryLine", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nHistogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Histogram.kt\ncom/intellij/diagnostic/hprof/histogram/Histogram$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1915#2,2:151\n1915#2,2:153\n1080#2:155\n*S KotlinDebug\n*F\n+ 1 Histogram.kt\ncom/intellij/diagnostic/hprof/histogram/Histogram$Companion\n*L\n78#1:151,2\n90#1:153,2\n106#1:155\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Histogram create(@NotNull HProfEventBasedParser parser, @NotNull ClassStore classStore) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
            HistogramVisitor histogramVisitor = new HistogramVisitor(classStore);
            parser.accept(histogramVisitor, "histogram");
            return histogramVisitor.createHistogram();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String prepareMergedHistogramReport(@NotNull Histogram mainHistogram, @NotNull String mainHistogramName, @NotNull Histogram secondaryHistogram, @NotNull String secondaryHistogramName, @NotNull AnalysisConfig.HistogramOptions options2) {
            Intrinsics.checkNotNullParameter((Object)mainHistogram, (String)"mainHistogram");
            Intrinsics.checkNotNullParameter((Object)mainHistogramName, (String)"mainHistogramName");
            Intrinsics.checkNotNullParameter((Object)secondaryHistogram, (String)"secondaryHistogram");
            Intrinsics.checkNotNullParameter((Object)secondaryHistogramName, (String)"secondaryHistogramName");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            StringBuilder result2 = new StringBuilder();
            Function1 appendToResult = arg_0 -> Companion.prepareMergedHistogramReport$lambda$0(result2, arg_0);
            HashMap mapClassNameToEntrySecondary = new HashMap();
            Iterable $this$forEach$iv = secondaryHistogram.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry it = (HistogramEntry)element$iv;
                boolean bl = false;
                ((Map)mapClassNameToEntrySecondary).put(it.getClassDefinition().getName(), it);
            }
            String summary = this.getSummaryLine(mainHistogram, mainHistogramName) + "\n" + this.getSummaryLine(secondaryHistogram, secondaryHistogramName);
            if (options2.getIncludeByCount()) {
                Object element$iv;
                result2.append("Histogram. Top " + options2.getClassByCountLimit() + " by instance count [All-objects] [Only-strong-ref]:").append('\n');
                int counter = 0;
                counter = 1;
                Closeable closeable = new TruncatingPrintBuffer(options2.getClassByCountLimit(), 0, (Function1<? super String, ? extends Object>)appendToResult);
                element$iv = null;
                try {
                    TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)closeable;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = mainHistogram.getEntries();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        HistogramEntry entry = (HistogramEntry)element$iv2;
                        boolean bl2 = false;
                        HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                        buffer2.println(Companion.formatEntryLineMerged(counter, entry, entry2));
                        ++counter;
                    }
                    buffer2 = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    element$iv = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, element$iv);
                }
                result2.append(summary).append('\n');
            }
            if (options2.getIncludeBySize() && options2.getIncludeByCount()) {
                result2.append('\n');
            }
            if (options2.getIncludeBySize()) {
                int classCountInByBytesSection = Math.min(mainHistogram.getEntries().size(), options2.getClassBySizeLimit());
                result2.append("Top " + classCountInByBytesSection + " by size:").append('\n');
                Iterable $this$sortedByDescending$iv = mainHistogram.getEntries();
                boolean $i$f$sortedByDescending = false;
                List entriesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistogramEntry it = (HistogramEntry)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTotalBytes());
                        it = (HistogramEntry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
                    }
                });
                for (int i2 = 0; i2 < classCountInByBytesSection; ++i2) {
                    HistogramEntry entry = (HistogramEntry)entriesByBytes.get(i2);
                    HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                    result2.append(this.formatEntryLineMerged(i2 + 1, entry, entry2)).append('\n');
                }
                if (!options2.getIncludeByCount()) {
                    result2.append(summary).append('\n');
                }
            }
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String getSummaryLine(Histogram histogram, String histogramName) {
            Pair pair = histogram.getTotals();
            long totalInstances = ((Number)pair.component1()).longValue();
            long totalBytes = ((Number)pair.component2()).longValue();
            String string = "Total - %10s: %s %s %d classes (Total instances: %d)";
            Object[] objectArray = new Object[]{histogramName, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(totalInstances), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(totalBytes), histogram.getEntries().size(), histogram.getInstanceCount()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        private final String formatEntryLineMerged(int counter, HistogramEntry entry, HistogramEntry entry2) {
            String string = "%5d: [%s/%s] [%s/%s] %s";
            Object[] objectArray = new Object[6];
            objectArray[0] = counter;
            objectArray[1] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances());
            objectArray[2] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes());
            HistogramEntry histogramEntry = entry2;
            objectArray[3] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(histogramEntry != null ? histogramEntry.getTotalInstances() : 0L);
            HistogramEntry histogramEntry2 = entry2;
            objectArray[4] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(histogramEntry2 != null ? histogramEntry2.getTotalBytes() : 0L);
            objectArray[5] = entry.getClassDefinition().getPrettyName();
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        private final String formatEntryLine(int counter, HistogramEntry entry) {
            String string = "%5d: [%s/%s] %s";
            Object[] objectArray = new Object[]{counter, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances()), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes()), entry.getClassDefinition().getPrettyName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        private static final Unit prepareMergedHistogramReport$lambda$0(StringBuilder $result, String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            $result.append(s).append('\n');
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

