/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logs;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.logs.DebugLogLevel;
import com.intellij.diagnostic.logs.LogCategory;
import com.intellij.diagnostic.logs.LogCategory$;
import com.intellij.diagnostic.logs.LogLevelConfigurationManager;
import com.intellij.diagnostic.logs.LogLevelConfigurationManager$State$;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.SerializablePersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashSetSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@com.intellij.openapi.components.State(name="Logs.Categories", storages={@Storage(value="log-categories.xml", usePathMacroManager=false)}, reportStatistic=false, useLoadedStateAsExisting=false)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0006\b\u0007\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004./01B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0007J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0014\u0010\u0012\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0007J\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\"\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001c0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010$\u001a\u00020\rH\u0002J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0017J\b\u0010'\u001a\u00020\rH\u0016J\b\u0010(\u001a\u00020\u0002H\u0002J \u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,2\b\u0010*\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00102\b\u0010*\u001a\u0004\u0018\u00010\u0007H\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager;", "Lcom/intellij/openapi/components/SerializablePersistentStateComponent;", "Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$State;", "<init>", "()V", "customizedLoggers", "Ljava/util/HashMap;", "", "Ljava/util/logging/Logger;", "Lkotlin/collections/HashMap;", "lock", "Ljava/lang/Object;", "setCategories", "", "state", "categories", "", "Lcom/intellij/diagnostic/logs/LogCategory;", "addCategories", "toTrimmed", "getJulLoggerFromCache", "category", "applyState", "addLogger", "trimmed", "loggerLevel", "Ljava/util/logging/Level;", "level", "Lcom/intellij/diagnostic/logs/DebugLogLevel;", "setSeparateFile", "logger", "enable", "", "updatedCategoriesToLevel", "", "categoriesToUpdate", "cleanCurrentCategories", "getCategories", "loadState", "noStateLoaded", "collectStateFromSystemProperties", "fromString", "text", "separateFileFromString", "", "splitCategories", "Companion", "Listener", "SeparateFileHandler", "State", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nLogLevelConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogLevelConfigurationManager.kt\ncom/intellij/diagnostic/logs/LogLevelConfigurationManager\n+ 2 SerializablePersistentStateComponent.kt\ncom/intellij/openapi/components/SerializablePersistentStateComponent\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,263:1\n91#2,11:264\n102#2,2:276\n91#2,11:305\n102#2,2:317\n1#3:275\n1#3:292\n1#3:316\n1#3:330\n221#4,2:278\n129#4:288\n158#4,3:289\n1586#5:280\n1661#5,3:281\n1586#5:284\n1661#5,3:285\n1205#5,2:293\n1282#5,4:295\n1205#5,2:299\n1282#5,4:301\n1642#5,10:319\n1915#5:329\n1916#5:331\n1652#5:332\n13#6:333\n*S KotlinDebug\n*F\n+ 1 LogLevelConfigurationManager.kt\ncom/intellij/diagnostic/logs/LogLevelConfigurationManager\n*L\n75#1:264,11\n75#1:276,2\n201#1:305,11\n201#1:317,2\n75#1:275\n201#1:316\n244#1:330\n90#1:278,2\n112#1:288\n112#1:289,3\n102#1:280\n102#1:281,3\n103#1:284\n103#1:285,3\n182#1:293,2\n182#1:295,4\n183#1:299,2\n183#1:301,4\n244#1:319,10\n244#1:329\n244#1:331\n244#1:332\n29#1:333\n*E\n"})
public final class LogLevelConfigurationManager
extends SerializablePersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, java.util.logging.Logger> customizedLoggers = new HashMap();
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String LOG_DEBUG_CATEGORIES_SYSTEM_PROPERTY = "idea.log.debug.categories";
    @NotNull
    public static final String LOG_TRACE_CATEGORIES_SYSTEM_PROPERTY = "idea.log.trace.categories";
    @NotNull
    public static final String LOG_ALL_CATEGORIES_SYSTEM_PROPERTY = "idea.log.all.categories";
    @NotNull
    public static final String LOG_SEPARATE_FILE_CATEGORIES_SYSTEM_PROPERTY = "idea.log.separate.file.categories";

    public LogLevelConfigurationManager() {
        super((Object)new State(null, null, 3, null));
    }

    @ApiStatus.Internal
    public final void setCategories(@NotNull State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.cleanCurrentCategories();
        this.addCategories(state2);
    }

    public final void setCategories(@NotNull List<LogCategory> categories) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        this.cleanCurrentCategories();
        this.addCategories(categories);
    }

    public final void addCategories(@NotNull List<LogCategory> categories) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        this.addCategories(new State(categories, null, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public final void addCategories(@NotNull State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        State appliedCategories = this.applyState(state2);
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        State next$iv = null;
        while (true) {
            void it$iv;
            Object object;
            if (next$iv == null) {
                State it = (State)prev$iv;
                boolean bl = false;
                next$iv = appliedCategories;
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object2 = object = this_$iv.getState();
            Object object3 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            boolean haveNext$iv = object3 == object;
            if (haveNext$iv) continue;
            next$iv = null;
        }
        Listener.EP_NAME.forEachExtensionSafe(arg_0 -> LogLevelConfigurationManager.addCategories$lambda$2(LogLevelConfigurationManager::addCategories$lambda$1, arg_0));
    }

    private final String toTrimmed(String $this$toTrimmed) {
        char[] cArray = new char[]{'#'};
        return StringsKt.trimStart((String)$this$toTrimmed, (char[])cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final java.util.logging.Logger getJulLoggerFromCache(String category) {
        java.util.logging.Logger logger2;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            java.util.logging.Logger logger3 = this.customizedLoggers.computeIfAbsent(category, arg_0 -> LogLevelConfigurationManager.getJulLoggerFromCache$lambda$0$0(getJulLoggerFromCache.1.1.INSTANCE, arg_0));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            logger2 = logger3;
        }
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"synchronized(...)");
        return logger2;
    }

    /*
     * WARNING - void declaration
     */
    private final State applyState(State state2) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        Object loggerLevel;
        Map.Entry<String, DebugLogLevel> element$iv;
        Map<String, DebugLogLevel> updatedCategoriesToLevel;
        Map<String, DebugLogLevel> $this$forEach$iv = updatedCategoriesToLevel = this.updatedCategoriesToLevel(state2.categories);
        boolean $i$f$forEach22 = false;
        Iterator<Map.Entry<String, DebugLogLevel>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, DebugLogLevel> entry = element$iv = iterator2.next();
            boolean bl = false;
            String category = entry.getKey();
            DebugLogLevel level = entry.getValue();
            loggerLevel = switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1 -> Level.FINE;
                case 2 -> Level.FINER;
                case 3 -> Level.ALL;
                default -> throw new NoWhenBranchMatchedException();
            };
            this.addLogger("#" + (String)category, (Level)loggerLevel, level);
            this.addLogger(category, (Level)loggerLevel, level);
        }
        Iterable $i$f$forEach22 = ((State)this.getState()).categories;
        Iterable iterable = updatedCategoriesToLevel.keySet();
        boolean $i$f$map = false;
        element$iv = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            loggerLevel = (LogCategory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toTrimmed(it.getCategory()));
        }
        Set allObservedCategories = CollectionsKt.union((Iterable)iterable, (Iterable)((List)destination$iv$iv));
        Map<String, DebugLogLevel> $this$map$iv2 = state2.categoriesWithSeparateFiles;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv2), (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String bl = (String)item$iv$iv;
            iterable = destination$iv$iv2;
            boolean bl2 = false;
            iterable.add(this.toTrimmed((String)it));
        }
        Set categoriesWithSeparateFiles = CollectionsKt.intersect((Iterable)((List)destination$iv$iv2), (Iterable)allObservedCategories);
        for (String category : allObservedCategories) {
            boolean enable2 = categoriesWithSeparateFiles.contains(category);
            this.setSeparateFile(this.getJulLoggerFromCache("#" + category), enable2);
            this.setSeparateFile(this.getJulLoggerFromCache(category), enable2);
        }
        $this$map$iv2 = updatedCategoriesToLevel;
        $i$f$map = false;
        Map<String, DebugLogLevel> enable2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        $i$f$mapTo2 = false;
        Iterator<Object> iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Object item$iv$iv;
            Object it = item$iv$iv = (Map.Entry)iterator3.next();
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new LogCategory((String)it.getKey(), (DebugLogLevel)((Object)it.getValue())));
        }
        Set set = categoriesWithSeparateFiles;
        List list2 = (List)destination$iv$iv2;
        return new State(list2, set);
    }

    private final void addLogger(String trimmed, Level loggerLevel, DebugLogLevel level) {
        java.util.logging.Logger logger2 = this.getJulLoggerFromCache(trimmed);
        logger2.setLevel(loggerLevel);
        LOG.info("Level " + level.name() + " is set for the following category: " + trimmed);
    }

    private final void setSeparateFile(java.util.logging.Logger logger2, boolean enable2) {
        Object object;
        block4: {
            Handler[] handlerArray = logger2.getHandlers();
            Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"getHandlers(...)");
            for (Object object2 : (Object[])handlerArray) {
                Handler it = (Handler)object2;
                boolean bl = false;
                if (!(it instanceof SeparateFileHandler)) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        Handler existingHandler = (Handler)object;
        if (enable2 && existingHandler == null) {
            logger2.setUseParentHandlers(false);
            String string = logger2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            logger2.addHandler(new SeparateFileHandler(string, logger2.getParent()));
            LOG.info("Debug logs are written in a separate file for the following category: " + logger2.getName());
        } else if (!enable2 && existingHandler != null) {
            logger2.setUseParentHandlers(true);
            logger2.removeHandler(existingHandler);
            LOG.info("Debug logs are not written anymore in a separate file for the following category: " + logger2.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DebugLogLevel> updatedCategoriesToLevel(List<LogCategory> categoriesToUpdate) {
        void $this$associateTo$iv$iv;
        Object object;
        void $this$associateTo$iv$iv2;
        Iterable $this$associate$iv = this.getCategories();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map2 = destination$iv$iv;
            object = (LogCategory)element$iv$iv;
            boolean bl = false;
            String category = ((LogCategory)object).component1();
            DebugLogLevel level = ((LogCategory)object).component2();
            object = TuplesKt.to((Object)this.toTrimmed(category), (Object)((Object)level));
            map2.put(object.getFirst(), object.getSecond());
        }
        Map trimmedCategories = MapsKt.toMutableMap((Map)destination$iv$iv);
        Iterable $this$associate$iv2 = categoriesToUpdate;
        boolean $i$f$associate2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv2;
            LogCategory logCategory = (LogCategory)element$iv$iv;
            boolean bl = false;
            String category = logCategory.component1();
            DebugLogLevel level = logCategory.component2();
            logCategory = TuplesKt.to((Object)this.toTrimmed(category), (Object)((Object)level));
            object.put(logCategory.getFirst(), logCategory.getSecond());
        }
        Map toUpdateTrimmedCategories = destination$iv$iv2;
        for (Map.Entry entry : toUpdateTrimmedCategories.entrySet()) {
            String newCategory = (String)entry.getKey();
            DebugLogLevel newLevel = (DebugLogLevel)((Object)entry.getValue());
            DebugLogLevel foundLevel = (DebugLogLevel)((Object)trimmedCategories.get(newCategory));
            if (foundLevel != null && foundLevel.ordinal() >= newLevel.ordinal()) continue;
            trimmedCategories.put(newCategory, newLevel);
        }
        return trimmedCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanCurrentCategories() {
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-LogLevelConfigurationManager$cleanCurrentCategories$22 = false;
            Iterator iterator2 = ((Map)this.customizedLoggers).entrySet().iterator();
            while (iterator2.hasNext()) {
                java.util.logging.Logger logger2 = (java.util.logging.Logger)iterator2.next().getValue();
                this.setSeparateFile(logger2, false);
                logger2.setLevel(null);
            }
            this.customizedLoggers.clear();
            Unit $i$a$-synchronized-LogLevelConfigurationManager$cleanCurrentCategories$22 = Unit.INSTANCE;
        }
        SerializablePersistentStateComponent this_$iv = this;
        boolean $i$f$updateState = false;
        Object prev$iv = null;
        prev$iv = this_$iv.getState();
        State next$iv = null;
        while (true) {
            void it$iv;
            Object object2;
            if (next$iv == null) {
                State it = (State)prev$iv;
                boolean bl = false;
                next$iv = State.copy$default(it, CollectionsKt.emptyList(), null, 2, null);
            }
            if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
            Object object3 = object2 = this_$iv.getState();
            Object object4 = prev$iv;
            boolean bl = false;
            prev$iv = it$iv;
            boolean haveNext$iv = object4 == object2;
            if (haveNext$iv) continue;
            next$iv = null;
        }
    }

    @NotNull
    public final List<LogCategory> getCategories() {
        return ((State)this.getState()).categories;
    }

    @ApiStatus.Internal
    public void loadState(@NotNull State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        super.loadState((Object)state2);
        State fromSystemProperties = this.collectStateFromSystemProperties();
        this.applyState(new State(CollectionsKt.plus((Collection)state2.categories, (Iterable)fromSystemProperties.categories), SetsKt.plus(state2.categoriesWithSeparateFiles, (Iterable)fromSystemProperties.categoriesWithSeparateFiles)));
    }

    public void noStateLoaded() {
        State categories = this.collectStateFromSystemProperties();
        this.applyState(categories);
    }

    private final State collectStateFromSystemProperties() {
        List categories = new ArrayList();
        categories.addAll((Collection)this.fromString(System.getProperty(LOG_DEBUG_CATEGORIES_SYSTEM_PROPERTY), DebugLogLevel.DEBUG));
        categories.addAll((Collection)this.fromString(System.getProperty(LOG_TRACE_CATEGORIES_SYSTEM_PROPERTY), DebugLogLevel.TRACE));
        categories.addAll((Collection)this.fromString(System.getProperty(LOG_ALL_CATEGORIES_SYSTEM_PROPERTY), DebugLogLevel.ALL));
        return new State(categories, this.separateFileFromString(System.getProperty(LOG_SEPARATE_FILE_CATEGORIES_SYSTEM_PROPERTY)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LogCategory> fromString(String text2, DebugLogLevel level) {
        void $this$mapNotNullTo$iv$iv;
        List<String> list2 = this.splitCategories(text2);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<String> categories = list2;
        Iterable $this$mapNotNull$iv = categories;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LogCategory it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((StringsKt.isBlank((CharSequence)it) ? null : new LogCategory(it, level)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Set<String> separateFileFromString(String text2) {
        Collection<String> collection = this.splitCategories(text2);
        return collection != null && (collection = CollectionsKt.toHashSet((Iterable)collection)) != null ? (Set)collection : SetsKt.emptySet();
    }

    private final List<String> splitCategories(String text2) {
        CharSequence charSequence = text2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        List byNewlines = StringsKt.lines((CharSequence)text2);
        char[] cArray = new char[]{','};
        List byCommas = StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (byCommas.size() > 1 && byNewlines.size() > 1) {
            LOG.error("Mixed commas and newlines as category separators: " + text2);
        }
        return byCommas.size() > byNewlines.size() ? byCommas : byNewlines;
    }

    private static final Unit addCategories$lambda$1(Listener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.onCategoriesChanged();
        return Unit.INSTANCE;
    }

    private static final void addCategories$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final java.util.logging.Logger getJulLoggerFromCache$lambda$0$0(Function1 $tmp0, Object p0) {
        return (java.util.logging.Logger)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final LogLevelConfigurationManager getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(LogLevelConfigurationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LOG_DEBUG_CATEGORIES_SYSTEM_PROPERTY", "", "LOG_TRACE_CATEGORIES_SYSTEM_PROPERTY", "LOG_ALL_CATEGORIES_SYSTEM_PROPERTY", "LOG_SEPARATE_FILE_CATEGORIES_SYSTEM_PROPERTY", "getInstance", "Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nLogLevelConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogLevelConfigurationManager.kt\ncom/intellij/diagnostic/logs/LogLevelConfigurationManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,263:1\n42#2,3:264\n*S KotlinDebug\n*F\n+ 1 LogLevelConfigurationManager.kt\ncom/intellij/diagnostic/logs/LogLevelConfigurationManager$Companion\n*L\n37#1:264,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LogLevelConfigurationManager getInstance() {
            boolean $i$f$service = false;
            Class<LogLevelConfigurationManager> serviceClass$iv = LogLevelConfigurationManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LogLevelConfigurationManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bg\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$Listener;", "", "onCategoriesChanged", "", "Companion", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static interface Listener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @JvmField
        @NotNull
        public static final ExtensionPointName<Listener> EP_NAME = ExtensionPointName.Companion.create("com.intellij.logLevelConfigurationListener");

        public void onCategoriesChanged();

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$Listener$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$Listener;", "intellij.platform.ide.impl"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$SeparateFileHandler;", "Ljava/util/logging/Handler;", "category", "", "parentLogger", "Ljava/util/logging/Logger;", "<init>", "(Ljava/lang/String;Ljava/util/logging/Logger;)V", "separateHandler", "Lkotlin/Lazy;", "Lcom/intellij/openapi/diagnostic/RollingFileHandler;", "publish", "", "record", "Ljava/util/logging/LogRecord;", "flush", "close", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nLogLevelConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogLevelConfigurationManager.kt\ncom/intellij/diagnostic/logs/LogLevelConfigurationManager$SeparateFileHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,263:1\n18#2:264\n4253#3,12:265\n1228#3,2:277\n*S KotlinDebug\n*F\n+ 1 LogLevelConfigurationManager.kt\ncom/intellij/diagnostic/logs/LogLevelConfigurationManager$SeparateFileHandler\n*L\n144#1:264\n144#1:265,12\n157#1:277,2\n*E\n"})
    private static final class SeparateFileHandler
    extends Handler {
        @NotNull
        private final String category;
        @Nullable
        private final java.util.logging.Logger parentLogger;
        @NotNull
        private final Lazy<RollingFileHandler> separateHandler;

        public SeparateFileHandler(@NotNull String category, @Nullable java.util.logging.Logger parentLogger) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.category = category;
            this.parentLogger = parentLogger;
            this.separateHandler = LazyKt.lazy(() -> SeparateFileHandler.separateHandler$lambda$0(this));
        }

        @Override
        public void publish(@NotNull LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                java.util.logging.Logger logger2 = this.parentLogger;
                if (logger2 != null) {
                    logger2.log(record);
                }
            }
            ((RollingFileHandler)this.separateHandler.getValue()).publish(record);
        }

        @Override
        public void flush() {
            if (this.separateHandler.isInitialized()) {
                ((RollingFileHandler)this.separateHandler.getValue()).flush();
            }
        }

        @Override
        public void close() {
            if (this.separateHandler.isInitialized()) {
                ((RollingFileHandler)this.separateHandler.getValue()).close();
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final RollingFileHandler separateHandler$lambda$0(SeparateFileHandler this$0) {
            void element$iv2;
            RollingFileHandler rollingFileHandler;
            RollingFileHandler handler2;
            block5: {
                void $this$first$iv;
                Path logRoot;
                void $this$filterIsInstanceTo$iv$iv;
                java.util.logging.Logger logger2 = this$0.parentLogger;
                Handler[] $this$orEmpty$iv = logger2 != null ? logger2.getHandlers() : null;
                boolean $i$f$orEmpty = false;
                Handler[] handlerArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    handlerArray = new Handler[]{};
                }
                Object[] $this$filterIsInstance$iv = handlerArray;
                boolean $i$f$filterIsInstance22 = false;
                Handler[] handlerArray2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof RollingFileHandler)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Object object = (RollingFileHandler)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                Path path = object != null && (object = object.getLogPath()) != null ? object.getParent() : (logRoot = null);
                if (logRoot == null) {
                    logRoot = PathManager.getLogDir();
                }
                $this$filterIsInstance$iv = new char[1];
                $this$filterIsInstance$iv[0] = (Handler)35;
                String logFileName = "idea_" + FileUtil.sanitizeFileName((String)IdeaLogRecordFormatter.smartAbbreviate((String)StringsKt.trimStart((String)this$0.category, (char[])$this$filterIsInstance$iv)), (boolean)true, (String)".") + ".log";
                Path path2 = logRoot.resolve(logFileName);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                handler2 = new RollingFileHandler(path2, JulLogger.LOG_FILE_SIZE_LIMIT, JulLogger.LOG_FILE_COUNT, true, null, 16, null);
                handler2.setLevel(Level.ALL);
                Handler[] handlerArray3 = java.util.logging.Logger.getLogger("").getHandlers();
                Intrinsics.checkNotNullExpressionValue((Object)handlerArray3, (String)"getHandlers(...)");
                Object[] $i$f$filterIsInstance22 = handlerArray3;
                rollingFileHandler = handler2;
                boolean $i$f$first = false;
                for (void element$iv2 : $this$first$iv) {
                    Handler it = (Handler)element$iv2;
                    boolean bl = false;
                    if (!(it instanceof RollingFileHandler)) {
                        continue;
                    }
                    break block5;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            rollingFileHandler.setFormatter(((Handler)element$iv2).getFormatter());
            return handler2;
        }
    }

    @Serializable
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B'\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tB;\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u000bH\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0007H\u00d6\u0081\u0004J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$State;", "", "categories", "", "Lcom/intellij/diagnostic/logs/LogCategory;", "categoriesWithSeparateFiles", "", "", "<init>", "(Ljava/util/List;Ljava/util/Set;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Ljava/util/Set;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_ide_impl", "$serializer", "Companion", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final List<LogCategory> categories;
        @JvmField
        @NotNull
        public final Set<String> categoriesWithSeparateFiles;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public State(@NotNull List<LogCategory> categories, @NotNull Set<String> categoriesWithSeparateFiles) {
            Intrinsics.checkNotNullParameter(categories, (String)"categories");
            Intrinsics.checkNotNullParameter(categoriesWithSeparateFiles, (String)"categoriesWithSeparateFiles");
            this.categories = categories;
            this.categoriesWithSeparateFiles = categoriesWithSeparateFiles;
        }

        public /* synthetic */ State(List list2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                set = SetsKt.emptySet();
            }
            this(list2, set);
        }

        @NotNull
        public final List<LogCategory> component1() {
            return this.categories;
        }

        @NotNull
        public final Set<String> component2() {
            return this.categoriesWithSeparateFiles;
        }

        @NotNull
        public final State copy(@NotNull List<LogCategory> categories, @NotNull Set<String> categoriesWithSeparateFiles) {
            Intrinsics.checkNotNullParameter(categories, (String)"categories");
            Intrinsics.checkNotNullParameter(categoriesWithSeparateFiles, (String)"categoriesWithSeparateFiles");
            return new State(categories, categoriesWithSeparateFiles);
        }

        public static /* synthetic */ State copy$default(State state2, List list2, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = state2.categories;
            }
            if ((n & 2) != 0) {
                set = state2.categoriesWithSeparateFiles;
            }
            return state2.copy(list2, set);
        }

        @NotNull
        public String toString() {
            return "State(categories=" + this.categories + ", categoriesWithSeparateFiles=" + this.categoriesWithSeparateFiles + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.categories).hashCode();
            result2 = result2 * 31 + ((Object)this.categoriesWithSeparateFiles).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state2 = (State)other;
            if (!Intrinsics.areEqual(this.categories, state2.categories)) {
                return false;
            }
            return Intrinsics.areEqual(this.categoriesWithSeparateFiles, state2.categoriesWithSeparateFiles);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_ide_impl(State self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual(self.categories, (Object)CollectionsKt.emptyList())) {
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.categories);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual(self.categoriesWithSeparateFiles, (Object)SetsKt.emptySet())) {
                output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.categoriesWithSeparateFiles);
            }
        }

        public /* synthetic */ State(int seen0, List categories, Set categoriesWithSeparateFiles, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)State$$serializer.INSTANCE.getDescriptor());
            }
            this.categories = (seen0 & 1) == 0 ? CollectionsKt.emptyList() : categories;
            this.categoriesWithSeparateFiles = (seen0 & 2) == 0 ? SetsKt.emptySet() : categoriesWithSeparateFiles;
        }

        public State() {
            this(null, null, 3, null);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)LogCategory$.serializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashSetSerializer((KSerializer)StringSerializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$State$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$State;", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<State> serializer() {
                return (KSerializer)State$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DebugLogLevel.values().length];
            try {
                nArray[DebugLogLevel.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebugLogLevel.TRACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebugLogLevel.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

