/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSettings;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u000bH\u0014J;\u0010\u0010\u001a\u00020\u00112\r\u0010\u0012\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u00132\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherImpl;", "Lcom/intellij/ide/browsers/BrowserLauncherAppless;", "<init>", "()V", "getDefaultBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "canBrowse", "", "project", "Lcom/intellij/openapi/project/Project;", "uri", "", "signUrl", "url", "substituteBrowser", "browserPath", "showError", "", "message", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "browser", "retry", "Lkotlin/Function0;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBrowserLauncherImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserLauncherImpl.kt\ncom/intellij/ide/browsers/BrowserLauncherImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public class BrowserLauncherImpl
extends BrowserLauncherAppless {
    @Nullable
    protected WebBrowser getDefaultBrowser() {
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        return browserManager.getDefaultBrowserPolicy() == DefaultBrowserPolicy.FIRST ? browserManager.getFirstActiveBrowser() : null;
    }

    protected boolean canBrowse(@Nullable Project project2, @NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (project2 == null || TrustedProjects.isProjectTrusted(project2)) {
            return true;
        }
        String string = IdeBundle.message((String)"external.link.confirmation.yes.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String yesLabel = string;
        String string2 = IdeBundle.message((String)"external.link.confirmation.trust.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String trustLabel = string2;
        String string3 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCancelButtonText(...)");
        String noLabel = string3;
        String string4 = IdeBundle.message((String)"external.link.confirmation.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        Object[] objectArray = new Object[]{uri};
        String string5 = IdeBundle.message((String)"external.link.confirmation.message.0", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        Object object = new String[]{yesLabel, trustLabel, noLabel};
        String answer2 = MessageDialogBuilder.Message.show$default((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)new MessageDialogBuilder.Message(string4, string5).asWarning()).buttons(object).defaultButton(yesLabel).focusedButton(trustLabel), (Project)project2, null, (int)2, null);
        object = answer2;
        if (Intrinsics.areEqual((Object)object, (Object)yesLabel)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)object, (Object)trustLabel)) {
            TrustedProjects.setProjectTrusted(project2, true);
            return true;
        }
        return false;
    }

    @NotNull
    protected String signUrl(@NotNull String url) {
        BuiltInServerManager serverManager;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url parsedUrl = Urls.parse((String)url, (boolean)false);
        if (parsedUrl != null && (serverManager = BuiltInServerManager.Companion.getInstance()).isOnBuiltInWebServer(parsedUrl)) {
            String string = serverManager.addAuthToken(parsedUrl).toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
            return string;
        }
        return url;
    }

    @Nullable
    protected WebBrowser substituteBrowser(@NotNull String browserPath) {
        WebBrowser firstActiveBrowser;
        Intrinsics.checkNotNullParameter((Object)browserPath, (String)"browserPath");
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        if ((browserManager.getDefaultBrowserPolicy() == DefaultBrowserPolicy.FIRST || SystemInfo.isMac && Intrinsics.areEqual((Object)"open", (Object)browserPath)) && (firstActiveBrowser = browserManager.getFirstActiveBrowser()) != null) {
            return firstActiveBrowser;
        }
        return null;
    }

    protected void showError(@Nullable String message, @Nullable Project project2, @Nullable WebBrowser browser, @Nullable Function0<Unit> retry) {
        Notification notification2;
        String string = IdeBundle.message((String)(retry != null ? "notification.title.browser.config.problem" : "notification.title.cannot.open"), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title2 = string;
        String string2 = message;
        if (string2 == null) {
            String string3 = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        String content2 = string2;
        Notification $this$showError_u24lambda_u240 = notification2 = new Notification("BrowserCfgProblems", title2, content2, NotificationType.WARNING);
        boolean bl = false;
        if (retry != null) {
            $this$showError_u24lambda_u240.addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"button.fix", (Object[])new Object[0]), () -> BrowserLauncherImpl.showError$lambda$0$0(browser, project2, retry)));
        }
        notification2.notify(project2);
    }

    private static final void showError$lambda$0$0$0$0(BrowserSettings $browserSettings, WebBrowser $it) {
        $browserSettings.selectBrowser($it);
    }

    private static final void showError$lambda$0$0(WebBrowser $browser, Project $project, Function0 $retry) {
        Runnable initializer;
        BrowserSettings browserSettings = new BrowserSettings();
        WebBrowser webBrowser = $browser;
        if (webBrowser != null) {
            WebBrowser it = webBrowser;
            boolean bl = false;
            v1 = () -> BrowserLauncherImpl.showError$lambda$0$0$0$0(browserSettings, it);
        } else {
            v1 = initializer = null;
        }
        if (ShowSettingsUtil.getInstance().editConfigurable($project, (Configurable)browserSettings, initializer)) {
            $retry.invoke();
        }
    }
}

