/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.statusBar;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.actions.LightEditOpenFileInProjectAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBPoint;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditModeNotificationWidget
implements CustomStatusBarWidget {
    private final PopupState<JPopupMenu> myPopupState = PopupState.forPopupMenu();

    @NonNls
    @NotNull
    public String ID() {
        return "light.edit.mode.notification";
    }

    public JComponent getComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag().nextLine().setDefaultFill(3).setDefaultWeightY(1.0);
        JBLabel label2 = new JBLabel(ApplicationBundle.message((String)"light.edit.status.bar.notification.label.text", (Object[])new Object[0]));
        panel2.add((Component)label2, gc.next().insets((Insets)JBUI.insets((int)0, (int)7, (int)0, (int)5)));
        ActionLink actionLink = this.createActionLink();
        panel2.add((Component)actionLink, gc.next());
        panel2.setOpaque(false);
        this.configureTooltip(label2, actionLink);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme -> this.configureTooltip(label2, actionLink));
        return panel2;
    }

    private void configureTooltip(@NotNull JBLabel label2, @NotNull ActionLink actionLink) {
        if (label2 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(0);
        }
        if (actionLink == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(1);
        }
        IdeTooltip tooltip = this.createTooltip((JComponent)actionLink);
        IdeTooltipManager.getInstance().setCustomTooltip((JComponent)label2, tooltip);
        IdeTooltipManager.getInstance().setCustomTooltip((JComponent)actionLink, tooltip);
    }

    @NotNull
    private ActionLink createActionLink() {
        final ActionLink actionLink = new ActionLink();
        actionLink.setText(ApplicationBundle.message((String)"light.edit.status.bar.notification.link.text", (Object[])new Object[0]));
        actionLink.setDropDownLinkIcon();
        actionLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightEditModeNotificationWidget.this.showPopupMenu((JComponent)actionLink);
            }
        });
        ActionLink actionLink2 = actionLink;
        if (actionLink2 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(2);
        }
        return actionLink2;
    }

    @NotNull
    private IdeTooltip createTooltip(@NotNull JComponent component2) {
        if (component2 == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(3);
        }
        TooltipWithClickableLinks tooltip = new TooltipWithClickableLinks(component2, LightEditModeNotificationWidget.getTooltipHtml(), (HyperlinkListener)new HyperlinkAdapter(this){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                HelpManager.getInstance().invokeHelp("LightEdit_Mode");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/lightEdit/statusBar/LightEditModeNotificationWidget$2", "hyperlinkActivated"));
            }
        }){

            @Override
            public boolean canBeDismissedOnTimeout() {
                return false;
            }

            @Override
            protected boolean beforeShow() {
                return !LightEditModeNotificationWidget.this.myPopupState.isShowing();
            }
        };
        tooltip.setToCenter(false);
        tooltip.setToCenterIfSmall(false);
        tooltip.setPoint((Point)new JBPoint(-3, 11));
        TooltipWithClickableLinks tooltipWithClickableLinks = tooltip;
        if (tooltipWithClickableLinks == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(4);
        }
        return tooltipWithClickableLinks;
    }

    @NotNull
    @Nls
    private static String getTooltipHtml() {
        HtmlChunk.Element link = HtmlChunk.link((String)"", (String)ApplicationBundle.message((String)"light.edit.status.bar.notification.tooltip.link.text", (Object[])new Object[0]));
        link = link.child((HtmlChunk)HtmlChunk.tag((String)"icon").attr("src", "AllIcons.Ide.External_link_arrow"));
        @NlsSafe String pTag = "<p>";
        Object tooltipText = ApplicationBundle.message((String)"light.edit.status.bar.notification.tooltip", (Object[])new Object[0]) + pTag + String.valueOf(link);
        Object object = tooltipText = ((String)tooltipText).replace(pTag, HtmlChunk.tag((String)"p").style("padding: " + JBUI.scale((int)3) + "px 0 0 0").toString());
        if (object == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(5);
        }
        return object;
    }

    private void showPopupMenu(@NotNull JComponent actionLink) {
        if (actionLink == null) {
            LightEditModeNotificationWidget.$$$reportNull$$$0(6);
        }
        if (!this.myPopupState.isRecentlyHidden()) {
            DataContext dataContext2 = CustomizedDataContext.withSnapshot((DataContext)DataManager.getInstance().getDataContext((Component)actionLink), sink -> sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)LightEditService.getInstance().getSelectedFile()));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("StatusBarPlace", LightEditModeNotificationWidget.createAccessFullIdeActionGroup());
            popupMenu.setDataContext(() -> dataContext2);
            JPopupMenu menu = popupMenu.getComponent();
            this.myPopupState.prepareToShow((Object)menu);
            JBPopupMenu.showAbove((Component)actionLink, (JPopupMenu)menu);
        }
    }

    @NotNull
    private static ActionGroup createAccessFullIdeActionGroup() {
        ActionManager actionManager = ActionManager.getInstance();
        return new DefaultActionGroup(new AnAction[]{new LightEditDelegatingAction((AnAction)new LightEditOpenFileInProjectAction(), ApplicationBundle.messagePointer((String)"light.edit.open_current_file_in_project.text", (Object[])new Object[0])), new Separator(), new LightEditDelegatingAction(actionManager.getAction("ManageRecentProjects"), ApplicationBundle.messagePointer((String)"light.edit.open_recent_project.text", (Object[])new Object[0])), new LightEditDelegatingAction(actionManager.getAction("NewProject"), ApplicationBundle.messagePointer((String)"light.edit.create_new_project.text", (Object[])new Object[0]))});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionLink";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/statusBar/LightEditModeNotificationWidget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/statusBar/LightEditModeNotificationWidget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionLink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureTooltip";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTooltip";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showPopupMenu";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class LightEditDelegatingAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final AnAction myDelegate;

        private LightEditDelegatingAction(@Nullable AnAction delegate, @NotNull Supplier<@Nls String> textSupplier) {
            if (textSupplier == null) {
                LightEditDelegatingAction.$$$reportNull$$$0(0);
            }
            super(textSupplier);
            this.myDelegate = delegate;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                LightEditDelegatingAction.$$$reportNull$$$0(1);
            }
            if (this.myDelegate == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            this.myDelegate.update(e);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = this.myDelegate == null ? ActionUpdateThread.BGT : this.myDelegate.getActionUpdateThread();
            if (actionUpdateThread == null) {
                LightEditDelegatingAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                LightEditDelegatingAction.$$$reportNull$$$0(3);
            }
            if (this.myDelegate != null) {
                this.myDelegate.actionPerformed(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textSupplier";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/lightEdit/statusBar/LightEditModeNotificationWidget$LightEditDelegatingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/lightEdit/statusBar/LightEditModeNotificationWidget$LightEditDelegatingAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

