/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.widget;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.ActionCenter;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.ApplicationNotificationsModel;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.UIBundle;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public final class IdeNotificationArea
implements CustomStatusBarWidget,
IconLikeCustomStatusBarWidget {
    public static final String WIDGET_ID = "Notifications";
    private static final BadgeIconSupplier NOTIFICATION_ICON = new BadgeIconSupplier(AllIcons.Toolwindows.Notifications);
    @NotNull
    private final LazyInitializer.LazyValue<JLabel> myComponent = LazyInitializer.create(() -> {
        JLabel result2 = new JLabel();
        result2.setBorder(JBUI.CurrentTheme.StatusBar.Widget.iconBorder());
        return result2;
    });
    @Nullable
    private StatusBar myStatusBar;

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    public void dispose() {
        this.myStatusBar = null;
        UIUtil.dispose((Component)((Component)this.myComponent.get()));
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            IdeNotificationArea.$$$reportNull$$$0(0);
        }
        this.myStatusBar = statusBar;
        final Project project2 = this.myStatusBar.getProject();
        if (project2 != null && !project2.isDisposed()) {
            new ClickListener(this){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!project2.isDisposed()) {
                        ActionCenter.toggleLog(project2);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/notification/impl/widget/IdeNotificationArea$1", "onClick"));
                }
            }.installOn((Component)this.myComponent.get(), true);
            Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)this).subscribe(ApplicationNotificationsModel.STATE_CHANGED, () -> app.invokeLater(() -> this.updateStatus(project2)));
            this.updateStatus(project2);
        }
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    private void updateStatus(@Nullable Project project2) {
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        List<Notification> notifications = ApplicationNotificationsModel.getStateNotifications(project2);
        this.updateIconOnStatusBar(notifications);
        int count = notifications.size();
        ((JLabel)this.myComponent.get()).setToolTipText(count > 0 ? UIBundle.message((String)"status.bar.notifications.widget.tooltip", (Object[])new Object[]{count}) : UIBundle.message((String)"status.bar.notifications.widget.no.notification.tooltip", (Object[])new Object[0]));
    }

    private void updateIconOnStatusBar(List<? extends Notification> notifications) {
        ((JLabel)this.myComponent.get()).setIcon(IdeNotificationArea.getActionCenterNotificationIcon(notifications));
    }

    @NotNull
    public static Icon getActionCenterNotificationIcon(List<? extends Notification> notifications) {
        for (Notification notification2 : notifications) {
            if ((!notification2.isSuggestionType() || !notification2.isImportantSuggestion()) && notification2.getType() != NotificationType.ERROR) continue;
            if (ExperimentalUI.isNewUI()) {
                Icon icon2 = NOTIFICATION_ICON.getErrorIcon();
                if (icon2 == null) {
                    IdeNotificationArea.$$$reportNull$$$0(1);
                }
                return icon2;
            }
            Icon icon3 = AllIcons.Toolwindows.NotificationsNewImportant;
            if (icon3 == null) {
                IdeNotificationArea.$$$reportNull$$$0(2);
            }
            return icon3;
        }
        if (ExperimentalUI.isNewUI()) {
            Icon icon4 = NOTIFICATION_ICON.getInfoIcon(!notifications.isEmpty());
            if (icon4 == null) {
                IdeNotificationArea.$$$reportNull$$$0(3);
            }
            return icon4;
        }
        Icon icon5 = notifications.isEmpty() ? AllIcons.Toolwindows.Notifications : AllIcons.Toolwindows.NotificationsNew;
        if (icon5 == null) {
            IdeNotificationArea.$$$reportNull$$$0(4);
        }
        return icon5;
    }

    @NotNull
    public static LayeredIcon createIconWithNotificationCount(JComponent component2, NotificationType type, int size2, boolean forToolWindow) {
        LayeredIcon icon2 = new LayeredIcon(2);
        Icon baseIcon = IdeNotificationArea.getPendingNotificationsIcon(type, forToolWindow);
        icon2.setIcon(baseIcon, 0);
        if (size2 > 0) {
            Object textColor = type == NotificationType.ERROR || type == NotificationType.INFORMATION ? new JBColor(Color.white, new Color(0xF2F2F2)) : new Color(0x333333);
            icon2.setIcon((Icon)new TextIcon(component2, size2 < 10 ? String.valueOf(size2) : "9+", (Color)textColor, baseIcon), 1);
        }
        LayeredIcon layeredIcon = icon2;
        if (layeredIcon == null) {
            IdeNotificationArea.$$$reportNull$$$0(5);
        }
        return layeredIcon;
    }

    public JComponent getComponent() {
        return (JComponent)this.myComponent.get();
    }

    private static Icon getPendingNotificationsIcon(NotificationType maximumType, boolean forToolWindow) {
        if (maximumType != null) {
            return switch (maximumType) {
                default -> throw new MatchException(null, null);
                case NotificationType.WARNING -> {
                    if (forToolWindow) {
                        yield AllIcons.Toolwindows.WarningEvents;
                    }
                    yield AllIcons.Ide.Notification.WarningEvents;
                }
                case NotificationType.ERROR -> {
                    if (forToolWindow) {
                        yield AllIcons.Toolwindows.ErrorEvents;
                    }
                    yield AllIcons.Ide.Notification.ErrorEvents;
                }
                case NotificationType.INFORMATION, NotificationType.IDE_UPDATE -> forToolWindow ? AllIcons.Toolwindows.InfoEvents : AllIcons.Ide.Notification.InfoEvents;
            };
        }
        return forToolWindow ? AllIcons.Toolwindows.NoEvents : AllIcons.Ide.Notification.NoEvents;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/widget/IdeNotificationArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/widget/IdeNotificationArea";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionCenterNotificationIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconWithNotificationCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class TextIcon
    implements Icon {
        private final String myStr;
        private final JComponent myComponent;
        private final Color myTextColor;
        private final Icon myBaseIcon;
        private final int myWidth;
        private final Font myFont;

        TextIcon(JComponent component2, @NotNull String str, @NotNull Color textColor, @NotNull Icon baseIcon) {
            if (str == null) {
                TextIcon.$$$reportNull$$$0(0);
            }
            if (textColor == null) {
                TextIcon.$$$reportNull$$$0(1);
            }
            if (baseIcon == null) {
                TextIcon.$$$reportNull$$$0(2);
            }
            this.myStr = str;
            this.myComponent = component2;
            this.myTextColor = textColor;
            this.myBaseIcon = baseIcon;
            this.myFont = new Font(NotificationsUtil.getFontName(), 1, JBUIScale.scale((int)9));
            this.myWidth = this.myComponent.getFontMetrics(this.myFont).stringWidth(this.myStr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextIcon)) {
                return false;
            }
            TextIcon icon2 = (TextIcon)o;
            if (this.myWidth != icon2.myWidth) {
                return false;
            }
            if (!this.myComponent.equals(icon2.myComponent)) {
                return false;
            }
            return this.myStr.equals(icon2.myStr);
        }

        public int hashCode() {
            int result2 = this.myStr.hashCode();
            result2 = 31 * result2 + this.myComponent.hashCode();
            result2 = 31 * result2 + this.myWidth;
            return result2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            UISettings.setupAntialiasing((Graphics)g);
            Font originalFont = g.getFont();
            Color originalColor = g.getColor();
            g.setFont(this.myFont);
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)c, g);
            boolean isTwoChar = this.myStr.length() == 2;
            float center = this.getIconWidth() - fm.stringWidth(this.myStr) + (isTwoChar ? JBUIScale.scale((int)1) : 0);
            float textX = (float)x + center / 2.0f;
            float textY = y + SimpleColoredComponent.getTextBaseLine((FontMetrics)fm, (int)this.getIconHeight());
            if (!JreHiDpiUtil.isJreHiDPI((Graphics2D)g2)) {
                textX = (float)Math.floor(textX);
            }
            g.setColor(this.myTextColor);
            g2.drawString(this.myStr.substring(0, 1), textX, textY);
            if (isTwoChar) {
                g2.drawString(this.myStr.substring(1), textX += (float)(fm.charWidth(this.myStr.charAt(0)) - JBUIScale.scale((int)1)), textY);
            }
            g.setFont(originalFont);
            g.setColor(originalColor);
        }

        @Override
        public int getIconWidth() {
            return this.myBaseIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myBaseIcon.getIconHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "str";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseIcon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/impl/widget/IdeNotificationArea$TextIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

