/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.DocumentReferenceByNonlocalVirtualFile;
import com.intellij.openapi.command.impl.DocumentReferenceByVirtualFile;
import com.intellij.openapi.command.impl.FilePath;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class DocumentReferenceManagerImpl
extends DocumentReferenceManager {
    private static final Key<Reference<DocumentReference>> FILE_TO_REF_KEY = Key.create((String)"FILE_TO_REF_KEY");
    private static final Key<DocumentReference> FILE_TO_STRONG_REF_KEY = Key.create((String)"FILE_TO_STRONG_REF_KEY");
    private final Map<Document, DocumentReference> docToRef = ContainerUtil.createWeakKeyWeakValueMap();
    private final Map<FilePath, DocumentReference> deletedFilePathToRef = ContainerUtil.createWeakValueMap();

    DocumentReferenceManagerImpl() {
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new CreateDeleteFileListener(), (Disposable)ApplicationManager.getApplication());
    }

    @NotNull
    public DocumentReference create(@NotNull Document document2) {
        VirtualFile file2;
        if (document2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(0);
        }
        return (file2 = FileDocumentManager.getInstance().getFile(document2)) != null && file2.isValid() ? this.create(file2) : this.createFromDocument(document2);
    }

    @NotNull
    public DocumentReference create(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(1);
        }
        return file2.isInLocalFileSystem() ? this.createFromLocal(file2) : this.createFromNonLocal(file2);
    }

    @NotNull
    private synchronized DocumentReference createFromDocument(@NotNull Document document2) {
        DocumentReference ref2;
        if (document2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(2);
        }
        if ((ref2 = this.docToRef.get(document2)) != null) {
            DocumentReference documentReference = ref2;
            if (documentReference == null) {
                DocumentReferenceManagerImpl.$$$reportNull$$$0(3);
            }
            return documentReference;
        }
        DocumentReferenceByDocument newRef = new DocumentReferenceByDocument(document2);
        this.docToRef.put(document2, newRef);
        DocumentReferenceByDocument documentReferenceByDocument = newRef;
        if (documentReferenceByDocument == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(4);
        }
        return documentReferenceByDocument;
    }

    @NotNull
    private synchronized DocumentReference createFromLocal(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(5);
        }
        assert (file2.isValid()) : "file is invalid: " + String.valueOf(file2);
        DocumentReference ref2 = (DocumentReference)SoftReference.dereference((Reference)((Reference)file2.getUserData(FILE_TO_REF_KEY)));
        if (ref2 != null) {
            DocumentReference documentReference = ref2;
            if (documentReference == null) {
                DocumentReferenceManagerImpl.$$$reportNull$$$0(6);
            }
            return documentReference;
        }
        DocumentReferenceByVirtualFile newRef = new DocumentReferenceByVirtualFile(file2);
        file2.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReferenceByVirtualFile>(newRef));
        DocumentReferenceByVirtualFile documentReferenceByVirtualFile = newRef;
        if (documentReferenceByVirtualFile == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(7);
        }
        return documentReferenceByVirtualFile;
    }

    @NotNull
    private synchronized DocumentReference createFromNonLocal(@NotNull VirtualFile file2) {
        DocumentReference ref2;
        if (file2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(8);
        }
        if ((ref2 = (DocumentReference)file2.getUserData(FILE_TO_STRONG_REF_KEY)) != null) {
            DocumentReference documentReference = ref2;
            if (documentReference == null) {
                DocumentReferenceManagerImpl.$$$reportNull$$$0(9);
            }
            return documentReference;
        }
        DocumentReferenceByNonlocalVirtualFile newRef = new DocumentReferenceByNonlocalVirtualFile(file2);
        file2.putUserData(FILE_TO_STRONG_REF_KEY, (Object)newRef);
        DocumentReferenceByNonlocalVirtualFile documentReferenceByNonlocalVirtualFile = newRef;
        if (documentReferenceByNonlocalVirtualFile == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(10);
        }
        return documentReferenceByNonlocalVirtualFile;
    }

    private synchronized void fileCreated(@NotNull VFileCreateEvent event) {
        DocumentReference ref2;
        VirtualFile file2;
        if (event == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(11);
        }
        if ((file2 = event.getFile()) != null && (ref2 = this.deletedFilePathToRef.remove(DocumentReferenceManagerImpl.filePath(file2))) != null) {
            file2.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(ref2));
            ((DocumentReferenceByVirtualFile)ref2).update(file2);
        }
    }

    private synchronized void fileDeleted(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(12);
        }
        DocumentReference ref2 = (DocumentReference)SoftReference.dereference((Reference)((Reference)file2.getUserData(FILE_TO_REF_KEY)));
        file2.putUserData(FILE_TO_REF_KEY, null);
        if (ref2 != null) {
            this.deletedFilePathToRef.put(DocumentReferenceManagerImpl.filePath(file2), ref2);
        }
    }

    @NotNull
    private static FilePath filePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(13);
        }
        return new FilePath(file2.getUrl());
    }

    @TestOnly
    public synchronized void cleanupForNextTest() {
        this.docToRef.clear();
        this.deletedFilePathToRef.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromDocument";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromLocal";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromNonLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFromDocument";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFromLocal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFromNonLocal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fileCreated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fileDeleted";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }

    private final class CreateDeleteFileListener
    implements AsyncFileListener {
        private CreateDeleteFileListener() {
        }

        @NotNull
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                CreateDeleteFileListener.$$$reportNull$$$0(0);
            }
            NotNullList deletedFiles = new NotNullList();
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                CreateDeleteFileListener.collectDeletedFiles(deleteEvent.getFile(), (List<? super VirtualFile>)deletedFiles);
            }
            return new AsyncFileListener.ChangeApplier(){
                final /* synthetic */ List val$deletedFiles;
                final /* synthetic */ List val$events;
                {
                    this.val$deletedFiles = list2;
                    this.val$events = list3;
                }

                public void afterVfsChange() {
                    for (VirtualFile file2 : this.val$deletedFiles) {
                        DocumentReferenceManagerImpl.this.fileDeleted(file2);
                    }
                    for (VFileEvent event : this.val$events) {
                        if (!(event instanceof VFileCreateEvent)) continue;
                        VFileCreateEvent createEvent = (VFileCreateEvent)event;
                        DocumentReferenceManagerImpl.this.fileCreated(createEvent);
                    }
                }
            };
        }

        private static void collectDeletedFiles(@NotNull VirtualFile parentFile, @NotNull List<? super VirtualFile> collectedFiles) {
            if (parentFile == null) {
                CreateDeleteFileListener.$$$reportNull$$$0(1);
            }
            if (collectedFiles == null) {
                CreateDeleteFileListener.$$$reportNull$$$0(2);
            }
            if (parentFile instanceof NewVirtualFile) {
                NewVirtualFile file2 = (NewVirtualFile)parentFile;
                ProgressManager.checkCanceled();
                if (parentFile.isDirectory()) {
                    for (VirtualFile childFile : file2.iterInDbChildren()) {
                        CreateDeleteFileListener.collectDeletedFiles(childFile, collectedFiles);
                    }
                } else {
                    collectedFiles.add((VirtualFile)parentFile);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collectedFiles";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl$CreateDeleteFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectDeletedFiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

