/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.InplaceCommentAppender;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.FileEditorStateWithPreferredOpenMode;
import com.intellij.openapi.fileEditor.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl$RecentlyChangedFilesState$;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImplKt;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.ExternalChangeActionUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="IdeDocumentHistory", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")}, reportStatistic=false)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0006vwxyz{B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020!J\n\u0010/\u001a\u0004\u0018\u000100H\u0014J\u0010\u00101\u001a\u00020+2\u0006\u0010.\u001a\u00020!H\u0002J\b\u00102\u001a\u00020\u0004H\u0016J\u0010\u00103\u001a\u00020+2\u0006\u0010)\u001a\u00020\u0004H\u0016J\b\u00104\u001a\u00020+H\u0016J\b\u00105\u001a\u00020+H\u0016J\u0010\u00106\u001a\u00020+2\b\u00107\u001a\u0004\u0018\u00010\u0016J\n\u00108\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u00109\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010:\u001a\u00020+2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\u0016J\b\u0010;\u001a\u00020+H\u0016J\b\u0010<\u001a\u00020+H\u0016J\b\u0010=\u001a\u00020+H\u0016J\u0010\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020\u0012H\u0002J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020!0AH\u0016J\u000e\u0010B\u001a\u00020\u00122\u0006\u0010.\u001a\u00020!J\b\u0010C\u001a\u00020+H\u0016J\b\u0010D\u001a\u00020+H\u0016J\b\u0010E\u001a\u00020+H\u0016J\n\u0010F\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010G\u001a\u00020\u0012H\u0016J\b\u0010H\u001a\u00020\u0012H\u0016J\b\u0010I\u001a\u00020+H\u0016J\u0006\u0010J\u001a\u00020+J\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000f0AJ\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0AJ\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u000f0AJ\u000e\u0010N\u001a\u00020+2\u0006\u0010O\u001a\u00020\u000fJ\u000e\u0010P\u001a\u00020+2\u0006\u0010O\u001a\u00020\u000fJ&\u0010Q\u001a\u00020+2\u0006\u0010O\u001a\u00020\u000f2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u000f0S2\u0006\u0010T\u001a\u00020\u0012H\u0002J\b\u0010U\u001a\u00020\u0012H\u0016J\u0006\u0010V\u001a\u00020+J\b\u0010W\u001a\u00020\u0012H\u0016J\u0016\u0010X\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0YH\u0002J\u0010\u0010Z\u001a\u00020+2\u0006\u0010[\u001a\u00020\u000fH\u0016J\u0018\u0010Z\u001a\u00020+2\u0006\u0010[\u001a\u00020\u000f2\u0006\u0010\\\u001a\u00020\u0012H\u0016J\n\u0010]\u001a\u0004\u0018\u00010^H\u0014J\u001a\u0010_\u001a\u0004\u0018\u00010\u000f2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020cH\u0014J\u0012\u0010d\u001a\u0004\u0018\u00010e2\u0006\u0010`\u001a\u00020aH\u0002J\u0010\u0010f\u001a\u00020+2\u0006\u0010.\u001a\u00020!H\u0002J*\u0010g\u001a\u00020+2\u0006\u0010h\u001a\u00020\u000f2\u0006\u0010i\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020\u00122\b\u0010k\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010l\u001a\u00020\fH\u0002J\b\u0010m\u001a\u00020+H\u0016J)\u0010n\u001a\u00020+2\u0006\u0010o\u001a\u00020p2\r\u0010q\u001a\t\u0018\u00010'\u00a2\u0006\u0002\br2\b\u0010k\u001a\u0004\u0018\u00010\u0016H\u0014J\u0018\u0010s\u001a\u00020\u00122\u0006\u0010t\u001a\u00020\u000f2\u0006\u0010u\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl;", "Lcom/intellij/openapi/fileEditor/ex/IdeDocumentHistory;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentlyChangedFilesState;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "backPlaces", "Ljava/util/ArrayDeque;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo;", "forwardPlaces", "backInProgress", "", "forwardInProgress", "currentCommandGroupId", "Ljava/lang/ref/Reference;", "", "lastGroupId", "registeredBackPlaceInLastGroup", "changePlaces", "currentIndex", "", "commandStartPlace", "currentCommandIsNavigation", "currentCommandHasChanges", "changedFilesInCurrentCommand", "Ljava/util/HashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentCommandHasMoves", "reallyExcludeCurrentCommandFromNavigation", "recentFileTimestampMap", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/intellij/util/io/PersistentHashMap;", "", "", "state", "appendTimestamp", "", "appender", "Lcom/intellij/ide/util/treeView/InplaceCommentAppender;", "file", "getFileEditorManager", "Lcom/intellij/openapi/fileEditor/ex/FileEditorManagerEx;", "registerViewed", "getState", "loadState", "onSelectionChanged", "reallyExcludeCurrentCommandAsNavigation", "onCommandStarted", "commandGroupId", "getCurrentPlaceInfo", "getPlaceInfoFromFocus", "onCommandFinished", "includeCurrentCommandAsNavigation", "setCurrentCommandHasMoves", "includeCurrentPlaceAsChangePlace", "setCurrentChangePlace", "acceptPlaceFromFocus", "getChangedFiles", "", "isRecentlyChanged", "clearHistory", "back", "forward", "getTargetForwardInfo", "isBackAvailable", "isForwardAvailable", "navigatePreviousChange", "navigateNextChange", "getBackPlaces", "getForwardPlaces", "getChangePlaces", "removeBackPlace", "placeInfo", "removeChangePlace", "removePlaceInfo", "places", "", "changed", "isNavigatePreviousChangeAvailable", "removeInvalidFilesFromStacks", "isNavigateNextChangeAvailable", "removeInvalidFilesFrom", "Ljava/util/Deque;", "gotoPlaceInfo", "info", "requestFocus", "getSelectedEditor", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "createPlaceInfo", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "fileProvider", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "getCaretPosition", "Lcom/intellij/openapi/editor/RangeMarker;", "notifyFileHistoryReordered", "putLastOrMerge", "next", "limit", "isChanged", "groupId", "getFileDocumentManager", "dispose", "executeCommand", "runnable", "Ljava/lang/Runnable;", "name", "Lcom/intellij/openapi/util/NlsContexts$Command;", "isSame", "first", "second", "RecentlyChangedFilesState", "OptionallyIncluded", "SkipFromDocumentHistory", "PlaceInfo", "RecentPlacesListener", "RecentFileHistoryOrderListener", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIdeDocumentHistoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeDocumentHistoryImpl.kt\ncom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,769:1\n1#2:770\n*E\n"})
public class IdeDocumentHistoryImpl
extends IdeDocumentHistory
implements Disposable,
PersistentStateComponent<RecentlyChangedFilesState> {
    @NotNull
    private final Project project;
    @Nullable
    private FileDocumentManager fileDocumentManager;
    @NotNull
    private final ArrayDeque<PlaceInfo> backPlaces;
    @NotNull
    private final ArrayDeque<PlaceInfo> forwardPlaces;
    private boolean backInProgress;
    private boolean forwardInProgress;
    @Nullable
    private Reference<Object> currentCommandGroupId;
    @Nullable
    private Reference<Object> lastGroupId;
    private boolean registeredBackPlaceInLastGroup;
    @NotNull
    private final ArrayDeque<PlaceInfo> changePlaces;
    private int currentIndex;
    @Nullable
    private PlaceInfo commandStartPlace;
    private boolean currentCommandIsNavigation;
    private boolean currentCommandHasChanges;
    @NotNull
    private final HashSet<VirtualFile> changedFilesInCurrentCommand;
    private boolean currentCommandHasMoves;
    private boolean reallyExcludeCurrentCommandFromNavigation;
    @NotNull
    private final SynchronizedClearableLazy<PersistentHashMap<String, Long>> recentFileTimestampMap;
    @NotNull
    private volatile RecentlyChangedFilesState state;

    public IdeDocumentHistoryImpl(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.backPlaces = new ArrayDeque();
        this.forwardPlaces = new ArrayDeque();
        this.changePlaces = new ArrayDeque();
        this.changedFilesInCurrentCommand = new HashSet();
        this.state = new RecentlyChangedFilesState(null, 1, null);
        SimpleMessageBusConnection connection = this.project.getMessageBus().connect(coroutineScope);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    this.removeInvalidFilesFromStacks();
                    return;
                }
            }
        });
        Topic topic2 = CommandListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new CommandListener(){

            public void commandStarted(CommandEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.onCommandStarted(event.getCommandGroupId());
            }

            public void commandFinished(CommandEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.onCommandFinished(event.getProject(), event.getCommandGroupId());
            }
        });
        EditorEventListener listener2 = new EditorEventListener(this){
            final /* synthetic */ IdeDocumentHistoryImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                VirtualFile file2 = IdeDocumentHistoryImpl.access$getFileDocumentManager(this.this$0).getFile(e.getDocument());
                if (file2 != null && !(file2 instanceof LightVirtualFile) && !ExternalChangeActionUtil.isExternalChangeInProgress()) {
                    ThreadingAssertions.assertEventDispatchThread();
                    IdeDocumentHistoryImpl.access$setCurrentCommandHasChanges$p(this.this$0, true);
                    IdeDocumentHistoryImpl.access$getChangedFilesInCurrentCommand$p(this.this$0).add(file2);
                }
            }

            public void caretPositionChanged(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getOldPosition().line == e.getNewPosition().line) {
                    return;
                }
                Document document2 = e.getEditor().getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                Document document3 = document2;
                if (IdeDocumentHistoryImpl.access$getFileDocumentManager(this.this$0).getFile(document3) != null) {
                    IdeDocumentHistoryImpl.access$setCurrentCommandHasMoves$p(this.this$0, true);
                }
            }
        };
        this.recentFileTimestampMap = new SynchronizedClearableLazy(() -> IdeDocumentHistoryImpl._init_$lambda$0(this));
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster multicaster = editorEventMulticaster;
        multicaster.addDocumentListener((DocumentListener)listener2, (Disposable)this);
        multicaster.addCaretListener((CaretListener)listener2, (Disposable)this);
        FileEditorProvider.EP_FILE_EDITOR_PROVIDER.addExtensionPointListener(coroutineScope, (ExtensionPointListener)new ExtensionPointListener<FileEditorProvider>(){

            public void extensionRemoved(FileEditorProvider provider, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                String string = provider.getEditorTypeId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEditorTypeId(...)");
                String editorTypeId = string;
                Predicate<PlaceInfo> clearStatePredicate = arg_0 -> 4.extensionRemoved$lambda$0(editorTypeId, arg_0);
                if (changePlaces.removeIf(clearStatePredicate)) {
                    currentIndex = changePlaces.size();
                }
                backPlaces.removeIf(clearStatePredicate);
                forwardPlaces.removeIf(clearStatePredicate);
                PlaceInfo placeInfo = commandStartPlace;
                if (Intrinsics.areEqual((Object)(placeInfo != null ? placeInfo.getEditorTypeId() : null), (Object)editorTypeId)) {
                    commandStartPlace = null;
                }
            }

            private static final boolean extensionRemoved$lambda$0(String $editorTypeId, PlaceInfo e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return Intrinsics.areEqual((Object)$editorTypeId, (Object)e.getEditorTypeId());
            }
        });
    }

    public final void appendTimestamp(@NotNull InplaceCommentAppender appender, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)appender, (String)"appender");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!UISettings.Companion.getInstance().getShowInplaceComments()) {
            return;
        }
        try {
            Long timestamp = (Long)((PersistentHashMap)this.recentFileTimestampMap.getValue()).get((Object)file2.getPath());
            if (timestamp != null) {
                appender.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                appender.append(DateFormatUtil.formatPrettyDateTime((long)timestamp), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
        catch (IOException e) {
            IdeDocumentHistoryImplKt.access$getLOG$p().info("Cannot get a timestamp from a persistent hash map", (Throwable)e);
        }
    }

    @Nullable
    protected FileEditorManagerEx getFileEditorManager() {
        return FileEditorManagerEx.Companion.getInstanceExIfCreated(this.project);
    }

    private final void registerViewed(VirtualFile file2) {
        if (ApplicationManager.getApplication().isUnitTestMode() || !UISettings.Companion.getInstance().getShowInplaceComments()) {
            return;
        }
        try {
            ((PersistentHashMap)this.recentFileTimestampMap.getValue()).put((Object)file2.getPath(), (Object)System.currentTimeMillis());
        }
        catch (IOException e) {
            IdeDocumentHistoryImplKt.access$getLOG$p().info("Cannot put a timestamp from a persistent hash map", (Throwable)e);
        }
    }

    @NotNull
    public RecentlyChangedFilesState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull RecentlyChangedFilesState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        RecentlyChangedFilesState recentlyChangedFilesState = this.state;
        synchronized (recentlyChangedFilesState) {
            boolean bl = false;
            this.state = state2;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void onSelectionChanged() {
        if (!this.reallyExcludeCurrentCommandFromNavigation) {
            this.currentCommandIsNavigation = true;
        }
        this.currentCommandHasMoves = true;
    }

    @Override
    public void reallyExcludeCurrentCommandAsNavigation() {
        this.reallyExcludeCurrentCommandFromNavigation = true;
        this.currentCommandIsNavigation = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void onCommandStarted(@Nullable Object commandGroupId) {
        WeakReference<void> weakReference;
        IdeDocumentHistoryImpl ideDocumentHistoryImpl = this;
        Object object = commandGroupId;
        if (object != null) {
            void it;
            Object object2 = object;
            IdeDocumentHistoryImpl ideDocumentHistoryImpl2 = ideDocumentHistoryImpl;
            boolean bl = false;
            weakReference = new WeakReference<void>(it);
            ideDocumentHistoryImpl = ideDocumentHistoryImpl2;
        } else {
            weakReference = null;
        }
        ideDocumentHistoryImpl.currentCommandGroupId = weakReference;
        this.commandStartPlace = this.getCurrentPlaceInfo();
        this.currentCommandIsNavigation = false;
        this.currentCommandHasChanges = false;
        this.currentCommandHasMoves = false;
        this.reallyExcludeCurrentCommandFromNavigation = false;
        this.changedFilesInCurrentCommand.clear();
    }

    private final PlaceInfo getCurrentPlaceInfo() {
        FileEditorWithProvider fileEditorWithProvider = this.getSelectedEditor();
        if (fileEditorWithProvider == null) {
            return null;
        }
        FileEditorWithProvider selectedEditorWithProvider = fileEditorWithProvider;
        return this.createPlaceInfo(selectedEditorWithProvider.getFileEditor(), selectedEditorWithProvider.getProvider());
    }

    private final PlaceInfo getPlaceInfoFromFocus(Project project2) {
        VirtualFile file2;
        FileEditor fileEditor = new FocusBasedCurrentEditorProvider().getCurrentEditor(project2);
        if (fileEditor instanceof TextEditor && ((TextEditor)fileEditor).isValid() && (file2 = ((TextEditor)fileEditor).getFile()) != null) {
            FileEditorState fileEditorState = ((TextEditor)fileEditor).getState(FileEditorStateLevel.NAVIGATION);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"getState(...)");
            return new PlaceInfo(file2, fileEditorState, TextEditorProvider.Companion.getInstance().getEditorTypeId(), null, false, this.getCaretPosition(fileEditor), System.currentTimeMillis());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void onCommandFinished(@Nullable Project project2, @Nullable Object commandGroupId) {
        PlaceInfo commandStartPlace;
        Object lastGroupId;
        Reference<Object> reference = this.lastGroupId;
        Object object = lastGroupId = reference != null ? reference.get() : null;
        if (!CommandMerger.canMergeGroup(commandGroupId, lastGroupId)) {
            this.registeredBackPlaceInLastGroup = false;
        }
        if (commandGroupId != lastGroupId) {
            WeakReference<void> weakReference;
            IdeDocumentHistoryImpl ideDocumentHistoryImpl = this;
            Object object2 = commandGroupId;
            if (object2 != null) {
                void it;
                Object object3 = object2;
                IdeDocumentHistoryImpl ideDocumentHistoryImpl2 = ideDocumentHistoryImpl;
                boolean bl = false;
                weakReference = new WeakReference<void>(it);
                ideDocumentHistoryImpl = ideDocumentHistoryImpl2;
            } else {
                weakReference = null;
            }
            ideDocumentHistoryImpl.lastGroupId = weakReference;
        }
        if ((commandStartPlace = this.commandStartPlace) != null && this.currentCommandIsNavigation && this.currentCommandHasMoves) {
            if (!this.backInProgress) {
                if (!this.registeredBackPlaceInLastGroup) {
                    this.registeredBackPlaceInLastGroup = true;
                    this.putLastOrMerge(commandStartPlace, IdeDocumentHistoryImplKt.access$getBACK_QUEUE_LIMIT$p(), false, commandGroupId);
                    this.registerViewed(commandStartPlace.getFile());
                }
                if (!this.forwardInProgress) {
                    this.forwardPlaces.clear();
                }
            }
            this.removeInvalidFilesFromStacks();
        }
        if (this.currentCommandHasChanges) {
            this.setCurrentChangePlace(project2 == this.project);
        } else if (this.currentCommandHasMoves) {
            this.currentIndex = this.changePlaces.size();
        }
    }

    @Override
    public void includeCurrentCommandAsNavigation() {
        if (!this.reallyExcludeCurrentCommandFromNavigation) {
            this.currentCommandIsNavigation = true;
        }
    }

    @Override
    public void setCurrentCommandHasMoves() {
        this.currentCommandHasMoves = true;
    }

    @Override
    public void includeCurrentPlaceAsChangePlace() {
        this.setCurrentChangePlace(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setCurrentChangePlace(boolean acceptPlaceFromFocus) {
        PlaceInfo placeInfo = null;
        placeInfo = this.getCurrentPlaceInfo();
        if (placeInfo != null && !this.changedFilesInCurrentCommand.contains(placeInfo.getFile())) {
            placeInfo = null;
        }
        if (placeInfo == null && acceptPlaceFromFocus) {
            placeInfo = this.getPlaceInfoFromFocus(this.project);
        }
        if (placeInfo != null && !this.changedFilesInCurrentCommand.contains(placeInfo.getFile())) {
            placeInfo = null;
        }
        if (placeInfo == null) {
            return;
        }
        int limit = UISettings.Companion.getInstance().getRecentFilesLimit() + 1;
        RecentlyChangedFilesState recentlyChangedFilesState = this.state;
        synchronized (recentlyChangedFilesState) {
            boolean bl = false;
            String string = placeInfo.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String path = string;
            List changedPaths = CollectionsKt.toMutableList((Collection)this.state.changedPaths);
            changedPaths.remove(path);
            changedPaths.add(path);
            while (changedPaths.size() > limit) {
                changedPaths.remove(0);
            }
            this.state = new RecentlyChangedFilesState(changedPaths);
            Unit unit = Unit.INSTANCE;
        }
        Reference<Object> reference = this.currentCommandGroupId;
        this.putLastOrMerge(placeInfo, IdeDocumentHistoryImplKt.access$getCHANGE_QUEUE_LIMIT$p(), true, reference != null ? reference.get() : null);
        this.notifyFileHistoryReordered(placeInfo.getFile());
        this.currentIndex = this.changePlaces.size();
    }

    @Override
    @NotNull
    public List<VirtualFile> getChangedFiles() {
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFs = localFileSystem;
        for (String path : this.state.changedPaths) {
            VirtualFile it;
            if (localFs.findFileByPath(path) == null) continue;
            boolean bl = false;
            files2.add(it);
        }
        return files2;
    }

    public final boolean isRecentlyChanged(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.state.changedPaths.contains(file2.getPath());
    }

    @Override
    public void clearHistory() {
        this.backPlaces.clear();
        this.forwardPlaces.clear();
        this.changePlaces.clear();
        this.lastGroupId = null;
        this.currentIndex = 0;
        this.commandStartPlace = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void back() {
        this.removeInvalidFilesFromStacks();
        if (this.backPlaces.isEmpty()) {
            return;
        }
        PlaceInfo info = this.backPlaces.removeLast();
        RecentPlacesListener recentPlacesListener = (RecentPlacesListener)this.project.getMessageBus().syncPublisher(RecentPlacesListener.TOPIC);
        Intrinsics.checkNotNull((Object)info);
        recentPlacesListener.recentPlaceRemoved(info, false);
        PlaceInfo current = this.getCurrentPlaceInfo();
        if (current != null) {
            this.forwardPlaces.add(current);
        }
        this.backInProgress = true;
        try {
            this.executeCommand(() -> IdeDocumentHistoryImpl.back$lambda$0(this, info), "", null);
        }
        finally {
            this.backInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forward() {
        this.removeInvalidFilesFromStacks();
        PlaceInfo placeInfo = this.getTargetForwardInfo();
        if (placeInfo == null) {
            return;
        }
        PlaceInfo target = placeInfo;
        this.forwardInProgress = true;
        try {
            this.executeCommand(() -> IdeDocumentHistoryImpl.forward$lambda$0(this, target), "", null);
        }
        finally {
            this.forwardInProgress = false;
        }
    }

    private final PlaceInfo getTargetForwardInfo() {
        if (this.forwardPlaces.isEmpty()) {
            return null;
        }
        PlaceInfo target = this.forwardPlaces.removeLast();
        PlaceInfo current = this.getCurrentPlaceInfo();
        while (!this.forwardPlaces.isEmpty() && current != null) {
            PlaceInfo placeInfo = target;
            Intrinsics.checkNotNull((Object)placeInfo);
            if (!this.isSame(current, placeInfo)) break;
            target = this.forwardPlaces.removeLast();
        }
        return target;
    }

    @Override
    public boolean isBackAvailable() {
        return !this.backPlaces.isEmpty();
    }

    @Override
    public boolean isForwardAvailable() {
        return !this.forwardPlaces.isEmpty();
    }

    @Override
    public void navigatePreviousChange() {
        this.removeInvalidFilesFromStacks();
        if (this.currentIndex == 0) {
            return;
        }
        PlaceInfo currentPlace = this.getCurrentPlaceInfo();
        List<PlaceInfo> changePlaces = this.getChangePlaces();
        for (int i2 = this.currentIndex - 1; -1 < i2; --i2) {
            PlaceInfo info = changePlaces.get(i2);
            if (currentPlace != null && this.isSame(currentPlace, info)) continue;
            this.executeCommand(() -> IdeDocumentHistoryImpl.navigatePreviousChange$lambda$0(this, info), "", null);
            this.currentIndex = i2;
            break;
        }
    }

    @Override
    public final void navigateNextChange() {
        this.removeInvalidFilesFromStacks();
        if (this.currentIndex >= this.changePlaces.size()) {
            return;
        }
        PlaceInfo currentPlace = this.getCurrentPlaceInfo();
        List<PlaceInfo> changePlaces = this.getChangePlaces();
        int n = changePlaces.size();
        for (int i2 = this.currentIndex; i2 < n; ++i2) {
            PlaceInfo info = changePlaces.get(i2);
            if (currentPlace != null && this.isSame(currentPlace, info)) continue;
            this.executeCommand(() -> IdeDocumentHistoryImpl.navigateNextChange$lambda$0(this, info), "", null);
            this.currentIndex = i2 + 1;
            break;
        }
    }

    @Override
    @NotNull
    public final List<PlaceInfo> getBackPlaces() {
        List<PlaceInfo> list2 = List.copyOf((Collection)this.backPlaces);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"copyOf(...)");
        return list2;
    }

    @Override
    @NotNull
    public final List<PlaceInfo> getForwardPlaces() {
        List<PlaceInfo> list2 = List.copyOf((Collection)this.forwardPlaces);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"copyOf(...)");
        return list2;
    }

    @Override
    @NotNull
    public final List<PlaceInfo> getChangePlaces() {
        List<PlaceInfo> list2 = List.copyOf((Collection)this.changePlaces);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"copyOf(...)");
        return list2;
    }

    @Override
    public final void removeBackPlace(@NotNull PlaceInfo placeInfo) {
        Intrinsics.checkNotNullParameter((Object)placeInfo, (String)"placeInfo");
        this.removePlaceInfo(placeInfo, (Collection<PlaceInfo>)this.backPlaces, false);
    }

    @Override
    public final void removeChangePlace(@NotNull PlaceInfo placeInfo) {
        Intrinsics.checkNotNullParameter((Object)placeInfo, (String)"placeInfo");
        this.removePlaceInfo(placeInfo, (Collection<PlaceInfo>)this.changePlaces, true);
    }

    private final void removePlaceInfo(PlaceInfo placeInfo, Collection<PlaceInfo> places, boolean changed) {
        boolean removed = places.remove(placeInfo);
        if (removed) {
            ((RecentPlacesListener)this.project.getMessageBus().syncPublisher(RecentPlacesListener.TOPIC)).recentPlaceRemoved(placeInfo, changed);
        }
    }

    @Override
    public boolean isNavigatePreviousChangeAvailable() {
        return this.currentIndex > 0;
    }

    public final void removeInvalidFilesFromStacks() {
        this.removeInvalidFilesFrom((Deque<PlaceInfo>)this.backPlaces);
        this.removeInvalidFilesFrom((Deque<PlaceInfo>)this.forwardPlaces);
        if (this.removeInvalidFilesFrom((Deque<PlaceInfo>)this.changePlaces)) {
            this.currentIndex = this.changePlaces.size();
        }
    }

    @Override
    public boolean isNavigateNextChangeAvailable() {
        return this.currentIndex < this.changePlaces.size();
    }

    private final boolean removeInvalidFilesFrom(Deque<PlaceInfo> backPlaces) {
        return backPlaces.removeIf(arg_0 -> IdeDocumentHistoryImpl.removeInvalidFilesFrom$lambda$1(arg_0 -> IdeDocumentHistoryImpl.removeInvalidFilesFrom$lambda$0(this, arg_0), arg_0));
    }

    @Override
    public void gotoPlaceInfo(@NotNull PlaceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.gotoPlaceInfo(info, ToolWindowManager.Companion.getInstance(this.project).isEditorComponentActive());
    }

    @Override
    public void gotoPlaceInfo(@NotNull PlaceInfo info, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        FileEditorManagerEx fileEditorManagerEx = this.getFileEditorManager();
        Intrinsics.checkNotNull((Object)((Object)fileEditorManagerEx));
        FileEditorManagerEx editorManager = fileEditorManagerEx;
        FileEditorManagerImpl.OpenMode openMode = info.getOpenMode();
        EditorWindow window = openMode != FileEditorManagerImpl.OpenMode.NEW_WINDOW ? info.getWindow() : null;
        boolean bl = info.isPreviewTab();
        FileEditorComposite editorsWithProviders2 = editorManager.openFile(info.getFile(), window, new FileEditorOpenOptions(false, true, bl, requestFocus, false, 0, false, openMode, false, false, false, null, 3953, null));
        editorManager.setSelectedEditor(info.getFile(), info.getEditorTypeId());
        List list2 = editorsWithProviders2.getAllEditorsWithProviders();
        for (FileEditorWithProvider item : list2) {
            String typeId;
            Intrinsics.checkNotNullExpressionValue((Object)item.getProvider().getEditorTypeId(), (String)"getEditorTypeId(...)");
            if (!Intrinsics.areEqual((Object)typeId, (Object)info.getEditorTypeId())) continue;
            item.getFileEditor().setState(info.getNavigationState());
        }
    }

    @Nullable
    protected FileEditorWithProvider getSelectedEditor() {
        FileEditorManagerEx editorManager = this.getFileEditorManager();
        FileEditorManagerEx fileEditorManagerEx = editorManager;
        if (fileEditorManagerEx == null || (fileEditorManagerEx = fileEditorManagerEx.getCurrentFile()) == null) {
            return null;
        }
        FileEditorManagerEx file2 = fileEditorManagerEx;
        return editorManager.getSelectedEditorWithProvider((VirtualFile)file2);
    }

    @Nullable
    protected PlaceInfo createPlaceInfo(@NotNull FileEditor fileEditor, @NotNull FileEditorProvider fileProvider2) {
        EditorWindow window;
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)fileProvider2, (String)"fileProvider");
        if (!fileEditor.isValid()) {
            return null;
        }
        FileEditorManagerEx editorManager = this.getFileEditorManager();
        VirtualFile virtualFile2 = fileEditor.getFile();
        if (virtualFile2 == null) {
            boolean $i$a$-requireNotNull-IdeDocumentHistoryImpl$createPlaceInfo$file$22 = false;
            String $i$a$-requireNotNull-IdeDocumentHistoryImpl$createPlaceInfo$file$22 = fileEditor.getClass().getName() + " getFile() returned null";
            throw new IllegalArgumentException($i$a$-requireNotNull-IdeDocumentHistoryImpl$createPlaceInfo$file$22.toString());
        }
        VirtualFile file2 = virtualFile2;
        if (file2 instanceof SkipFromDocumentHistory && !((SkipFromDocumentHistory)file2).isIncludedInDocumentHistory(this.project)) {
            return null;
        }
        FileEditorState fileEditorState = fileEditor.getState(FileEditorStateLevel.NAVIGATION);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"getState(...)");
        FileEditorState state2 = fileEditorState;
        FileEditorManagerEx fileEditorManagerEx = editorManager;
        EditorWindow editorWindow = window = fileEditorManagerEx != null ? fileEditorManagerEx.getCurrentWindow() : null;
        EditorComposite composite2 = editorWindow != null ? editorWindow.getComposite(file2) : null;
        String string = fileProvider2.getEditorTypeId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEditorTypeId(...)");
        return new PlaceInfo(file2, state2, string, window, composite2 != null && composite2.isPreview(), this.getCaretPosition(fileEditor), System.currentTimeMillis());
    }

    private final RangeMarker getCaretPosition(FileEditor fileEditor) {
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor2 = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        int offset = editor3.getCaretModel().getOffset();
        RangeMarker marker = (RangeMarker)fileEditor.getUserData(IdeDocumentHistoryImplKt.access$getCACHED_CARET_MARKER_KEY$p());
        if (marker == null || !marker.isValid() || marker.getStartOffset() != offset || marker.getEndOffset() != offset) {
            marker = editor3.getDocument().createRangeMarker(offset, offset);
            fileEditor.putUserData(IdeDocumentHistoryImplKt.access$getCACHED_CARET_MARKER_KEY$p(), (Object)marker);
        }
        return marker;
    }

    private final void notifyFileHistoryReordered(VirtualFile file2) {
        if (VirtualFileUtil.isFile((VirtualFile)file2)) {
            ((RecentFileHistoryOrderListener)this.project.getMessageBus().syncPublisher(RecentFileHistoryOrderListener.TOPIC)).recentFileUpdated(file2);
        }
    }

    private final void putLastOrMerge(PlaceInfo next, int limit, boolean isChanged, Object groupId) {
        ArrayDeque<PlaceInfo> list2 = isChanged ? this.changePlaces : this.backPlaces;
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus messageBus2 = messageBus;
        RecentPlacesListener listener2 = (RecentPlacesListener)messageBus2.syncPublisher(RecentPlacesListener.TOPIC);
        if (!list2.isEmpty()) {
            PlaceInfo prev = list2.getLast();
            Intrinsics.checkNotNull((Object)prev);
            if (this.isSame(prev, next)) {
                PlaceInfo removed = list2.removeLast();
                Intrinsics.checkNotNull((Object)removed);
                listener2.recentPlaceRemoved(removed, isChanged);
            }
        }
        list2.add(next);
        listener2.recentPlaceAdded(next, isChanged, groupId);
        if (list2.size() > limit) {
            PlaceInfo first = list2.removeFirst();
            Intrinsics.checkNotNull((Object)first);
            listener2.recentPlaceRemoved(first, isChanged);
        }
    }

    private final FileDocumentManager getFileDocumentManager() {
        FileDocumentManager fileDocumentManager = this.fileDocumentManager;
        if (fileDocumentManager == null) {
            this.fileDocumentManager = fileDocumentManager = FileDocumentManager.getInstance();
        }
        return fileDocumentManager;
    }

    public void dispose() {
        this.lastGroupId = null;
        this.currentCommandGroupId = null;
        PersistentHashMap persistentHashMap = (PersistentHashMap)this.recentFileTimestampMap.getValueIfInitialized();
        if (persistentHashMap == null) {
            return;
        }
        PersistentHashMap map2 = persistentHashMap;
        try {
            map2.close();
        }
        catch (IOException e) {
            IdeDocumentHistoryImplKt.access$getLOG$p().info("Cannot close persistent viewed files timestamps hash map", (Throwable)e);
        }
    }

    protected void executeCommand(@NotNull Runnable runnable2, @Nullable String name2, @Nullable Object groupId) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        CommandProcessor.getInstance().executeCommand(this.project, runnable2, name2, groupId);
    }

    @Override
    public boolean isSame(@NotNull PlaceInfo first, @NotNull PlaceInfo second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first.getFile(), (Object)second.getFile())) {
            FileEditorState secondState;
            FileEditorState firstState = first.getNavigationState();
            return Intrinsics.areEqual((Object)firstState, (Object)(secondState = second.getNavigationState())) || firstState.canBeMergedWith(secondState, FileEditorStateLevel.NAVIGATION);
        }
        return false;
    }

    private static final PersistentHashMap _init_$lambda$0(IdeDocumentHistoryImpl this$0) {
        return IdeDocumentHistoryImplKt.access$initRecentFilesTimestampMap(this$0.project);
    }

    private static final void back$lambda$0(IdeDocumentHistoryImpl this$0, PlaceInfo $info) {
        Intrinsics.checkNotNull((Object)$info);
        this$0.gotoPlaceInfo($info);
    }

    private static final void forward$lambda$0(IdeDocumentHistoryImpl this$0, PlaceInfo $target) {
        this$0.gotoPlaceInfo($target);
    }

    private static final void navigatePreviousChange$lambda$0(IdeDocumentHistoryImpl this$0, PlaceInfo $info) {
        this$0.gotoPlaceInfo($info, true);
    }

    private static final void navigateNextChange$lambda$0(IdeDocumentHistoryImpl this$0, PlaceInfo $info) {
        this$0.gotoPlaceInfo($info);
    }

    private static final boolean removeInvalidFilesFrom$lambda$0(IdeDocumentHistoryImpl this$0, PlaceInfo info) {
        VirtualFile file2 = info.getFile();
        return file2 instanceof OptionallyIncluded && !((OptionallyIncluded)file2).isIncludedInDocumentHistory(this$0.project) || !file2.isValid();
    }

    private static final boolean removeInvalidFilesFrom$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ FileDocumentManager access$getFileDocumentManager(IdeDocumentHistoryImpl $this) {
        return $this.getFileDocumentManager();
    }

    public static final /* synthetic */ void access$setCurrentCommandHasChanges$p(IdeDocumentHistoryImpl $this, boolean bl) {
        $this.currentCommandHasChanges = bl;
    }

    public static final /* synthetic */ HashSet access$getChangedFilesInCurrentCommand$p(IdeDocumentHistoryImpl $this) {
        return $this.changedFilesInCurrentCommand;
    }

    public static final /* synthetic */ void access$setCurrentCommandHasMoves$p(IdeDocumentHistoryImpl $this, boolean bl) {
        $this.currentCommandHasMoves = bl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$OptionallyIncluded;", "", "isIncludedInDocumentHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    public static interface OptionallyIncluded {
        public boolean isIncludedInDocumentHistory(@NotNull Project var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0010\u0010\u0012J\b\u0010 \u001a\u0004\u0018\u00010\tJ\n\u0010!\u001a\u00020\u0007H\u0096\u0080\u0004J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0019R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "navigationState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "editorTypeId", "", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "isPreviewTab", "", "caretPosition", "Lcom/intellij/openapi/editor/RangeMarker;", "timeStamp", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/FileEditorState;Ljava/lang/String;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;ZLcom/intellij/openapi/editor/RangeMarker;J)V", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/FileEditorState;Ljava/lang/String;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;Lcom/intellij/openapi/editor/RangeMarker;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getNavigationState", "()Lcom/intellij/openapi/fileEditor/FileEditorState;", "getEditorTypeId", "()Ljava/lang/String;", "()Z", "getCaretPosition", "()Lcom/intellij/openapi/editor/RangeMarker;", "getTimeStamp", "()J", "windowRef", "Ljava/lang/ref/WeakReference;", "getWindow", "toString", "getOpenMode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nIdeDocumentHistoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeDocumentHistoryImpl.kt\ncom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,769:1\n1#2:770\n*E\n"})
    public static final class PlaceInfo {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final FileEditorState navigationState;
        @NotNull
        private final String editorTypeId;
        private final boolean isPreviewTab;
        @Nullable
        private final RangeMarker caretPosition;
        private final long timeStamp;
        @NotNull
        private final WeakReference<EditorWindow> windowRef;

        public PlaceInfo(@NotNull VirtualFile file2, @NotNull FileEditorState navigationState, @NotNull String editorTypeId, @Nullable EditorWindow window, boolean isPreviewTab, @Nullable RangeMarker caretPosition, long timeStamp) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)navigationState, (String)"navigationState");
            Intrinsics.checkNotNullParameter((Object)editorTypeId, (String)"editorTypeId");
            this.file = file2;
            this.navigationState = navigationState;
            this.editorTypeId = editorTypeId;
            this.isPreviewTab = isPreviewTab;
            this.caretPosition = caretPosition;
            this.timeStamp = timeStamp;
            this.windowRef = new WeakReference<EditorWindow>(window);
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final FileEditorState getNavigationState() {
            return this.navigationState;
        }

        @NotNull
        public final String getEditorTypeId() {
            return this.editorTypeId;
        }

        public final boolean isPreviewTab() {
            return this.isPreviewTab;
        }

        @Nullable
        public final RangeMarker getCaretPosition() {
            return this.caretPosition;
        }

        public final long getTimeStamp() {
            return this.timeStamp;
        }

        public PlaceInfo(@NotNull VirtualFile file2, @NotNull FileEditorState navigationState, @NotNull String editorTypeId, @Nullable EditorWindow window, @Nullable RangeMarker caretPosition) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)navigationState, (String)"navigationState");
            Intrinsics.checkNotNullParameter((Object)editorTypeId, (String)"editorTypeId");
            this(file2, navigationState, editorTypeId, window, false, caretPosition, -1L);
        }

        @Nullable
        public final EditorWindow getWindow() {
            return (EditorWindow)this.windowRef.get();
        }

        @NotNull
        public String toString() {
            return this.file.getName() + " " + this.navigationState;
        }

        @ApiStatus.Internal
        @Nullable
        public final FileEditorManagerImpl.OpenMode getOpenMode() {
            FileEditorStateWithPreferredOpenMode fileEditorStateWithPreferredOpenMode;
            FileEditorState fileEditorState = this.navigationState;
            FileEditorStateWithPreferredOpenMode fileEditorStateWithPreferredOpenMode2 = fileEditorStateWithPreferredOpenMode = fileEditorState instanceof FileEditorStateWithPreferredOpenMode ? (FileEditorStateWithPreferredOpenMode)fileEditorState : null;
            if (fileEditorStateWithPreferredOpenMode != null) {
                FileEditorStateWithPreferredOpenMode it = fileEditorStateWithPreferredOpenMode;
                boolean bl = false;
                return it.getOpenMode();
            }
            return null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentFileHistoryOrderListener;", "", "recentFileUpdated", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static interface RecentFileHistoryOrderListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @Topic.ProjectLevel
        @JvmField
        @NotNull
        public static final Topic<RecentFileHistoryOrderListener> TOPIC = new Topic(RecentFileHistoryOrderListener.class, Topic.BroadcastDirection.NONE);

        public void recentFileUpdated(@NotNull VirtualFile var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentFileHistoryOrderListener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentFileHistoryOrderListener;", "intellij.platform.ide.impl"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u0000 \n2\u00020\u0001:\u0001\nJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentPlacesListener;", "", "recentPlaceAdded", "", "changePlace", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo;", "isChanged", "", "recentPlaceRemoved", "groupId", "Companion", "intellij.platform.ide.impl"})
    public static interface RecentPlacesListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @Topic.ProjectLevel
        @JvmField
        @NotNull
        public static final Topic<RecentPlacesListener> TOPIC = new Topic(RecentPlacesListener.class, Topic.BroadcastDirection.NONE);

        @Deprecated(message="")
        public void recentPlaceAdded(@NotNull PlaceInfo var1, boolean var2);

        public void recentPlaceRemoved(@NotNull PlaceInfo var1, boolean var2);

        default public void recentPlaceAdded(@NotNull PlaceInfo changePlace, boolean isChanged, @Nullable Object groupId) {
            Intrinsics.checkNotNullParameter((Object)changePlace, (String)"changePlace");
            this.recentPlaceAdded(changePlace, isChanged);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentPlacesListener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentPlacesListener;", "intellij.platform.ide.impl"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\bH\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0004H\u00d6\u0081\u0004J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001aR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentlyChangedFilesState;", "", "changedPaths", "", "", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_ide_impl", "$serializer", "Companion", "intellij.platform.ide.impl"})
    public static final class RecentlyChangedFilesState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final List<String> changedPaths;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public RecentlyChangedFilesState(@NotNull List<String> changedPaths) {
            Intrinsics.checkNotNullParameter(changedPaths, (String)"changedPaths");
            this.changedPaths = changedPaths;
        }

        public /* synthetic */ RecentlyChangedFilesState(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list2);
        }

        @NotNull
        public final List<String> component1() {
            return this.changedPaths;
        }

        @NotNull
        public final RecentlyChangedFilesState copy(@NotNull List<String> changedPaths) {
            Intrinsics.checkNotNullParameter(changedPaths, (String)"changedPaths");
            return new RecentlyChangedFilesState(changedPaths);
        }

        public static /* synthetic */ RecentlyChangedFilesState copy$default(RecentlyChangedFilesState recentlyChangedFilesState, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = recentlyChangedFilesState.changedPaths;
            }
            return recentlyChangedFilesState.copy(list2);
        }

        @NotNull
        public String toString() {
            return "RecentlyChangedFilesState(changedPaths=" + this.changedPaths + ")";
        }

        public int hashCode() {
            return ((Object)this.changedPaths).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecentlyChangedFilesState)) {
                return false;
            }
            RecentlyChangedFilesState recentlyChangedFilesState = (RecentlyChangedFilesState)other;
            return Intrinsics.areEqual(this.changedPaths, recentlyChangedFilesState.changedPaths);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_ide_impl(RecentlyChangedFilesState self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual(self.changedPaths, (Object)CollectionsKt.emptyList())) {
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.changedPaths);
            }
        }

        public /* synthetic */ RecentlyChangedFilesState(int seen0, List changedPaths, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)RecentlyChangedFilesState$$serializer.INSTANCE.getDescriptor());
            }
            this.changedPaths = (seen0 & 1) == 0 ? CollectionsKt.emptyList() : changedPaths;
        }

        public RecentlyChangedFilesState() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentlyChangedFilesState$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentlyChangedFilesState;", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<RecentlyChangedFilesState> serializer() {
                return (KSerializer)RecentlyChangedFilesState$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$SkipFromDocumentHistory;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$OptionallyIncluded;", "isIncludedInDocumentHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    public static interface SkipFromDocumentHistory
    extends OptionallyIncluded {
        @Override
        default public boolean isIncludedInDocumentHistory(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return false;
        }
    }
}

