/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.actions.DumpThreadsAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.EventStealer;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.JBColor;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PotemkinOverlayProgress
extends AbstractProgressIndicatorBase
implements StandardProgressIndicator,
ProgressIndicatorWithDelayedPresentation,
PingProgress,
Disposable {
    private static final KeyboardShortcut CANCEL_SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(27, 0), null);
    private static final KeyboardShortcut DUMP_SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(68, SystemInfo.isMac ? 256 : 128), null);
    private final Component myComponent;
    private final EventStealer myEventStealer;
    private final long myCreatedAt = System.nanoTime();
    private long myDelayInMillis = 3000L;
    private long myLastUiUpdate = this.myCreatedAt;
    private long myLastInteraction;
    private boolean myShowing;
    private final boolean myCancellable;

    @ApiStatus.Obsolete
    public PotemkinOverlayProgress(@Nullable Component component2) {
        this(component2, true);
    }

    @ApiStatus.Obsolete
    public PotemkinOverlayProgress(@Nullable Component component2, boolean cancellable) {
        EDT.assertIsEdt();
        this.myCancellable = cancellable;
        this.myComponent = component2;
        this.myEventStealer = PotemkinProgress.startStealingInputEvents(this::dispatchInputEvent, this);
    }

    public void setDelayInMillis(int delayInMillis) {
        this.myDelayInMillis = delayInMillis;
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                Disposer.dispose((Disposable)this);
            }
            finally {
                this.myEventStealer.dispatchEvents(0);
            }
        }
    }

    public void dispose() {
        JRootPane rootPane;
        if (this.myShowing && (rootPane = SwingUtilities.getRootPane(this.myComponent)) != null) {
            rootPane.repaint();
        }
    }

    public void interact() {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        long now = System.nanoTime();
        if (now == this.myLastInteraction) {
            return;
        }
        this.myLastInteraction = now;
        long millisSinceLastUpdate = TimeoutUtil.getDurationMillis((long)this.myLastUiUpdate);
        if (!this.myShowing && millisSinceLastUpdate > this.myDelayInMillis) {
            this.drainUndispatchedInputEvents();
            this.myShowing = true;
        }
        if (this.myShowing) {
            this.myEventStealer.dispatchEvents(0);
        }
        if (this.myShowing && millisSinceLastUpdate > 50L) {
            this.myLastUiUpdate = System.nanoTime();
            this.paintProgress();
        }
    }

    private void dispatchInputEvent(@NotNull InputEvent event) {
        Shortcut shortcut;
        if (event == null) {
            PotemkinOverlayProgress.$$$reportNull$$$0(0);
        }
        if ((shortcut = PotemkinOverlayProgress.createShortcut(event)) == null) {
            return;
        }
        if (CANCEL_SHORTCUT.equals((Object)shortcut)) {
            event.consume();
            this.cancel();
        } else if (DUMP_SHORTCUT.equals((Object)shortcut)) {
            event.consume();
            Project project2 = ProjectUtil.getProjectForComponent(this.myComponent);
            DumpThreadsAction.dumpThreads(project2);
        }
    }

    @Nullable
    private static Shortcut createShortcut(@NotNull InputEvent event) {
        if (event == null) {
            PotemkinOverlayProgress.$$$reportNull$$$0(1);
        }
        if (event instanceof MouseEvent) {
            return KeymapUtil.createMouseShortcut((MouseEvent)((MouseEvent)event));
        }
        if (event instanceof KeyEvent) {
            KeyStroke ks = KeyStrokeAdapter.getDefaultKeyStroke((KeyEvent)event);
            return ks == null ? null : new KeyboardShortcut(ks, null);
        }
        return null;
    }

    private List<InputEvent> drainUndispatchedInputEvents() {
        return this.myEventStealer.drainUndispatchedInputEvents();
    }

    public void dispatchAllInvocationEvents() {
        this.myEventStealer.dispatchAllExistingEvents();
    }

    private void paintProgress() {
        PotemkinOverlayProgress.paintOverlayProgress(SwingUtilities.getRootPane(this.myComponent), this.myCreatedAt, this.myCancellable);
    }

    private static void paintOverlayProgress(@Nullable JRootPane rootPane, long createdAt, boolean cancellable) {
        IdeGlassPane glassPane;
        IdeGlassPane ideGlassPane = glassPane = rootPane == null ? null : (IdeGlassPane)ObjectUtils.tryCast((Object)rootPane.getGlassPane(), IdeGlassPane.class);
        if (glassPane == null) {
            return;
        }
        long roundedDuration = TimeoutUtil.getDurationMillis((long)createdAt) / 1000L * 1000L;
        String text2 = (String)(cancellable ? KeymapUtil.getShortcutText((Shortcut)CANCEL_SHORTCUT) + " to cancel, " : "") + KeymapUtil.getShortcutText((Shortcut)DUMP_SHORTCUT) + " to dump threads (" + NlsMessages.formatDurationApproximateNarrow((long)roundedDuration) + ")";
        Graphics originalGraphics = GraphicsUtil.safelyGetGraphics((Component)rootPane);
        Rectangle viewR = rootPane.getBounds();
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        FontMetrics fm = originalGraphics.getFontMetrics();
        SwingUtilities.layoutCompoundLabel(fm, text2, null, 0, 0, 0, 0, viewR, iconR, textR, 0);
        int border = 10;
        BufferedImage backBuffer = UIUtil.createImage((GraphicsConfiguration)rootPane.getGraphicsConfiguration(), (double)(textR.width + 2 * border), (double)(textR.height + 2 * border), (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND);
        Graphics2D graphics = backBuffer.createGraphics();
        GraphicsUtil.setupAAPainting((Graphics)originalGraphics);
        graphics.setColor((Color)JBColor.GRAY);
        graphics.fillRoundRect(0, 0, textR.width + 2 * border, textR.height + 2 * border, border, border);
        graphics.setColor((Color)JBColor.WHITE);
        ((Graphics)graphics).drawString(text2, border, border + fm.getAscent());
        originalGraphics.translate(textR.x - border, textR.y - border);
        UIUtil.drawImage((Graphics)originalGraphics, (Image)backBuffer, (int)0, (int)0, null);
        graphics.dispose();
        originalGraphics.dispose();
    }

    static {
        NlsMessages.formatDurationApproximateNarrow((long)0L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/openapi/progress/util/PotemkinOverlayProgress";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatchInputEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createShortcut";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

