/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.mapped.content;

import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLogFactory;
import com.intellij.platform.util.io.storages.enumerator.DurableEnumerator;
import com.intellij.platform.util.io.storages.enumerator.DurableEnumeratorFactory;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class ContentHashEnumeratorOverDurableEnumerator
implements ContentHashEnumerator,
CleanableStorage {
    private static final int HASH_RECORD_LENGTH = 24;
    private final DurableEnumerator<byte[]> enumerator;
    private final int pageSize;

    public static ContentHashEnumeratorOverDurableEnumerator open(@NotNull Path storagePath) throws IOException {
        if (storagePath == null) {
            ContentHashEnumeratorOverDurableEnumerator.$$$reportNull$$$0(0);
        }
        int pageSize = 0x100000;
        return new ContentHashEnumeratorOverDurableEnumerator((DurableEnumerator<byte[]>)DurableEnumeratorFactory.defaultWithDurableMap((KeyDescriptorEx)ContentHashKeyDescriptor.INSTANCE).rebuildMapIfInconsistent(true).valuesLogFactory((StorageFactory)AppendOnlyLogFactory.withDefaults().pageSize(pageSize)).open(storagePath), pageSize);
    }

    private ContentHashEnumeratorOverDurableEnumerator(@NotNull DurableEnumerator<byte[]> enumerator2, int enumeratorPageSize) {
        if (enumerator2 == null) {
            ContentHashEnumeratorOverDurableEnumerator.$$$reportNull$$$0(1);
        }
        this.enumerator = enumerator2;
        this.pageSize = enumeratorPageSize;
    }

    public int enumerate(byte @NotNull [] hash) throws IOException {
        if (hash == null) {
            ContentHashEnumeratorOverDurableEnumerator.$$$reportNull$$$0(2);
        }
        ContentHashEnumeratorOverDurableEnumerator.checkValidHash(hash);
        int id2 = this.enumerator.enumerate((Object)hash);
        return this.enumeratorIdToHashId(id2);
    }

    public int tryEnumerate(byte @Nullable [] hash) throws IOException {
        ContentHashEnumeratorOverDurableEnumerator.checkValidHash(hash);
        int id2 = this.enumerator.tryEnumerate((Object)hash);
        if (id2 == 0) {
            return id2;
        }
        return this.enumeratorIdToHashId(id2);
    }

    public int enumerateEx(byte @NotNull [] hash) throws IOException {
        int id2;
        if (hash == null) {
            ContentHashEnumeratorOverDurableEnumerator.$$$reportNull$$$0(3);
        }
        if ((id2 = this.tryEnumerate(hash)) != 0) {
            return -id2;
        }
        return this.enumerate(hash);
    }

    public byte[] valueOf(int hashId) throws IOException {
        return (byte[])this.enumerator.valueOf(this.hashIdToEnumeratorId(hashId));
    }

    public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super byte[]> reader) throws IOException {
        if (reader == null) {
            ContentHashEnumeratorOverDurableEnumerator.$$$reportNull$$$0(4);
        }
        return this.enumerator.forEach((enumeratorId, hash) -> reader.read(this.enumeratorIdToHashId(enumeratorId), hash));
    }

    public int recordsCount() throws IOException {
        return this.enumerator.recordsCount();
    }

    public boolean isDirty() {
        return this.enumerator.isDirty();
    }

    public void force() throws IOException {
        this.enumerator.force();
    }

    public void close() throws IOException {
        this.enumerator.close();
    }

    public void closeAndClean() throws IOException {
        this.enumerator.closeAndClean();
    }

    @VisibleForTesting
    public int enumeratorIdToHashId(int enumeratorId) {
        if (enumeratorId == 0) {
            return 0;
        }
        int logHeaderSize = 64;
        long offset = ((long)enumeratorId - 1L << 2) + (long)logHeaderSize;
        int pageNo = (int)(offset / (long)this.pageSize);
        if (pageNo == 0) {
            return (int)((offset - (long)logHeaderSize) / 24L + 1L);
        }
        int offsetOnPage = (int)(offset % (long)this.pageSize);
        int recordsOnPage = this.pageSize / 24;
        int recordsOnFirstPage = (this.pageSize - logHeaderSize) / 24;
        return recordsOnPage * (pageNo - 1) + recordsOnFirstPage + offsetOnPage / 24 + 1;
    }

    @VisibleForTesting
    public int hashIdToEnumeratorId(int hashId) {
        if (hashId == 0) {
            return 0;
        }
        int recordNo = hashId - 1;
        int logHeaderSize = 64;
        int recordsOnPage = this.pageSize / 24;
        int recordsOnFirstPage = (this.pageSize - logHeaderSize) / 24;
        if (recordNo < recordsOnFirstPage) {
            return (recordNo * 24 >> 2) + 1;
        }
        int pageNo = (recordNo - recordsOnFirstPage) / recordsOnPage + 1;
        int recordOnPage = (recordNo - recordsOnFirstPage) % recordsOnPage;
        return (int)(((long)pageNo * (long)this.pageSize - (long)logHeaderSize + (long)(recordOnPage * 24) >> 2) + 1L);
    }

    private static void checkValidHash(byte[] hash) {
        if (hash != null && hash.length != 20) {
            throw new IllegalArgumentException("hash.length(=" + hash.length + ") must be 20");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumerator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/content/ContentHashEnumeratorOverDurableEnumerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "open";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enumerate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "enumerateEx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "forEach";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ContentHashKeyDescriptor
    implements KeyDescriptorEx<byte[]> {
        public static final ContentHashKeyDescriptor INSTANCE = new ContentHashKeyDescriptor();

        private ContentHashKeyDescriptor() {
        }

        public int getHashCode(byte[] contentHash) {
            int hashCode = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                hashCode = (hashCode << 8) + (contentHash[i2] & 0xFF);
            }
            return hashCode;
        }

        public boolean isEqual(byte[] hash1, byte[] hash2) {
            return Arrays.equals(hash1, hash2);
        }

        public DataExternalizerEx.KnownSizeRecordWriter writerFor(byte @NotNull [] hash) {
            if (hash == null) {
                ContentHashKeyDescriptor.$$$reportNull$$$0(0);
            }
            return DataExternalizerEx.fromBytes((byte[])hash);
        }

        public byte[] read(@NotNull ByteBuffer input) throws IOException {
            if (input == null) {
                ContentHashKeyDescriptor.$$$reportNull$$$0(1);
            }
            byte[] hash = new byte[20];
            input.get(hash);
            return hash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/content/ContentHashEnumeratorOverDurableEnumerator$ContentHashKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writerFor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

