/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.EWMHFrameDecorator;
import com.intellij.openapi.wm.impl.IdeFrameDecoratorKt;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.WLFrameDecorator;
import com.intellij.openapi.wm.impl.WinMainFrameDecorator;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.util.system.OS;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.JBR;
import java.util.concurrent.CancellationException;
import javax.swing.JMenuBar;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b \u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u00a6@\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0004J\b\u0010\u0011\u001a\u00020\nH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/wm/impl/IdeFrameDecorator;", "", "frame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "<init>", "(Lcom/intellij/openapi/wm/impl/IdeFrameImpl;)V", "isInFullScreen", "", "()Z", "setStoredFullScreen", "", "state", "setProject", "isTabbedWindow", "toggleFullScreen", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notifyFrameComponents", "appClosing", "Companion", "intellij.platform.ide.impl"})
public abstract class IdeFrameDecorator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final IdeFrameImpl frame;
    @NotNull
    public static final String FULL_SCREEN = "ide.frame.full.screen";

    protected IdeFrameDecorator(@NotNull IdeFrameImpl frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
    }

    public abstract boolean isInFullScreen();

    public void setStoredFullScreen(boolean state2) {
        this.notifyFrameComponents(state2);
    }

    public void setProject() {
    }

    public boolean isTabbedWindow() {
        return false;
    }

    @Nullable
    public abstract Object toggleFullScreen(boolean var1, @NotNull Continuation<? super Boolean> var2);

    protected final void notifyFrameComponents(boolean state2) {
        block0: {
            this.frame.getRootPane().putClientProperty(FULL_SCREEN, state2);
            JMenuBar jMenuBar = this.frame.getJMenuBar();
            if (jMenuBar == null) break block0;
            jMenuBar.putClientProperty(FULL_SCREEN, state2);
        }
    }

    public void appClosing() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/wm/impl/IdeFrameDecorator$Companion;", "", "<init>", "()V", "FULL_SCREEN", "", "decorate", "Lcom/intellij/openapi/wm/impl/IdeFrameDecorator;", "frame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "glassPane", "Lcom/intellij/openapi/wm/IdeGlassPane;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "isCustomDecorationAvailable", "", "isCustomDecorationAvailable$intellij_platform_ide_impl", "()Z", "isCustomDecorationActive", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final IdeFrameDecorator decorate(@NotNull IdeFrameImpl frame, @NotNull IdeGlassPane glassPane, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            try {
                return OS.CURRENT == OS.Windows ? (IdeFrameDecorator)new WinMainFrameDecorator(frame) : (OS.CURRENT == OS.macOS ? (IdeFrameDecorator)new MacMainFrameDecorator(frame, glassPane, coroutineScope) : (StartupUiUtil.isXToolkit() && X11UiUtil.isFullScreenSupported() ? (IdeFrameDecorator)new EWMHFrameDecorator(frame) : (StartupUiUtil.isWaylandToolkit() && UIUtil.isFullScreenSupportedByDefaultGD() ? (IdeFrameDecorator)new WLFrameDecorator(frame) : null)));
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Throwable e) {
                IdeFrameDecoratorKt.access$getLOG().warn("Failed to initialize IdeFrameDecorator", e);
                return null;
            }
        }

        public final boolean isCustomDecorationAvailable$intellij_platform_ide_impl() {
            return (OS.CURRENT == OS.Windows || OS.CURRENT == OS.macOS) && JBR.isWindowDecorationsSupported();
        }

        public final boolean isCustomDecorationActive() {
            if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                return this.isCustomDecorationAvailable$intellij_platform_ide_impl() && IdeFrameDecoratorKt.access$getDefaultCustomDecorationState();
            }
            Object v = IdeFrameDecoratorKt.access$isCustomDecorationActiveCache$p().updateAndGet(Companion::isCustomDecorationActive$lambda$0);
            Intrinsics.checkNotNullExpressionValue(v, (String)"updateAndGet(...)");
            return (Boolean)v;
        }

        private static final Boolean isCustomDecorationActive$lambda$0(Boolean cached) {
            if (cached != null) {
                return cached;
            }
            if (!Companion.isCustomDecorationAvailable$intellij_platform_ide_impl()) {
                return false;
            }
            Boolean bl = IdeFrameDecoratorKt.access$getMergeMainMenuWithWindowTitleOverrideValue$p();
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                return it;
            }
            return UISettings.Companion.getInstance().getMergeMainMenuWithWindowTitle();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

