/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GroupedComboBoxRenderer;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.listCellRenderer.KotlinUIDslRendererComponent;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBoxPopup<T>
extends ListPopupImpl {
    @NotNull
    public static final JBEmptyBorder COMBO_ITEM_BORDER = JBUI.Borders.empty((int)2, (int)8);
    private final Context<T> myContext;

    public ComboBoxPopup(@NotNull Context<T> context2, @Nullable T selectedItem, @NotNull Consumer<? super T> onItemSelected) {
        if (context2 == null) {
            ComboBoxPopup.$$$reportNull$$$0(0);
        }
        if (onItemSelected == null) {
            ComboBoxPopup.$$$reportNull$$$0(1);
        }
        this(context2, null, ComboBoxPopup.popupStateFromContext(context2, onItemSelected, selectedItem), null);
    }

    private ComboBoxPopup(@NotNull Context<T> context2, @Nullable WizardPopup aParent, @NotNull MyBasePopupState<T> aStep, @Nullable Object parentValue) {
        if (context2 == null) {
            ComboBoxPopup.$$$reportNull$$$0(2);
        }
        if (aStep == null) {
            ComboBoxPopup.$$$reportNull$$$0(3);
        }
        super(context2.getProject(), aParent, (ListPopupStep)aStep, parentValue);
        this.myContext = context2;
        this.configurePopup();
    }

    @NotNull
    private static <T> MyBasePopupState<T> popupStateFromContext(final @NotNull Context<T> context2, @NotNull Consumer<? super T> onItemSelected, @Nullable T selectedItem) {
        if (context2 == null) {
            ComboBoxPopup.$$$reportNull$$$0(4);
        }
        if (onItemSelected == null) {
            ComboBoxPopup.$$$reportNull$$$0(5);
        }
        MyBasePopupState step2 = new MyBasePopupState<T>(onItemSelected, () -> context2.getModel(), () -> context2.getRenderer()){

            public void canceled() {
                context2.onPopupStepCancelled();
            }
        };
        if (selectedItem != null) {
            List stepValues = step2.getValues();
            step2.setDefaultOptionIndex(stepValues.indexOf(selectedItem));
        }
        MyBasePopupState myBasePopupState = step2;
        if (myBasePopupState == null) {
            ComboBoxPopup.$$$reportNull$$$0(6);
        }
        return myBasePopupState;
    }

    public void syncWithModelChange() {
        this.disposeChildren();
        MyBasePopupState step2 = (MyBasePopupState)this.getStep();
        List values2 = step2.getValues();
        values2.clear();
        values2.addAll(ComboBoxPopup.copyItemsFromModel(this.myContext.getModel()));
        JList<T> popupList = this.getList();
        ((ListPopupModel)popupList.getModel()).syncModel();
        JComponent content2 = this.getContent();
        content2.setPreferredSize(null);
        Dimension newSize = content2.getPreferredSize();
        content2.setPreferredSize(newSize);
        this.setSize(newSize);
        this.moveToFitScreen();
    }

    @Override
    @NotNull
    protected WizardPopup createPopup(WizardPopup parent, PopupStep step2, Object parentValue) {
        if (step2 instanceof MyBasePopupState) {
            return new ComboBoxPopup<T>(this.myContext, parent, (MyBasePopupState)step2, parentValue);
        }
        throw new IllegalArgumentException(step2.getClass().toString());
    }

    @Override
    @NotNull
    protected JComponent createPopupComponent(JComponent content2) {
        JComponent component2 = super.createPopupComponent(content2);
        ListCellRenderer renderer2 = ((MyBasePopupState)this.myStep).myGetRenderer.get();
        if (component2 instanceof JBScrollPane) {
            JBScrollPane scrollPane = (JBScrollPane)component2;
            if (ComboBoxPopup.isRendererWithInsets(renderer2)) {
                scrollPane.setOverlappingScrollBar(true);
            }
        }
        JComponent jComponent = component2;
        if (jComponent == null) {
            ComboBoxPopup.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @Override
    public JList<T> getList() {
        return super.getList();
    }

    protected ListCellRenderer<T> getListElementRenderer() {
        return new MyDelegateRenderer();
    }

    public static boolean isRendererWithInsets(ListCellRenderer<?> comboRenderer) {
        ListCellRenderer unwrappedRenderer = ComboBoxPopup.unwrap(comboRenderer);
        return ExperimentalUI.isNewUI() && unwrappedRenderer instanceof ExperimentalUI.NewUIComboBoxRenderer;
    }

    private void configurePopup() {
        this.setMaxRowCount(this.myContext.getMaximumRowCount());
        this.setRequestFocus(false);
        JList<T> list2 = this.getList();
        this.myContext.configureList(list2);
        list2.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        list2.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        list2.setBorder(null);
        list2.setFocusable(ScreenReader.isActive());
        list2.setSelectionMode(0);
        ListCellRenderer renderer2 = ((MyBasePopupState)this.myStep).myGetRenderer.get();
        if (ComboBoxPopup.isRendererWithInsets(renderer2)) {
            list2.setBorder(JBUI.Borders.empty((Insets)PopupUtil.getListInsets((boolean)false, (boolean)false)));
            this.mySpeedSearch.addChangeListener(x -> list2.setBorder(JBUI.Borders.empty((Insets)PopupUtil.getListInsets((!this.mySpeedSearch.getFilter().isBlank() ? 1 : 0) != 0, (boolean)false))));
        } else {
            Border border = UIManager.getBorder("ComboPopup.border");
            if (border != null) {
                this.getContent().setBorder(border);
            }
        }
    }

    private static ListCellRenderer unwrap(ListCellRenderer renderer2) {
        while (renderer2 != null) {
            if (renderer2 instanceof ComboBoxWithWidePopup.AdjustingListCellRenderer) {
                ComboBoxWithWidePopup.AdjustingListCellRenderer wrapper2 = (ComboBoxWithWidePopup.AdjustingListCellRenderer)renderer2;
                renderer2 = wrapper2.delegate;
                continue;
            }
            return renderer2;
        }
        return null;
    }

    @NotNull
    private static <T> List<T> copyItemsFromModel(@NotNull ListModel<T> model2) {
        if (model2 == null) {
            ComboBoxPopup.$$$reportNull$$$0(8);
        }
        ArrayList<T> items2 = new ArrayList<T>(model2.getSize());
        int size2 = model2.getSize();
        for (int i2 = 0; i2 < size2; ++i2) {
            items2.add(model2.getElementAt(i2));
        }
        ArrayList<T> arrayList = items2;
        if (arrayList == null) {
            ComboBoxPopup.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public <U> Boolean isSeparatorAboveOf(U value) {
        return this.getListModel().isSeparatorAboveOf(value);
    }

    @NlsContexts.Separator
    public <U> String getCaptionAboveOf(U value) {
        return this.getListModel().getCaptionAboveOf(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onItemSelected";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/list/ComboBoxPopup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/list/ComboBoxPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "popupStateFromContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyItemsFromModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "popupStateFromContext";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyItemsFromModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9 -> new IllegalStateException(string);
        };
    }

    public static interface Context<T> {
        @Nullable
        public Project getProject();

        @NotNull
        public ListModel<T> getModel();

        @NotNull
        public ListCellRenderer<? super T> getRenderer();

        default public int getMaximumRowCount() {
            return 10;
        }

        default public void onPopupStepCancelled() {
        }

        default public void configureList(@NotNull JList<T> list2) {
            if (list2 == null) {
                Context.$$$reportNull$$$0(0);
            }
        }

        default public void customizeListRendererComponent(JComponent component2) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/popup/list/ComboBoxPopup$Context", "configureList"));
        }
    }

    private static class MyBasePopupState<T>
    extends BaseListPopupStep<T> {
        private final JBList<T> myProxyList;
        private final Consumer<? super T> myOnItemSelected;
        @NotNull
        private final Supplier<? extends ListModel<T>> myGetComboboxModel;
        private final Supplier<? extends ListCellRenderer<? super T>> myGetRenderer;

        private MyBasePopupState(@NotNull Consumer<? super T> onItemSelected, @NotNull Supplier<? extends ListModel<T>> getComboboxModel, @NotNull Supplier<? extends ListCellRenderer<? super T>> getRenderer) {
            if (onItemSelected == null) {
                MyBasePopupState.$$$reportNull$$$0(0);
            }
            if (getComboboxModel == null) {
                MyBasePopupState.$$$reportNull$$$0(1);
            }
            if (getRenderer == null) {
                MyBasePopupState.$$$reportNull$$$0(2);
            }
            super(null, ComboBoxPopup.copyItemsFromModel(getComboboxModel.get()));
            this.myProxyList = new JBList();
            this.myOnItemSelected = onItemSelected;
            this.myGetComboboxModel = getComboboxModel;
            this.myGetRenderer = getRenderer;
        }

        @Nullable
        public PopupStep<?> onChosen(T selectedValue, boolean finalChoice) {
            ListModel nextModel;
            ListModel<T> model2 = this.myGetComboboxModel.get();
            if (model2 instanceof ComboBoxPopupState && (nextModel = ((ComboBoxPopupState)model2).onChosen(selectedValue)) != null) {
                return new MyBasePopupState<T>(this.myOnItemSelected, () -> nextModel, this.myGetRenderer);
            }
            ApplicationManager.getApplication().invokeLater(() -> this.myOnItemSelected.accept(selectedValue));
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(T selectedValue) {
            ListModel<T> model2 = this.myGetComboboxModel.get();
            if (model2 instanceof ComboBoxPopupState) {
                return ((ComboBoxPopupState)model2).hasSubstep(selectedValue);
            }
            return super.hasSubstep(selectedValue);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(T value) {
            String string;
            ListCellRenderer<T> cellRenderer = this.myGetRenderer.get();
            Component component2 = cellRenderer.getListCellRendererComponent((JList<T>)this.myProxyList, value, -1, false, false);
            if (component2 instanceof TitledSeparator || component2 instanceof JSeparator) {
                string = "";
            } else if (component2 instanceof JLabel) {
                JLabel label2 = (JLabel)component2;
                string = label2.getText();
            } else if (component2 instanceof SimpleColoredComponent) {
                SimpleColoredComponent c = (SimpleColoredComponent)component2;
                string = c.getCharSequence(false).toString();
            } else if (component2 instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)component2);
                string = accessible.getAccessibleContext().getAccessibleName();
            } else {
                string = null;
            }
            String componentText = string;
            String string2 = componentText != null ? componentText : String.valueOf(value);
            if (string2 == null) {
                MyBasePopupState.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public boolean isSelectable(T value) {
            ComboBox.SelectableItem selectableItem;
            Component component2 = this.myGetRenderer.get().getListCellRendererComponent((JList<T>)this.myProxyList, value, -1, false, false);
            return !(component2 instanceof ComboBox.SelectableItem && !(selectableItem = (ComboBox.SelectableItem)component2).isSelectable() || component2 instanceof JSeparator);
        }

        @Nullable
        public ListSeparator getSeparatorAbove(T value) {
            ListCellRenderer unwrappedRenderer;
            ListCellRenderer<? super T> cellRenderer = this.myGetRenderer.get();
            if (cellRenderer instanceof GroupedComboBoxRenderer) {
                GroupedComboBoxRenderer renderer2 = (GroupedComboBoxRenderer)cellRenderer;
                return renderer2.separatorFor(value);
            }
            if (cellRenderer instanceof ComboBoxWithWidePopup.AdjustingListCellRenderer) {
                ComboBoxWithWidePopup.AdjustingListCellRenderer renderer3 = (ComboBoxWithWidePopup.AdjustingListCellRenderer)cellRenderer;
                ListCellRenderer delegate = renderer3.delegate;
                if (delegate instanceof GroupedComboBoxRenderer) {
                    GroupedComboBoxRenderer groupedComboBoxRenderer = (GroupedComboBoxRenderer)delegate;
                    return groupedComboBoxRenderer.separatorFor(value);
                }
            }
            if ((unwrappedRenderer = ComboBoxPopup.unwrap(cellRenderer)) instanceof LcrRow) {
                KotlinUIDslRendererComponent component2 = (KotlinUIDslRendererComponent)unwrappedRenderer.getListCellRendererComponent(this.myProxyList, value, -1, false, false);
                return component2.getListSeparator();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onItemSelected";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getComboboxModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/list/ComboBoxPopup$MyBasePopupState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/list/ComboBoxPopup$MyBasePopupState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyDelegateRenderer
    implements ListCellRenderer<T> {
        private MyDelegateRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component2 = ComboBoxPopup.this.myContext.getRenderer().getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            if (component2 instanceof JComponent) {
                JComponent jComponent = (JComponent)component2;
                if (!(component2 instanceof JSeparator) && !(component2 instanceof TitledSeparator)) {
                    if (!(component2 instanceof GroupedElementsRenderer.MyComponent || component2 instanceof KotlinUIDslRendererComponent || component2 instanceof DarculaComboBoxRenderer)) {
                        jComponent.setBorder((Border)COMBO_ITEM_BORDER);
                    }
                    ComboBoxPopup.this.myContext.customizeListRendererComponent(jComponent);
                }
            }
            return component2;
        }
    }

    public static interface SelectionListener<T>
    extends EventListener {
        public void setSelectedItem(@NotNull T var1);
    }
}

