/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.IDatagramSocketWrapper;
import com.intellij.platform.split.connection.network.quic.QuicServerKt;
import com.intellij.platform.split.connection.network.quic.QuicServerStreamTransport;
import com.intellij.platform.split.connection.network.quic.Quiche;
import com.intellij.platform.split.connection.network.quic.QuicheCommon;
import com.intellij.platform.split.connection.network.quic.QuicheConfig;
import com.intellij.platform.split.connection.network.quic.QuicheConnection;
import com.intellij.platform.split.connection.network.quic.QuicheSockAddrKt;
import com.intellij.platform.split.connection.network.quic.SockAddrI;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.transport.StreamTransport;
import com.jetbrains.quiche.stubs.quiche_recv_info;
import com.jetbrains.quiche.stubs.quiche_send_info;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0005;<=>?B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001eH\u0002JR\u0010&\u001a\u0004\u0018\u00010\u00122\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J\u0010\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u0012H\u0002J\b\u00104\u001a\u00020$H\u0002J\u0018\u00105\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u00106\u001a\u00020\u001eH\u0002J\b\u00107\u001a\u00020\u0016H\u0002J\u0018\u00108\u001a\u00020$2\u0006\u00103\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u001fH\u0002J\u0018\u0010:\u001a\u00020$2\u0006\u00103\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicServer;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "datagramSocketWrapper", "Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;", "connectionIdleTimeout", "Ljava/time/Duration;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;Ljava/time/Duration;)V", "acceptSignal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "Lcom/intellij/platform/split/connection/network/quic/QuicServer$AcceptData;", "getAcceptSignal", "()Lcom/jetbrains/rd/util/reactive/ISignal;", "connections", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/platform/split/connection/network/quic/QuicServer$DestinationConnectionId;", "Lcom/intellij/platform/split/connection/network/quic/QuicServer$ConnectionData;", "LOCAL_CONN_ID_LEN", "Lcom/ochafik/lang/jnaerator/runtime/NativeSize;", "TOKEN_LEN", "", "PACKET_TYPE_INITIAL", "", "config", "Lcom/intellij/platform/split/connection/network/quic/QuicheConfig;", "socketReceivedDatagrams", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Pair;", "Ljava/net/InetSocketAddress;", "", "quicWakeupQueue", "Ljava/util/concurrent/LinkedBlockingDeque;", "", "quicThread", "", "localAddress", "getOrCreateConnection", "type", "scid", "Lcom/intellij/platform/split/connection/network/quic/QuicServer$SourceConnectionId;", "dcid", "version", "tokenLength", "", "packetRemoteAddress", "localSockAddress", "Lcom/intellij/platform/split/connection/network/quic/SockAddrI;", "peerSockAddr", "closeQuicConnection", "connection", "releaseTerminatedQuicheConnections", "mintToken", "remoteAddress", "getMaxTokenLen", "addToSendQueue", "arr", "addToReceiveQueue", "AcceptData", "DestinationConnectionId", "SourceConnectionId", "QuicheConnectionState", "ConnectionData", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nQuicServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuicServer.kt\ncom/intellij/platform/split/connection/network/quic/QuicServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,611:1\n1#2:612\n1#2:629\n60#3,5:613\n67#3,4:635\n67#3,4:639\n60#3,5:643\n67#3,4:648\n67#3,4:652\n67#3,4:656\n67#3,4:660\n67#3,4:664\n67#3,4:668\n60#3,5:674\n60#3,5:679\n60#3,5:684\n60#3,5:689\n60#3,5:694\n60#3,5:699\n60#3,5:704\n60#3,5:709\n60#3,5:714\n60#3,5:719\n60#3,5:724\n60#3,5:733\n1642#4,10:618\n1915#4:628\n1916#4:630\n1652#4:631\n777#4:632\n873#4,2:633\n777#4:729\n873#4,2:730\n1915#4:732\n1916#4:738\n221#5,2:672\n*S KotlinDebug\n*F\n+ 1 QuicServer.kt\ncom/intellij/platform/split/connection/network/quic/QuicServer\n*L\n191#1:629\n183#1:613,5\n195#1:635,4\n208#1:639,4\n239#1:643,5\n276#1:648,4\n298#1:652,4\n344#1:656,4\n356#1:660,4\n379#1:664,4\n383#1:668,4\n420#1:674,5\n433#1:679,5\n435#1:684,5\n447#1:689,5\n457#1:694,5\n463#1:699,5\n480#1:704,5\n490#1:709,5\n536#1:714,5\n554#1:719,5\n561#1:724,5\n565#1:733,5\n191#1:618,10\n191#1:628\n191#1:630\n191#1:631\n192#1:632\n192#1:633,2\n563#1:729\n563#1:730,2\n564#1:732\n564#1:738\n400#1:672,2\n*E\n"})
public final class QuicServer {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IDatagramSocketWrapper datagramSocketWrapper;
    @NotNull
    private final Duration connectionIdleTimeout;
    @NotNull
    private final ISignal<AcceptData> acceptSignal;
    @NotNull
    private final ConcurrentHashMap<DestinationConnectionId, ConnectionData> connections;
    @NotNull
    private final NativeSize LOCAL_CONN_ID_LEN;
    private final int TOKEN_LEN;
    private final byte PACKET_TYPE_INITIAL;
    @NotNull
    private final QuicheConfig config;
    @NotNull
    private final LinkedBlockingQueue<Pair<InetSocketAddress, byte[]>> socketReceivedDatagrams;
    @NotNull
    private final LinkedBlockingDeque<Boolean> quicWakeupQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuicServer(@NotNull Lifetime lifetime, @NotNull IDatagramSocketWrapper datagramSocketWrapper, @NotNull Duration connectionIdleTimeout) {
        byte[] byArray;
        Object it;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)datagramSocketWrapper, (String)"datagramSocketWrapper");
        Intrinsics.checkNotNullParameter((Object)connectionIdleTimeout, (String)"connectionIdleTimeout");
        this.lifetime = lifetime;
        this.datagramSocketWrapper = datagramSocketWrapper;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.acceptSignal = (ISignal)new Signal();
        this.connections = new ConcurrentHashMap();
        this.LOCAL_CONN_ID_LEN = QuicheCommon.INSTANCE.toNativeSize(16);
        this.TOKEN_LEN = 31;
        this.PACKET_TYPE_INITIAL = 1;
        this.config = new QuicheConfig();
        this.socketReceivedDatagrams = new LinkedBlockingQueue();
        this.quicWakeupQueue = new LinkedBlockingDeque();
        this.config.setCommonSensibleOptions(this.connectionIdleTimeout);
        Object object = new String[]{"hq-27", "http/0.9"};
        this.config.setSupportedProtocols((String)object);
        InputStream inputStream = this.getClass().getResourceAsStream("/quic/cert.crt");
        Intrinsics.checkNotNull((Object)inputStream);
        object = inputStream;
        QuicheConfig quicheConfig = this.config;
        Throwable throwable = null;
        try {
            it = (InputStream)object;
            boolean bl = false;
            it = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        quicheConfig.loadCertChainFromPemBytes((byte[])it);
        InputStream inputStream2 = this.getClass().getResourceAsStream("/quic/cert.key");
        Intrinsics.checkNotNull((Object)inputStream2);
        object = inputStream2;
        QuicheConfig quicheConfig2 = this.config;
        throwable = null;
        try {
            it = (InputStream)object;
            boolean bl = false;
            byArray = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        quicheConfig2.loadPrivateKeyFromPemBytes(byArray);
        InetSocketAddress inetSocketAddress = this.datagramSocketWrapper.getLocalAddress();
        Intrinsics.checkNotNull((Object)inetSocketAddress);
        InetSocketAddress localAddress = inetSocketAddress;
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)("Quic Server on " + localAddress), (int)0, () -> QuicServer._init_$lambda$2(this, localAddress), (int)21, null);
        this.quicWakeupQueue.add(true);
        this.datagramSocketWrapper.adviseOnRemainingPackets(this.lifetime, (Function2<? super InetSocketAddress, ? super byte[], Unit>)((Function2)(arg_0, arg_1) -> QuicServer._init_$lambda$3(this, arg_0, arg_1)));
    }

    @NotNull
    public final ISignal<AcceptData> getAcceptSignal() {
        return this.acceptSignal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void quicThread(InetSocketAddress localAddress) {
        boolean bl2;
        Memory sendInfoDummyMemory = new Memory(512L);
        try {
            Logger logger;
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            SockAddrI localSockAddress = QuicheSockAddrKt.getQuicheSockAddr(localAddress);
            Logger $this$debug_u24default$iv = QuicServerKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                bl2 = false;
                logger.debug("quic server thread operational", t$iv);
            }
            while (RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object it$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                this.releaseTerminatedQuicheConnections();
                Collection<ConnectionData> collection = this.connections.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable bl2 = collection;
                boolean $i$f$mapNotNull = false;
                void var10_36 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Long l;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl22 = false;
                    ConnectionData connection = (ConnectionData)element$iv$iv;
                    boolean bl3 = false;
                    if (connection.getQuichePointerSafe() != null) {
                        PointerByReference it;
                        boolean bl4 = false;
                        l = Quiche.INSTANCE.getLibrary().quiche_conn_timeout_as_nanos(it);
                    } else {
                        l = null;
                    }
                    if (l == null) continue;
                    it$iv$iv = l;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapNotNullTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    long it = ((Number)element$iv$iv).longValue();
                    boolean bl6 = false;
                    if (!(it > 0L)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Long l = (Long)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
                long nextTimeoutNs = l != null ? l : 5000000000L;
                Pair<InetSocketAddress, byte[]> $this$trace$iv = QuicServerKt.access$getLOG$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl7 = false;
                    logger.trace("TILL NEXT QUICHE TIMEOUT: " + nextTimeoutNs / 1000000L + " ms");
                }
                this.quicWakeupQueue.poll(nextTimeoutNs, TimeUnit.NANOSECONDS);
                if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
                    break;
                }
                block13: while (this.socketReceivedDatagrams.poll() != null) {
                    PointerByReference conn;
                    ConnectionData connection;
                    InetSocketAddress packetRemoteAddress = (InetSocketAddress)$this$trace$iv.component1();
                    byte[] packetData = (byte[])$this$trace$iv.component2();
                    Logger $this$trace$iv2 = QuicServerKt.access$getLOG$p();
                    boolean $i$f$trace2 = false;
                    if ($this$trace$iv2.isTraceEnabled()) {
                        logger = $this$trace$iv2;
                        boolean bl8 = false;
                        logger.trace("Polled packet. packetRemoteAddress: " + IPrintableKt.printToString((Object)packetRemoteAddress) + ", packetData: " + packetData.length + " bytes");
                    }
                    ByteBuffer scidRaw = ByteBuffer.allocate(20);
                    NativeSizeByReference scidLen = new NativeSizeByReference(QuicheCommon.INSTANCE.toNativeSize(scidRaw.limit()));
                    ByteBuffer dcidRaw = ByteBuffer.allocate(20);
                    NativeSizeByReference dcidLen = new NativeSizeByReference(QuicheCommon.INSTANCE.toNativeSize(dcidRaw.limit()));
                    ByteBuffer typeBuf = ByteBuffer.allocate(1);
                    IntBuffer versionBuf = IntBuffer.allocate(1);
                    ByteBuffer token = ByteBuffer.allocate(this.TOKEN_LEN);
                    NativeSizeByReference tokenLen = new NativeSizeByReference(QuicheCommon.INSTANCE.toNativeSize(token.limit()));
                    int rc = Quiche.INSTANCE.getLibrary().quiche_header_info(packetData, QuicheCommon.INSTANCE.toNativeSize(packetData.length), this.LOCAL_CONN_ID_LEN, versionBuf, typeBuf, scidRaw, scidLen, dcidRaw, dcidLen, token, tokenLen);
                    SockAddrI peerSockAddr = QuicheSockAddrKt.getQuicheSockAddr(packetRemoteAddress);
                    QuicheCommon.INSTANCE.assertQuicheError("quiche_header_info", rc);
                    int version = versionBuf.get(0);
                    byte type = typeBuf.get(0);
                    byte[] byArray = scidRaw.array();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                    it$iv$iv = byArray;
                    int bl5 = scidLen.getValue().intValue();
                    byte[] byArray2 = Arrays.copyOf((byte[])it$iv$iv, bl5);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
                    SourceConnectionId scid = new SourceConnectionId(byArray2);
                    Intrinsics.checkNotNullExpressionValue((Object)dcidRaw.array(), (String)"array(...)");
                    int n = dcidLen.getValue().intValue();
                    byte[] byArray3 = Arrays.copyOf(bl5, n);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
                    DestinationConnectionId dcid = new DestinationConnectionId(byArray3);
                    if (this.getOrCreateConnection(type, scid, dcid, version, tokenLen.getValue().longValue(), localAddress, packetRemoteAddress, localSockAddress, peerSockAddr) == null) continue;
                    Logger $this$debug_u24default$iv2 = QuicServerKt.access$getLOG$p();
                    Throwable t$iv2 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug_u24default$iv2.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv2;
                        boolean bl9 = false;
                        logger.debug("QUIC connection id=" + connection.getId() + ", peer=" + IPrintableKt.printToString((Object)connection.getPeer()) + ", quic=" + IPrintableKt.printToString((Object)connection.getQuic()), t$iv2);
                    }
                    quiche_recv_info recvInfo = new quiche_recv_info(peerSockAddr.getQuicheSockAddr(), peerSockAddr.size(), localSockAddress.getQuicheSockAddr(), localSockAddress.size());
                    if (connection.getQuichePointerSafe() == null) continue;
                    long read = Quiche.INSTANCE.getLibrary().quiche_conn_recv(conn, ByteBuffer.wrap(packetData), QuicheCommon.INSTANCE.toNativeSize(packetData.length), recvInfo).longValue();
                    QuicheCommon.INSTANCE.assertQuicheError("quiche_conn_recv", read);
                    if (Intrinsics.areEqual((Object)connection.getStreamTransport().getConnected().getValue(), (Object)ConnectionState.NOT_CONNECTED.INSTANCE) && connection.isQuicheConnectionEstablished()) {
                        connection.getStreamTransport().getStateProperty().set(ConnectionState.CONNECTED.INSTANCE);
                    }
                    if (connection.isTransportConnected() && connection.isQuicheConnectionClosed()) {
                        this.closeQuicConnection(connection);
                    }
                    if (!connection.isTransportConnected()) continue;
                    PointerByReference pointerByReference = connection.getQuichePointerSafe();
                    if (pointerByReference == null) continue;
                    PointerByReference it = pointerByReference;
                    boolean bl10 = false;
                    PointerByReference pointerByReference = Quiche.INSTANCE.getLibrary().quiche_conn_readable(it);
                    pointerByReference = pointerByReference;
                    if (pointerByReference2 == null) {
                        continue;
                    }
                    PointerByReference iter = pointerByReference;
                    try {
                        while (true) {
                            PointerByReference connRecv;
                            NativeSize streamRecvRaw;
                            long streamRecvRc;
                            LongByReference streamId = new LongByReference();
                            if (!QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_stream_iter_next(iter, streamId))) continue block13;
                            Logger $this$trace$iv3 = QuicServerKt.access$getLOG$p();
                            boolean $i$f$trace3 = false;
                            if ($this$trace$iv3.isTraceEnabled()) {
                                logger = $this$trace$iv3;
                                boolean bl11 = false;
                                logger.trace("DATA FOR STREAM ID " + streamId.getValue());
                            }
                            ByteBuffer fin = ByteBuffer.allocate(1);
                            if (connection.getQuichePointerSafe() == null || (streamRecvRc = (streamRecvRaw = Quiche.INSTANCE.getLibrary().quiche_conn_stream_recv(connRecv, streamId.getValue(), buffer, QuicheCommon.INSTANCE.toNativeSize(buffer.capacity()), fin)).longValue()) == 0L || QuicheCommon.INSTANCE.isQuicheErrDone(streamRecvRc)) continue block13;
                            QuicheCommon.INSTANCE.assertQuicheError("quiche_conn_stream_recv", streamRecvRc);
                            Logger $this$trace$iv4 = QuicServerKt.access$getLOG$p();
                            boolean $i$f$trace4 = false;
                            if ($this$trace$iv4.isTraceEnabled()) {
                                logger = $this$trace$iv4;
                                boolean bl12 = false;
                                logger.trace("received from app stream " + streamId.getValue() + " " + streamRecvRc + " bytes");
                            }
                            byte[] byArray4 = Arrays.copyOf(buffer.array(), (int)streamRecvRc);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"copyOf(...)");
                            this.addToReceiveQueue(connection, byArray4);
                        }
                    }
                    finally {
                        Quiche.INSTANCE.getLibrary().quiche_stream_iter_free(iter);
                    }
                }
                block15: for (Object e : this.connections.values()) {
                    PointerByReference conn;
                    PointerByReference conn2;
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConnectionData connection = (ConnectionData)e;
                    if (connection.getQuichePointerSafe() == null) continue;
                    boolean bl13 = false;
                    Quiche.INSTANCE.getLibrary().quiche_conn_on_timeout(conn2);
                    if (connection.isTransportConnected() && connection.isQuicheConnectionClosed()) {
                        this.closeQuicConnection(connection);
                        continue;
                    }
                    while (connection.getStreamTransport().getToSendQueue().poll() != null && connection.getQuichePointerSafe() != null) {
                        byte[] arr;
                        NativeSize streamReadReturn = Quiche.INSTANCE.getLibrary().quiche_conn_stream_send(conn, 4L, arr, QuicheCommon.INSTANCE.toNativeSize(arr.length), QuicheCommon.INSTANCE.toByte(false));
                        long sendRc = streamReadReturn.longValue();
                        if (QuicheCommon.INSTANCE.isQuicheErrDone(sendRc)) {
                            Logger $this$trace$iv5 = QuicServerKt.access$getLOG$p();
                            boolean $i$f$trace5 = false;
                            if ($this$trace$iv5.isTraceEnabled()) {
                                logger = $this$trace$iv5;
                                boolean bl14 = false;
                                logger.trace("Quiche said done?! still have bytes to send (" + arr.length + ")");
                            }
                            this.addToSendQueue(connection, arr);
                            break;
                        }
                        QuicheCommon.INSTANCE.assertQuicheError("quiche_conn_stream_send", sendRc);
                        if (sendRc > (long)arr.length) {
                            throw new IOException("Trying to send more than requested. Reported sent size from quiche_conn_stream_send (" + sendRc + ") != requested bytes to send (" + arr.length + ")");
                        }
                        if (sendRc >= (long)arr.length) continue;
                        Logger $this$trace$iv6 = QuicServerKt.access$getLOG$p();
                        boolean $i$f$trace6 = false;
                        if ($this$trace$iv6.isTraceEnabled()) {
                            logger = $this$trace$iv6;
                            boolean bl15 = false;
                            logger.trace("Partial send?! reported sent size from quiche_conn_stream_send (" + sendRc + ") != requested bytes to send (" + arr.length + ")");
                        }
                        this.addToSendQueue(connection, ArraysKt.copyOfRange((byte[])arr, (int)((int)sendRc), (int)arr.length));
                        if (sendRc != 0L) continue;
                        break;
                    }
                    while (true) {
                        long written;
                        buffer.rewind();
                        quiche_send_info sendInfo = new quiche_send_info((Pointer)sendInfoDummyMemory);
                        if (connection.getQuichePointerSafe() == null || QuicheCommon.INSTANCE.isQuicheErrDone(written = Quiche.INSTANCE.getLibrary().quiche_conn_send(conn, buffer, QuicheCommon.INSTANCE.toNativeSize(buffer.capacity()), sendInfo).longValue())) continue block15;
                        QuicheCommon.INSTANCE.assertQuicheError("quiche_conn_send", written);
                        Logger $this$trace$iv7 = QuicServerKt.access$getLOG$p();
                        boolean $i$f$trace7 = false;
                        if ($this$trace$iv7.isTraceEnabled()) {
                            logger = $this$trace$iv7;
                            boolean bl16 = false;
                            logger.trace(connection.getPeer() + ": sending " + written + " bytes to UDP socket");
                        }
                        try {
                            Object $this$trace$iv2 = QuicServerKt.access$getLOG$p();
                            boolean $i$f$trace2 = false;
                            if ($this$trace$iv2.isTraceEnabled()) {
                                logger = $this$trace$iv2;
                                boolean bl17 = false;
                                logger.trace("Sending " + written + " bytes to UDP socket");
                            }
                            byte[] byArray = buffer.array();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                            $this$trace$iv2 = byArray;
                            int n = (int)written;
                            byte[] byArray5 = Arrays.copyOf((byte[])$this$trace$iv2, n);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"copyOf(...)");
                            this.datagramSocketWrapper.send(byArray5, connection.getPeer());
                        }
                        catch (Throwable t) {
                            QuicServerKt.access$getLOG$p().info(connection.getPeer() + ": sending " + written + " bytes to UDP socket: " + t.getMessage(), t);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            QuicServerKt.access$getLOG$p().error("QUIC server thread '" + localAddress + "' failed with exception: " + t.getMessage(), t);
        }
        finally {
            QuicServerKt.access$getLOG$p().info("QUIC server thread '" + localAddress + "' is finished");
            sendInfoDummyMemory.clear();
            Map $this$forEach$iv = this.connections;
            boolean $i$f$forEach = false;
            Iterator nextTimeoutNs = $this$forEach$iv.entrySet().iterator();
            while (nextTimeoutNs.hasNext()) {
                Map.Entry element$iv;
                Map.Entry connection = element$iv = nextTimeoutNs.next();
                bl2 = false;
                ((ConnectionData)connection.getValue()).requestQuicheTermination();
            }
            this.releaseTerminatedQuicheConnections();
        }
    }

    private final ConnectionData getOrCreateConnection(byte type, SourceConnectionId scid, DestinationConnectionId dcid, int version, long tokenLength, InetSocketAddress localAddress, InetSocketAddress packetRemoteAddress, SockAddrI localSockAddress, SockAddrI peerSockAddr) {
        Object object;
        ConnectionData existingConnection = this.connections.get(dcid);
        if (existingConnection != null) {
            Logger $this$debug_u24default$iv = QuicServerKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Found existing connection for DCID: " + existingConnection.getId(), t$iv);
            }
            return existingConnection;
        }
        QuicServerKt.access$getLOG$p().info("Creating connection: type=" + type + ", scid=" + scid + ", dcid=" + dcid);
        if (type != this.PACKET_TYPE_INITIAL) {
            QuicServerKt.access$getLOG$p().info("No connection established and got packet type " + type + " (not INITIAL), skipping");
            return null;
        }
        boolean quicVersionSupported = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_version_is_supported(version));
        Logger $this$debug_u24default$iv = QuicServerKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            object.debug("Is Quic version supported: " + quicVersionSupported, t$iv);
        }
        if (!quicVersionSupported) {
            $this$debug_u24default$iv = QuicServerKt.access$getLOG$p();
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                object = $this$debug_u24default$iv;
                boolean bl = false;
                object.debug("version negotiation", t$iv);
            }
            ByteBuffer out = ByteBuffer.allocate(1600);
            long written = Quiche.INSTANCE.getLibrary().quiche_negotiate_version(scid.getBytes(), QuicheCommon.INSTANCE.toNativeSize(scid.getBytes().length), dcid.getBytes(), QuicheCommon.INSTANCE.toNativeSize(dcid.getBytes().length), out, QuicheCommon.INSTANCE.toNativeSize(out.limit())).longValue();
            QuicheCommon.INSTANCE.assertQuicheError("quiche_negotiate_version", written);
            if (written < 0L) {
                Logger $this$debug_u24default$iv2 = QuicServerKt.access$getLOG$p();
                Throwable t$iv2 = null;
                boolean $i$f$debug2 = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    object = $this$debug_u24default$iv2;
                    boolean bl = false;
                    object.debug("failed to create vneg packet: " + written, t$iv2);
                }
                return null;
            }
            if (!(written > 0L)) {
                String t$iv2 = "Failed requirement.";
                throw new IllegalArgumentException(t$iv2.toString());
            }
            if (!(written <= 1600L)) {
                String t$iv2 = "Failed requirement.";
                throw new IllegalArgumentException(t$iv2.toString());
            }
            byte[] byArray = out.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            Object $this$debug_u24default$iv2 = byArray;
            int t$iv2 = (int)written;
            byte[] byArray2 = Arrays.copyOf($this$debug_u24default$iv2, t$iv2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            this.datagramSocketWrapper.send(byArray2, packetRemoteAddress);
            $this$debug_u24default$iv2 = QuicServerKt.access$getLOG$p();
            Throwable t$iv22 = null;
            boolean $i$f$debug3 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                object = $this$debug_u24default$iv2;
                boolean bl = false;
                object.debug("sent " + written + " bytes as vneg packet to " + packetRemoteAddress, t$iv22);
            }
            return null;
        }
        if (tokenLength == 0L) {
            $this$debug_u24default$iv = QuicServerKt.access$getLOG$p();
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                object = $this$debug_u24default$iv;
                boolean bl = false;
                object.debug("No token from " + packetRemoteAddress + ", doing stateless retry", t$iv);
            }
            byte[] newToken = this.mintToken(scid, packetRemoteAddress);
            ByteBuffer out = ByteBuffer.allocate(1600);
            long written = Quiche.INSTANCE.getLibrary().quiche_retry(scid.getBytes(), QuicheCommon.INSTANCE.toNativeSize(scid.getBytes().length), dcid.getBytes(), QuicheCommon.INSTANCE.toNativeSize(dcid.getBytes().length), dcid.getBytes(), QuicheCommon.INSTANCE.toNativeSize(dcid.getBytes().length), newToken, QuicheCommon.INSTANCE.toNativeSize(newToken.length), version, out, QuicheCommon.INSTANCE.toNativeSize(out.limit())).longValue();
            if (written < 0L) {
                Logger $this$debug_u24default$iv3 = QuicServerKt.access$getLOG$p();
                Throwable t$iv3 = null;
                boolean $i$f$debug4 = false;
                if ($this$debug_u24default$iv3.isDebugEnabled()) {
                    object = $this$debug_u24default$iv3;
                    boolean bl = false;
                    object.debug("failed to create retry packet: " + written, t$iv3);
                }
                return null;
            }
            if (!(written > 0L)) {
                String t$iv3 = "Failed requirement.";
                throw new IllegalArgumentException(t$iv3.toString());
            }
            if (!(written <= 1600L)) {
                String t$iv3 = "Failed requirement.";
                throw new IllegalArgumentException(t$iv3.toString());
            }
            byte[] byArray = out.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            Object $this$debug_u24default$iv3 = byArray;
            int t$iv3 = (int)written;
            byte[] byArray3 = Arrays.copyOf($this$debug_u24default$iv3, t$iv3);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
            this.datagramSocketWrapper.send(byArray3, packetRemoteAddress);
            $this$debug_u24default$iv3 = QuicServerKt.access$getLOG$p();
            Throwable t$iv32 = null;
            boolean $i$f$debug5 = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                object = $this$debug_u24default$iv3;
                boolean bl = false;
                object.debug("send " + written + " bytes as retry packet to " + packetRemoteAddress, t$iv32);
            }
            return null;
        }
        DestinationConnectionId connScid = dcid;
        PointerByReference connectionRaw = Quiche.INSTANCE.getLibrary().quiche_accept(connScid.getBytes(), QuicheCommon.INSTANCE.toNativeSize(connScid.getBytes().length), dcid.getBytes(), QuicheCommon.INSTANCE.toNativeSize(dcid.getBytes().length), localSockAddress.getQuicheSockAddr(), localSockAddress.getNativeSize(), peerSockAddr.getQuicheSockAddr(), peerSockAddr.getNativeSize(), this.config.getPointer());
        Pointer pointer = connectionRaw.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
        if (QuicheCommon.INSTANCE.isNull(pointer)) {
            QuicServerKt.access$getLOG$p().info("Accept failed");
            return null;
        }
        Lifetime bl = this.lifetime;
        LinkedBlockingDeque<Boolean> $this$debug_u24default$iv4 = this.quicWakeupQueue;
        String string = localAddress.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String t$iv32 = string;
        QuicServerStreamTransport streamTransport = new QuicServerStreamTransport(bl, t$iv32, (BlockingDeque<Boolean>)$this$debug_u24default$iv4);
        streamTransport.getStateProperty().set(ConnectionState.NOT_CONNECTED.INSTANCE);
        Intrinsics.checkNotNull((Object)connectionRaw);
        QuicheConnection newConnection = new QuicheConnection(connectionRaw);
        ConnectionData data = new ConnectionData(this.lifetime.createNested(), newConnection, streamTransport, packetRemoteAddress, connScid);
        data.getLifetimeDefinition().onTermination(() -> QuicServer.getOrCreateConnection$lambda$8(data, streamTransport));
        Logger $this$debug_u24default$iv5 = QuicServerKt.access$getLOG$p();
        Throwable t$iv4 = null;
        boolean $i$f$debug6 = false;
        if ($this$debug_u24default$iv5.isDebugEnabled()) {
            object = $this$debug_u24default$iv5;
            boolean bl2 = false;
            object.debug(streamTransport.getName() + " Add new connection. Peer: " + data.getPeer() + ". Connection state: <" + data.getStreamTransport().getStateProperty().getValue() + ">", t$iv4);
        }
        ((Map)this.connections).put(connScid, data);
        this.acceptSignal.fire((Object)new AcceptData(data.getLifetimeDefinition(), data.getStreamTransport(), data.getPeer()));
        QuicServerKt.access$getLOG$p().info(streamTransport.getName() + " Accepted new connection from " + packetRemoteAddress);
        return data;
    }

    private final void closeQuicConnection(ConnectionData connection) {
        Logger $this$debug_u24default$iv = QuicServerKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Closing QUIC connection " + connection.getQuic() + " to a peer " + IPrintableKt.printToString((Object)connection.getPeer()), t$iv);
        }
        connection.requestQuicheTermination();
        connection.getStreamTransport().getStateProperty().setIfNotTerminal(ConnectionState.CLOSED.INSTANCE);
        LifetimeDefinition.terminate$default((LifetimeDefinition)connection.getLifetimeDefinition(), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void releaseTerminatedQuicheConnections() {
        void $this$filterTo$iv$iv;
        Logger $this$debug_u24default$iv = QuicServerKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug22 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Release all terminated Quiche connections", t$iv);
        }
        Collection<ConnectionData> collection = this.connections.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable $i$f$debug22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConnectionData connection = (ConnectionData)element$iv$iv;
            boolean bl = false;
            if (!(connection.getQuicheConnectionState() != QuicheConnectionState.CONNECTED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConnectionData connection = (ConnectionData)element$iv;
            boolean bl = false;
            Logger $this$debug_u24default$iv2 = QuicServerKt.access$getLOG$p();
            Throwable t$iv2 = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv2;
                boolean bl2 = false;
                logger.debug("Release Quiche connection (id: " + connection.getId() + ", state: " + connection.getQuicheConnectionState() + ")", t$iv2);
            }
            connection.getQuichePointerSafe();
            this.connections.remove(connection.getId());
        }
    }

    private final byte[] mintToken(SourceConnectionId scid, InetSocketAddress remoteAddress) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(48);
        out.write(scid.getBytes().length);
        out.write(scid.getBytes(), 0, scid.getBytes().length);
        out.write(remoteAddress.getAddress().getAddress().length);
        out.write(remoteAddress.getAddress().getAddress(), 0, remoteAddress.getAddress().getAddress().length);
        new DataOutputStream(out).writeInt(remoteAddress.getPort());
        byte[] arr = out.toByteArray();
        if (!(arr.length <= this.getMaxTokenLen())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)arr);
        return arr;
    }

    private final int getMaxTokenLen() {
        return 43;
    }

    private final void addToSendQueue(ConnectionData connection, byte[] arr) {
        connection.getStreamTransport().getToSendQueue().addFirst(arr);
        this.quicWakeupQueue.add(true);
    }

    private final void addToReceiveQueue(ConnectionData connection, byte[] arr) {
        connection.getStreamTransport().getReceivedQueue().add(arr);
    }

    private static final Unit _init_$lambda$2(QuicServer this$0, InetSocketAddress $localAddress) {
        this$0.quicThread($localAddress);
        return Unit.INSTANCE;
    }

    private static final Unit getOrCreateConnection$lambda$8(ConnectionData $data, QuicServerStreamTransport $streamTransport) {
        $data.requestQuicheTermination();
        $streamTransport.getStateProperty().setIfNotTerminal(ConnectionState.CLOSED.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(QuicServer this$0, InetSocketAddress peer, byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this$0.socketReceivedDatagrams.add((Pair<InetSocketAddress, byte[]>)TuplesKt.to((Object)peer, (Object)bytes));
        this$0.quicWakeupQueue.add(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicServer$AcceptData;", "", "lifetimeOnQuicThread", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "streamTransport", "Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;", "peer", "Ljava/net/InetSocketAddress;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;Ljava/net/InetSocketAddress;)V", "getLifetimeOnQuicThread", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getStreamTransport", "()Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;", "getPeer", "()Ljava/net/InetSocketAddress;", "toString", "", "intellij.platform.split.connection"})
    public static final class AcceptData {
        @NotNull
        private final LifetimeDefinition lifetimeOnQuicThread;
        @NotNull
        private final StreamTransport streamTransport;
        @NotNull
        private final InetSocketAddress peer;

        public AcceptData(@NotNull LifetimeDefinition lifetimeOnQuicThread, @NotNull StreamTransport streamTransport, @NotNull InetSocketAddress peer) {
            Intrinsics.checkNotNullParameter((Object)lifetimeOnQuicThread, (String)"lifetimeOnQuicThread");
            Intrinsics.checkNotNullParameter((Object)streamTransport, (String)"streamTransport");
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            this.lifetimeOnQuicThread = lifetimeOnQuicThread;
            this.streamTransport = streamTransport;
            this.peer = peer;
        }

        @NotNull
        public final LifetimeDefinition getLifetimeOnQuicThread() {
            return this.lifetimeOnQuicThread;
        }

        @NotNull
        public final StreamTransport getStreamTransport() {
            return this.streamTransport;
        }

        @NotNull
        public final InetSocketAddress getPeer() {
            return this.peer;
        }

        @NotNull
        public String toString() {
            return "QUIC:" + this.peer;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010!\u001a\u0004\u0018\u00010\"J\b\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020\u001fJ\u0006\u0010'\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \u00a8\u0006("}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicServer$ConnectionData;", "", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "quic", "Lcom/intellij/platform/split/connection/network/quic/QuicheConnection;", "streamTransport", "Lcom/intellij/platform/split/connection/network/quic/QuicServerStreamTransport;", "peer", "Ljava/net/InetSocketAddress;", "id", "Lcom/intellij/platform/split/connection/network/quic/QuicServer$DestinationConnectionId;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/intellij/platform/split/connection/network/quic/QuicheConnection;Lcom/intellij/platform/split/connection/network/quic/QuicServerStreamTransport;Ljava/net/InetSocketAddress;Lcom/intellij/platform/split/connection/network/quic/QuicServer$DestinationConnectionId;)V", "getLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getQuic", "()Lcom/intellij/platform/split/connection/network/quic/QuicheConnection;", "getStreamTransport", "()Lcom/intellij/platform/split/connection/network/quic/QuicServerStreamTransport;", "getPeer", "()Ljava/net/InetSocketAddress;", "getId", "()Lcom/intellij/platform/split/connection/network/quic/QuicServer$DestinationConnectionId;", "quicheConnectionStateAtomic", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/platform/split/connection/network/quic/QuicServer$QuicheConnectionState;", "quicheConnectionState", "getQuicheConnectionState", "()Lcom/intellij/platform/split/connection/network/quic/QuicServer$QuicheConnectionState;", "isTransportConnected", "", "()Z", "getQuichePointerSafe", "Lcom/sun/jna/ptr/PointerByReference;", "freeQuicheConnection", "", "requestQuicheTermination", "isQuicheConnectionEstablished", "isQuicheConnectionClosed", "intellij.platform.split.connection"})
    @SourceDebugExtension(value={"SMAP\nQuicServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuicServer.kt\ncom/intellij/platform/split/connection/network/quic/QuicServer$ConnectionData\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,611:1\n60#2,5:612\n1#3:617\n*S KotlinDebug\n*F\n+ 1 QuicServer.kt\ncom/intellij/platform/split/connection/network/quic/QuicServer$ConnectionData\n*L\n123#1:612,5\n*E\n"})
    private static final class ConnectionData {
        @NotNull
        private final LifetimeDefinition lifetimeDefinition;
        @NotNull
        private final QuicheConnection quic;
        @NotNull
        private final QuicServerStreamTransport streamTransport;
        @NotNull
        private final InetSocketAddress peer;
        @NotNull
        private final DestinationConnectionId id;
        @NotNull
        private final AtomicReference<QuicheConnectionState> quicheConnectionStateAtomic;

        public ConnectionData(@NotNull LifetimeDefinition lifetimeDefinition, @NotNull QuicheConnection quic, @NotNull QuicServerStreamTransport streamTransport, @NotNull InetSocketAddress peer, @NotNull DestinationConnectionId id) {
            Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
            Intrinsics.checkNotNullParameter((Object)quic, (String)"quic");
            Intrinsics.checkNotNullParameter((Object)streamTransport, (String)"streamTransport");
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.lifetimeDefinition = lifetimeDefinition;
            this.quic = quic;
            this.streamTransport = streamTransport;
            this.peer = peer;
            this.id = id;
            this.quicheConnectionStateAtomic = new AtomicReference<QuicheConnectionState>(QuicheConnectionState.CONNECTED);
        }

        @NotNull
        public final LifetimeDefinition getLifetimeDefinition() {
            return this.lifetimeDefinition;
        }

        @NotNull
        public final QuicheConnection getQuic() {
            return this.quic;
        }

        @NotNull
        public final QuicServerStreamTransport getStreamTransport() {
            return this.streamTransport;
        }

        @NotNull
        public final InetSocketAddress getPeer() {
            return this.peer;
        }

        @NotNull
        public final DestinationConnectionId getId() {
            return this.id;
        }

        @NotNull
        public final QuicheConnectionState getQuicheConnectionState() {
            QuicheConnectionState quicheConnectionState = this.quicheConnectionStateAtomic.get();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)quicheConnectionState), (String)"get(...)");
            return quicheConnectionState;
        }

        public final boolean isTransportConnected() {
            return ConnectionState.Companion.isConnected(this.streamTransport.getStateProperty().getValue());
        }

        @Nullable
        public final PointerByReference getQuichePointerSafe() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.getQuicheConnectionState().ordinal()]) {
                case 1 -> this.quic.getPointer();
                case 2 -> {
                    QuicServerKt.access$getLOG$p().warn("Skip free Quiche connection. Connection is already terminated.");
                    yield null;
                }
                case 3 -> {
                    this.freeQuicheConnection();
                    yield null;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final void freeQuicheConnection() {
            Logger $this$debug_u24default$iv = QuicServerKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Quiche connection in request termination state. Release Quiche connection.", t$iv);
            }
            Quiche.INSTANCE.getLibrary().quiche_conn_free(this.quic.getPointer());
            this.quicheConnectionStateAtomic.set(QuicheConnectionState.TERMINATED);
        }

        public final void requestQuicheTermination() {
            if (this.quicheConnectionStateAtomic.compareAndSet(QuicheConnectionState.CONNECTED, QuicheConnectionState.REQUESTED_TERMINATION)) {
                QuicServerKt.access$getLOG$p().info("Quiche connection request termination");
            } else {
                QuicServerKt.access$getLOG$p().info("Quiche connection is already in termination state: " + this.getQuicheConnectionState());
            }
        }

        public final boolean isQuicheConnectionEstablished() {
            boolean bl;
            PointerByReference pointerByReference = this.getQuichePointerSafe();
            if (pointerByReference != null) {
                PointerByReference it = pointerByReference;
                boolean bl2 = false;
                bl = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_established(it));
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean isQuicheConnectionClosed() {
            boolean bl;
            PointerByReference pointerByReference = this.getQuichePointerSafe();
            if (pointerByReference != null) {
                PointerByReference it = pointerByReference;
                boolean bl2 = false;
                bl = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_closed(it));
            } else {
                bl = true;
            }
            return bl;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[QuicheConnectionState.values().length];
                try {
                    nArray[QuicheConnectionState.CONNECTED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QuicheConnectionState.TERMINATED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QuicheConnectionState.REQUESTED_TERMINATION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u000b\u001a\u00020\fH\u0096\u0080\u0004J\n\u0010\r\u001a\u00020\u000eH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicServer$DestinationConnectionId;", "", "bytes", "", "<init>", "([B)V", "getBytes", "()[B", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.split.connection"})
    private static final class DestinationConnectionId {
        @NotNull
        private final byte[] bytes;

        public DestinationConnectionId(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.bytes = bytes;
            if (!(this.bytes.length <= 20)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            DestinationConnectionId destinationConnectionId = (DestinationConnectionId)other;
            Object object = destinationConnectionId;
            if (destinationConnectionId == null) return false;
            object = ((DestinationConnectionId)object).bytes;
            if (((DestinationConnectionId)object).bytes == null) return false;
            if (!Arrays.equals((byte[])object, this.bytes)) return false;
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        @NotNull
        public String toString() {
            return "DCID:" + QuicheCommon.INSTANCE.toHexString(this.bytes);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicServer$QuicheConnectionState;", "", "<init>", "(Ljava/lang/String;I)V", "CONNECTED", "REQUESTED_TERMINATION", "TERMINATED", "intellij.platform.split.connection"})
    private static final class QuicheConnectionState
    extends Enum<QuicheConnectionState> {
        public static final /* enum */ QuicheConnectionState CONNECTED = new QuicheConnectionState();
        public static final /* enum */ QuicheConnectionState REQUESTED_TERMINATION = new QuicheConnectionState();
        public static final /* enum */ QuicheConnectionState TERMINATED = new QuicheConnectionState();
        private static final /* synthetic */ QuicheConnectionState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static QuicheConnectionState[] values() {
            return (QuicheConnectionState[])$VALUES.clone();
        }

        public static QuicheConnectionState valueOf(String value) {
            return Enum.valueOf(QuicheConnectionState.class, value);
        }

        @NotNull
        public static EnumEntries<QuicheConnectionState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = quicheConnectionStateArray = new QuicheConnectionState[]{QuicheConnectionState.CONNECTED, QuicheConnectionState.REQUESTED_TERMINATION, QuicheConnectionState.TERMINATED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u000b\u001a\u00020\fH\u0096\u0080\u0004J\n\u0010\r\u001a\u00020\u000eH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicServer$SourceConnectionId;", "", "bytes", "", "<init>", "([B)V", "getBytes", "()[B", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.split.connection"})
    private static final class SourceConnectionId {
        @NotNull
        private final byte[] bytes;

        public SourceConnectionId(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.bytes = bytes;
            if (!(this.bytes.length <= 20)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            SourceConnectionId sourceConnectionId = (SourceConnectionId)other;
            Object object = sourceConnectionId;
            if (sourceConnectionId == null) return false;
            object = ((SourceConnectionId)object).bytes;
            if (((SourceConnectionId)object).bytes == null) return false;
            if (!Arrays.equals((byte[])object, this.bytes)) return false;
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        @NotNull
        public String toString() {
            return "SCID:" + QuicheCommon.INSTANCE.toHexString(this.bytes);
        }
    }
}

