/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.turn.channel;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.turn.TurnMessageUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/split/connection/network/turn/channel/ChannelNumberGenerator;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "MIN_CHANNEL_NUMBER", "", "MAX_CHANNEL_NUMBER", "channelNumbersArray", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "getFreeChannelNumber", "", "releaseChannelNumber", "", "channelNumber", "reset", "isNumberAvailable", "", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nChannelNumberGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelNumberGenerator.kt\ncom/intellij/platform/split/connection/network/turn/channel/ChannelNumberGenerator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,64:1\n67#2,4:65\n67#2,4:69\n67#2,4:73\n13#2:79\n1#3:77\n13#4:78\n*S KotlinDebug\n*F\n+ 1 ChannelNumberGenerator.kt\ncom/intellij/platform/split/connection/network/turn/channel/ChannelNumberGenerator\n*L\n32#1:65,4\n38#1:69,4\n55#1:73,4\n14#1:79\n14#1:78\n*E\n"})
public final class ChannelNumberGenerator {
    @NotNull
    public static final ChannelNumberGenerator INSTANCE = new ChannelNumberGenerator();
    @NotNull
    private static final Logger logger;
    public static final int MIN_CHANNEL_NUMBER = 16384;
    public static final int MAX_CHANNEL_NUMBER = 20479;
    @NotNull
    private static final ConcurrentLinkedDeque<Integer> channelNumbersArray;

    private ChannelNumberGenerator() {
    }

    public final char getFreeChannelNumber() {
        if (channelNumbersArray.isEmpty()) {
            throw new IllegalStateException("Exceeded maximum number of available TURN channel numbers.");
        }
        char channelToUse = (char)((Number)channelNumbersArray.pop()).intValue();
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Got TURN channel number to use: " + TurnMessageUtil.INSTANCE.toHex(channelToUse));
        }
        return channelToUse;
    }

    public final void releaseChannelNumber(char channelNumber) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Release TURN channel number: " + TurnMessageUtil.INSTANCE.toHex(channelNumber));
        }
        char channelNumberCode = channelNumber;
        if (channelNumbersArray.contains(channelNumberCode)) {
            logger.warn("Channel with number '" + TurnMessageUtil.INSTANCE.toHex(channelNumber) + "' is not used.");
            return;
        }
        if (channelNumberCode < '\u4000' || channelNumberCode > '\u4fff') {
            int n = 16384;
            String string = TurnMessageUtil.INSTANCE.toHex((char)n);
            n = 20479;
            throw new IllegalStateException("Channel number must be in range: " + string + ".." + TurnMessageUtil.INSTANCE.toHex((char)n));
        }
        channelNumbersArray.add(Integer.valueOf(channelNumberCode));
    }

    public final void reset() {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Reset available TURN channels array");
        }
        channelNumbersArray.clear();
        IntRange it = new IntRange(16384, 20479);
        boolean bl = false;
        CollectionsKt.addAll((Collection)channelNumbersArray, (Iterable)((Iterable)it));
    }

    public final boolean isNumberAvailable(char channelNumber) {
        return channelNumbersArray.contains(channelNumber);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChannelNumberGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ChannelNumberGenerator.logger = logger;
        channelNumbersArray = new ConcurrentLinkedDeque();
        INSTANCE.reset();
    }
}

