/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.channel;

import com.intellij.platform.split.connection.impl.SelfSignedCertificate;
import com.intellij.platform.split.connection.protocol.channel.ChannelProtocolType;
import com.intellij.platform.split.connection.protocol.channel.TlsByteChannelKt;
import com.intellij.platform.split.connection.protocol.transport.NamedTransportEntity;
import com.intellij.platform.split.connection.protocol.transport.tls.TlsData;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tlschannel.ClientTlsChannel;
import tlschannel.ServerTlsChannel;
import tlschannel.TlsChannel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0016J\u0006\u0010\u001e\u001a\u00020\u0015J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J&\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/TlsByteChannel;", "Ljava/nio/channels/ByteChannel;", "Lcom/intellij/platform/split/connection/protocol/transport/NamedTransportEntity;", "id", "", "underlying", "tlsData", "Lcom/intellij/platform/split/connection/protocol/transport/tls/TlsData;", "<init>", "(Ljava/lang/String;Ljava/nio/channels/ByteChannel;Lcom/intellij/platform/split/connection/protocol/transport/tls/TlsData;)V", "getTlsData", "()Lcom/intellij/platform/split/connection/protocol/transport/tls/TlsData;", "name", "getName", "()Ljava/lang/String;", "tlsChannel", "Ltlschannel/TlsChannel;", "isTrusted", "", "()Z", "close", "", "isOpenMismatchLogged", "isOpen", "read", "", "dst", "Ljava/nio/ByteBuffer;", "write", "src", "handshake", "getCertificates", "", "Ljava/security/cert/X509Certificate;", "initTlsChannel", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "isServer", "certificateData", "Lkotlin/Function0;", "Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$SelfSignedCertificateData;", "Companion", "intellij.platform.split.connection"})
public class TlsByteChannel
implements ByteChannel,
NamedTransportEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final ByteChannel underlying;
    @NotNull
    private final TlsData tlsData;
    @NotNull
    private final String name;
    @NotNull
    private final TlsChannel tlsChannel;
    private boolean isOpenMismatchLogged;
    @NotNull
    private static final String TLS_PROTOCOL_TYPE = ChannelProtocolType.TLS_V_13.getValue();

    public TlsByteChannel(@NotNull String id, @NotNull ByteChannel underlying, @NotNull TlsData tlsData) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)tlsData, (String)"tlsData");
        this.id = id;
        this.underlying = underlying;
        this.tlsData = tlsData;
        this.name = "TLS Byte Channel (id: " + this.id + ")";
        this.tlsChannel = this.initTlsChannel(this.tlsData.getTrustManager(), this.tlsData.isServer(), this.tlsData.getLocalCertificate());
    }

    @NotNull
    public final TlsData getTlsData() {
        return this.tlsData;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final boolean isTrusted() {
        Collection collection = this.getCertificates();
        return !(collection == null || collection.isEmpty());
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public boolean isOpen() {
        if (this.tlsChannel.isOpen() != this.underlying.isOpen() && !this.isOpenMismatchLogged) {
            TlsByteChannelKt.access$getLogger$p().info(this.getName() + " isOpen = " + this.tlsChannel.isOpen() + ", but underlying channel isOpen = " + this.underlying.isOpen());
            this.isOpenMismatchLogged = true;
        }
        return this.tlsChannel.isOpen();
    }

    @Override
    public int read(@Nullable ByteBuffer dst) {
        return this.tlsChannel.read(dst);
    }

    @Override
    public int write(@Nullable ByteBuffer src) {
        return this.tlsChannel.write(src);
    }

    public final void handshake() {
        this.tlsChannel.handshake();
    }

    @NotNull
    public final List<X509Certificate> getCertificates() {
        return this.tlsData.getTrustManager().getCertificates();
    }

    private final TlsChannel initTlsChannel(X509TrustManager trustManager, boolean isServer, Function0<SelfSignedCertificate.SelfSignedCertificateData> certificateData) {
        TlsChannel tlsChannel;
        SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL_TYPE);
        SelfSignedCertificate.SelfSignedCertificateData certData = (SelfSignedCertificate.SelfSignedCertificateData)certificateData.invoke();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(certData.getKeyStore(), certData.getKeyPassword());
        X509TrustManager[] x509TrustManagerArray = new X509TrustManager[]{trustManager};
        sslContext.init(keyManagerFactory.getKeyManagers(), x509TrustManagerArray, null);
        boolean bl = isServer;
        if (bl) {
            tlsChannel = (TlsChannel)ServerTlsChannel.newBuilder((ByteChannel)this.underlying, (SSLContext)sslContext).withEngineFactory(TlsByteChannel::initTlsChannel$lambda$0).build();
        } else if (!bl) {
            tlsChannel = (TlsChannel)ClientTlsChannel.newBuilder((ByteChannel)this.underlying, (SSLContext)sslContext).build();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TlsChannel channel = tlsChannel;
        Intrinsics.checkNotNull((Object)channel);
        return channel;
    }

    private static final SSLEngine initTlsChannel$lambda$0(SSLContext it) {
        SSLEngine sslEngine = it.createSSLEngine();
        sslEngine.setUseClientMode(false);
        sslEngine.setNeedClientAuth(true);
        return sslEngine;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/TlsByteChannel$Companion;", "", "<init>", "()V", "TLS_PROTOCOL_TYPE", "", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

