/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThrowableConsumer;
import java.io.IOException;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public abstract class CompositeStorageOwner
implements StorageOwner {
    private static final Logger LOG = Logger.getInstance(CompositeStorageOwner.class);

    protected abstract Iterable<? extends StorageOwner> getChildStorages();

    @Override
    public void flush(boolean memoryCachesOnly) {
        try {
            this.applyBulkOperation(this.getChildStorages(), storageOwner -> storageOwner.flush(memoryCachesOnly));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void clean() throws IOException {
        this.applyBulkOperation(this.getChildStorages(), StorageOwner::clean);
    }

    @Override
    public void close() throws IOException {
        this.applyBulkOperation(this.getChildStorages(), StorageOwner::close);
    }

    protected <T extends StorageOwner> void applyBulkOperation(Iterable<? extends T> storages, ThrowableConsumer<? super T, IOException> action) throws IOException {
        IOException exc = null;
        for (StorageOwner child : storages) {
            if (child == null) continue;
            try {
                action.consume((Object)child);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                if (exc != null) continue;
                exc = e;
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        if (exc != null) {
            throw exc;
        }
    }
}

