/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.terminal.BlockTerminalColors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.output.BlockDecorationState;
import org.jetbrains.plugins.terminal.block.ui.GradientTextureCache;
import org.jetbrains.plugins.terminal.block.ui.TerminalBlockBackgroundRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalBlockCornersRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalBlockLeftAreaRenderer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/HoveredBlockDecorationState;", "Lorg/jetbrains/plugins/terminal/block/output/BlockDecorationState;", "gradientCache", "Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;)V", "backgroundRenderer", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "getBackgroundRenderer", "()Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "cornersRenderer", "getCornersRenderer", "leftAreaRenderer", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "getLeftAreaRenderer", "()Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "intellij.terminal"})
public class HoveredBlockDecorationState
implements BlockDecorationState {
    @NotNull
    private final CustomHighlighterRenderer backgroundRenderer;
    @NotNull
    private final CustomHighlighterRenderer cornersRenderer;
    @NotNull
    private final LineMarkerRenderer leftAreaRenderer;

    public HoveredBlockDecorationState(@NotNull GradientTextureCache gradientCache) {
        Intrinsics.checkNotNullParameter((Object)gradientCache, (String)"gradientCache");
        this.backgroundRenderer = new TerminalBlockBackgroundRenderer(gradientCache);
        this.cornersRenderer = new TerminalBlockCornersRenderer(gradientCache, null, 0, 6, null);
        this.leftAreaRenderer = new TerminalBlockLeftAreaRenderer(BlockTerminalColors.HOVERED_BLOCK_BACKGROUND_START, null, null, 0, 14, null);
    }

    @Override
    @NotNull
    public CustomHighlighterRenderer getBackgroundRenderer() {
        return this.backgroundRenderer;
    }

    @Override
    @NotNull
    public CustomHighlighterRenderer getCornersRenderer() {
        return this.cornersRenderer;
    }

    @Override
    @NotNull
    public LineMarkerRenderer getLeftAreaRenderer() {
        return this.leftAreaRenderer;
    }
}

