/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.socket;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.DebugTrafficInfo;
import com.jetbrains.codeWithMe.model.PortStrategy;
import com.jetbrains.codeWithMe.model.RdConnection;
import com.jetbrains.codeWithMe.model.RdForwardedPort;
import com.jetbrains.codeWithMe.model.RdPortState;
import com.jetbrains.codeWithMe.model.RdSocketAddress;
import com.jetbrains.codeWithMe.model.SocketState;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.utils.PortForwardingUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.threading.SingleThreadScheduler;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u00011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\rJ\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\rH\u0002J\b\u0010+\u001a\u00020\u001aH\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "rdPort", "Lcom/jetbrains/codeWithMe/model/RdForwardedPort;", "uniqueId", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/codeWithMe/model/RdForwardedPort;Ljava/lang/String;)V", "getRdPort", "()Lcom/jetbrains/codeWithMe/model/RdForwardedPort;", "acceptTimeout", "", "getAcceptTimeout", "()I", "clientConnectionTimeout", "getClientConnectionTimeout", "name", "meter", "Lio/opentelemetry/api/metrics/Meter;", "sentBytesCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "receivedBytesCounter", "_serverSocket", "Ljava/net/ServerSocket;", "serverSocket", "getServerSocket", "()Ljava/net/ServerSocket;", "_trafficThread", "Ljava/lang/Thread;", "trafficThread", "getTrafficThread", "()Ljava/lang/Thread;", "incomingSignalsScheduler", "Lcom/jetbrains/rd/util/threading/SingleThreadScheduler;", "start", "", "changeListeningSocket", "newPort", "createNewSocket", "port", "createListeningSocket", "monitorOneConnection", "clientSocket", "Ljava/net/Socket;", "createListeningThread", "socket", "Companion", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nServerSocketWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerSocketWrapper.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,337:1\n60#2,5:338\n60#2,5:343\n60#2,5:348\n67#2,4:353\n60#2,5:357\n60#2,5:362\n60#2,5:367\n60#2,5:372\n60#2,5:377\n60#2,5:382\n67#2,4:387\n60#2,5:391\n67#2,4:396\n60#2,5:400\n67#2,4:405\n60#2,5:409\n60#2,5:414\n60#2,5:419\n60#2,5:424\n67#2,4:429\n67#2,4:433\n13#2:438\n13#3:437\n*S KotlinDebug\n*F\n+ 1 ServerSocketWrapper.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper\n*L\n150#1:338,5\n286#1:343,5\n61#1:348,5\n163#1:353,4\n175#1:357,5\n179#1:362,5\n189#1:367,5\n193#1:372,5\n203#1:377,5\n205#1:382,5\n207#1:387,4\n222#1:391,5\n228#1:396,4\n234#1:400,5\n251#1:405,4\n257#1:409,5\n271#1:414,5\n274#1:419,5\n281#1:424,5\n302#1:429,4\n306#1:433,4\n33#1:438\n33#1:437\n*E\n"})
public final class ServerSocketWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RdForwardedPort rdPort;
    @NotNull
    private final String name;
    @NotNull
    private final Meter meter;
    private final LongCounter sentBytesCounter;
    private final LongCounter receivedBytesCounter;
    @Nullable
    private ServerSocket _serverSocket;
    @Nullable
    private Thread _trafficThread;
    @NotNull
    private final SingleThreadScheduler incomingSignalsScheduler;
    @NotNull
    private static final Logger logger;

    public ServerSocketWrapper(@NotNull Lifetime lifetime, @NotNull RdForwardedPort rdPort, @NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)rdPort, (String)"rdPort");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        this.lifetime = lifetime;
        this.rdPort = rdPort;
        this.name = StringsKt.take((String)uniqueId, (int)7);
        this.meter = TelemetryManager.Companion.getMeter(RdctScopesKt.RDCT);
        this.sentBytesCounter = this.meter.counterBuilder("rdct.ServerSocketWrapper.sentBytes." + this.name).setUnit("bytes").build();
        this.receivedBytesCounter = this.meter.counterBuilder("rdct.ServerSocketWrapper.receivedBytes." + this.name).setUnit("bytes").build();
        this.incomingSignalsScheduler = new SingleThreadScheduler(this.lifetime, "Scheduler for port forwarding " + this.rdPort.getPortNumber());
        this.lifetime.onTermination(() -> ServerSocketWrapper._init_$lambda$0(this));
    }

    @NotNull
    public final RdForwardedPort getRdPort() {
        return this.rdPort;
    }

    private final int getAcceptTimeout() {
        return Registry.Companion.intValue("codeWithMe.portForwarding.socketAcceptTimeout");
    }

    private final int getClientConnectionTimeout() {
        return Registry.Companion.intValue("codeWithMe.portForwarding.clientConnectionTimeout");
    }

    private final ServerSocket getServerSocket() {
        ServerSocket serverSocket = this._serverSocket;
        if (serverSocket == null) {
            throw new IllegalStateException("Server socket is not defined. Please make sure you init server socket.".toString());
        }
        return serverSocket;
    }

    private final Thread getTrafficThread() {
        Thread thread = this._trafficThread;
        if (thread == null) {
            throw new IllegalStateException("Traffic thread is not defined. Please make sure you init server socket.".toString());
        }
        return thread;
    }

    public final void start() {
        this._serverSocket = this.createListeningSocket();
        this._trafficThread = this.createListeningThread(this.getServerSocket());
        logger.info("Started port forwarding session: " + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState()))) + " -> " + this.rdPort.getPortNumber());
        this.getTrafficThread().start();
    }

    public final void changeListeningSocket(int newPort) {
        ServerSocket newSocket = this.createNewSocket(newPort);
        Thread newThread = this.createListeningThread(newSocket);
        this.getServerSocket().close();
        this._serverSocket = newSocket;
        this._trafficThread = newThread;
        ApplicationKt.getApplication().invokeLater(() -> ServerSocketWrapper.changeListeningSocket$lambda$0(this), ModalityState.any());
        this.getTrafficThread().start();
    }

    private final ServerSocket createNewSocket(int port) throws IllegalStateException, IOException {
        Object object;
        ServerSocket socket = new ServerSocket();
        socket.setReuseAddress(true);
        if (this.getAcceptTimeout() > 0) {
            socket.setSoTimeout(this.getAcceptTimeout());
        }
        if ((object = (RdPortState)this.rdPort.getRdPortState().getValueOrNull()) == null || (object = object.getSocketAddress()) == null || (object = PortForwardingUtilsKt.toSocketAddress((RdSocketAddress)object)) == null || (object = ((InetSocketAddress)object).getAddress()) == null) {
            object = Inet4Address.getByName("127.0.0.1");
        }
        Object prevSockAddr = object;
        socket.bind(new InetSocketAddress((InetAddress)prevSockAddr, port), 1000);
        return socket;
    }

    private final ServerSocket createListeningSocket() {
        PortStrategy strategy = this.rdPort.getPortStrategy();
        RdSocketAddress rdSocketAddress = this.rdPort.getDesiredSocketAddress();
        if (rdSocketAddress == null) {
            rdSocketAddress = new RdSocketAddress("127.0.0.1", this.rdPort.getPortNumber());
        }
        RdSocketAddress desiredAddress = rdSocketAddress;
        ServerSocket socket = new ServerSocket();
        socket.setReuseAddress(true);
        if (this.getAcceptTimeout() > 0) {
            socket.setSoTimeout(this.getAcceptTimeout());
        }
        try {
            socket.bind(PortForwardingUtilsKt.toSocketAddress(desiredAddress), 1000);
            this.rdPort.getRdPortState().set((Object)new RdPortState(SocketState.LISTENING, desiredAddress, null));
            return socket;
        }
        catch (IOException e) {
            switch (WhenMappings.$EnumSwitchMapping$0[strategy.ordinal()]) {
                case 1: {
                    InetAddress address = PortForwardingUtilsKt.toSocketAddress(desiredAddress).getAddress();
                    socket.bind(new InetSocketAddress(address, 0), 1000);
                    IOptProperty iOptProperty = this.rdPort.getRdPortState();
                    String string = address.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
                    SocketAddress socketAddress = socket.getLocalSocketAddress();
                    Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
                    iOptProperty.set((Object)new RdPortState(SocketState.LISTENING, new RdSocketAddress(string, ((InetSocketAddress)socketAddress).getPort()), null));
                    return socket;
                }
                case 2: {
                    throw e;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void monitorOneConnection(Socket clientSocket) {
        RdConnection rdConnection2;
        Logger logger;
        int portNumber = this.rdPort.getPortNumber();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String connectionId = string;
        Logger $this$debug_u24default$iv = ServerSocketWrapper.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean rdConnection2 = false;
            logger.debug("Creating connection: " + clientSocket.getPort() + " -> " + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState()))) + " -> " + portNumber + ", id: " + connectionId, t$iv);
        }
        if (this.getClientConnectionTimeout() > 0) {
            clientSocket.setSoTimeout(this.getClientConnectionTimeout());
        }
        LifetimeDefinition rdConnectionLifetimeDef = this.lifetime.createNested();
        Lifetime rdConnectionLifetime = rdConnectionLifetimeDef.getLifetime();
        RdConnection $this$monitorOneConnection_u24lambda_u241 = rdConnection2 = new RdConnection(connectionId, clientSocket.getPort());
        boolean bl = false;
        PortForwardingUtilsKt.setScheduler($this$monitorOneConnection_u24lambda_u241, (IScheduler)this.incomingSignalsScheduler);
        RdConnection rdConnection3 = rdConnection2;
        rdConnection3.getToServerSocket().advise(rdConnectionLifetime, arg_0 -> ServerSocketWrapper.monitorOneConnection$lambda$2(this, clientSocket, connectionId, rdConnectionLifetimeDef, arg_0));
        rdConnection3.getDestinationSocketInputShutdown().advise(rdConnectionLifetime, arg_0 -> ServerSocketWrapper.monitorOneConnection$lambda$3(clientSocket, rdConnectionLifetimeDef, portNumber, connectionId, arg_0));
        rdConnection3.getDestinationSocketOutputShutdown().advise(rdConnectionLifetime, arg_0 -> ServerSocketWrapper.monitorOneConnection$lambda$4(clientSocket, rdConnectionLifetimeDef, portNumber, connectionId, arg_0));
        rdConnectionLifetime.onTermination(() -> ServerSocketWrapper.monitorOneConnection$lambda$5(clientSocket, this, portNumber, connectionId, rdConnection3));
        String threadName = "Port Forwarding connection thread, id: " + connectionId;
        Thread myThread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)threadName, (int)0, () -> ServerSocketWrapper.monitorOneConnection$lambda$6(rdConnectionLifetime, clientSocket, connectionId, this, rdConnection3, threadName), (int)20, null);
        rdConnection3.getReady().advise(rdConnectionLifetime, arg_0 -> ServerSocketWrapper.monitorOneConnection$lambda$7(myThread, connectionId, arg_0));
        Logger $this$debug_u24default$iv2 = ServerSocketWrapper.logger;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl2 = false;
            logger.debug("Adding connection: " + clientSocket.getPort() + " -> " + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState()))) + " -> " + portNumber + ", id: " + connectionId, t$iv2);
        }
        ApplicationKt.getApplication().invokeLater(() -> ServerSocketWrapper.monitorOneConnection$lambda$9(this, rdConnection3), ModalityState.any());
    }

    private final Thread createListeningThread(ServerSocket socket) {
        int hostPortNumber = this.rdPort.getPortNumber();
        return ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)("PortForwarder: " + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState()))) + " -> " + hostPortNumber), (int)0, () -> ServerSocketWrapper.createListeningThread$lambda$0(this, hostPortNumber, socket), (int)20, null);
    }

    private static final Unit _init_$lambda$0(ServerSocketWrapper this$0) {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Server Socket. Lifetime is terminated. Try to close server socket", t$iv);
        }
        try {
            if (!this$0.getServerSocket().isClosed()) {
                this$0.getServerSocket().close();
            }
        }
        catch (Throwable e) {
            logger.warn(e);
        }
        return Unit.INSTANCE;
    }

    private static final void changeListeningSocket$lambda$0(ServerSocketWrapper this$0) {
        IOptProperty iOptProperty = this$0.rdPort.getRdPortState();
        SocketAddress socketAddress = this$0.getServerSocket().getLocalSocketAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        iOptProperty.set((Object)new RdPortState(SocketState.LISTENING, PortForwardingUtilsKt.toRdSocketAddress((InetSocketAddress)socketAddress), null));
    }

    private static final void monitorOneConnection$lambda$5$3(ServerSocketWrapper this$0, RdConnection $rdConnection) {
        this$0.rdPort.getConnections().remove((Object)$rdConnection);
    }

    private static final Unit monitorOneConnection$lambda$2(ServerSocketWrapper this$0, Socket $clientSocket, String $connectionId, LifetimeDefinition $rdConnectionLifetimeDef, DebugTrafficInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("received buffer " + it.getCounter() + " from model. size: " + it.getBytes().length + ", id: " + $connectionId);
        }
        try {
            this$0.receivedBytesCounter.add((long)it.getBytes().length);
            $clientSocket.getOutputStream().write(it.getBytes());
        }
        catch (IOException e) {
            logger.warn("Failed to write to client socket. exiting connection, id: " + $connectionId);
            LifetimeDefinition.terminate$default((LifetimeDefinition)$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit monitorOneConnection$lambda$3(Socket $clientSocket, LifetimeDefinition $rdConnectionLifetimeDef, int $portNumber, String $connectionId, Unit it) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$debug_u24default$iv = ServerSocketWrapper.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("hostSocketInputShutdown of " + $portNumber + ", id: " + $connectionId, t$iv);
        }
        try {
            $clientSocket.shutdownOutput();
            if ($clientSocket.isInputShutdown() || $clientSocket.isClosed()) {
                $this$debug_u24default$iv = ServerSocketWrapper.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("hostSocketInputShutdown and isInputShutdown=true. Terminating lifetime of " + $portNumber + ", id: " + $connectionId, t$iv);
                }
                LifetimeDefinition.terminate$default((LifetimeDefinition)$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
            }
        }
        catch (Throwable e) {
            ServerSocketWrapper.logger.warn("hostSocketInputShutdown: Failed to shutdownOutput of " + $portNumber + ", id: " + $connectionId, e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit monitorOneConnection$lambda$4(Socket $clientSocket, LifetimeDefinition $rdConnectionLifetimeDef, int $portNumber, String $connectionId, Unit it) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$debug_u24default$iv = ServerSocketWrapper.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("hostSocketOutputShutdown of " + $portNumber + ", id: " + $connectionId, t$iv);
        }
        try {
            $clientSocket.shutdownInput();
            if ($clientSocket.isOutputShutdown() || $clientSocket.isClosed()) {
                $this$debug_u24default$iv = ServerSocketWrapper.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("hostSocketOutputShutdown and isOutputShutdown=true. Terminating lifetime of " + $portNumber + ", id: " + $connectionId, t$iv);
                }
                LifetimeDefinition.terminate$default((LifetimeDefinition)$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
            }
        }
        catch (Throwable e) {
            ServerSocketWrapper.logger.warn("hostSocketOutputShutdown: Failed to shutdownInput of " + $portNumber + ", id: " + $connectionId, e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit monitorOneConnection$lambda$5(Socket $clientSocket, ServerSocketWrapper this$0, int $portNumber, String $connectionId, RdConnection $rdConnection) {
        Logger logger;
        Logger $this$debug_u24default$iv = ServerSocketWrapper.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Removing connection: " + $clientSocket.getPort() + " -> " + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this$0.rdPort.getRdPortState()))) + " -> " + $portNumber + ", id: " + $connectionId, t$iv);
        }
        try {
            $this$debug_u24default$iv = ServerSocketWrapper.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Going to close socket, id: " + $connectionId, t$iv);
            }
            if (!$clientSocket.isClosed()) {
                Logger $this$trace$iv = ServerSocketWrapper.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Closing socket, id: " + $connectionId);
                }
                $clientSocket.close();
            }
        }
        catch (Throwable e) {
            ServerSocketWrapper.logger.error(e);
        }
        ApplicationKt.getApplication().invokeLater(() -> ServerSocketWrapper.monitorOneConnection$lambda$5$3(this$0, $rdConnection));
        return Unit.INSTANCE;
    }

    private static final Unit monitorOneConnection$lambda$6(Lifetime $rdConnectionLifetime, Socket $clientSocket, String $connectionId, ServerSocketWrapper this$0, RdConnection $rdConnection, String $threadName) {
        Logger logger;
        int counter = 0;
        Logger $this$debug_u24default$iv = ServerSocketWrapper.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Thread '" + $threadName + "' started", t$iv);
        }
        byte[] bytes = new byte[4096];
        block8: while (RLifetimeKt.isAlive((Lifetime)$rdConnectionLifetime)) {
            boolean $i$f$debug2;
            try {
                Logger $this$trace$iv = ServerSocketWrapper.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Going to read from socket, id: " + $connectionId);
                }
                int bytesRead = $clientSocket.getInputStream().read(bytes);
                switch (bytesRead) {
                    case -1: {
                        Logger $this$debug_u24default$iv2 = ServerSocketWrapper.logger;
                        Throwable t$iv2 = null;
                        $i$f$debug2 = false;
                        if (!$this$debug_u24default$iv2.isDebugEnabled()) break block8;
                        logger = $this$debug_u24default$iv2;
                        boolean bl = false;
                        logger.debug("Read -1 bytes, id: " + $connectionId, t$iv2);
                        break block8;
                    }
                    case 0: {
                        ServerSocketWrapper.logger.error("unexpected zero-length buffer read. Veeeery straaange..., id: " + $connectionId);
                        break block8;
                    }
                    default: {
                        this$0.sentBytesCounter.add((long)bytesRead);
                        Logger $this$trace$iv2 = ServerSocketWrapper.logger;
                        boolean $i$f$trace2 = false;
                        if ($this$trace$iv2.isTraceEnabled()) {
                            logger = $this$trace$iv2;
                            boolean bl = false;
                            logger.trace("sending buffer " + counter + " to model. size: " + bytesRead + ", id: " + $connectionId);
                        }
                        $rdConnection.getToDestinationSocket().fire((Object)new DebugTrafficInfo(counter, CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])bytes, (int)bytesRead))));
                        ++counter;
                        break;
                    }
                }
            }
            catch (SocketTimeoutException e) {
                Logger $this$debug_u24default$iv3 = ServerSocketWrapper.logger;
                Throwable t$iv3 = null;
                $i$f$debug2 = false;
                if (!$this$debug_u24default$iv3.isDebugEnabled()) break;
                logger = $this$debug_u24default$iv3;
                boolean bl = false;
                logger.debug("Closing socket after " + $clientSocket.getSoTimeout() + " milliseconds with no data to read, id: " + $connectionId, t$iv3);
                break;
            }
            catch (IOException e) {
                Class<?> clazz = e.getClass();
                String string = e.getMessage();
                if (string == null) {
                    string = "(no message)";
                }
                ServerSocketWrapper.logger.warn("Closing socket after got io exception \"" + clazz + ": " + string + "\" -> closing, id: " + $connectionId);
                break;
            }
            catch (Throwable e) {
                ServerSocketWrapper.logger.error("Exception for connection, id: " + $connectionId, e);
                break;
            }
        }
        Logger $this$debug_u24default$iv4 = ServerSocketWrapper.logger;
        Throwable t$iv4 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug_u24default$iv4.isDebugEnabled()) {
            logger = $this$debug_u24default$iv4;
            boolean bl = false;
            logger.debug("Firing clientSocketInputShutdown, id: " + $connectionId, t$iv4);
        }
        $rdConnection.getAcceptedConnectionSocketInputShutdown().fire((Object)Unit.INSTANCE);
        if ($clientSocket.isClosed()) {
            $this$debug_u24default$iv4 = ServerSocketWrapper.logger;
            t$iv4 = null;
            $i$f$debug3 = false;
            if ($this$debug_u24default$iv4.isDebugEnabled()) {
                logger = $this$debug_u24default$iv4;
                boolean bl = false;
                logger.debug("Firing clientSocketInputShutdown, socket.isClosed=true, firing clientSocketOutputShutdown , id: " + $connectionId, t$iv4);
            }
            $rdConnection.getAcceptedConnectionSocketOutputShutdown().fire((Object)Unit.INSTANCE);
        }
        ServerSocketWrapper.logger.debug("thread '" + $threadName + "' ended");
        return Unit.INSTANCE;
    }

    private static final Unit monitorOneConnection$lambda$7(Thread $myThread, String $connectionId, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Got rdConnection.ready -> change ready to true, id: " + $connectionId, t$iv);
        }
        $myThread.start();
        return Unit.INSTANCE;
    }

    private static final void monitorOneConnection$lambda$9(ServerSocketWrapper this$0, RdConnection $rdConnection) {
        this$0.rdPort.getConnections().add((Object)$rdConnection);
    }

    private static final Unit createListeningThread$lambda$0(ServerSocketWrapper this$0, int $hostPortNumber, ServerSocket $socket) {
        logger.info("Starting port forwarding: " + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this$0.rdPort.getRdPortState()))) + " -> " + $hostPortNumber);
        while (RLifetimeKt.isAlive((Lifetime)this$0.lifetime)) {
            try {
                Logger logger;
                boolean $i$f$trace;
                Logger $this$trace$iv;
                Socket clientSocket = $socket.accept();
                if (RLifetimeKt.isAlive((Lifetime)this$0.lifetime)) {
                    $this$trace$iv = ServerSocketWrapper.logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Accepted connection: " + clientSocket.getPort() + " -> " + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this$0.rdPort.getRdPortState()))) + " -> " + $hostPortNumber);
                    }
                    Intrinsics.checkNotNull((Object)clientSocket);
                    this$0.monitorOneConnection(clientSocket);
                    continue;
                }
                $this$trace$iv = ServerSocketWrapper.logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Accepted connection but dropped it. Lifetime is terminated");
                }
                clientSocket.close();
            }
            catch (SocketTimeoutException e) {
            }
            catch (SocketException e) {
                logger.warn("Socket exception", (Throwable)e);
                break;
            }
            catch (Throwable e) {
                logger.error(e);
                break;
            }
        }
        try {
            if (!$socket.isClosed()) {
                $socket.close();
            }
        }
        catch (Throwable e) {
            logger.warn(e);
        }
        logger.info("Ended port forwarding: " + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this$0.rdPort.getRdPortState()))) + " -> " + $hostPortNumber);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ServerSocketWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ServerSocketWrapper.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PortStrategy.values().length];
            try {
                nArray[PortStrategy.REASSIGN_WHEN_BUSY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortStrategy.ERROR_WHEN_BUSY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

