/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.utils;

import com.jetbrains.codeWithMe.model.PortStrategy;
import com.jetbrains.codeWithMe.model.RdConnection;
import com.jetbrains.codeWithMe.model.RdPortDirectionType;
import com.jetbrains.codeWithMe.model.RdPortState;
import com.jetbrains.codeWithMe.model.RdPortType;
import com.jetbrains.codeWithMe.model.RdSocketAddress;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ClientPortAttributes;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ClientPortPickingStrategy;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ClientPortState;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortDirectionType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortAttributes;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortPickingStrategy;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.util.reactive.IScheduler;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0007\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u000e*\u00020\r\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0015*\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u001d\u001a\n\u0010\u001e\u001a\u00020\u0018*\u00020\u0017\u00a8\u0006\u001f"}, d2={"setScheduler", "", "Lcom/jetbrains/codeWithMe/model/RdConnection;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "readable", "", "Lcom/jetbrains/codeWithMe/model/RdSocketAddress;", "Lcom/jetbrains/codeWithMe/model/RdPortState;", "toRdSocketAddress", "Ljava/net/InetSocketAddress;", "toSocketAddress", "toRdPortType", "Lcom/jetbrains/codeWithMe/model/RdPortType;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "toRdPortDirectionType", "Lcom/jetbrains/codeWithMe/model/RdPortDirectionType;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortDirectionType;", "toPortType", "toModel", "Lcom/jetbrains/codeWithMe/model/PortStrategy;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortPickingStrategy;", "toServerSocketPortState", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortState;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ClientPortState;", "toServerSocketPortPickingStrategy", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ClientPortPickingStrategy;", "toServerSocketPortAttributes", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortAttributes;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ClientPortAttributes;", "toClientPortState", "intellij.platform.split"})
public final class PortForwardingUtilsKt {
    public static final void setScheduler(@NotNull RdConnection $this$setScheduler, @NotNull IScheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)$this$setScheduler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        $this$setScheduler.getToDestinationSocket().setScheduler(scheduler);
        $this$setScheduler.getToServerSocket().setScheduler(scheduler);
        $this$setScheduler.getAcceptedConnectionSocketInputShutdown().setScheduler(scheduler);
        $this$setScheduler.getAcceptedConnectionSocketOutputShutdown().setScheduler(scheduler);
        $this$setScheduler.getDestinationSocketInputShutdown().setScheduler(scheduler);
        $this$setScheduler.getDestinationSocketOutputShutdown().setScheduler(scheduler);
        $this$setScheduler.getReady().setScheduler(scheduler);
    }

    @NotNull
    public static final String readable(@NotNull RdSocketAddress $this$readable) {
        Intrinsics.checkNotNullParameter((Object)$this$readable, (String)"<this>");
        return $this$readable.getNetworkInterface() + ":" + $this$readable.getPort();
    }

    @NotNull
    public static final String readable(@NotNull RdPortState $this$readable) {
        Intrinsics.checkNotNullParameter((Object)$this$readable, (String)"<this>");
        RdSocketAddress rdSocketAddress = $this$readable.getSocketAddress();
        return $this$readable.getSocketState().name() + " - " + (rdSocketAddress != null ? PortForwardingUtilsKt.readable(rdSocketAddress) : null);
    }

    @NotNull
    public static final RdSocketAddress toRdSocketAddress(@NotNull InetSocketAddress $this$toRdSocketAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$toRdSocketAddress, (String)"<this>");
        String string = $this$toRdSocketAddress.getAddress().getHostAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
        return new RdSocketAddress(string, $this$toRdSocketAddress.getPort());
    }

    @NotNull
    public static final InetSocketAddress toSocketAddress(@NotNull RdSocketAddress $this$toSocketAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$toSocketAddress, (String)"<this>");
        return new InetSocketAddress(Inet4Address.getByName($this$toSocketAddress.getNetworkInterface()), $this$toSocketAddress.getPort());
    }

    @NotNull
    public static final RdPortType toRdPortType(@NotNull PortType $this$toRdPortType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toRdPortType), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toRdPortType.ordinal()]) {
            case 1 -> RdPortType.TCP;
            case 2 -> RdPortType.NON_USER_TCP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final RdPortDirectionType toRdPortDirectionType(@NotNull PortDirectionType $this$toRdPortDirectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toRdPortDirectionType), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toRdPortDirectionType.ordinal()]) {
            case 1 -> RdPortDirectionType.DIRECT;
            case 2 -> RdPortDirectionType.REVERSED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final PortType toPortType(@NotNull RdPortType $this$toPortType) {
        Intrinsics.checkNotNullParameter((Object)$this$toPortType, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$toPortType.ordinal()]) {
            case 1 -> PortType.TCP;
            case 2 -> PortType.NON_USER_TCP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final PortStrategy toModel(@NotNull ServerSocketPortPickingStrategy $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toModel), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$3[$this$toModel.ordinal()]) {
            case 1 -> PortStrategy.ERROR_WHEN_BUSY;
            case 2 -> PortStrategy.REASSIGN_WHEN_BUSY;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final ServerSocketPortState toServerSocketPortState(@NotNull ClientPortState $this$toServerSocketPortState) {
        ServerSocketPortState serverSocketPortState;
        Intrinsics.checkNotNullParameter((Object)$this$toServerSocketPortState, (String)"<this>");
        ClientPortState clientPortState = $this$toServerSocketPortState;
        if (Intrinsics.areEqual((Object)clientPortState, (Object)ClientPortState.NotAssigned.INSTANCE)) {
            serverSocketPortState = ServerSocketPortState.NotAssigned.INSTANCE;
        } else if (clientPortState instanceof ClientPortState.Assigned) {
            serverSocketPortState = new ServerSocketPortState.Assigned(((ClientPortState.Assigned)$this$toServerSocketPortState).getClientPort(), ((ClientPortState.Assigned)$this$toServerSocketPortState).getClientInterface());
        } else if (clientPortState instanceof ClientPortState.FailedToAssign) {
            serverSocketPortState = new ServerSocketPortState.FailedToAssign(((ClientPortState.FailedToAssign)$this$toServerSocketPortState).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return serverSocketPortState;
    }

    @NotNull
    public static final ServerSocketPortPickingStrategy toServerSocketPortPickingStrategy(@NotNull ClientPortPickingStrategy $this$toServerSocketPortPickingStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toServerSocketPortPickingStrategy), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$4[$this$toServerSocketPortPickingStrategy.ordinal()]) {
            case 1 -> ServerSocketPortPickingStrategy.REASSIGN_WHEN_BUSY;
            case 2 -> ServerSocketPortPickingStrategy.ERROR_WHEN_BUSY;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final ServerSocketPortAttributes toServerSocketPortAttributes(@NotNull ClientPortAttributes $this$toServerSocketPortAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$toServerSocketPortAttributes, (String)"<this>");
        return new ServerSocketPortAttributes($this$toServerSocketPortAttributes.getPreferredPortNumber(), PortForwardingUtilsKt.toServerSocketPortPickingStrategy($this$toServerSocketPortAttributes.getStrategy()));
    }

    @NotNull
    public static final ClientPortState toClientPortState(@NotNull ServerSocketPortState $this$toClientPortState) {
        ClientPortState clientPortState;
        Intrinsics.checkNotNullParameter((Object)$this$toClientPortState, (String)"<this>");
        ServerSocketPortState serverSocketPortState = $this$toClientPortState;
        if (Intrinsics.areEqual((Object)serverSocketPortState, (Object)ServerSocketPortState.NotAssigned.INSTANCE)) {
            clientPortState = ClientPortState.NotAssigned.INSTANCE;
        } else if (serverSocketPortState instanceof ServerSocketPortState.Assigned) {
            clientPortState = new ClientPortState.Assigned(((ServerSocketPortState.Assigned)$this$toClientPortState).getPort(), ((ServerSocketPortState.Assigned)$this$toClientPortState).getNetworkInterface());
        } else if (serverSocketPortState instanceof ServerSocketPortState.FailedToAssign) {
            clientPortState = new ClientPortState.FailedToAssign(((ServerSocketPortState.FailedToAssign)$this$toClientPortState).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return clientPortState;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[PortType.values().length];
            try {
                nArray[PortType.TCP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortType.NON_USER_TCP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PortDirectionType.values().length];
            try {
                nArray[PortDirectionType.DIRECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortDirectionType.REVERSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RdPortType.values().length];
            try {
                nArray[RdPortType.TCP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdPortType.NON_USER_TCP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ServerSocketPortPickingStrategy.values().length];
            try {
                nArray[ServerSocketPortPickingStrategy.ERROR_WHEN_BUSY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerSocketPortPickingStrategy.REASSIGN_WHEN_BUSY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[ClientPortPickingStrategy.values().length];
            try {
                nArray[ClientPortPickingStrategy.REASSIGN_WHEN_BUSY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientPortPickingStrategy.ERROR_WHEN_BUSY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

