/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.ChartsModificationListener;
import com.intellij.kubernetes.helm.CustomChartSupport;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.ChartObject;
import com.intellij.kubernetes.helm.model.HelmModelProvider;
import com.intellij.kubernetes.helm.model.HelmNavigationTargetProviderMixin;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmObjectKt;
import com.intellij.kubernetes.helm.model.HelmResolveTarget;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.kubernetes.helm.model.HelmResolverKt;
import com.intellij.kubernetes.helm.model.HelmValuePomTarget;
import com.intellij.kubernetes.helm.model.MergeableHelmObject;
import com.intellij.kubernetes.helm.model.MultiHelmObject;
import com.intellij.kubernetes.helm.model.ObjectPath;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.PathObject;
import com.intellij.kubernetes.helm.model.RootObject;
import com.intellij.kubernetes.helm.model.SimpleHelmResolveTarget;
import com.intellij.kubernetes.helm.model.TransformDirection;
import com.intellij.kubernetes.helm.model.ValuesYamlFileObject;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0017\b\u0007\u0018\u0000 ]2\u00020\u0001:\u0002\\]B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u0017J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0010J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001d\u001a\u00020\u0010J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001d\u001a\u00020\u0010J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u000e\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0017J\u0010\u0010+\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0017H\u0002J\u0010\u0010,\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0017H\u0002J#\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010.\u001a\u00020'H\u0000\u00a2\u0006\u0002\b/J3\u00104\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00105\u001a\u0002062\u0006\u0010.\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0000\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020\u00172\u0006\u0010:\u001a\u00020;H\u0000\u00a2\u0006\u0002\b<JU\u0010=\u001a\b\u0012\u0004\u0012\u0002H>0\r\"\u0004\b\u0000\u0010>2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010.\u001a\u00020'2\u0006\u0010(\u001a\u00020'2'\u0010?\u001a#\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002H>0\r0@H\u0002J\u0010\u0010C\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010F\u001a\u00020GH\u0002JT\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010I\u001a\u00020'2\u0006\u0010J\u001a\u00020'2\u0018\u0010K\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0@2\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020'0@H\u0002J\b\u0010M\u001a\u000209H\u0016J\u000e\u0010N\u001a\u0004\u0018\u00010\u000e*\u00020\u0010H\u0002J\u0016\u0010O\u001a\u0004\u0018\u00010\u000e*\u00020\u00132\u0006\u0010B\u001a\u00020;H\u0002J\u0016\u0010P\u001a\u0004\u0018\u00010\u000e*\u00020\u00132\u0006\u0010Q\u001a\u00020\u001bH\u0002J\u0010\u0010R\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001d\u0010T\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010U\u001a\u00020EH\u0000\u00a2\u0006\u0002\bVJ\u001e\u0010W\u001a\u00020\u000e2\u0006\u0010X\u001a\u00020\u000e2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010Z\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020;2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u00100\u001a\u0004\u0018\u0001018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006^"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "chartsModificationListener", "Lcom/intellij/kubernetes/helm/ChartsModificationListener;", "chartModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getChartModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "resolveEffectiveObjects", "", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "startFrom", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "getRootPathInChart", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "getResolveTargetByDeclarationElement", "Lcom/intellij/kubernetes/helm/model/HelmResolveTarget;", "declarationElement", "Lcom/intellij/psi/PsiElement;", "getPathInChartByDefinitionElement", "definitionElement", "getObjectPathByDefinitionElement", "Lcom/intellij/kubernetes/helm/model/ObjectPath;", "getResolveTarget", "pathInChart", "resolveClosestObjects", "resolveReachableObjectsInAllCharts", "resolveOverridingObjects", "resolveOverriddenObjects", "resolveNearestObjectsInOverrideChain", "direction", "Lcom/intellij/kubernetes/helm/model/TransformDirection;", "resolveByObjectPath", "onlyNavigatable", "", "stopOnFirst", "isUsageTarget", "element", "isValueDeclaration", "isProbablyValueDefinition", "resolveObjectsInAllChartsNamedBy", "forRename", "resolveObjectsInAllChartsNamedBy$intellij_clouds_kubernetes_backend", "usagesHandler", "Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "getUsagesHandler", "()Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "findUsages", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "findUsages$intellij_clouds_kubernetes_backend", "renameUsage", "", "newName", "", "renameUsage$intellij_clouds_kubernetes_backend", "collectItemsForSameNamedPathsInAllCharts", "T", "collector", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isOverridable", "getObjectSchemaByFileName", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "fileName", "", "resolveOverridableObjectsOneDirection", "onlyFirstOnPath", "resolveInInitialChart", "transformPathInChart", "isKosher", "dispose", "resolveRightHere", "resolveTopObject", "resolveHere", "objectPath", "createRootObject", "collectMergedInObjects", "createValuesObject", "schema", "createValuesObject$intellij_clouds_kubernetes_backend", "mergeIfNeeded", "mainObject", "mergedInObjects", "joinIfNeeded", "objects", "UsagesHandler", "Companion", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmResolver.kt\ncom/intellij/kubernetes/helm/model/HelmResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,320:1\n1391#2:321\n1480#2,5:322\n1696#2,8:327\n1807#2,3:340\n1391#2:343\n1480#2,2:344\n1642#2,10:346\n1915#2:356\n1916#2:358\n1652#2:359\n1482#2,3:360\n19#3:335\n19#3:336\n30#4,2:337\n1#5:339\n1#5:357\n54#6:363\n*S KotlinDebug\n*F\n+ 1 HelmResolver.kt\ncom/intellij/kubernetes/helm/model/HelmResolver\n*L\n49#1:321\n49#1:322,5\n56#1:327,8\n139#1:340,3\n258#1:343\n258#1:344,2\n259#1:346,10\n259#1:356\n259#1:358\n259#1:359\n258#1:360,3\n64#1:335\n69#1:336\n77#1:337,2\n259#1:357\n272#1:363\n*E\n"})
public final class HelmResolver
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ChartsModificationListener chartsModificationListener;
    @NotNull
    private final ModificationTracker chartModificationTracker;

    public HelmResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.chartsModificationListener = new ChartsModificationListener(this.project, this);
        this.chartModificationTracker = this.chartsModificationListener.getValuesModificationTracker();
    }

    @NotNull
    public final ModificationTracker getChartModificationTracker() {
        return this.chartModificationTracker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<HelmObject> resolveEffectiveObjects(@NotNull PathInChart startFrom) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        if (!this.isOverridable(startFrom)) {
            return CollectionsKt.listOfNotNull((Object)this.resolveRightHere(startFrom));
        }
        Function1 isKosher = HelmResolver::resolveEffectiveObjects$lambda$0;
        if (HelmResolver.Companion.isGlobal(startFrom.getObjectPath())) {
            collection = CollectionsKt.listOfNotNull((Object)CollectionsKt.lastOrNull((Iterable)this.resolveOverridableObjectsOneDirection(startFrom, false, true, TransformDirection.UPCHART.getTransformOperation(true), (Function1<? super HelmObject, Boolean>)isKosher)));
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = HelmResolveUtilKt.transformToTopmost(startFrom);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PathInChart it = (PathInChart)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.resolveOverridableObjectsOneDirection(it, true, true, TransformDirection.DOWNCHART.getTransformOperation(false), (Function1<? super HelmObject, Boolean>)isKosher);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<Set> set$iv = new HashSet<Set>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                HelmObject it = (HelmObject)e$iv;
                boolean bl = false;
                Set key$iv = CollectionsKt.toSet((Iterable)it.getDefinitionElements());
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            collection = list$iv;
        }
        return collection;
    }

    @NotNull
    public final PathInChart getRootPathInChart(@NotNull Chart chart) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        return HelmResolveUtilKt.getRootPathInChart(chart);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final HelmResolveTarget getResolveTargetByDeclarationElement(@NotNull PsiElement declarationElement) {
        HelmNavigationTargetProviderMixin helmNavigationTargetProviderMixin;
        void $this$asSafely$iv;
        Intrinsics.checkNotNullParameter((Object)declarationElement, (String)"declarationElement");
        if (declarationElement instanceof PomTargetPsiElement) {
            PomTarget $this$asSafely$iv2 = ((PomTargetPsiElement)declarationElement).getTarget();
            boolean $i$f$asSafely = false;
            PomTarget pomTarget = $this$asSafely$iv2;
            if (!(pomTarget instanceof HelmValuePomTarget)) {
                pomTarget = null;
            }
            HelmValuePomTarget helmValuePomTarget = (HelmValuePomTarget)pomTarget;
            Object object = helmValuePomTarget;
            if (helmValuePomTarget == null) return null;
            PathInChart pathInChart = ((HelmValuePomTarget)object).getPathInChart();
            object = pathInChart;
            if (pathInChart == null) return null;
            HelmResolveTarget helmResolveTarget = HelmResolverKt.resolveTarget((PathInChart)object);
            return helmResolveTarget;
        }
        if (!(declarationElement instanceof YAMLScalar)) return null;
        YamlMetaTypeProvider yamlMetaTypeProvider = HelmModelProvider.Companion.getInstance().getMetaTypeProvider(((YAMLScalar)declarationElement).getContainingFile());
        if (yamlMetaTypeProvider == null) return null;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = yamlMetaTypeProvider.getValueMetaType((YAMLValue)declarationElement);
        if (metaTypeProxy == null) return null;
        YamlMetaType yamlMetaType = metaTypeProxy.getMetaType();
        if (yamlMetaType == null) return null;
        YamlMetaType yamlMetaType2 = yamlMetaType;
        boolean $i$f$asSafely = false;
        Object v5 = $this$asSafely$iv;
        if (!(v5 instanceof HelmNavigationTargetProviderMixin)) {
            v5 = null;
        }
        if ((helmNavigationTargetProviderMixin = (HelmNavigationTargetProviderMixin)v5) == null) return null;
        HelmResolveTarget helmResolveTarget = helmNavigationTargetProviderMixin.getResolveTarget((YAMLScalar)declarationElement);
        return helmResolveTarget;
    }

    @Nullable
    public final PathInChart getPathInChartByDefinitionElement(@NotNull PsiElement definitionElement) {
        Intrinsics.checkNotNullParameter((Object)definitionElement, (String)"definitionElement");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart = ((ChartManager)object).findChartByDefinitionElement(definitionElement);
        if (chart == null) {
            return null;
        }
        Chart chart2 = chart;
        ObjectPath objectPath = this.getObjectPathByDefinitionElement(chart2, definitionElement);
        if (objectPath == null) {
            return null;
        }
        ObjectPath objectPath2 = objectPath;
        return new PathInChart(objectPath2, chart2);
    }

    private final ObjectPath getObjectPathByDefinitionElement(Chart chart, PsiElement definitionElement) {
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)definitionElement);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile containerFile = virtualFile;
        CharSequence charSequence = containerFile.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        Definition definition = this.getObjectSchemaByFileName(chart, charSequence);
        if (definition == null) {
            return null;
        }
        Definition rootObjectSchema = definition;
        return ObjectPath.Companion.fromDefinition(rootObjectSchema.getName(), definitionElement, rootObjectSchema.getReferencedWithCapitalization());
    }

    @NotNull
    public final HelmResolveTarget getResolveTarget(@NotNull PathInChart pathInChart) {
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        HelmResolveTarget helmResolveTarget = (HelmResolveTarget)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes_backend()), arg_0 -> HelmResolver.getResolveTarget$lambda$0(pathInChart, arg_0)));
        if (helmResolveTarget == null) {
            helmResolveTarget = new SimpleHelmResolveTarget(pathInChart);
        }
        return helmResolveTarget;
    }

    @NotNull
    public final Collection<HelmObject> resolveClosestObjects(@NotNull PathInChart pathInChart) {
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        return this.resolveByObjectPath(pathInChart, false, true);
    }

    @NotNull
    public final Collection<HelmObject> resolveReachableObjectsInAllCharts(@NotNull PathInChart pathInChart) {
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        return this.resolveByObjectPath(pathInChart, false, false);
    }

    @NotNull
    public final Collection<HelmObject> resolveOverridingObjects(@NotNull PathInChart startFrom) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        return this.resolveNearestObjectsInOverrideChain(startFrom, TransformDirection.UPCHART);
    }

    @NotNull
    public final Collection<HelmObject> resolveOverriddenObjects(@NotNull PathInChart startFrom) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        return this.resolveNearestObjectsInOverrideChain(startFrom, TransformDirection.DOWNCHART);
    }

    private final Collection<HelmObject> resolveNearestObjectsInOverrideChain(PathInChart startFrom, TransformDirection direction) {
        if (!this.isOverridable(startFrom)) {
            return CollectionsKt.emptyList();
        }
        Function1<PathInChart, Collection<PathInChart>> transformOperation = direction.getTransformOperation(HelmResolver.Companion.isGlobal(startFrom.getObjectPath()));
        Object object = this.resolveRightHere(startFrom);
        if (object == null || (object = object.getDefinitionElements()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        Object localDefinitions = object;
        return this.resolveOverridableObjectsOneDirection(startFrom, true, false, transformOperation, (Function1<? super HelmObject, Boolean>)((Function1)arg_0 -> HelmResolver.resolveNearestObjectsInOverrideChain$lambda$0((Set)localDefinitions, arg_0)));
    }

    @NotNull
    public final Collection<HelmObject> resolveByObjectPath(@NotNull PathInChart startFrom, boolean onlyNavigatable, boolean stopOnFirst) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        return !this.isOverridable(startFrom) ? (Collection)CollectionsKt.listOfNotNull((Object)HelmResolver.resolveByObjectPath$resolveInChart(this, onlyNavigatable, startFrom)) : HelmResolveUtilKt.collectInCharts(startFrom, HelmResolver.Companion.isGlobal(startFrom.getObjectPath()), stopOnFirst, arg_0 -> HelmResolver.resolveByObjectPath$lambda$1(this, onlyNavigatable, arg_0));
    }

    public final boolean isUsageTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.isProbablyValueDefinition(element) || this.isValueDeclaration(element);
    }

    private final boolean isValueDeclaration(PsiElement element) {
        return element instanceof PomTargetPsiElement && ((PomTargetPsiElement)element).getTarget() instanceof HelmValuePomTarget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProbablyValueDefinition(PsiElement element) {
        CustomChartSupport it;
        if (element instanceof YAMLKeyValue || element instanceof YAMLDocument || element instanceof YAMLScalar) {
            VirtualFile it2 = YamlUtilKt.getVfsFile((PsiElement)element);
            boolean bl = false;
            if (Chart.Companion.isChartDefinitionYaml(it2)) return true;
            if (Chart.Companion.isRequirementsFile(it2)) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
        }
        Iterable $this$any$iv = CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes_backend();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (CustomChartSupport)element$iv;
            boolean bl = false;
        } while (!it.isValueDefinition(element));
        return true;
    }

    @NotNull
    public final Collection<HelmObject> resolveObjectsInAllChartsNamedBy$intellij_clouds_kubernetes_backend(@NotNull PathInChart startFrom, boolean forRename) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        HelmObject helmObject = this.resolveRightHere(startFrom);
        if (helmObject == null) {
            return CollectionsKt.emptyList();
        }
        HelmObject resolvedObject = helmObject;
        if (!this.isOverridable(startFrom)) {
            return CollectionsKt.listOf((Object)resolvedObject);
        }
        boolean isGlobalValue = HelmResolver.Companion.isGlobal(startFrom.getObjectPath());
        return HelmResolveUtilKt.collectInCharts(forRename && !isGlobalValue ? HelmResolveUtilKt.transformToBottommost(startFrom) : (Collection<PathInChart>)CollectionsKt.listOf((Object)startFrom), isGlobalValue, false, arg_0 -> HelmResolver.resolveObjectsInAllChartsNamedBy$lambda$0(this, resolvedObject, arg_0));
    }

    private final UsagesHandler getUsagesHandler() {
        return (UsagesHandler)CollectionsKt.firstOrNull((List)UsagesHandler.Companion.getEP_NAME().getExtensionList((AreaInstance)this.project));
    }

    @NotNull
    public final Collection<PsiElement> findUsages$intellij_clouds_kubernetes_backend(@NotNull PathInChart startFrom, @NotNull SearchScope searchScope, boolean forRename, boolean stopOnFirst) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        UsagesHandler handler = this.getUsagesHandler();
        if (handler == null) {
            return CollectionsKt.emptyList();
        }
        return this.collectItemsForSameNamedPathsInAllCharts(startFrom, forRename, stopOnFirst, arg_0 -> HelmResolver.findUsages$lambda$0(handler, searchScope, arg_0));
    }

    public final void renameUsage$intellij_clouds_kubernetes_backend(@NotNull PsiElement element, @NotNull String newName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            UsagesHandler usagesHandler = this.getUsagesHandler();
            if (usagesHandler == null) break block0;
            usagesHandler.renameUsage(element, newName);
        }
    }

    private final <T> Collection<T> collectItemsForSameNamedPathsInAllCharts(PathInChart startFrom, boolean forRename, boolean stopOnFirst, Function1<? super PathInChart, ? extends Collection<? extends T>> collector) {
        HelmObject helmObject = this.resolveRightHere(startFrom);
        if (helmObject == null) {
            return CollectionsKt.emptyList();
        }
        HelmObject resolvedObject = helmObject;
        if (!this.isOverridable(startFrom)) {
            return (Collection)collector.invoke((Object)startFrom);
        }
        boolean isGlobalValue = HelmResolver.Companion.isGlobal(startFrom.getObjectPath());
        return HelmResolveUtilKt.collectInCharts(forRename && !isGlobalValue ? HelmResolveUtilKt.transformToBottommost(startFrom) : (Collection<PathInChart>)CollectionsKt.listOf((Object)startFrom), isGlobalValue, stopOnFirst, arg_0 -> HelmResolver.collectItemsForSameNamedPathsInAllCharts$lambda$0(resolvedObject, collector, arg_0));
    }

    private final boolean isOverridable(PathInChart pathInChart) {
        if (Intrinsics.areEqual((Object)pathInChart.getObjectPath(), (Object)HelmResolveUtilKt.getCHART_OBJECT_PATH())) {
            return true;
        }
        String string = pathInChart.getObjectPath().getTopObjectName();
        if (string == null) {
            return false;
        }
        String topObjectName = string;
        HelmObject helmObject = this.resolveTopObject(pathInChart.getChart(), topObjectName);
        return helmObject != null ? helmObject.isOverridable() : false;
    }

    private final Definition getObjectSchemaByFileName(Chart chart, CharSequence fileName) {
        Object v0;
        block2: {
            if (Chart.Companion.isValuesYamlName(fileName)) {
                return chart.getModel().getObjectSchemas().get("Values");
            }
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
            CharSequence containerName = dotIndex > 0 ? fileName.subSequence(0, dotIndex) : fileName;
            Iterable iterable = chart.getModel().getObjectSchemas().values();
            for (Object t : iterable) {
                Definition it = (Definition)t;
                boolean bl = false;
                if (!StringUtil.equalsIgnoreCase((CharSequence)it.getValueContainer(), (CharSequence)containerName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private final Collection<HelmObject> resolveOverridableObjectsOneDirection(PathInChart startFrom, boolean onlyFirstOnPath, boolean resolveInInitialChart, Function1<? super PathInChart, ? extends Collection<PathInChart>> transformPathInChart, Function1<? super HelmObject, Boolean> isKosher) {
        return HelmResolveUtilKt.collectInChartsOneDirection(startFrom, onlyFirstOnPath, resolveInInitialChart, transformPathInChart, arg_0 -> HelmResolver.resolveOverridableObjectsOneDirection$lambda$0(this, isKosher, arg_0));
    }

    public void dispose() {
    }

    private final HelmObject resolveRightHere(PathInChart $this$resolveRightHere) {
        return this.resolveHere($this$resolveRightHere.getChart(), $this$resolveRightHere.getObjectPath());
    }

    private final HelmObject resolveTopObject(Chart $this$resolveTopObject, String name) {
        return this.createRootObject($this$resolveTopObject).findChildObject(name);
    }

    private final HelmObject resolveHere(Chart $this$resolveHere, ObjectPath objectPath) {
        return Intrinsics.areEqual((Object)objectPath, (Object)HelmResolveUtilKt.getCHART_OBJECT_PATH()) ? (HelmObject)new ChartObject($this$resolveHere) : HelmObjectKt.resolve(this.createRootObject($this$resolveHere), objectPath.getFullPath());
    }

    private final HelmObject createRootObject(Chart chart) {
        return this.mergeIfNeeded(new RootObject(chart), this.collectMergedInObjects(chart));
    }

    private final Collection<HelmObject> collectMergedInObjects(Chart chart) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes_backend()), arg_0 -> HelmResolver.collectMergedInObjects$lambda$0(chart, arg_0)), arg_0 -> HelmResolver.collectMergedInObjects$lambda$1(chart, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HelmObject createValuesObject$intellij_clouds_kubernetes_backend(@NotNull Chart chart, @NotNull Definition schema) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Iterable iterable = chart.getDependencies().values();
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            Chart.Dependency dependency = (Chart.Dependency)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = dependency.getImportValuesMappings();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                HelmObject helmObject;
                HelmObject helmObject2;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Chart.ImportValues importValues = (Chart.ImportValues)element$iv$iv2;
                boolean bl3 = false;
                Chart chart2 = dependency.getChart();
                if (chart2 != null && (helmObject2 = this.resolveHere(chart2, HelmResolveUtilKt.getVALUES_ROOT().append(importValues.getFromPath()))) != null) {
                    HelmObject it = helmObject2;
                    boolean bl4 = false;
                    helmObject = PathObject.Companion.create(new PathInChart(HelmResolveUtilKt.getVALUES_ROOT(), chart), importValues.getToPath(), it);
                } else {
                    helmObject = null;
                }
                if (helmObject == null) continue;
                HelmObject it$iv$iv = helmObject;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List importedValueObjects = (List)destination$iv$iv;
        return this.mergeIfNeeded(new ValuesYamlFileObject(chart, schema), importedValueObjects);
    }

    /*
     * WARNING - void declaration
     */
    private final HelmObject mergeIfNeeded(HelmObject mainObject, Collection<? extends HelmObject> mergedInObjects) {
        HelmObject helmObject;
        void condition$iv;
        HelmObject helmObject2 = mainObject;
        boolean bl = !mergedInObjects.isEmpty();
        boolean $i$f$transformIf = false;
        if (condition$iv != false) {
            void $this$transformIf$iv;
            void it = $this$transformIf$iv;
            boolean bl2 = false;
            helmObject = new MergeableHelmObject((HelmObject)it, this.joinIfNeeded(it.getName(), mergedInObjects));
        } else {
            helmObject = helmObject2;
        }
        return helmObject;
    }

    private final HelmObject joinIfNeeded(String name, Collection<? extends HelmObject> objects) {
        return objects.size() == 1 ? (HelmObject)CollectionsKt.first((Iterable)objects) : (HelmObject)new MultiHelmObject(name, objects);
    }

    private static final boolean resolveEffectiveObjects$lambda$0(HelmObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.getDefinitionElements().isEmpty();
    }

    private static final HelmResolveTarget getResolveTarget$lambda$0(PathInChart $pathInChart, CustomChartSupport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getResolveTarget($pathInChart);
    }

    private static final boolean resolveNearestObjectsInOverrideChain$lambda$0(Set $localDefinitions, HelmObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !((Collection)CollectionsKt.minus((Iterable)it.getDefinitionElements(), (Iterable)$localDefinitions)).isEmpty();
    }

    private static final HelmObject resolveByObjectPath$resolveInChart(HelmResolver this$0, boolean $onlyNavigatable, PathInChart pathInChart) {
        HelmObject helmObject;
        HelmObject helmObject2 = this$0.resolveRightHere(pathInChart);
        if (helmObject2 != null) {
            HelmObject helmObject3;
            HelmObject it = helmObject3 = helmObject2;
            boolean bl = false;
            helmObject = !$onlyNavigatable || !it.getDefinitionElements().isEmpty() || !it.getDeclarationElements().isEmpty() ? helmObject3 : null;
        } else {
            helmObject = null;
        }
        return helmObject;
    }

    private static final Collection resolveByObjectPath$lambda$1(HelmResolver this$0, boolean $onlyNavigatable, PathInChart it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.listOfNotNull((Object)HelmResolver.resolveByObjectPath$resolveInChart(this$0, $onlyNavigatable, it));
    }

    private static final Collection resolveObjectsInAllChartsNamedBy$lambda$0(HelmResolver this$0, HelmObject $resolvedObject, PathInChart it) {
        HelmObject helmObject;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HelmObject helmObject2 = this$0.resolveRightHere(it);
        if (helmObject2 != null) {
            HelmObject helmObject3;
            HelmObject it2 = helmObject3 = helmObject2;
            boolean bl = false;
            helmObject = Intrinsics.areEqual((Object)it2.getName(), (Object)$resolvedObject.getName()) ? helmObject3 : null;
        } else {
            helmObject = null;
        }
        return CollectionsKt.listOfNotNull(helmObject);
    }

    private static final Collection findUsages$lambda$0(UsagesHandler $handler, SearchScope $searchScope, PathInChart it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $handler.collectUsages(it, $searchScope);
    }

    private static final Collection collectItemsForSameNamedPathsInAllCharts$lambda$0(HelmObject $resolvedObject, Function1 $collector, PathInChart it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(it.getObjectPath().getFullPath()), (Object)$resolvedObject.getName()) ? (Collection)$collector.invoke((Object)it) : (Collection)CollectionsKt.emptyList();
    }

    private static final Collection resolveOverridableObjectsOneDirection$lambda$0(HelmResolver this$0, Function1 $isKosher, PathInChart it) {
        HelmObject helmObject;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HelmObject helmObject2 = this$0.resolveRightHere(it);
        return CollectionsKt.listOfNotNull(helmObject2 != null ? (((Boolean)$isKosher.invoke((Object)(helmObject = helmObject2))).booleanValue() ? helmObject : null) : null);
    }

    private static final Iterable collectMergedInObjects$lambda$0(Chart $chart, CustomChartSupport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.collectObjects($chart);
    }

    private static final HelmObject collectMergedInObjects$lambda$1(Chart $chart, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PathObject.Companion.create(new PathInChart(ObjectPath.Companion.getROOT(), $chart), (List)it.getFirst(), (HelmObject)it.getSecond());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver$Companion;", "", "<init>", "()V", "isGlobal", "", "Lcom/intellij/kubernetes/helm/model/ObjectPath;", "(Lcom/intellij/kubernetes/helm/model/ObjectPath;)Z", "getInstance", "Lcom/intellij/kubernetes/helm/model/HelmResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isGlobal(ObjectPath $this$isGlobal) {
            return Intrinsics.areEqual((Object)$this$isGlobal.getTopObjectName(), (Object)"Values") && Intrinsics.areEqual((Object)$this$isGlobal.getTopDefinitionName(), (Object)"global");
        }

        @NotNull
        public final HelmResolver getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(HelmResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (HelmResolver)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "", "collectUsages", "", "Lcom/intellij/psi/PsiElement;", "pathInChart", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "renameUsage", "", "element", "newName", "", "Companion", "intellij.clouds.kubernetes.backend"})
    public static interface UsagesHandler {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public Collection<PsiElement> collectUsages(@NotNull PathInChart var1, @NotNull SearchScope var2);

        public void renameUsage(@NotNull PsiElement var1, @NotNull String var2);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.clouds.kubernetes.backend"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final ExtensionPointName<UsagesHandler> EP_NAME;

            private Companion() {
            }

            @NotNull
            public final ExtensionPointName<UsagesHandler> getEP_NAME() {
                return EP_NAME;
            }

            static {
                $$INSTANCE = new Companion();
                EP_NAME = ExtensionPointName.Companion.create("com.intellij.kubernetes.helm.helmUsageHandler");
            }
        }
    }
}

