/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEventContainerObject;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import java.time.Instant;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesEventLog;", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "event", "Lio/kubernetes/client/openapi/models/CoreV1Event;", "context", "Lcom/intellij/kubernetes/api/Context;", "<init>", "(Lio/kubernetes/client/openapi/models/CoreV1Event;Lcom/intellij/kubernetes/api/Context;)V", "getEvent", "()Lio/kubernetes/client/openapi/models/CoreV1Event;", "message", "", "getMessage", "()Ljava/lang/String;", "source", "getSource", "isEvent", "", "()Z", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesContextLogsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesContextLogsModel.kt\ncom/intellij/kubernetes/logs/KubernetesEventLog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class KubernetesEventLog
extends KubernetesContextLog {
    @NotNull
    private final CoreV1Event event;
    @NotNull
    private final String source;
    private final boolean isEvent;

    /*
     * WARNING - void declaration
     */
    public KubernetesEventLog(@NotNull CoreV1Event event, @NotNull Context context2) {
        CharSequence charSequence;
        void it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Comparable<OffsetDateTime> comparable = event.getEventTime();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            OffsetDateTime offsetDateTime = event.getLastTimestamp();
            comparable = offsetDateTime != null ? offsetDateTime.toInstant() : null;
            if (comparable == null) {
                comparable = Instant.now();
            }
        }
        Object[] objectArray = comparable;
        Intrinsics.checkNotNull((Object)objectArray);
        super((Instant)objectArray, "", (KubernetesContainerObject)new KubernetesEventContainerObject(context2));
        this.event = event;
        objectArray = new String[2];
        V1EventSource v1EventSource = this.event.getSource();
        objectArray[0] = v1EventSource != null ? v1EventSource.getComponent() : null;
        V1ObjectReference v1ObjectReference = this.event.getInvolvedObject();
        objectArray[1] = v1ObjectReference != null ? v1ObjectReference.getName() : null;
        String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        KubernetesEventLog kubernetesEventLog = this;
        boolean bl = false;
        CharSequence charSequence2 = (CharSequence)it;
        if (charSequence2.length() == 0) {
            boolean bl2 = false;
            charSequence = "Cluster Event";
        } else {
            charSequence = charSequence2;
        }
        kubernetesEventLog.source = (String)charSequence;
        this.isEvent = true;
    }

    @NotNull
    public final CoreV1Event getEvent() {
        return this.event;
    }

    @Override
    @NotNull
    public String getMessage() {
        return "Type: " + this.event.getType() + "\tReason: " + this.event.getReason() + "\tMessage: " + this.event.getMessage();
    }

    @Override
    @NotNull
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }
}

