/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.ILogConsistentCache;
import com.intellij.kubernetes.logs.ILogItem;
import com.intellij.kubernetes.logs.ILogSource;
import com.intellij.kubernetes.logs.IdRange;
import com.intellij.kubernetes.util.ConcurrentCopyOnWriteSliceableAvlStorageSet;
import com.intellij.kubernetes.util.SliceableStorageSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0010\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00010\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007B\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u00192\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0016J\u001c\u0010!\u001a\u00020\u00142\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020$0#H\u0016J\u0017\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020&H\u0016J\u0016\u0010*\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\b\u0010,\u001a\u00020&H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/kubernetes/logs/LogConsistentCache;", "Id", "", "L", "Lcom/intellij/kubernetes/logs/ILogItem;", "S", "Lcom/intellij/kubernetes/logs/ILogSource;", "Lcom/intellij/kubernetes/logs/ILogConsistentCache;", "<init>", "()V", "logsCache", "Lcom/intellij/kubernetes/util/SliceableStorageSet;", "getLogsCache", "()Lcom/intellij/kubernetes/util/SliceableStorageSet;", "_globalConsistentLogsRange", "Lcom/intellij/kubernetes/logs/IdRange;", "consistentLogsRange", "getConsistentLogsRange", "()Lcom/intellij/kubernetes/logs/IdRange;", "size", "", "getSize", "()I", "totalLogsNeeded", "getSnapshot", "", "sliceBetween", "start", "end", "getLogsAround", "timestamp", "(Ljava/lang/Comparable;)Ljava/util/List;", "takeLast", "indexOfFirst", "predicate", "Lkotlin/Function1;", "", "plusAssign", "", "newLogs", "", "clear", "relaxConsistentLogsRange", "newSlice", "unrelaxConsistentLogsRangeByLogsArrayBounderies", "intellij.clouds.kubernetes.backend"})
public class LogConsistentCache<Id extends Comparable<? super Id>, L extends ILogItem<S, Id>, S extends ILogSource>
implements ILogConsistentCache<Id, L, S> {
    @NotNull
    private final SliceableStorageSet<L> logsCache = (SliceableStorageSet)new ConcurrentCopyOnWriteSliceableAvlStorageSet();
    @NotNull
    private IdRange<Id> _globalConsistentLogsRange = IdRange.Companion.EMPTY();
    private final int totalLogsNeeded;

    public LogConsistentCache() {
        this.totalLogsNeeded = 250;
    }

    @NotNull
    protected final SliceableStorageSet<L> getLogsCache() {
        return this.logsCache;
    }

    @Override
    @NotNull
    public IdRange<Id> getConsistentLogsRange() {
        return this._globalConsistentLogsRange;
    }

    @Override
    public int getSize() {
        return this.logsCache.getSize();
    }

    @Override
    @NotNull
    public List<L> getSnapshot() {
        return this.logsCache.snapshot();
    }

    @NotNull
    public final List<L> sliceBetween(int start, int end) {
        return this.logsCache.sliceBetween(start, end);
    }

    @Override
    @NotNull
    public List<L> getLogsAround(@NotNull Id timestamp) {
        Intrinsics.checkNotNullParameter(timestamp, (String)"timestamp");
        int newTimestampIndex = this.logsCache.lowerBound(arg_0 -> LogConsistentCache.getLogsAround$lambda$0(timestamp, arg_0));
        if (newTimestampIndex == -1) {
            Comparable id;
            ILogItem iLogItem = (ILogItem)this.logsCache.lastOrNull();
            Comparable comparable = id = iLogItem != null ? iLogItem.getTimestamp() : null;
            if (id == null || id.compareTo(timestamp) <= 0) {
                return this.logsCache.sliceBetween(Math.max(0, this.logsCache.getSize() - this.totalLogsNeeded), this.logsCache.getSize());
            }
        }
        int start = Math.max(0, newTimestampIndex - 100);
        int end = Math.min(start + this.totalLogsNeeded, this.logsCache.getSize());
        int adjustedStart = Math.max(0, end - this.totalLogsNeeded);
        return this.logsCache.sliceBetween(adjustedStart, end);
    }

    @Override
    @NotNull
    public List<L> takeLast() {
        int start = Math.max(0, this.getSize() - 100);
        int end = Math.min(start + this.totalLogsNeeded, this.logsCache.getSize());
        int adjustedStart = Math.max(0, end - this.totalLogsNeeded);
        return this.logsCache.sliceBetween(adjustedStart, end);
    }

    @Override
    public int indexOfFirst(@NotNull Function1<? super L, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return this.logsCache.lowerBound(predicate);
    }

    @Override
    public void plusAssign(@NotNull Collection<? extends L> newLogs) {
        Intrinsics.checkNotNullParameter(newLogs, (String)"newLogs");
        this.logsCache.plusAssign(newLogs);
        if (!newLogs.isEmpty()) {
            IdRange newSlice = new IdRange(((ILogItem)CollectionsKt.first((Iterable)newLogs)).getTimestamp(), ((ILogItem)CollectionsKt.last((Iterable)newLogs)).getTimestamp());
            this.relaxConsistentLogsRange(newSlice);
        }
    }

    @Override
    public void clear() {
        this.logsCache.clear();
        this._globalConsistentLogsRange = IdRange.Companion.EMPTY();
    }

    @Override
    public void relaxConsistentLogsRange(@NotNull IdRange<Id> newSlice) {
        Intrinsics.checkNotNullParameter(newSlice, (String)"newSlice");
        this._globalConsistentLogsRange = this._globalConsistentLogsRange.relax(newSlice);
    }

    @Override
    public void unrelaxConsistentLogsRangeByLogsArrayBounderies() {
        ILogItem iLogItem = (ILogItem)this.logsCache.firstOrNull();
        ILogItem iLogItem2 = (ILogItem)this.logsCache.lastOrNull();
        this._globalConsistentLogsRange = new IdRange(iLogItem != null ? iLogItem.getTimestamp() : null, iLogItem2 != null ? iLogItem2.getTimestamp() : null);
    }

    private static final boolean getLogsAround$lambda$0(Comparable $timestamp, ILogItem log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        return log.getTimestamp().compareTo($timestamp) >= 0;
    }
}

