/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.quickfix.AddModelVersionQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.UpdateXmlsTo410;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenModelVersionMissedInspection;", "Lcom/intellij/util/xml/highlighting/BasicDomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "<init>", "()V", "getGroupDisplayName", "", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "intellij.maven"})
public final class MavenModelVersionMissedInspection
extends BasicDomElementsInspection<MavenDomProjectModel> {
    public MavenModelVersionMissedInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder2) {
        XmlTag xmlTag;
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        DomElement domElement = domFileElement.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"getRootElement(...)");
        MavenDomProjectModel projectModel = (MavenDomProjectModel)domElement;
        if (projectModel.getModelVersion().exists()) {
            return;
        }
        XmlTag rootTag = domFileElement.getRootTag();
        XmlTag xmlTag2 = rootTag;
        if (MavenUtil.INSTANCE.isMaven410(xmlTag2 != null && (xmlTag2 = xmlTag2.getAttribute("xmlns")) != null ? xmlTag2.getValue() : null, (xmlTag = rootTag) != null && (xmlTag = xmlTag.getAttribute("xsi:schemaLocation")) != null ? xmlTag.getValue() : null)) {
            return;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new AddModelVersionQuickFix(), new UpdateXmlsTo410()};
        holder2.createProblem((DomElement)projectModel, HighlightSeverity.ERROR, MavenDomBundle.message("inspection.missed.model.version", new Object[0]), localQuickFixArray);
    }
}

