/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ssl;

import com.intellij.openapi.project.Project;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.server.ssl.MavenTLSCertificateChecker;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/server/ssl/IdeCertificateManagerMavenTLSCertificateChecker;", "Lorg/jetbrains/idea/maven/server/ssl/MavenTLSCertificateChecker;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkCertificates", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)Z", "intellij.maven"})
@ApiStatus.Internal
public final class IdeCertificateManagerMavenTLSCertificateChecker
implements MavenTLSCertificateChecker {
    @NotNull
    private final Project project;

    public IdeCertificateManagerMavenTLSCertificateChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean checkCertificates(@NotNull X509Certificate[] chain, @NotNull String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        try {
            ConfirmingTrustManager.CertificateConfirmationParameters certificateConfirmationParameters = ConfirmingTrustManager.CertificateConfirmationParameters.askConfirmation((boolean)false, (String)MavenProjectBundle.message("maven.server.ask.trust", new Object[0]), null);
            Intrinsics.checkNotNullExpressionValue((Object)certificateConfirmationParameters, (String)"askConfirmation(...)");
            ConfirmingTrustManager.CertificateConfirmationParameters confirmationParameters = certificateConfirmationParameters;
            CertificateManager.Companion.getInstance().getTrustManager().checkServerTrusted(chain, authType, confirmationParameters);
            return true;
        }
        catch (CertificateException e) {
            MavenLog.LOG.warn((Throwable)e);
            return false;
        }
    }
}

