/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.shared.XDebuggerExecutionPointManager;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import com.intellij.xdebugger.impl.inline.InlineValuePopupProvider;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.inline.XDebuggerTreeInlayPopup;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InlineDebugRenderer
extends InlineDebugRendererBase {
    public static final String NAME_VALUE_SEPARATION = ": ";
    public static final String INDENT = "  ";
    boolean myPopupIsShown;
    private final boolean myCustomNode;
    private final XDebugSessionProxy mySession;
    private final XValueNodeImpl myValueNode;
    private final XDebuggerTreeCreator myTreeCreator;
    private final XSourcePosition myPosition;
    private SimpleColoredText myPresentation;

    public InlineDebugRenderer(XValueNodeImpl valueNode2, @NotNull VirtualFile file2, int line, @NotNull XDebugSessionProxy session) {
        if (file2 == null) {
            InlineDebugRenderer.$$$reportNull$$$0(0);
        }
        if (session == null) {
            InlineDebugRenderer.$$$reportNull$$$0(1);
        }
        this.myPopupIsShown = false;
        this.myPosition = XSourcePositionImpl.create(file2, line);
        this.mySession = session;
        this.myCustomNode = valueNode2 instanceof InlineWatchNodeImpl;
        this.myValueNode = valueNode2;
        this.updatePresentation();
        XValueMarkers markers = session.getValueMarkers();
        this.myTreeCreator = new XDebuggerTreeCreator(session.getProject(), session.getEditorsProvider(), session.getCurrentPosition(), markers);
    }

    public void updatePresentation() {
        TextAttributes attributes = LinePainter.getAttributes(this.myPosition.getLine(), this.myPosition.getFile(), this.mySession);
        SimpleColoredText valuePresentation = LinePainter.createPresentation(this.myValueNode);
        this.myPresentation = LinePainter.computeVariablePresentationWithChanges(this.myValueNode.getName(), valuePresentation, attributes, this.myPosition.getLine(), this.mySession.getProject());
    }

    @Override
    @RequiresBackgroundThread
    protected boolean calculateIsInExecutionPoint() {
        ThreadingAssertions.assertBackgroundThread();
        return LinePainter.isFullLineHighlighter(this.mySession, this.myPosition.getFile(), this.myPosition.getLine(), false);
    }

    @Override
    public void onClick(Inlay inlay, @NotNull EditorMouseEvent event) {
        boolean isRemoveIconClick;
        if (event == null) {
            InlineDebugRenderer.$$$reportNull$$$0(2);
        }
        int x = event.getMouseEvent().getX();
        boolean bl = isRemoveIconClick = this.myCustomNode && x >= this.myRemoveXCoordinate;
        if (isRemoveIconClick) {
            XDebugSessionTab tab = (XDebugSessionTab)this.mySession.getSessionTab();
            if (tab != null) {
                tab.getWatchesView().removeWatches(Collections.singletonList(this.myValueNode));
            }
            inlay.update();
        } else if (x >= this.myTextStartXCoordinate) {
            this.handleClick(inlay);
        }
    }

    private void handleClick(Inlay inlay) {
        InlineDebugRenderer inlayRenderer = (InlineDebugRenderer)inlay.getRenderer();
        if (inlayRenderer.myPopupIsShown) {
            return;
        }
        Pair<XValue, String> descriptor = InlineDebugRenderer.getXValueDescriptor(this.myValueNode);
        Rectangle bounds = inlay.getBounds();
        Point point = new Point(bounds.x, bounds.y + bounds.height);
        inlayRenderer.myPopupIsShown = true;
        Runnable hidePopupRunnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
            inlayRenderer.myPopupIsShown = false;
        });
        Editor editor = inlay.getEditor();
        InlineValuePopupProvider popupProvider = (InlineValuePopupProvider)InlineValuePopupProvider.EP_NAME.findFirstSafe(a -> a.accepts(this.myValueNode));
        if (popupProvider != null) {
            popupProvider.showPopup(this.myValueNode, this.mySession, this.myPosition, this.myTreeCreator, editor, point, hidePopupRunnable);
        } else {
            XDebuggerTreeInlayPopup.showTreePopup(this.myTreeCreator, descriptor, this.myValueNode, editor, point, this.myPosition, this.mySession, hidePopupRunnable);
        }
    }

    @NotNull
    public static Pair<XValue, String> getXValueDescriptor(@NotNull XValueNodeImpl xValueNode) {
        if (xValueNode == null) {
            InlineDebugRenderer.$$$reportNull$$$0(3);
        }
        String name = "valueName";
        XValue container2 = (XValue)xValueNode.getValueContainer();
        if (container2 instanceof XNamedValue) {
            name = ((XNamedValue)container2).getName();
        }
        Pair pair = Pair.create((Object)container2, (Object)name);
        if (pair == null) {
            InlineDebugRenderer.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @Override
    @NotNull
    public SimpleColoredText getPresentation() {
        SimpleColoredText simpleColoredText = this.myPresentation;
        if (simpleColoredText == null) {
            InlineDebugRenderer.$$$reportNull$$$0(5);
        }
        return simpleColoredText;
    }

    @Override
    public boolean isErrorMessage() {
        return XDebuggerUIConstants.ERROR_MESSAGE_ICON.equals(this.myValueNode.getIcon());
    }

    @Override
    public boolean isCustomNode() {
        return this.myCustomNode;
    }

    XValueNodeImpl getValueNode() {
        return this.myValueNode;
    }

    XSourcePosition getPosition() {
        return this.myPosition;
    }

    @Override
    @Nullable
    protected Icon getIcon() {
        Icon icon = this.myValueNode.getInlayIcon();
        return icon == null ? super.getIcon() : icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xValueNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineDebugRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineDebugRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getXValueDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getXValueDescriptor";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public static final class LinePainter {
        private static final Logger LOG = Logger.getInstance(LinePainter.class);
        public static final Key<Map<Variable, VariableValue>> CACHE = Key.create((String)"debug.inline.variables.cache");

        public static SimpleColoredText computeVariablePresentationWithChanges(String name, SimpleColoredText text, TextAttributes attributes, int lineNumber, Project project) {
            Map<Variable, VariableValue> oldValues = LinePainter.getOldValues(project);
            VariableText variableText = LinePainter.computeVariablePresentationWithChanges(name, text, attributes, lineNumber, oldValues);
            SimpleColoredText coloredText = new SimpleColoredText();
            for (LineExtensionInfo info : variableText.infos) {
                TextAttributes textAttributes = new TextAttributes(info.getColor(), info.getBgColor(), info.getEffectColor(), info.getEffectType(), info.getFontType());
                coloredText.append(info.getText(), SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes));
            }
            return coloredText;
        }

        @NotNull
        private static VariableText computeVariablePresentationWithChanges(@NlsSafe String name, SimpleColoredText text, TextAttributes attributes, int lineNumber, Map<Variable, VariableValue> oldValues) {
            VariableText res = new VariableText();
            res.add(new LineExtensionInfo(name, attributes));
            Variable var = new Variable(name, lineNumber);
            VariableValue variableValue = oldValues.get(var);
            if (variableValue == null) {
                variableValue = new VariableValue(text.toString(), null);
                oldValues.put(var, variableValue);
            } else if (!StringUtil.equals((CharSequence)text.toString(), (CharSequence)variableValue.actual)) {
                variableValue.setOld(variableValue.actual);
                variableValue.actual = text.toString();
            }
            if (!variableValue.isChanged()) {
                ArrayList texts = text.getTexts();
                for (int i = 0; i < texts.size(); ++i) {
                    String s = (String)texts.get(i);
                    TextAttributes attr = Registry.is((String)"debugger.show.values.colorful") ? ((SimpleTextAttributes)text.getAttributes().get(i)).toTextAttributes() : attributes;
                    res.add(new LineExtensionInfo(s, attr));
                }
            } else {
                variableValue.produceChangedParts(res.infos);
            }
            VariableText variableText = res;
            if (variableText == null) {
                LinePainter.$$$reportNull$$$0(0);
            }
            return variableText;
        }

        @NotNull
        public static Map<Variable, VariableValue> getOldValues(@NotNull Project project) {
            HashMap<Variable, VariableValue> oldValues;
            if (project == null) {
                LinePainter.$$$reportNull$$$0(1);
            }
            if ((oldValues = (HashMap<Variable, VariableValue>)project.getUserData(CACHE)) == null) {
                oldValues = new HashMap<Variable, VariableValue>();
                project.putUserData(CACHE, oldValues);
            }
            HashMap<Variable, VariableValue> hashMap = oldValues;
            if (hashMap == null) {
                LinePainter.$$$reportNull$$$0(2);
            }
            return hashMap;
        }

        @NotNull
        static TextAttributes getAttributes(int lineNumber, @NotNull VirtualFile file2, XDebugSessionProxy session) {
            if (file2 == null) {
                LinePainter.$$$reportNull$$$0(3);
            }
            TextAttributes textAttributes = LinePainter.isFullLineHighlighter(session, file2, lineNumber, true) ? LinePainter.getTopFrameSelectedAttributes() : LinePainter.getNormalAttributes();
            if (textAttributes == null) {
                LinePainter.$$$reportNull$$$0(4);
            }
            return textAttributes;
        }

        static boolean isFullLineHighlighter(@NotNull XDebugSessionProxy session, @NotNull VirtualFile file2, int lineNumber, boolean isToCheckTopFrameOnly) {
            if (session == null) {
                LinePainter.$$$reportNull$$$0(5);
            }
            if (file2 == null) {
                LinePainter.$$$reportNull$$$0(6);
            }
            Project project = session.getProject();
            XDebuggerExecutionPointManager executionPointManager = XDebugManagerProxy.getInstance().getDebuggerExecutionPointManager(project);
            if (executionPointManager == null) {
                return false;
            }
            return executionPointManager.isFullLineHighlighterAt(file2, lineNumber, project, isToCheckTopFrameOnly);
        }

        @Nullable
        public static SimpleColoredText createPresentation(@NotNull XValueNodeImpl value) {
            if (value == null) {
                LinePainter.$$$reportNull$$$0(7);
            }
            SimpleColoredText text = new SimpleColoredText();
            XValueTextRendererImpl renderer = new XValueTextRendererImpl((ColoredTextContainer)text);
            XValuePresentation presentation = value.getValuePresentation();
            if (presentation == null) {
                return null;
            }
            try {
                String type;
                if (presentation instanceof XValueCompactPresentation && !value.getTree().isUnderRemoteDebug()) {
                    ((XValueCompactPresentation)presentation).renderValue(renderer, value);
                } else {
                    presentation.renderValue((XValuePresentation.XValueTextRenderer)renderer);
                }
                if (StringUtil.isEmpty((String)text.toString()) && !StringUtil.isEmpty((String)(type = value.getValuePresentation().getType()))) {
                    text.append(type, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
            return text;
        }

        private static TextAttributes getNormalAttributes() {
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES);
            if (attributes == null || attributes.getForegroundColor() == null) {
                return new TextAttributes((Color)JBColor.lazy(() -> EditorColorsManager.getInstance().isDarkEditor() ? new Color(4030565) : Gray._135), null, null, null, 2);
            }
            return attributes;
        }

        private static TextAttributes getChangedAttributes() {
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES_MODIFIED);
            if (attributes == null || attributes.getForegroundColor() == null) {
                return new TextAttributes((Color)JBColor.lazy(() -> EditorColorsManager.getInstance().isDarkEditor() ? new Color(10584842) : new Color(13271073)), null, null, null, 2);
            }
            return attributes;
        }

        private static TextAttributes getTopFrameSelectedAttributes() {
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            if (attributes == null || attributes.getForegroundColor() == null) {
                return new TextAttributes(EditorColorsManager.getInstance().isDarkEditor() ? new Color(255, 235, 9) : new Color(0, 255, 86), null, null, null, 2);
            }
            return attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineDebugRenderer$LinePainter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeVariablePresentationWithChanges";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineDebugRenderer$LinePainter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldValues";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getOldValues";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributes";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isFullLineHighlighter";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createPresentation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }

        private static class VariableText {
            final List<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();

            private VariableText() {
            }

            void add(LineExtensionInfo info) {
                this.infos.add(info);
            }
        }

        static class Variable {
            private final int lineNumber;
            private final String name;

            Variable(String name, int lineNumber) {
                this.lineNumber = lineNumber;
                this.name = name;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Variable variable = (Variable)o;
                if (this.lineNumber != variable.lineNumber) {
                    return false;
                }
                return this.name.equals(variable.name);
            }

            public int hashCode() {
                return Objects.hash(this.lineNumber, this.name);
            }
        }

        static class VariableValue {
            private static final List<Couple<String>> ARRAYS_WRAPPERS = List.of(Couple.of((Object)"[", (Object)"]"), Couple.of((Object)"{", (Object)"}"));
            private static final String ARRAY_DELIMITER = ", ";
            @NlsSafe
            private String actual;
            @NlsSafe
            private String old;

            VariableValue(String actual, String old) {
                this.actual = actual;
                this.old = old;
            }

            public boolean isChanged() {
                return this.old != null && !StringUtil.equals((CharSequence)this.actual, (CharSequence)this.old) && !VariableValue.isCollecting(this.actual);
            }

            void produceChangedParts(List<? super LineExtensionInfo> result2) {
                Couple<String> wrapperActual = VariableValue.getArrayWrapper(this.actual);
                if (wrapperActual != null && VariableValue.getArrayWrapper(this.old) != null) {
                    List<String> actualParts = VariableValue.getArrayParts(this.actual);
                    List<String> oldParts = VariableValue.getArrayParts(this.old);
                    result2.add((LineExtensionInfo)new LineExtensionInfo((String)wrapperActual.first, LinePainter.getNormalAttributes()));
                    for (int i = 0; i < actualParts.size(); ++i) {
                        if (i < oldParts.size() && StringUtil.equals((CharSequence)actualParts.get(i), (CharSequence)oldParts.get(i))) {
                            result2.add((LineExtensionInfo)new LineExtensionInfo(actualParts.get(i), LinePainter.getNormalAttributes()));
                        } else {
                            result2.add((LineExtensionInfo)new LineExtensionInfo(actualParts.get(i), LinePainter.getChangedAttributes()));
                        }
                        if (i == actualParts.size() - 1) continue;
                        result2.add((LineExtensionInfo)new LineExtensionInfo(ARRAY_DELIMITER, LinePainter.getNormalAttributes()));
                    }
                    result2.add((LineExtensionInfo)new LineExtensionInfo((String)wrapperActual.second, LinePainter.getNormalAttributes()));
                    return;
                }
                result2.add((LineExtensionInfo)new LineExtensionInfo(this.actual, LinePainter.getChangedAttributes()));
            }

            void setOld(String text) {
                if (!VariableValue.isCollecting(text)) {
                    this.old = text;
                }
            }

            static boolean isCollecting(@NotNull String text) {
                if (text == null) {
                    VariableValue.$$$reportNull$$$0(0);
                }
                return text.contains(XDebuggerUIConstants.getCollectingDataMessage());
            }

            @Nullable
            private static Couple<String> getArrayWrapper(@Nullable String s) {
                if (s == null) {
                    return null;
                }
                return (Couple)ContainerUtil.find(ARRAYS_WRAPPERS, w -> s.startsWith((String)w.first) && s.endsWith((String)w.second));
            }

            private static List<String> getArrayParts(String array) {
                return StringUtil.split((String)array.substring(1, array.length() - 1), (String)ARRAY_DELIMITER);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/inline/InlineDebugRenderer$LinePainter$VariableValue", "isCollecting"));
            }
        }
    }
}

