/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.NonInteractiveTemplateUtil;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateBuilderImpl
implements TemplateBuilder {
    private final RangeMarker myContainerElement;
    private final Map<RangeMarker, Expression> myExpressions;
    private final Map<RangeMarker, String> myVariableExpressions;
    private final Map<RangeMarker, Boolean> myAlwaysStopAtMap;
    private final Map<RangeMarker, Boolean> mySkipOnStartMap;
    private final Map<RangeMarker, String> myVariableNamesMap;
    private final Set<RangeMarker> myElements;
    private RangeMarker myEndElement;
    private RangeMarker mySelection;
    private final Document myDocument;
    private final PsiFile myPsiFile;
    private Comparator<? super Variable> myVariableComparator;
    private boolean scrollToTemplate;
    private static final Logger LOG = Logger.getInstance(TemplateBuilderImpl.class);

    public TemplateBuilderImpl(@NotNull PsiElement element) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(0);
        }
        this.myExpressions = new HashMap<RangeMarker, Expression>();
        this.myVariableExpressions = new HashMap<RangeMarker, String>();
        this.myAlwaysStopAtMap = new HashMap<RangeMarker, Boolean>();
        this.mySkipOnStartMap = new HashMap<RangeMarker, Boolean>();
        this.myVariableNamesMap = new HashMap<RangeMarker, String>();
        this.myElements = new TreeSet<RangeMarker>(RangeMarker.BY_START_OFFSET);
        this.scrollToTemplate = true;
        this.myPsiFile = InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element);
        this.myDocument = this.myPsiFile.getViewProvider().getDocument();
        this.myContainerElement = this.wrapElement(element);
    }

    public void setGreedyToRight(boolean greedy) {
        this.myContainerElement.setGreedyToRight(greedy);
    }

    public int getElementsCount() {
        return this.myElements.size();
    }

    public void replaceElement(PsiElement element, Expression expression, boolean alwaysStopAt) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.replaceElement(key, expression);
    }

    private RangeMarker wrapElement(PsiElement element) {
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        return this.myDocument.createRangeMarker(range);
    }

    private RangeMarker wrapReference(PsiReference ref) {
        PsiElement element = ref.getElement();
        return this.myDocument.createRangeMarker(ref.getRangeInElement().shiftRight(InjectedLanguageManager.getInstance((Project)this.myPsiFile.getProject()).injectedToHost(element, element.getTextRange().getStartOffset())));
    }

    public void replaceElement(PsiElement element, @NonNls String varName, Expression expression, boolean alwaysStopAt) {
        this.replaceElement(element, varName, expression, alwaysStopAt, false);
    }

    public void replaceElement(PsiReference ref, String varName, Expression expression, boolean alwaysStopAt) {
        RangeMarker key = this.wrapReference(ref);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.replaceElement(key, expression);
    }

    public void replaceElement(@NotNull PsiElement element, @NotNull TextRange textRange, String varName, Expression expression, boolean alwaysStopAt) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(1);
        }
        if (textRange == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(2);
        }
        TextRange elementTextRange = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        RangeMarker key = this.myDocument.createRangeMarker(textRange.shiftRight(elementTextRange.getStartOffset()));
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.replaceElement(key, expression);
    }

    private void replaceElement(RangeMarker key, Expression expression) {
        this.myExpressions.put(key, expression);
        this.myElements.add(key);
    }

    public void replaceElement(PsiElement element, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.myVariableExpressions.put(key, dependantVariableName);
        this.myElements.add(key);
    }

    public void replaceElement(PsiReference ref, @NonNls String varName, @NonNls String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key = this.wrapReference(ref);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.myVariableExpressions.put(key, dependantVariableName);
        this.myElements.add(key);
    }

    public void replaceElement(PsiElement element, TextRange textRange, String primaryVariableName, String otherVariableName, boolean alwaysStopAt) {
        TextRange elementTextRange = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        RangeMarker key = this.myDocument.createRangeMarker(textRange.shiftRight(elementTextRange.getStartOffset()));
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, primaryVariableName);
        this.myVariableExpressions.put(key, otherVariableName);
        this.myElements.add(key);
    }

    public void replaceElement(@NotNull PsiElement element, Expression expression) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(3);
        }
        RangeMarker key = this.wrapElement(element);
        this.replaceElement(key, expression);
    }

    public void replaceElement(@NotNull PsiElement element, TextRange rangeWithinElement, Expression expression) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(4);
        }
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(element.getTextRange().getStartOffset()));
        this.replaceElement(key, expression);
    }

    public void replaceRange(TextRange rangeWithinElement, String replacementText) {
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(this.myContainerElement.getStartOffset()));
        ConstantNode value = new ConstantNode(replacementText);
        this.replaceElement(key, (Expression)value);
    }

    public void replaceRange(TextRange rangeWithinElement, Expression expression) {
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement);
        this.replaceElement(key, expression);
    }

    public void setEndVariableAfter(PsiElement element) {
        element = PsiTreeUtil.nextLeaf((PsiElement)element);
        this.setEndVariableBefore(element);
    }

    public void setEndVariableBefore(PsiElement element) {
        if (this.myEndElement != null) {
            this.myElements.remove(this.myEndElement);
        }
        this.myEndElement = this.wrapElement(element);
        this.myElements.add(this.myEndElement);
    }

    public void setSelection(PsiElement element) {
        this.mySelection = this.wrapElement(element);
        this.myElements.add(this.mySelection);
    }

    public void setVariableOrdering(@Nullable Comparator<? super Variable> comparator) {
        this.myVariableComparator = comparator;
    }

    public Template buildInlineTemplate() {
        return this.initInlineTemplate(this.buildTemplate());
    }

    public Template initInlineTemplate(Template template) {
        template.setInline(true);
        if (this.myPsiFile.isPhysical()) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        DocumentUtil.executeInBulk((Document)this.myDocument, (boolean)true, () -> {
            for (RangeMarker element : this.myElements) {
                if (element == this.myEndElement) continue;
                this.myDocument.deleteString(element.getStartOffset(), element.getEndOffset());
            }
        });
        return template;
    }

    public Template buildTemplate() {
        TemplateManager manager = TemplateManager.getInstance(this.myPsiFile.getProject());
        Template template = manager.createTemplate("", "");
        return this.initTemplate(template);
    }

    public Template initTemplate(Template template) {
        String variableName;
        Expression expression;
        boolean alwaysStopAt;
        Boolean stop;
        String text = this.getDocumentTextFragment(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset());
        int containerStart = this.myContainerElement.getStartOffset();
        int start = 0;
        for (RangeMarker element : this.myElements) {
            int offset = element.getStartOffset() - containerStart;
            if (start > offset) {
                LOG.error("file: " + String.valueOf(this.myPsiFile) + " container: " + String.valueOf(this.myContainerElement) + " markers: " + StringUtil.join(this.myElements, rangeMarker -> {
                    String docString = this.myDocument.getText(rangeMarker.getTextRange());
                    return "[[" + docString + "]" + rangeMarker.getStartOffset() + ", " + rangeMarker.getEndOffset() + "]";
                }, (String)", "));
            }
            template.addTextSegment(text.substring(start, offset));
            if (element == this.mySelection) {
                template.addSelectionStartVariable();
                template.addTextSegment(this.getDocumentTextFragment(this.mySelection.getStartOffset(), this.mySelection.getEndOffset()));
                template.addSelectionEndVariable();
            } else {
                if (element == this.myEndElement) {
                    template.addEndVariable();
                    start = offset;
                    continue;
                }
                stop = this.myAlwaysStopAtMap.get(element);
                alwaysStopAt = stop == null || stop != false;
                expression = this.myExpressions.get(element);
                String string = variableName = this.myVariableNamesMap.get(element) == null ? String.valueOf(expression.hashCode()) : this.myVariableNamesMap.get(element);
                if (expression != null) {
                    Boolean skipOnStart = this.mySkipOnStartMap.get(element);
                    template.addVariable(variableName, expression, expression, alwaysStopAt, skipOnStart != null && skipOnStart != false);
                } else {
                    template.addVariableSegment(variableName);
                }
            }
            start = element.getEndOffset() - containerStart;
        }
        template.addTextSegment(text.substring(start));
        for (RangeMarker element : this.myElements) {
            String dependantVariable = this.myVariableExpressions.get(element);
            if (dependantVariable == null) continue;
            stop = this.myAlwaysStopAtMap.get(element);
            alwaysStopAt = stop == null || stop != false;
            expression = this.myExpressions.get(element);
            variableName = this.myVariableNamesMap.get(element) == null ? String.valueOf(expression.hashCode()) : this.myVariableNamesMap.get(element);
            template.addVariable(variableName, dependantVariable, dependantVariable, alwaysStopAt);
        }
        template.setToIndent(false);
        template.setToReformat(false);
        template.setScrollToTemplate(this.scrollToTemplate);
        this.orderTemplateVariables(template);
        return template;
    }

    private void orderTemplateVariables(Template template) {
        if (this.myVariableComparator == null || !(template instanceof TemplateImpl)) {
            return;
        }
        TemplateImpl templateImpl = (TemplateImpl)template;
        ArrayList<? super Variable> variables = new ArrayList<Variable>(templateImpl.getVariables());
        variables.sort(this.myVariableComparator);
        for (int i = variables.size() - 1; i >= 0; --i) {
            templateImpl.removeVariable(i);
        }
        for (Variable variable : variables) {
            templateImpl.addVariable(variable);
        }
    }

    private String getDocumentTextFragment(int startOffset, int endOffset) {
        return this.myDocument.getCharsSequence().subSequence(startOffset, endOffset).toString();
    }

    public void replaceElement(@NotNull PsiElement element, @NlsSafe String replacementText) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(5);
        }
        this.replaceElement(element, (Expression)new ConstantNode(replacementText));
    }

    public void replaceElement(@NotNull PsiElement element, TextRange rangeWithinElement, String replacementText) {
        if (element == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(6);
        }
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(element.getTextRange().getStartOffset()));
        ConstantNode value = new ConstantNode(replacementText);
        this.replaceElement(key, (Expression)value);
    }

    public void runNonInteractively(boolean inline) {
        Template template = new TemplateImpl("", "");
        if (inline) {
            template = this.initInlineTemplate(template);
        } else {
            template = this.initTemplate(template);
            this.myDocument.replaceString(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset(), (CharSequence)"");
        }
        NonInteractiveTemplateUtil.runNonInteractively(this.myPsiFile, this.myDocument, template, this.myContainerElement);
    }

    public void run(@NotNull Editor editor, boolean inline) {
        Template template;
        if (editor == null) {
            TemplateBuilderImpl.$$$reportNull$$$0(7);
        }
        if (inline) {
            template = this.buildInlineTemplate();
        } else {
            template = this.buildTemplate();
            editor.getDocument().replaceString(this.myContainerElement.getStartOffset(), this.myContainerElement.getEndOffset(), (CharSequence)"");
        }
        editor.getCaretModel().moveToOffset(this.myContainerElement.getStartOffset());
        TemplateManager.getInstance(this.myPsiFile.getProject()).startTemplate(editor, template);
    }

    public void replaceElement(PsiElement element, @NonNls String varName, Expression expression, boolean alwaysStopAt, boolean skipOnStart) {
        RangeMarker key = this.wrapElement(element);
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.mySkipOnStartMap.put(key, skipOnStart);
        this.replaceElement(key, expression);
    }

    public void replaceRange(TextRange rangeWithinElement, String varName, Expression expression, boolean alwaysStopAt) {
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(this.myContainerElement.getStartOffset()));
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.replaceElement(key, expression);
    }

    public void replaceElement(TextRange rangeWithinElement, String varName, String dependantVariableName, boolean alwaysStopAt) {
        RangeMarker key = this.myDocument.createRangeMarker(rangeWithinElement.shiftRight(this.myContainerElement.getStartOffset()));
        this.myAlwaysStopAtMap.put(key, alwaysStopAt ? Boolean.TRUE : Boolean.FALSE);
        this.myVariableNamesMap.put(key, varName);
        this.myVariableExpressions.put(key, dependantVariableName);
        this.myElements.add(key);
    }

    public TemplateBuilder setScrollToTemplate(boolean scrollToTemplate) {
        this.scrollToTemplate = scrollToTemplate;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/TemplateBuilderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

