/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LazyRangeMarkerFactoryImpl
extends LazyRangeMarkerFactory {
    private final Project myProject;

    public LazyRangeMarkerFactoryImpl(@NotNull Project project) {
        if (project == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull VirtualFile file, int offset) {
        if (file == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(1);
        }
        RangeMarker rangeMarker = (RangeMarker)ReadAction.compute(() -> DocumentImpl.createRangeMarkerForVirtualFile((VirtualFile)file, (int)offset, (int)-1, (int)-1, (int)-1, (int)-1, (boolean)false));
        if (rangeMarker == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(2);
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull VirtualFile file, int line, int column, boolean persistent) {
        if (file == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(3);
        }
        RangeMarker rangeMarker = (RangeMarker)ReadAction.compute(() -> {
            Document document;
            Document document2 = document = file.getFileType().isBinary() ? null : FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                int offset = DocumentUtil.calculateOffset((Document)document, (int)line, (int)column, (int)CodeStyle.getFacade((Project)this.myProject, (Document)document, (FileType)file.getFileType()).getTabSize());
                return DocumentImpl.createRangeMarkerForVirtualFile((VirtualFile)file, (int)offset, (int)line, (int)column, (int)line, (int)column, (boolean)persistent);
            }
            return DocumentImpl.createRangeMarkerForVirtualFile((VirtualFile)file, (int)0, (int)line, (int)column, (int)line, (int)column, (boolean)true);
        });
        if (rangeMarker == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(4);
        }
        return rangeMarker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarker";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

