/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.fasterxml.aalto.WFCException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.xml.AttributeIteratorImpl;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.XmlProcessor;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.CancellationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a+\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0082\b\u001a\u0018\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "parseXml", "", "reader", "Ljava/io/Reader;", "processor", "Lcom/intellij/util/xml/XmlProcessor;", "inputStream", "Ljava/io/InputStream;", "parseXmlHeader", "Lcom/intellij/util/xml/XmlFileHeader;", "Lorg/codehaus/stax2/XMLStreamReader2;", "logOrRethrow", "e", "Ljavax/xml/stream/XMLStreamException;", "processXml", "closeable", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "readerSupplier", "Lkotlin/Function0;", "", "intellij.platform.indexing.impl"})
@JvmName(name="XmlProcessorUtil")
@SourceDebugExtension(value={"SMAP\nXmlProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlProcessor.kt\ncom/intellij/util/xml/XmlProcessorUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n149#1,27:211\n149#1,27:238\n13#2:210\n*S KotlinDebug\n*F\n+ 1 XmlProcessor.kt\ncom/intellij/util/xml/XmlProcessorUtil\n*L\n59#1:211,27\n66#1:238,27\n55#1:210\n*E\n"})
public final class XmlProcessorUtil {
    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NanoXmlUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void parseXml(@NotNull Reader reader, @NotNull XmlProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        XmlProcessor xmlProcessor = processor;
        AutoCloseable closeable$iv = reader;
        boolean $i$f$processXml = false;
        try {
            AutoCloseable autoCloseable = closeable$iv;
            Throwable throwable = null;
            try {
                Boolean bl;
                AutoCloseable it$iv = autoCloseable;
                boolean bl2 = false;
                boolean bl3 = false;
                try (XMLStreamReader2 reader$iv = StaxFactory.createXmlStreamReader((Reader)reader);){
                    void processor$iv;
                    bl = XmlProcessorUtil.processXml(reader$iv, (XmlProcessor)processor$iv);
                }
                Boolean bl4 = bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (ProcessCanceledException e$iv) {
            throw e$iv;
        }
        catch (CancellationException e$iv) {
            throw e$iv;
        }
        catch (Exception e$iv) {
            XmlProcessorUtil.getLOG().error((Throwable)e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void parseXml(@NotNull InputStream inputStream, @NotNull XmlProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        XmlProcessor xmlProcessor = processor;
        AutoCloseable closeable$iv = inputStream;
        boolean $i$f$processXml = false;
        try {
            AutoCloseable autoCloseable = closeable$iv;
            Throwable throwable = null;
            try {
                Boolean bl;
                AutoCloseable it$iv = autoCloseable;
                boolean bl2 = false;
                boolean bl3 = false;
                try (XMLStreamReader2 reader$iv = StaxFactory.createXmlStreamReader$default((InputStream)inputStream, null, (int)2, null);){
                    void processor$iv;
                    bl = XmlProcessorUtil.processXml(reader$iv, (XmlProcessor)processor$iv);
                }
                Boolean bl4 = bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (ProcessCanceledException e$iv) {
            throw e$iv;
        }
        catch (CancellationException e$iv) {
            throw e$iv;
        }
        catch (Exception e$iv) {
            XmlProcessorUtil.getLOG().error((Throwable)e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final XmlFileHeader parseXmlHeader(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Closeable closeable = reader;
        Throwable throwable = null;
        try {
            Reader it = (Reader)closeable;
            boolean bl = false;
            XmlFileHeader xmlFileHeader = XmlProcessorUtil.parseXmlHeader(StaxFactory.createXmlStreamReader((Reader)reader));
            return xmlFileHeader;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final XmlFileHeader parseXmlHeader(XMLStreamReader2 reader) {
        try {
            while (reader.hasNext()) {
                if (reader.next() != 1) continue;
                Location location = reader.getLocation();
                XmlFileHeader xmlFileHeader = new XmlFileHeader(reader.getLocalName(), reader.getNamespaceURI(), location.getPublicId(), location.getSystemId());
                return xmlFileHeader;
            }
        }
        catch (XMLStreamException e) {
            XmlProcessorUtil.logOrRethrow(e);
        }
        catch (WFCException e) {
            XmlProcessorUtil.getLOG().debug((Throwable)e);
        }
        finally {
            reader.close();
        }
        return new XmlFileHeader(null, null, null, null);
    }

    private static final void logOrRethrow(XMLStreamException e) {
        Throwable nestedException = e.getNestedException();
        if (nestedException instanceof ProcessCanceledException) {
            throw new ProcessCanceledException((Throwable)e);
        }
        if (nestedException instanceof CancellationException) {
            throw nestedException;
        }
        XmlProcessorUtil.getLOG().debug((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processXml(XmlProcessor processor, AutoCloseable closeable, Function0<? extends XMLStreamReader2> readerSupplier) {
        boolean $i$f$processXml = false;
        try {
            AutoCloseable autoCloseable = closeable;
            Throwable throwable = null;
            try {
                Boolean bl;
                AutoCloseable it = autoCloseable;
                boolean bl2 = false;
                XMLStreamReader2 reader = (XMLStreamReader2)readerSupplier.invoke();
                try {
                    bl = XmlProcessorUtil.processXml(reader, processor);
                }
                catch (XMLStreamException e) {
                    XmlProcessorUtil.logOrRethrow(e);
                    bl = Unit.INSTANCE;
                }
                catch (WFCException e) {
                    XmlProcessorUtil.getLOG().debug((Throwable)e);
                    bl = Unit.INSTANCE;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    reader.close();
                    InlineMarker.finallyEnd((int)1);
                }
                Boolean bl3 = bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            XmlProcessorUtil.getLOG().error((Throwable)e);
        }
    }

    private static final boolean processXml(XMLStreamReader2 reader, XmlProcessor processor) {
        AttributeIteratorImpl attributeIterator = new AttributeIteratorImpl(reader);
        while (reader.hasNext()) {
            int token = reader.next();
            switch (token) {
                case 1: {
                    String elementLocalName = reader.getLocalName();
                    String elementNamespacePrefix = reader.getPrefix();
                    String elementNamespaceUri = reader.getNamespaceURI();
                    attributeIterator.reset();
                    Intrinsics.checkNotNull((Object)elementLocalName);
                    if (processor.startElement(elementLocalName, elementNamespacePrefix, elementNamespaceUri, attributeIterator)) break;
                    return false;
                }
                case 12: {
                    int fromIndex = reader.getTextStart();
                    char[] cArray = reader.getTextCharacters();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getTextCharacters(...)");
                    processor.content(cArray, fromIndex, fromIndex + reader.getTextLength());
                    break;
                }
                case 2: {
                    String string = reader.getLocalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
                    if (processor.endElement(string, reader.getNamespaceURI())) break;
                    return false;
                }
                case 4: 
                case 6: {
                    if (reader.isWhiteSpace()) break;
                    int fromIndex = reader.getTextStart();
                    char[] cArray = reader.getTextCharacters();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getTextCharacters(...)");
                    processor.content(cArray, fromIndex, fromIndex + reader.getTextLength());
                }
            }
        }
        return true;
    }
}

