/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.validation.DuplicatesCheckUtil;
import com.intellij.lang.javascript.validation.JSNavigateToAlreadyDeclaredVariableFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDuplicatedDeclarationInspection
extends JSInspection
implements DumbAware {
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSFunctionDeclaration(node);
                this.checkFunctionDeclaration(node, holder);
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitJSVariable(node);
                if (!(node instanceof JSParameter)) {
                    JSDuplicatedDeclarationInspection.this.reportDuplicateError((PsiElement)node, DuplicatesCheckUtil.checkDuplicatesForVariable(node), holder);
                }
            }

            public void visitJSParameter(@NotNull JSParameter node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitJSParameter(node);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)node, holder);
            }

            public void visitJSNamespaceDeclaration(@NotNull JSNamespaceDeclaration namespaceDeclaration) {
                if (namespaceDeclaration == null) {
                    1.$$$reportNull$$$0(3);
                }
                super.visitJSNamespaceDeclaration(namespaceDeclaration);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)namespaceDeclaration, holder);
            }

            public void visitJSClass(@NotNull JSClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(4);
                }
                super.visitJSClass(aClass);
                if (DialectDetector.isActionScript((PsiElement)aClass) || JSClassUtils.isES6ClassImplementation((PsiElement)aClass) && !(aClass instanceof JSClassExpression)) {
                    JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)aClass, holder);
                }
            }

            public void visitJSProperty(@NotNull JSProperty node) {
                if (node == null) {
                    1.$$$reportNull$$$0(5);
                }
                super.visitJSProperty(node);
                if (!JSDestructuringUtil.parentIsDestructuringAssignmentLHS((JSExpression)node.getValue())) {
                    JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)node, holder);
                }
            }

            public void visitImportSpecifier(@NotNull ES6ImportSpecifier node) {
                if (node == null) {
                    1.$$$reportNull$$$0(6);
                }
                super.visitImportSpecifier(node);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)node, holder);
            }

            public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
                if (importedBinding == null) {
                    1.$$$reportNull$$$0(7);
                }
                super.visitES6ImportedBinding(importedBinding);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)importedBinding, holder);
            }

            public void visitES6ImportSpecifierAlias(@NotNull ES6ImportSpecifierAlias specifierAlias) {
                if (specifierAlias == null) {
                    1.$$$reportNull$$$0(8);
                }
                super.visitES6ImportSpecifierAlias(specifierAlias);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)specifierAlias, holder);
            }

            public void visitJSFunctionProperty(@NotNull JSFunctionProperty functionProperty) {
                if (functionProperty == null) {
                    1.$$$reportNull$$$0(9);
                }
                ProgressManager.checkCanceled();
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)functionProperty, holder);
            }

            private void checkFunctionDeclaration(@NotNull JSFunction function, @NotNull ProblemsHolder holder2) {
                if (function == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (holder2 == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (!TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)function)) {
                    JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)function, holder2);
                }
            }

            public void visitTypeScriptPropertySignature(@NotNull TypeScriptPropertySignature propertySignature) {
                if (propertySignature == null) {
                    1.$$$reportNull$$$0(12);
                }
                super.visitTypeScriptPropertySignature(propertySignature);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)propertySignature, holder);
            }

            public void visitTypeScriptFunctionSignature(@NotNull TypeScriptFunctionSignature functionSignature) {
                if (functionSignature == null) {
                    1.$$$reportNull$$$0(13);
                }
                super.visitTypeScriptFunctionSignature(functionSignature);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)functionSignature, holder);
            }

            public void visitES6ExportDefaultAssignment(@NotNull ES6ExportDefaultAssignment node) {
                DuplicatesCheckUtil.JSDuplicatesCheckError error;
                if (node == null) {
                    1.$$$reportNull$$$0(14);
                }
                super.visitES6ExportDefaultAssignment(node);
                JSNamedElement namedElement = node.getNamedElement();
                Object expressionToReport = namedElement != null ? namedElement.getNameIdentifier() : node.getExpression();
                if (expressionToReport != null && (error = DuplicatesCheckUtil.checkDefaultExports(node)) != null) {
                    JSDuplicatedDeclarationInspection.this.reportDuplicateError((PsiElement)expressionToReport, error, holder);
                }
            }

            public void visitTypeScriptTypeParameter(@NotNull TypeScriptTypeParameter typeParameter) {
                if (typeParameter == null) {
                    1.$$$reportNull$$$0(15);
                }
                super.visitTypeScriptTypeParameter(typeParameter);
                JSDuplicatedDeclarationInspection.this.reportDuplicateError((PsiElement)typeParameter, DuplicatesCheckUtil.checkTypeParameterDuplicates(typeParameter), holder);
            }

            public void visitES6ExportSpecifier(@NotNull ES6ExportSpecifier node) {
                if (node == null) {
                    1.$$$reportNull$$$0(16);
                }
                super.visitES6ExportSpecifier(node);
                ES6ExportSpecifierAlias alias = node.getAlias();
                ES6ExportSpecifierAlias element = alias != null ? alias : node;
                JSDuplicatedDeclarationInspection.this.reportDuplicateError((PsiElement)element, DuplicatesCheckUtil.checkExportDuplicates((PsiNamedElement)element), holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "namespaceDeclaration";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importedBinding";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "specifierAlias";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "functionProperty";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "holder";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "propertySignature";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "functionSignature";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeParameter";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDuplicatedDeclarationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSParameter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSNamespaceDeclaration";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSClass";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSProperty";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitImportSpecifier";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ImportedBinding";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ImportSpecifierAlias";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionProperty";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkFunctionDeclaration";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeScriptPropertySignature";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeScriptFunctionSignature";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ExportDefaultAssignment";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeScriptTypeParameter";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ExportSpecifier";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void checkDuplicates(@NotNull JSPsiNamedElementBase element, @NotNull ProblemsHolder holder) {
        if (element == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(3);
        }
        this.reportDuplicateError((PsiElement)element, DuplicatesCheckUtil.checkDuplicates(element), holder);
    }

    protected void reportDuplicateError(@NotNull PsiElement elementToReport, @Nullable DuplicatesCheckUtil.JSDuplicatesCheckError error, @NotNull ProblemsHolder holder) {
        LocalQuickFix[] localQuickFixArray;
        PsiElement nameIdentifier;
        if (elementToReport == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(5);
        }
        if (error == null || error.hasErrorSeverity()) {
            return;
        }
        PsiElement psiElement = nameIdentifier = elementToReport instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)elementToReport).getNameIdentifier() : null;
        if (nameIdentifier == null) {
            nameIdentifier = elementToReport;
        }
        if (error.getDuplicatedElement() instanceof JSElement) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = new JSNavigateToAlreadyDeclaredVariableFix((JSElement)error.getDuplicatedElement());
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] actions = localQuickFixArray;
        holder.registerProblem(nameIdentifier, error.getMessage(), actions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReport";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDuplicatedDeclarationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportDuplicateError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

