/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamedToFunctionExpressionIntention
extends JavaScriptIntention {
    public JSNamedToFunctionExpressionIntention() {
        this.setText(JavaScriptBundle.message((String)"js.named.to.anonymous.family.name", (Object[])new Object[0]));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.named.to.anonymous.family.name", (Object[])new Object[0]);
        if (string == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(1);
        }
        return currentFile;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSFunction declaration = JSNamedToFunctionExpressionIntention.getFunction(element);
        if (declaration == null || declaration.getNameIdentifier() == null || declaration.getKind() != JSFunction.FunctionKind.SIMPLE || TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)declaration)) {
            return false;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)declaration);
        boolean isClassMember = declaration.getParent() instanceof JSClass;
        if (isClassMember && !JSClassUtils.isES6ClassImplementation((DialectOptionHolder)dialect)) {
            return false;
        }
        this.setText(JSNamedToFunctionExpressionIntention.canConvertToArrowFunction(dialect, declaration) ? JavaScriptBundle.message((String)"js.named.to.arrow.text", (Object[])new Object[]{isClassMember ? "field" : "variable"}) : JavaScriptBundle.message((String)"js.named.to.function.expression.text", (Object[])new Object[0]));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(5);
        }
        JSFunction declaration = JSNamedToFunctionExpressionIntention.getFunction(element);
        assert (declaration != null);
        boolean isClassMember = declaration.getParent() instanceof JSClass;
        MultiMap conflicts = new MultiMap();
        Ref usedOutsideBlockScope = new Ref((Object)Boolean.FALSE);
        Ref hasReassignments = new Ref((Object)Boolean.FALSE);
        HashSet<JSPsiElementBase> implementations = new HashSet<JSPsiElementBase>();
        if (!isClassMember) {
            if (!JSNamedToFunctionExpressionIntention.processUsages(declaration, (MultiMap<PsiElement, String>)conflicts, (Ref<Boolean>)usedOutsideBlockScope, (Ref<Boolean>)hasReassignments)) {
                return;
            }
            if (!BaseRefactoringProcessor.processConflicts((Project)declaration.getProject(), (MultiMap)conflicts)) {
                return;
            }
        } else {
            JSNamedToFunctionExpressionIntention.collectImplementations(implementations, declaration);
        }
        WriteAction.run(() -> {
            JSNamedToFunctionExpressionIntention.performReplacement(declaration, isClassMember, usedOutsideBlockScope.get() == Boolean.TRUE, hasReassignments.get() == Boolean.TRUE);
            for (JSPsiElementBase impl : implementations) {
                if (!(impl instanceof JSFunction)) continue;
                JSFunction function = (JSFunction)impl;
                JSNamedToFunctionExpressionIntention.performReplacement(function, true, false, false);
            }
        });
    }

    private static void collectImplementations(@NotNull Collection<JSPsiElementBase> implementations, @NotNull JSFunction declaration) {
        if (implementations == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(6);
        }
        if (declaration == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(implementations);
            JSInheritanceUtil.iterateMembersDown((JSPsiElementBase)declaration, (Processor)processor);
        }), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, declaration.getProject());
    }

    private static boolean processUsages(@NotNull JSFunction declaration, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Ref<Boolean> usedOutsideBlockScope, @NotNull Ref<Boolean> hasReassignments) {
        if (declaration == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(8);
        }
        if (conflicts == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(9);
        }
        if (usedOutsideBlockScope == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(10);
        }
        if (hasReassignments == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(11);
        }
        int declarationStartOffset = declaration.getTextRange().getStartOffset();
        PsiFile declarationFile = declaration.getContainingFile();
        JSStatement expectedBlockScope = (JSStatement)ObjectUtils.tryCast((Object)JSVariableBaseImpl.getDeclarationScope((PsiElement)declaration, (boolean)true), JSStatement.class);
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> ReferencesSearch.search((PsiElement)declaration, (SearchScope)declaration.getUseScope()).forEach(reference -> {
            PsiElement refElement = reference.getElement();
            if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess(refElement) != ReadWriteAccessDetector.Access.Read) {
                hasReassignments.set((Object)true);
            }
            if (refElement.getContainingFile().isEquivalentTo((PsiElement)declarationFile) && refElement.getTextRange().getEndOffset() <= declarationStartOffset) {
                conflicts.putValue((Object)refElement, (Object)JavaScriptBundle.message((String)"js.named.to.function.hoisting.conflict.text", (Object[])new Object[0]));
            }
            if (expectedBlockScope != null && !PsiTreeUtil.isAncestor((PsiElement)expectedBlockScope, (PsiElement)refElement, (boolean)true)) {
                usedOutsideBlockScope.set((Object)true);
            }
            return true;
        })), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, declaration.getProject());
    }

    private static void performReplacement(@NotNull JSFunction function, boolean isClassMember, boolean usedOutsideBlockScope, boolean hasReassignments) {
        String typeText;
        JSVarStatement varStatement;
        boolean isAbstract;
        if (function == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(12);
        }
        PsiElement nameIdentifier = function.getNameIdentifier();
        assert (nameIdentifier != null);
        String functionName = nameIdentifier.getText();
        assert (functionName != null);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)function);
        JSAttributeList attributeList = function.getAttributeList();
        boolean bl = isAbstract = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
        if (isClassMember) {
            String memberBody = isAbstract ? functionName + semicolon : functionName + " = null" + semicolon;
            varStatement = (JSVarStatement)JSChangeUtil.createClassMemberPsiFromTextWithContext((String)memberBody, (PsiElement)function, JSVarStatement.class);
        } else {
            varStatement = (JSVarStatement)JSPsiElementFactory.createJSStatement((String)String.format("%s %s = null%s", JSNamedToFunctionExpressionIntention.getVarKeyword(dialectOptionHolder, usedOutsideBlockScope, hasReassignments).getText(), functionName, semicolon), (PsiElement)function, JSVarStatement.class);
        }
        assert (varStatement != null);
        JSVariable firstVariable = (JSVariable)ArrayUtil.getFirstElement((Object[])varStatement.getVariables());
        assert (firstVariable != null);
        JSExpression initializer = firstVariable.getInitializer();
        assert (initializer != null || isAbstract);
        JSFunctionsRefactoringUtil.moveNonFunctionAttributes((JSFunction)function, (JSAttributeListOwner)varStatement);
        JSRefactoringUtil.copyDecorators((JSAttributeListOwner)function, (JSAttributeListOwner)varStatement);
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)function);
        JSDocumentationUtils.copyJSDocComment((PsiComment)docComment, (PsiElement)varStatement);
        if (JSNamedToFunctionExpressionIntention.canConvertToArrowFunction(dialectOptionHolder, function)) {
            if (isAbstract) {
                JSType functionType = JSResolveUtil.getElementJSType((PsiElement)function);
                typeText = functionType != null ? functionType.getTypeText(JSType.TypeTextFormat.CODE) : "any";
                JSRefactoringUtil.setType((JSElement)firstVariable, (String)typeText);
            } else {
                initializer.replace((JSExpression)JSFunctionsRefactoringUtil.createArrowFunction((JSFunction)function));
            }
        } else {
            assert (initializer != null);
            initializer.replace((JSExpression)JSFunctionsRefactoringUtil.createAnonymousFunctionExpression((JSFunction)function));
        }
        typeText = function.getParent();
        if (typeText instanceof ES6ExportDefaultAssignment) {
            ES6ExportDefaultAssignment exportDefault = (ES6ExportDefaultAssignment)typeText;
            JSExpression expression = exportDefault.getExpression();
            assert (expression != null);
            expression.replace(JSPsiElementFactory.createJSExpression((String)functionName, (PsiElement)function));
            JSChangeUtil.doAddBefore((PsiElement)exportDefault.getParent(), (PsiElement)varStatement, (PsiElement)exportDefault);
        } else {
            function.replace((PsiElement)varStatement);
        }
    }

    @NotNull
    private static JSVarStatement.VarKeyword getVarKeyword(@Nullable DialectOptionHolder dialectOptionHolder, boolean usedOutsideBlockScope, boolean hasReassignments) {
        if (usedOutsideBlockScope) {
            JSVarStatement.VarKeyword varKeyword = JSVarStatement.VarKeyword.VAR;
            if (varKeyword == null) {
                JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(13);
            }
            return varKeyword;
        }
        if (hasReassignments) {
            JSVarStatement.VarKeyword varKeyword = DialectDetector.hasFeature((DialectOptionHolder)dialectOptionHolder, (JSLanguageFeature)JSLanguageFeature.LET_DEFINITIONS) ? JSVarStatement.VarKeyword.LET : JSVarStatement.VarKeyword.VAR;
            if (varKeyword == null) {
                JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(14);
            }
            return varKeyword;
        }
        JSVarStatement.VarKeyword varKeyword = DialectDetector.hasFeature((DialectOptionHolder)dialectOptionHolder, (JSLanguageFeature)JSLanguageFeature.CONST_DEFINITIONS) ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.VAR;
        if (varKeyword == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(15);
        }
        return varKeyword;
    }

    private static boolean canConvertToArrowFunction(@Nullable DialectOptionHolder dialect, @NotNull JSFunction declaration) {
        if (declaration == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(16);
        }
        return dialect != null && dialect.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS) && !declaration.isGenerator() && !declaration.isReferencesArguments() && (declaration.getParent() instanceof JSClass || PsiTreeUtil.findChildOfType((PsiElement)declaration, JSThisExpression.class) == null);
    }

    @Nullable
    static JSFunction getFunction(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(17);
        }
        if ((parent = element.getParent()) instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof TypeScriptTypeParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof TypeScriptTypeParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunctionDeclaration) {
            return (JSFunctionDeclaration)parent;
        }
        if (parent instanceof JSFunctionExpression && parent.getParent() instanceof ES6ExportDefaultAssignment) {
            return (JSFunctionExpression)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSNamedToFunctionExpressionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementations";
                break;
            }
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedOutsideBlockScope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasReassignments";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSNamedToFunctionExpressionIntention";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectImplementations";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performReplacement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canConvertToArrowFunction";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFunction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

