/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSCustomIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6IntroduceSpreadVariableHandler
implements JSCustomIntroduceVariableHandler {
    public static final String DEFAULT_VAR_NAME = "spreadElements";

    public boolean isAvailableOnEditorAndFile(@NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel;
        if (editor == null) {
            ES6IntroduceSpreadVariableHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ES6IntroduceSpreadVariableHandler.$$$reportNull$$$0(1);
        }
        if (!(selectionModel = editor.getSelectionModel()).hasSelection()) {
            return false;
        }
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        PsiElement scope = ES6IntroduceSpreadVariableHandler.getScope(file.findElementAt(start));
        if (scope == null || !DialectDetector.hasFeature((PsiElement)scope, (JSLanguageFeature)JSLanguageFeature.SHORTHAND_PROPERTY_NAMES)) {
            return false;
        }
        return ES6IntroduceSpreadVariableHandler.isAvailableFor(JSArrayLiteralExpression.class, a -> a.getExpressions(), file, start, end, true) || ES6IntroduceSpreadVariableHandler.isAvailableFor(JSObjectLiteralExpression.class, a -> a.getPropertiesIncludingSpreads(), file, start, end, false);
    }

    private static <T extends PsiElement> boolean isAvailableFor(Class<T> clazz, Function<? super T, ? extends PsiElement[]> subitemsFunc, @NotNull PsiFile file, int start, int end, boolean spreadAsLast) {
        PsiElement array;
        if (file == null) {
            ES6IntroduceSpreadVariableHandler.$$$reportNull$$$0(2);
        }
        if ((array = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(start), clazz, (boolean)true, (Class[])new Class[]{JSSourceElement.class})) == null) {
            return false;
        }
        return ES6IntroduceSpreadVariableHandler.isValidRangeIn(array, subitemsFunc, start, end, spreadAsLast);
    }

    private static <T extends PsiElement> boolean isValidRangeIn(T array, Function<? super T, ? extends PsiElement[]> subitemsFunc, int start, int end, boolean isArray) {
        int arrayEnd;
        TextRange selectionRange = new TextRange(start, end);
        if (selectionRange.contains(array.getTextRange())) {
            return false;
        }
        PsiElement parent = array.getParent();
        PsiElement nextSibling = parent == null ? null : parent.getNextSibling();
        int n = arrayEnd = PsiUtilCore.getElementType((PsiElement)nextSibling) == JSTokenTypes.SEMICOLON ? nextSibling.getTextRange().getEndOffset() : array.getTextRange().getEndOffset();
        if (arrayEnd < end) {
            return false;
        }
        PsiElement[] elements = (PsiElement[])subitemsFunc.fun(array);
        int count = 0;
        for (PsiElement expression : elements) {
            TextRange range = expression.getTextRange();
            if (range.getEndOffset() < start) continue;
            if (range.getStartOffset() > end) break;
            if (!selectionRange.contains(range)) {
                return false;
            }
            ++count;
        }
        return !isArray || count > 1;
    }

    public void invoke(@NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel;
        if (editor == null) {
            ES6IntroduceSpreadVariableHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ES6IntroduceSpreadVariableHandler.$$$reportNull$$$0(4);
        }
        if (!(selectionModel = editor.getSelectionModel()).hasSelection()) {
            return;
        }
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        Ref statementRef = Ref.create();
        ES6IntroduceSpreadVariableHandler.runWriteCommand(() -> statementRef.set((Object)ES6IntroduceSpreadVariableHandler.invokeFor(JSArrayLiteralExpression.class, "[", "]", file, start, end)));
        if (ES6IntroduceSpreadVariableHandler.rename(file, statementRef, editor, s -> s.getVariables()[0].getTextOffset())) {
            return;
        }
        ES6IntroduceSpreadVariableHandler.runWriteCommand(() -> statementRef.set((Object)ES6IntroduceSpreadVariableHandler.invokeFor(JSObjectLiteralExpression.class, "{", "}", file, start, end)));
        ES6IntroduceSpreadVariableHandler.rename(file, statementRef, editor, s -> s.getVariables()[0].getTextOffset());
    }

    static <T extends PsiElement> boolean rename(@NotNull PsiFile file, Ref<T> statementRef, Editor editor, Function<? super T, Integer> getOffset) {
        JSVariable newVariable;
        if (file == null) {
            ES6IntroduceSpreadVariableHandler.$$$reportNull$$$0(5);
        }
        if (statementRef.isNull()) {
            return false;
        }
        PsiElement statement = (PsiElement)statementRef.get();
        int offset = (Integer)getOffset.fun((Object)statement);
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return true;
        }
        PsiElement parent = element.getParent();
        JSVariable jSVariable = newVariable = parent instanceof JSReferenceExpression ? (JSVariable)ObjectUtils.tryCast((Object)((JSReferenceExpression)parent).resolve(), JSVariable.class) : (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)element, JSVariable.class);
        if (newVariable == null) {
            return true;
        }
        JSRefactoringUtil.suggestSameFileRename((PsiFile)file, (Editor)editor, (PsiNameIdentifierOwner)newVariable, (String)newVariable.getName());
        return true;
    }

    static void runWriteCommand(Runnable runnable) {
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(runnable));
    }

    private static JSVarStatement invokeFor(Class<? extends PsiElement> clazz, String lbrace, String rbrace, PsiFile file, int start, int end) {
        PsiElement scope;
        JSObjectLiteralExpression literal;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(start), clazz, (boolean)true, (Class[])new Class[]{JSSourceElement.class});
        if (parent == null) {
            return null;
        }
        String variableName = JSNameSuggestionsUtil.ensureUniqueVariableName((String)DEFAULT_VAR_NAME, (PsiElement)parent, (Collection)ContainerUtil.emptyList(), (boolean)false);
        String fileText = file.getText();
        start = ES6IntroduceSpreadVariableHandler.normalizeOffset(start, file, true);
        end = ES6IntroduceSpreadVariableHandler.normalizeOffset(end, file, false);
        String selectionText = fileText.substring(start, end);
        JSStatement newStatement = null;
        String variableKind = StringUtil.toLowerCase((String)JSIntroduceVariableHandler.getDefaultVariableType(parent).name());
        String otherName = null;
        boolean isSingle = false;
        if (clazz == JSObjectLiteralExpression.class && (literal = (JSObjectLiteralExpression)JSPsiElementFactory.createJSExpression((String)("{" + selectionText + "}"), (PsiElement)parent, JSObjectLiteralExpression.class)).getProperties().length == 1) {
            String uniqueName;
            JSProperty property = literal.getProperties()[0];
            String propertyName = property.getName();
            String string = uniqueName = propertyName == null ? null : JSNameSuggestionsUtil.ensureUniqueVariableName((String)propertyName, (PsiElement)parent, (Collection)ContainerUtil.emptyList(), (boolean)false);
            if (uniqueName != null) {
                isSingle = true;
                variableName = uniqueName;
                otherName = propertyName;
                JSExpression propertyValue = property.getValue();
                if (propertyValue == null) {
                    return null;
                }
                newStatement = JSPsiElementFactory.createJSStatement((String)(variableKind + " " + uniqueName + " = " + propertyValue.getText() + JSCodeStyleSettings.getSemicolon((PsiElement)parent)), (PsiElement)parent);
            }
        }
        if (newStatement == null) {
            newStatement = JSPsiElementFactory.createJSStatement((String)(variableKind + " " + variableName + " = " + lbrace + selectionText + rbrace + JSCodeStyleSettings.getSemicolon((PsiElement)parent)), (PsiElement)parent);
        }
        if ((scope = ES6IntroduceSpreadVariableHandler.getScope(parent)) == null) {
            return null;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, JSStatement.class);
        if (statement == null || !PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)statement, (boolean)false)) {
            return null;
        }
        SmartPsiElementPointer statementPointer = SmartPointerManager.createPointer((PsiElement)statement);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return null;
        }
        document.replaceString(start, end, (CharSequence)(isSingle ? (variableName.equals(otherName) ? variableName : otherName + ": " + variableName) : "..." + variableName));
        documentManager.commitDocument(document);
        PsiElement newElement = file.findElementAt(start);
        JSSpreadExpression spread = (JSSpreadExpression)PsiTreeUtil.getParentOfType((PsiElement)newElement, JSSpreadExpression.class, (boolean)false, (Class[])new Class[]{JSObjectLiteralExpression.class});
        SmartPsiElementPointer spreadPointer = spread != null ? SmartPointerManager.createPointer((PsiElement)spread) : null;
        statement = (JSStatement)statementPointer.getElement();
        assert (statement != null);
        JSVarStatement varStatement = (JSVarStatement)statement.addStatementBefore(newStatement);
        SmartPsiElementPointer varStatementPointer = SmartPointerManager.createPointer((PsiElement)varStatement);
        FormatFixer.create((PsiElement)varStatement, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        if (spreadPointer != null && spreadPointer.getElement() != null) {
            FormatFixer.create((PsiElement)spreadPointer.getElement(), (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        }
        return (JSVarStatement)varStatementPointer.getElement();
    }

    static int normalizeOffset(int end, PsiFile file, boolean start) {
        PsiElement endElement = file.findElementAt(end);
        if (ES6IntroduceSpreadVariableHandler.isLeafAfter(endElement, start)) {
            PsiElement psiElement = endElement = start ? endElement.getNextSibling().getFirstChild().getFirstChild() : ES6IntroduceSpreadVariableHandler.getLastGrandchild(endElement);
            if (endElement instanceof JSArrayLiteralExpression || endElement instanceof JSObjectLiteralExpression) {
                endElement = endElement.getLastChild();
            }
        }
        while (endElement instanceof PsiWhiteSpace || endElement instanceof PsiComment) {
            endElement = start ? endElement.getNextSibling() : endElement.getPrevSibling();
        }
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)endElement);
        if (elementType == JSTokenTypes.COMMA || elementType == (start ? JSTokenTypes.LBRACKET : JSTokenTypes.RBRACKET) || elementType == (start ? JSTokenTypes.LBRACE : JSTokenTypes.RBRACE)) {
            PsiElement psiElement = endElement = start ? endElement.getNextSibling() : endElement.getPrevSibling();
        }
        if (endElement == null) {
            return end;
        }
        TextRange range = endElement.getTextRange();
        return start ? range.getStartOffset() : range.getEndOffset();
    }

    private static PsiElement getLastGrandchild(PsiElement endElement) {
        PsiElement child = endElement.getPrevSibling().getLastChild();
        return child instanceof LeafPsiElement ? child.getPrevSibling().getLastChild() : child.getLastChild();
    }

    private static boolean isLeafAfter(PsiElement endElement, boolean start) {
        PsiElement child;
        PsiElement sibling;
        if (!(endElement instanceof LeafPsiElement)) {
            return false;
        }
        PsiElement psiElement = sibling = start ? endElement.getNextSibling() : endElement.getPrevSibling();
        if (sibling == null) {
            return false;
        }
        PsiElement psiElement2 = child = start ? sibling.getFirstChild() : sibling.getLastChild();
        if (!start && child instanceof LeafPsiElement) {
            child = child.getPrevSibling();
        }
        if (!start && child instanceof JSVariable) {
            child = ((JSVariable)child).getInitializer();
        }
        return child instanceof JSObjectLiteralExpression || child instanceof JSArrayLiteralExpression;
    }

    @Nullable
    static PsiElement getScope(PsiElement context) {
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)context, JSExecutionScope.class);
        if (scope != null && scope.getNode().getElementType() == JSElementTypes.EMBEDDED_EXPRESSION) {
            return PsiTreeUtil.getParentOfType((PsiElement)scope.getParent(), JSExecutionScope.class);
        }
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/ES6IntroduceSpreadVariableHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnEditorAndFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

