/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSChangeSignatureWithDelegationUpdateFix
extends JSChangeSignatureFix {
    private final SmartPsiElementPointer<JSCallExpression> myNode;
    private final String myCallName;

    public JSChangeSignatureWithDelegationUpdateFix(JSFunction function, JSFunction functionToTakeParameters, JSCallExpression node) {
        super(function, functionToTakeParameters.getParameterList());
        this.myNode = SmartPointerManager.createPointer((PsiElement)node);
        JSExpression methodExpression = node.getMethodExpression();
        this.myCallName = methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSSuperExpression ? "'" + methodExpression.getText() + "'" : JavaScriptBundle.message((String)"change.method.signature.delegating.default.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            JSChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(0);
        }
        if (this.myNode.getElement() == null) {
            return false;
        }
        return super.isAvailable(project, editor, psiFile);
    }

    @Override
    public void invoke(PsiElement context) throws IncorrectOperationException {
        JSParameterList parameterList = this.myExpectedParameterList != null ? (JSParameterList)this.myExpectedParameterList.getElement() : null;
        JSFunction function = this.getFunction();
        if (parameterList == null || function == null) {
            return;
        }
        List<JSParameterInfo> parameterInfos = JSChangeSignatureWithDelegationUpdateFix.createParameterInfos(parameterList);
        this.runSilently(parameterInfos, function);
        ApplicationManager.getApplication().runWriteAction(() -> {
            JSCallExpression element = (JSCallExpression)this.myNode.getElement();
            assert (element != null);
            JSExpression expression = element.getMethodExpression();
            StringBuilder builder = new StringBuilder();
            if (element instanceof JSNewExpression) {
                builder.append("new ");
            }
            assert (expression != null);
            builder.append(expression.getText());
            builder.append(JSChangeSignatureWithDelegationUpdateFix.createParameterList(element, parameterInfos));
            JSChangeUtil.replaceExpression((JSExpression)element, (JSExpression)JSPsiElementFactory.createJSExpression((String)builder.toString(), (PsiElement)element));
        });
    }

    @NotNull
    private static List<JSParameterInfo> createParameterInfos(JSParameterList parameterList) {
        List list = ContainerUtil.map((Object[])parameterList.getParameters(), p -> JSParameterInfo.build(p, -1));
        if (list == null) {
            JSChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static String createParameterList(JSCallExpression element, List<? extends JSParameterInfo> parameterInfos) {
        JSExpression[] arguments = element.getArguments();
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (JSExpression arg : arguments) {
            builder.append(arg.getText());
            builder.append(',');
        }
        for (int i = arguments.length; i < parameterInfos.size(); ++i) {
            builder.append(parameterInfos.get(i).getName());
            if (i >= parameterInfos.size() - 1) continue;
            builder.append(',');
        }
        return StringUtil.trimEnd((String)builder.toString(), (char)',') + ")";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"change.method.signature.and.update.delegating.call.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            JSChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        JSFunction function = this.getFunction();
        if (function == null) {
            String string = JavaScriptBundle.message((String)"change.method.signature.and.update.delegating.call.noname.fix.text", (Object[])new Object[]{this.myCallName});
            if (string == null) {
                JSChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = JavaScriptBundle.message((String)"change.method.signature.and.update.delegating.call.fix.text", (Object[])new Object[]{JSFormatUtil.formatMethod((JSFunctionItem)function, (int)4353, (int)0, (int)0, null), this.myCallName});
        if (string == null) {
            JSChangeSignatureWithDelegationUpdateFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSChangeSignatureWithDelegationUpdateFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSChangeSignatureWithDelegationUpdateFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterInfos";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

