/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.Dbms;
import com.intellij.database.actions.BasicElementAction;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001c\u0010\f\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0014J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/actions/HideSchemasAction;", "Lcom/intellij/database/actions/BasicElementAction;", "Lcom/intellij/database/model/basic/BasicNamespace;", "<init>", "()V", "expandGroupItems", "", "getExpandGroupItems", "()Z", "cast", "node", "Lcom/intellij/database/model/basic/BasicNode;", "enabled", "selection", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicModel;", "doIt", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.impl"})
public final class HideSchemasAction
extends BasicElementAction<BasicNamespace> {
    @Override
    protected boolean getExpandGroupItems() {
        return false;
    }

    @Override
    @Nullable
    protected BasicNamespace cast(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof BasicNamespace ? (BasicNamespace)node : null;
    }

    @Override
    protected boolean enabled(@NotNull MultiMap<BasicModel, BasicNamespace> selection) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        for (BasicNamespace element : selection.values()) {
            if (!Intrinsics.areEqual((Object)element.getKind(), (Object)ObjectKind.DATABASE) || !element.isCurrent()) continue;
            BasicModel basicModel = element.getModel();
            if (!Intrinsics.areEqual((Object)(basicModel != null ? basicModel.getDbms() : null), (Object)Dbms.POSTGRES)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doIt(@NotNull AnActionEvent e, @NotNull Project project, @NotNull MultiMap<BasicModel, BasicNamespace> selection) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        for (LocalDataSource dataSource : DataSourceStorage.getProjectStorage((Project)project).getDataSources()) {
            DasModel model;
            if (dataSource == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)dataSource.getModel(), (String)"getModel(...)");
            if (!(model instanceof BasicModel) || !selection.containsKey((Object)model)) continue;
            DataSourceUtil.setNamespacesVisible((Project)project, (LocalDataSource)dataSource, (Iterable)selection.get((Object)model), (boolean)false);
        }
    }
}

