/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyTypeKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u0014\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u0096\u0080\u0004J\n\u0010 \u001a\u00020\tH\u0096\u0080\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/microservices/jvm/config/MetaConfigKeyType;", "", "psiType", "Lcom/intellij/psi/PsiType;", "accessType", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$AccessType;", "project", "Lcom/intellij/openapi/project/Project;", "keyName", "", "<init>", "(Lcom/intellij/psi/PsiType;Lcom/intellij/microservices/jvm/config/MetaConfigKey$AccessType;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getAccessType", "()Lcom/intellij/microservices/jvm/config/MetaConfigKey$AccessType;", "typePointer", "Lcom/intellij/psi/SmartTypePointer;", "effectiveValueTypePointer", "getEffectiveValueTypePointer", "()Lcom/intellij/psi/SmartTypePointer;", "effectiveValueTypePointer$delegate", "Lkotlin/Lazy;", "mapKeyClassPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiClass;", "getType", "getEffectiveValueType", "getMapKeyClass", "equals", "", "other", "hashCode", "", "toString", "intellij.microservices.config"})
@SourceDebugExtension(value={"SMAP\nMetaConfigKeyType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaConfigKeyType.kt\ncom/intellij/microservices/jvm/config/MetaConfigKeyType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n1#2:90\n13#3:91\n13#3:92\n*S KotlinDebug\n*F\n+ 1 MetaConfigKeyType.kt\ncom/intellij/microservices/jvm/config/MetaConfigKeyType\n*L\n51#1:91\n61#1:92\n*E\n"})
public final class MetaConfigKeyType {
    @NotNull
    private final Project project;
    @NotNull
    private final String keyName;
    @NotNull
    private final MetaConfigKey.AccessType accessType;
    @Nullable
    private final SmartTypePointer typePointer;
    @NotNull
    private final Lazy effectiveValueTypePointer$delegate;
    @Nullable
    private final SmartPsiElementPointer<PsiClass> mapKeyClassPointer;

    /*
     * WARNING - void declaration
     */
    public MetaConfigKeyType(@Nullable PsiType psiType, @NotNull MetaConfigKey.AccessType accessType, @NotNull Project project, @NotNull String keyName) {
        SmartTypePointer smartTypePointer;
        Intrinsics.checkNotNullParameter((Object)((Object)accessType), (String)"accessType");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
        this.project = project;
        this.keyName = keyName;
        MetaConfigKeyType metaConfigKeyType = this;
        PsiType psiType2 = psiType;
        if (psiType2 != null) {
            void it;
            PsiType psiType3 = psiType2;
            MetaConfigKeyType metaConfigKeyType2 = metaConfigKeyType;
            boolean bl = false;
            smartTypePointer = SmartTypePointerManager.getInstance((Project)this.project).createSmartTypePointer((PsiType)it);
            metaConfigKeyType = metaConfigKeyType2;
        } else {
            smartTypePointer = null;
        }
        metaConfigKeyType.typePointer = smartTypePointer;
        this.effectiveValueTypePointer$delegate = LazyKt.lazy(() -> MetaConfigKeyType.effectiveValueTypePointer_delegate$lambda$0(this, accessType));
        if (accessType == MetaConfigKey.AccessType.MAP) {
            PsiClass mapKeyClass = MetaConfigKeyTypeKt.access$getMapKeyClass(psiType);
            boolean isEnumMapKeyType = mapKeyClass != null && mapKeyClass.isEnum();
            PsiClass psiClass = mapKeyClass;
            this.mapKeyClassPointer = psiClass != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)psiClass)) : null;
            this.accessType = isEnumMapKeyType ? MetaConfigKey.AccessType.ENUM_MAP : accessType;
        } else {
            this.mapKeyClassPointer = null;
            this.accessType = accessType;
        }
    }

    @NotNull
    public final MetaConfigKey.AccessType getAccessType() {
        return this.accessType;
    }

    private final SmartTypePointer getEffectiveValueTypePointer() {
        Lazy lazy = this.effectiveValueTypePointer$delegate;
        return (SmartTypePointer)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiType getType() {
        PsiType psiType;
        SmartTypePointer smartTypePointer = this.typePointer;
        if (smartTypePointer != null) {
            void var3_3;
            SmartTypePointer it = smartTypePointer;
            boolean bl = false;
            PsiType type = it.getType();
            if (type == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(MetaConfigKeyType.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Invalid meta config key type for key '" + this.keyName + "'");
            }
            psiType = var3_3;
        } else {
            psiType = null;
        }
        return psiType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiType getEffectiveValueType() {
        PsiType psiType;
        SmartTypePointer smartTypePointer = this.getEffectiveValueTypePointer();
        if (smartTypePointer != null) {
            void var3_3;
            SmartTypePointer it = smartTypePointer;
            boolean bl = false;
            PsiType type = it.getType();
            if (type == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(MetaConfigKeyType.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Invalid meta config key effective value type for key '" + this.keyName + "'");
            }
            psiType = var3_3;
        } else {
            psiType = null;
        }
        return psiType;
    }

    @Nullable
    public final PsiClass getMapKeyClass() {
        SmartPsiElementPointer<PsiClass> smartPsiElementPointer = this.mapKeyClassPointer;
        return smartPsiElementPointer != null ? (PsiClass)smartPsiElementPointer.dereference() : null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetaConfigKeyType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.keyName, (Object)((MetaConfigKeyType)other).keyName)) {
            return false;
        }
        if (this.accessType != ((MetaConfigKeyType)other).accessType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getType(), (Object)((MetaConfigKeyType)other).getType());
    }

    public int hashCode() {
        int result = this.keyName.hashCode();
        result = 31 * result + this.accessType.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "MetaConfigKeyType(project=" + this.project + ", keyName='" + this.keyName + "', accessType=" + this.accessType + ", type=" + this.getType() + ", mapKeyClass=" + this.getMapKeyClass() + ")";
    }

    private static final SmartTypePointer effectiveValueTypePointer_delegate$lambda$0(MetaConfigKeyType this$0, MetaConfigKey.AccessType $accessType) {
        SmartTypePointer smartTypePointer = this$0.typePointer;
        if (smartTypePointer == null || (smartTypePointer = smartTypePointer.getType()) == null) {
            return null;
        }
        SmartTypePointer type = smartTypePointer;
        PsiType psiType = $accessType.getEffectiveValueType((PsiType)type);
        if (psiType == null) {
            return null;
        }
        PsiType effectiveValueType = psiType;
        return SmartTypePointerManager.getInstance((Project)this$0.project).createSmartTypePointer(effectiveValueType);
    }
}

