/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.gradle.dependencies.build;

import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.intellij.microservices.jvm.dependencies.build.BuildFileChecker;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/microservices/jvm/gradle/dependencies/build/GradleFileChecker;", "Lcom/intellij/microservices/jvm/dependencies/build/BuildFileChecker;", "<init>", "()V", "supports", "", "module", "Lcom/intellij/openapi/module/Module;", "isBuildFile", "file", "Lcom/intellij/psi/PsiFile;", "adjustModule", "getRelatedModules", "", "findRelatedModule", "qualifier", "", "isDependenciesElement", "element", "Lcom/intellij/psi/PsiElement;", "intellij.microservices.jvm.gradle"})
public final class GradleFileChecker
implements BuildFileChecker {
    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return Intrinsics.areEqual((Object)GradleConstants.SYSTEM_ID.getId(), (Object)ExternalSystemModulePropertyManager.Companion.getInstance(module).getExternalSystemId());
    }

    @Override
    public boolean isBuildFile(@NotNull Module module, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ExternalSystemModulePropertyManager propertyManager = ExternalSystemModulePropertyManager.Companion.getInstance(module);
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        VirtualFile virtualFile3 = virtualFile2.getParent();
        if (virtualFile3 == null) {
            return false;
        }
        VirtualFile parent = virtualFile3;
        if (!Intrinsics.areEqual((Object)parent.getPath(), (Object)propertyManager.getLinkedProjectPath())) {
            return false;
        }
        String string = virtualFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        return Intrinsics.areEqual((Object)"build.gradle", (Object)fileName) || Intrinsics.areEqual((Object)"build.gradle.kts", (Object)fileName);
    }

    @Override
    @NotNull
    public Module adjustModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Module module2 = this.findRelatedModule(module, "main");
        if (module2 == null) {
            module2 = module;
        }
        return module2;
    }

    @Override
    @NotNull
    public List<Module> getRelatedModules(@NotNull Module module) {
        Module testModule;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Module module2 = testModule = this.findRelatedModule(module, "test");
        return module2 != null ? CollectionsKt.listOf((Object)module2) : CollectionsKt.emptyList();
    }

    private final Module findRelatedModule(Module module, String qualifier) {
        Module module2;
        block2: {
            DataNode dataNode = GradleUtil.findGradleModuleData((Module)module);
            if (dataNode == null) {
                return null;
            }
            DataNode dataNode2 = dataNode;
            String mainSourceSetModuleId = ((ModuleData)dataNode2.getData()).getId() + ":" + qualifier;
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Module[] moduleArray = ModuleManager.Companion.getInstance(project).getModules();
            int n = moduleArray.length;
            for (int i = 0; i < n; ++i) {
                Module module3;
                Module candidate = module3 = moduleArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)mainSourceSetModuleId, (Object)ExternalSystemApiUtil.getExternalProjectId((Module)candidate))) continue;
                module2 = module3;
                break block2;
            }
            module2 = null;
        }
        return module2;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDependenciesElement(@NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        DependenciesModel dependenciesModel = ProjectBuildModel.get((Project)file.getProject()).getModuleBuildModel(virtualFile2).dependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependenciesModel, (String)"dependencies(...)");
        DependenciesModel dependenciesModel2 = dependenciesModel;
        String string = virtualFile2.getName();
        switch (string.hashCode()) {
            case -2062421629: {
                if (string.equals("build.gradle.kts")) break;
                return false;
            }
            case -1995398201: {
                if (!string.equals("build.gradle")) return false;
                PsiElement psiElement = dependenciesModel2.getPsiElement();
                bl = Intrinsics.areEqual((Object)element, (Object)(psiElement != null ? psiElement.getFirstChild() : null));
                return bl;
            }
        }
        PsiElement psiElement = dependenciesModel2.getPsiElement();
        bl = Intrinsics.areEqual((Object)element, psiElement != null && (psiElement = psiElement.getParent()) != null ? psiElement.getFirstChild() : null);
        return bl;
        return false;
    }
}

