/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.yaml.cron;

import com.intellij.cron.CronDefinitionExpressionProvider;
import com.intellij.lang.Language;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.microservices.jvm.cron.PropertyReferenceCronUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/microservices/jvm/yaml/cron/YamlReferenceCronExpressionProvider;", "Lcom/intellij/cron/CronDefinitionExpressionProvider;", "<init>", "()V", "languages", "", "Lcom/intellij/lang/Language;", "getLanguages", "()Ljava/util/Collection;", "supportId", "", "getSupportId", "()Ljava/lang/String;", "isSuitableElement", "", "element", "Lcom/intellij/psi/PsiElement;", "hasPropertyReference", "value", "getCronExpression", "intellij.microservices.jvm.yaml"})
@SourceDebugExtension(value={"SMAP\nYamlReferenceCronExpressionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlReferenceCronExpressionProvider.kt\ncom/intellij/microservices/jvm/yaml/cron/YamlReferenceCronExpressionProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n19#2:44\n19#2:45\n1#3:46\n*S KotlinDebug\n*F\n+ 1 YamlReferenceCronExpressionProvider.kt\ncom/intellij/microservices/jvm/yaml/cron/YamlReferenceCronExpressionProvider\n*L\n22#1:44\n38#1:45\n*E\n"})
public abstract class YamlReferenceCronExpressionProvider
implements CronDefinitionExpressionProvider {
    @NotNull
    private final Collection<Language> languages = CollectionsKt.listOf((Object)YAMLLanguage.INSTANCE);
    @NotNull
    private final String supportId;

    public YamlReferenceCronExpressionProvider() {
        this.supportId = "yaml";
    }

    @NotNull
    public Collection<Language> getLanguages() {
        return this.languages;
    }

    @NotNull
    public String getSupportId() {
        return this.supportId;
    }

    public boolean isSuitableElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$asSafely$iv = element;
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof YAMLScalar)) {
            psiElement = null;
        }
        YAMLScalar yAMLScalar = (YAMLScalar)psiElement;
        if (yAMLScalar == null) {
            return false;
        }
        YAMLScalar property = yAMLScalar;
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)property), YAMLKeyValue.class);
        if (yAMLKeyValue == null) {
            return false;
        }
        YAMLKeyValue yamlKeyValue = yAMLKeyValue;
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedConfigKeyName(...)");
        String qualifiedConfigKeyName = string;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        if (this.hasPropertyReference(property.getTextValue())) {
            return false;
        }
        return PropertyReferenceCronUtilsKt.isCronReferenceValue(module2, qualifiedConfigKeyName);
    }

    private final boolean hasPropertyReference(String value) {
        if (value == null) {
            return false;
        }
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)value, (String)"${", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        Set propertyPlaceholderRange = set;
        return !((Collection)propertyPlaceholderRange).isEmpty();
    }

    @Nullable
    public String getCronExpression(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$asSafely$iv = element;
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof YAMLScalar)) {
            psiElement = null;
        }
        YAMLScalar yAMLScalar = (YAMLScalar)psiElement;
        if (yAMLScalar == null) {
            return null;
        }
        YAMLScalar yamlScalar = yAMLScalar;
        String string2 = yamlScalar.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextValue(...)");
        String value = string2;
        if (this.hasPropertyReference(value)) {
            return null;
        }
        String it = string = ((Object)StringsKt.trim((CharSequence)value)).toString();
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }
}

