/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.CustomModuleEntitySource;
import com.intellij.platform.workspace.jps.JpsFileDependentEntitySource;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.ExtensionsKt;
import com.intellij.platform.workspace.jps.entities.FacetEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleGroupPathEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.jps.serialization.SerializationContext;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsModuleListSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ModuleImlFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0010\u0018\u0000 52\u00020\u0001:\u00015B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010 \u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u00030\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u001e\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190*2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u0019H\u0014J\u0018\u00100\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u00101\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0019H\u0002J\n\u00104\u001a\u00020\u0003H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;", "fileUrl", "", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "externalModuleListSerializer", "<init>", "(Ljava/lang/String;Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;)V", "getFileUrl", "()Ljava/lang/String;", "getContext", "()Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "isExternalStorage", "", "()Z", "componentName", "getComponentName", "entitySourceFilter", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "getEntitySourceFilter", "()Lkotlin/jvm/functions/Function1;", "getFileName", "entity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "createSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "internalSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "moduleGroup", "loadFileList", "", "Lkotlin/Pair;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "saveEntityList", "", "entities", "Lkotlin/sequences/Sequence;", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "getSourceToSave", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$FileInDirectory;", "module", "deleteObsoleteFile", "manuallyRemoveImlFile", "getModuleFileUrl", "source", "toString", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nModuleImlFileEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleImlFileEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1228:1\n1586#2:1229\n1661#2,3:1230\n1068#2:1239\n1915#2,2:1240\n1807#2,3:1242\n1807#2,3:1245\n1807#2,3:1248\n1807#2,3:1251\n1172#3:1233\n1342#3:1234\n1343#3:1237\n1173#3:1238\n1#4:1235\n1#4:1236\n*S KotlinDebug\n*F\n+ 1 ModuleImlFileEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl\n*L\n1140#1:1229\n1140#1:1230,3\n1155#1:1239\n1160#1:1240,2\n1149#1:1242,3\n1150#1:1245,3\n1151#1:1248,3\n1152#1:1251,3\n1154#1:1233\n1154#1:1234\n1154#1:1237\n1154#1:1238\n1154#1:1236\n*E\n"})
public class ModuleListSerializerImpl
implements JpsModuleListSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileUrl;
    @NotNull
    private final SerializationContext context;
    @Nullable
    private final JpsModuleListSerializer externalModuleListSerializer;

    public ModuleListSerializerImpl(@NotNull String fileUrl, @NotNull SerializationContext context, @Nullable JpsModuleListSerializer externalModuleListSerializer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.fileUrl = fileUrl;
        this.context = context;
        this.externalModuleListSerializer = externalModuleListSerializer;
    }

    public /* synthetic */ ModuleListSerializerImpl(String string, SerializationContext serializationContext, JpsModuleListSerializer jpsModuleListSerializer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            jpsModuleListSerializer = null;
        }
        this(string, serializationContext, jpsModuleListSerializer);
    }

    @Override
    @NotNull
    public String getFileUrl() {
        return this.fileUrl;
    }

    @NotNull
    protected final SerializationContext getContext() {
        return this.context;
    }

    @Override
    public boolean isExternalStorage() {
        return false;
    }

    @NotNull
    public String getComponentName() {
        return "ProjectModuleManager";
    }

    @Override
    @NotNull
    public Function1<EntitySource, Boolean> getEntitySourceFilter() {
        return ModuleListSerializerImpl::_get_entitySourceFilter_$lambda$0;
    }

    @Override
    @NotNull
    public String getFileName(@NotNull ModuleEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getName() + ".iml";
    }

    @Override
    @NotNull
    public JpsFileEntitiesSerializer<ModuleEntity> createSerializer(@NotNull JpsFileEntitySource internalSource, @NotNull VirtualFileUrl fileUrl, @Nullable String moduleGroup) {
        Intrinsics.checkNotNullParameter((Object)internalSource, (String)"internalSource");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        return Companion.createModuleEntitiesSerializer$intellij_platform_workspace_jps(fileUrl, moduleGroup, internalSource, this.context, this, this.externalModuleListSerializer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<VirtualFileUrl, String>> loadFileList(@NotNull JpsFileContentReader reader, @NotNull VirtualFileUrlManager virtualFileManager) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        Element element = JpsFileContentReader.loadComponent$default(reader, this.getFileUrl(), this.getComponentName(), null, 4, null);
        if (element == null) {
            return CollectionsKt.emptyList();
        }
        Element moduleManagerTag = element;
        Iterable $this$map$iv = ModulePath.Companion.getPathsToModuleFiles(moduleManagerTag);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModulePath modulePath = (ModulePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)virtualFileManager.getOrCreateFromUrl("file://" + it.getPath()), (Object)it.getGroup()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveEntityList(@NotNull Sequence<? extends ModuleEntity> entities, @NotNull JpsFileContentWriter writer) {
        void $this$sortedBy$iv;
        ModuleEntity module;
        Iterable $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Sequence sequence = SequencesKt.filter(entities, arg_0 -> ModuleListSerializerImpl.saveEntityList$lambda$0(this, arg_0));
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            module = (ModuleEntity)element$iv;
            boolean bl2 = false;
            if (this.getSourceToSave(module) != null) {
                JpsProjectFileEntitySource.FileInDirectory it;
                boolean bl3 = false;
                pair = new Pair((Object)it, (Object)module);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv = pair;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        List entitiesToSave = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((ModuleEntity)it.getSecond()).getName());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((ModuleEntity)it.getSecond()).getName())));
            }
        });
        Element componentTag2 = null;
        if (!((Collection)entitiesToSave).isEmpty()) {
            void $this$forEach$iv;
            Element modulesTag = new Element("modules");
            Iterable $i$f$mapNotNullTo2 = entitiesToSave;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                JpsProjectFileEntitySource.FileInDirectory source = (JpsProjectFileEntitySource.FileInDirectory)pair.component1();
                module = (ModuleEntity)pair.component2();
                Element moduleTag = new Element("module");
                String fileUrl = this.getModuleFileUrl(source, module);
                moduleTag.setAttribute("fileurl", fileUrl);
                moduleTag.setAttribute("filepath", JpsPathUtil.urlToPath((String)fileUrl));
                if (ModuleExtensions.getGroupPath(module) != null) {
                    ModuleGroupPathEntity it;
                    boolean bl5 = false;
                    moduleTag.setAttribute("group", CollectionsKt.joinToString$default((Iterable)it.getPath(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
                }
                modulesTag.addContent(moduleTag);
            }
            componentTag2 = JDomSerializationUtil.createComponentElement((String)this.getComponentName());
            componentTag2.addContent(modulesTag);
        } else {
            componentTag2 = null;
        }
        writer.saveComponent(this.getFileUrl(), this.getComponentName(), componentTag2);
    }

    @Nullable
    protected JpsProjectFileEntitySource.FileInDirectory getSourceToSave(@NotNull ModuleEntity module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        EntitySource entitySource = module.getEntitySource();
        if (entitySource instanceof CustomModuleEntitySource) {
            JpsFileEntitySource jpsFileEntitySource = ((CustomModuleEntitySource)entitySource).getInternalSource();
            return jpsFileEntitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)jpsFileEntitySource : null;
        }
        if (entitySource instanceof JpsFileDependentEntitySource) {
            JpsFileEntitySource jpsFileEntitySource = ((JpsFileDependentEntitySource)((Object)entitySource)).getOriginalSource();
            return jpsFileEntitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)jpsFileEntitySource : null;
        }
        return entitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)entitySource : null;
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.saveComponent(fileUrl, "FacetManager", null);
        writer.saveComponent(fileUrl, "NewModuleRootManager", null);
        writer.saveComponent(fileUrl, "DeprecatedModuleOptionManager", null);
        writer.saveComponent(fileUrl, "TestModuleProperties", null);
        writer.saveComponent(fileUrl, "AdditionalModuleElements", null);
        this.manuallyRemoveImlFile(fileUrl);
    }

    private final void manuallyRemoveImlFile(String fileUrl) {
        String string = JpsPathUtil.urlToPath((String)fileUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)((Object)path2).toString(), (Object)((Object)path2.toRealPath(new LinkOption[0])).toString())) {
            Files.deleteIfExists(path2);
        }
    }

    private final String getModuleFileUrl(JpsProjectFileEntitySource.FileInDirectory source, ModuleEntity module) {
        return source.getDirectory().getUrl() + "/" + module.getName() + ".iml";
    }

    @NotNull
    public String toString() {
        return "ModuleListSerializerImpl(" + this.getFileUrl() + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _get_entitySourceFilter_$lambda$0(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof JpsFileEntitySource) return true;
        if (it instanceof CustomModuleEntitySource) return true;
        if (!(it instanceof JpsFileDependentEntitySource)) return false;
        if (!(it instanceof JpsImportedEntitySource)) return true;
        JpsImportedEntitySource jpsImportedEntitySource = (JpsImportedEntitySource)it;
        if (jpsImportedEntitySource == null) return true;
        if (!jpsImportedEntitySource.getStoredExternally()) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean saveEntityList$lambda$0(ModuleListSerializerImpl this$0, ModuleEntity moduleEntity) {
        FacetEntity it;
        boolean bl;
        boolean bl2;
        ContentRootEntity cr;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        if ((Boolean)this$0.getEntitySourceFilter().invoke((Object)moduleEntity.getEntitySource()) != false) return true;
        Iterable $this$any$iv = moduleEntity.getContentRoots();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl3 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                cr = (ContentRootEntity)element$iv;
                boolean bl4 = false;
                if (!((Boolean)this$0.getEntitySourceFilter().invoke((Object)cr.getEntitySource())).booleanValue()) continue;
                return true;
            }
            bl3 = false;
        }
        if (bl3) return true;
        $this$any$iv = ExtensionsKt.getSourceRoots(moduleEntity);
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                SourceRootEntity sr = (SourceRootEntity)element$iv;
                boolean bl5 = false;
                if (!((Boolean)this$0.getEntitySourceFilter().invoke((Object)sr.getEntitySource())).booleanValue()) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = moduleEntity.getContentRoots();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                boolean bl6;
                cr = (ContentRootEntity)element$iv;
                boolean bl7 = false;
                Iterable $this$any$iv2 = cr.getExcludedUrls();
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl6 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        ExcludeUrlEntity ex = (ExcludeUrlEntity)element$iv2;
                        boolean bl8 = false;
                        if (!((Boolean)this$0.getEntitySourceFilter().invoke((Object)ex.getEntitySource())).booleanValue()) continue;
                        return true;
                    }
                    bl6 = false;
                }
                if (!bl6) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = moduleEntity.getFacets();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (FacetEntity)element$iv;
            boolean bl9 = false;
        } while (!((Boolean)this$0.getEntitySourceFilter().invoke((Object)it.getEntitySource())).booleanValue());
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl$Companion;", "", "<init>", "()V", "createModuleEntitiesSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleImlFileEntitiesSerializer;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "moduleGroup", "", "source", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "internalModuleListSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;", "externalModuleListSerializer", "createModuleEntitiesSerializer$intellij_platform_workspace_jps", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleImlFileEntitiesSerializer createModuleEntitiesSerializer$intellij_platform_workspace_jps(@NotNull VirtualFileUrl fileUrl, @Nullable String moduleGroup, @NotNull JpsFileEntitySource source, @NotNull SerializationContext context, @Nullable JpsModuleListSerializer internalModuleListSerializer, @Nullable JpsModuleListSerializer externalModuleListSerializer) {
            Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = JpsPathUtil.urlToPath((String)fileUrl.getUrl());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
            return new ModuleImlFileEntitiesSerializer(new ModulePath(string, moduleGroup), fileUrl, source, context, internalModuleListSerializer, externalModuleListSerializer);
        }

        public static /* synthetic */ ModuleImlFileEntitiesSerializer createModuleEntitiesSerializer$intellij_platform_workspace_jps$default(Companion companion, VirtualFileUrl virtualFileUrl, String string, JpsFileEntitySource jpsFileEntitySource, SerializationContext serializationContext, JpsModuleListSerializer jpsModuleListSerializer, JpsModuleListSerializer jpsModuleListSerializer2, int n, Object object) {
            if ((n & 0x10) != 0) {
                jpsModuleListSerializer = null;
            }
            if ((n & 0x20) != 0) {
                jpsModuleListSerializer2 = null;
            }
            return companion.createModuleEntitiesSerializer$intellij_platform_workspace_jps(virtualFileUrl, string, jpsFileEntitySource, serializationContext, jpsModuleListSerializer, jpsModuleListSerializer2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

