/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.util.Key;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.impl.VersionedEntityStorageImpl;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class IntelliJProjectUtil {
    private static final Key<Boolean> IDEA_PROJECT = Key.create((String)"idea.internal.inspections.enabled");
    private static final Key<Boolean> PLUGIN_PROJECT = Key.create((String)"ij.platform.plugin.project");
    private static final String[] IDEA_PROJECT_MARKER_MODULE_NAMES = new String[]{"intellij.idea.community.main", "intellij.platform.commercial", "intellij.android.studio.integration", "community.platform.platform-api.ide"};
    private static final CachedValue<Boolean> isIntelliJPlatformProjectValue = new CachedValue(storage -> ContainerUtil.exists((Object[])IDEA_PROJECT_MARKER_MODULE_NAMES, marker -> storage.resolve((SymbolicEntityId)new ModuleId(marker)) != null));

    public static boolean isIntelliJPlatformProject(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        VersionedEntityStorageImpl storage = ((WorkspaceModelInternal)WorkspaceModel.getInstance((Project)project)).getEntityStorage();
        return (Boolean)storage.cachedValue(isIntelliJPlatformProjectValue) != false || Boolean.TRUE.equals(project.getUserData(IDEA_PROJECT));
    }

    public static boolean isIntelliJPluginProject(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        Boolean flag = (Boolean)project.getUserData(PLUGIN_PROJECT);
        if (flag == null) {
            flag = ContainerUtil.exists((Iterable)ProjectTypeService.getProjectTypes((Project)project), type -> "INTELLIJ_PLUGIN".equals(type.getId()));
            project.putUserData(PLUGIN_PROJECT, (Object)flag);
        }
        return flag;
    }

    @TestOnly
    public static void markAsIntelliJPlatformProject(@NotNull Project project, Boolean value) {
        if (project == null) {
            IntelliJProjectUtil.$$$reportNull$$$0(0);
        }
        project.putUserData(IDEA_PROJECT, (Object)value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/IntelliJProjectUtil", "markAsIntelliJPlatformProject"));
    }
}

