/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MatchingHandler {
    protected NodeFilter filter;
    private PsiElement pinnedElement;
    protected static ClearStateVisitor clearingVisitor = new ClearStateVisitor();

    public void setFilter(@Nullable NodeFilter filter) {
        this.filter = filter;
    }

    public boolean match(PsiElement patternNode, PsiElement matchedNode, @NotNull MatchContext context) {
        if (context == null) {
            MatchingHandler.$$$reportNull$$$0(0);
        }
        return patternNode == null ? matchedNode == null : this.canMatch(patternNode, matchedNode, context);
    }

    public boolean canMatch(@NotNull PsiElement patternNode, PsiElement matchedNode, @NotNull MatchContext context) {
        if (patternNode == null) {
            MatchingHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MatchingHandler.$$$reportNull$$$0(2);
        }
        return this.filter != null ? this.filter.accepts(matchedNode) : DefaultFilter.accepts(patternNode, matchedNode);
    }

    public boolean matchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes, @NotNull MatchContext context) {
        if (patternNodes == null) {
            MatchingHandler.$$$reportNull$$$0(3);
        }
        if (matchNodes == null) {
            MatchingHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            MatchingHandler.$$$reportNull$$$0(5);
        }
        MatchingStrategy strategy = context.getPattern().getStrategy();
        PsiElement currentPatternNode = patternNodes.current();
        PsiElement currentMatchNode = matchNodes.current();
        MatchingHandler.skipIfNecessary(matchNodes, currentPatternNode, strategy);
        MatchingHandler.skipIfNecessary(patternNodes, matchNodes.current(), strategy);
        if (!patternNodes.hasNext()) {
            return !matchNodes.hasNext();
        }
        PsiElement patternElement = patternNodes.current();
        MatchingHandler handler = context.getPattern().getHandler(patternElement);
        if (!(handler instanceof TopLevelMatchingHandler)) {
            MatchingHandler.skipComments(matchNodes, currentPatternNode);
        }
        if (matchNodes.hasNext() && handler.match(patternElement, matchNodes.current(), context)) {
            patternNodes.advance();
            MatchingHandler.skipIfNecessary(patternNodes, matchNodes.current(), strategy);
            if (this.shouldAdvanceTheMatchFor(patternElement, matchNodes.current())) {
                matchNodes.advance();
                MatchingHandler.skipIfNecessary(matchNodes, patternNodes.current(), strategy);
                if (patternNodes.hasNext()) {
                    MatchingHandler.skipComments(matchNodes, patternNodes.current());
                }
            }
            if (patternNodes.hasNext()) {
                MatchingHandler nextHandler = context.getPattern().getHandler(patternNodes.current());
                if (nextHandler.matchSequentially(patternNodes, matchNodes, context)) {
                    return true;
                }
                patternNodes.rewindTo(currentPatternNode);
                matchNodes.rewindTo(currentMatchNode);
            } else {
                return handler.isMatchSequentiallySucceeded(matchNodes);
            }
        }
        return false;
    }

    private static void skipComments(@NotNull NodeIterator matchNodes, PsiElement patternNode) {
        if (matchNodes == null) {
            MatchingHandler.$$$reportNull$$$0(6);
        }
        if (patternNode instanceof PsiComment) {
            return;
        }
        while (matchNodes.current() instanceof PsiComment) {
            matchNodes.advance();
        }
    }

    private static void skipIfNecessary(@NotNull NodeIterator nodes, PsiElement elementToMatchWith, @NotNull MatchingStrategy strategy) {
        if (nodes == null) {
            MatchingHandler.$$$reportNull$$$0(7);
        }
        if (strategy == null) {
            MatchingHandler.$$$reportNull$$$0(8);
        }
        while (nodes.hasNext() && strategy.shouldSkip(nodes.current(), elementToMatchWith)) {
            nodes.advance();
        }
    }

    protected boolean isMatchSequentiallySucceeded(@NotNull NodeIterator matchNodes) {
        if (matchNodes == null) {
            MatchingHandler.$$$reportNull$$$0(9);
        }
        MatchingHandler.skipComments(matchNodes, null);
        return !matchNodes.hasNext();
    }

    public static boolean matchInAnyOrder(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchedNodes, @NotNull MatchContext context) {
        if (patternNodes == null) {
            MatchingHandler.$$$reportNull$$$0(10);
        }
        if (matchedNodes == null) {
            MatchingHandler.$$$reportNull$$$0(11);
        }
        if (context == null) {
            MatchingHandler.$$$reportNull$$$0(12);
        }
        if (patternNodes.hasNext() && !matchedNodes.hasNext()) {
            return MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
        }
        HashSet<PsiElement> matchedElements = null;
        while (patternNodes.hasNext()) {
            int matchedOccurs;
            MatchingHandler handler;
            block16: {
                PsiElement pinnedNode;
                PsiElement patternNode = patternNodes.current();
                patternNodes.advance();
                CompiledPattern pattern = context.getPattern();
                handler = pattern.getHandler(patternNode);
                matchedNodes.reset();
                boolean allElementsMatched = true;
                matchedOccurs = 0;
                do {
                    PsiElement matchedNode;
                    PsiElement psiElement = matchedNode = (pinnedNode = handler.getPinnedNode()) != null ? pinnedNode : matchedNodes.current();
                    if (pinnedNode == null) {
                        matchedNodes.advance();
                    }
                    if (matchedElements != null && matchedElements.contains(matchedNode)) continue;
                    allElementsMatched = false;
                    if (handler.match(patternNode, matchedNode, context)) {
                        ++matchedOccurs;
                        if (matchedElements == null) {
                            matchedElements = new HashSet<PsiElement>();
                        }
                        matchedElements.add(matchedNode);
                        if (handler.shouldAdvanceThePatternFor(patternNode, matchedNode)) {
                            break block16;
                        }
                    } else if (pinnedNode != null) {
                        return false;
                    }
                    clearingVisitor.clearState(pattern, patternNode);
                } while (matchedNodes.hasNext() && pinnedNode == null);
                if (!handler.validate(context, matchedOccurs)) {
                    return false;
                }
                if (allElementsMatched || !patternNodes.hasNext()) {
                    boolean result = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
                    if (result && matchedElements != null) {
                        context.notifyMatchedElements(matchedElements);
                    }
                    return result;
                }
            }
            if (handler.validate(context, matchedOccurs)) continue;
            return false;
        }
        boolean result = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
        if (result && matchedElements != null) {
            context.notifyMatchedElements(matchedElements);
        }
        return result;
    }

    protected static boolean validateSatisfactionOfHandlers(@NotNull NodeIterator patternNodes, @NotNull MatchContext context) {
        if (patternNodes == null) {
            MatchingHandler.$$$reportNull$$$0(13);
        }
        if (context == null) {
            MatchingHandler.$$$reportNull$$$0(14);
        }
        while (patternNodes.hasNext()) {
            if (!context.getPattern().getHandler(patternNodes.current()).validate(context, 0)) {
                return false;
            }
            patternNodes.advance();
        }
        return true;
    }

    public boolean validate(@NotNull MatchContext context, int matchedOccurs) {
        if (context == null) {
            MatchingHandler.$$$reportNull$$$0(15);
        }
        return matchedOccurs == 1;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean shouldAdvanceThePatternFor(@NotNull PsiElement patternElement, @NotNull PsiElement matchedElement) {
        if (patternElement == null) {
            MatchingHandler.$$$reportNull$$$0(16);
        }
        if (matchedElement == null) {
            MatchingHandler.$$$reportNull$$$0(17);
        }
        return true;
    }

    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    public void reset() {
    }

    public PsiElement getPinnedNode() {
        return this.pinnedElement;
    }

    public void setPinnedElement(@NotNull PsiElement pinnedElement) {
        if (pinnedElement == null) {
            MatchingHandler.$$$reportNull$$$0(18);
        }
        this.pinnedElement = pinnedElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNode";
                break;
            }
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNodes";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchNodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNodes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinnedElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/handlers/MatchingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canMatch";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "matchSequentially";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "skipComments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "skipIfNecessary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatchSequentiallySucceeded";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "matchInAnyOrder";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSatisfactionOfHandlers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAdvanceThePatternFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "setPinnedElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ClearStateVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private CompiledPattern pattern;

        ClearStateVisitor() {
            super(true);
        }

        public void visitElement(@NotNull PsiElement element) {
            MatchingHandler handler;
            if (element == null) {
                ClearStateVisitor.$$$reportNull$$$0(0);
            }
            if (this.pattern.isToResetHandler(element) && (handler = this.pattern.getHandlerSimple(element)) != null) {
                handler.reset();
            }
            super.visitElement(element);
        }

        synchronized void clearState(@NotNull CompiledPattern _pattern, @NotNull PsiElement el) {
            if (_pattern == null) {
                ClearStateVisitor.$$$reportNull$$$0(1);
            }
            if (el == null) {
                ClearStateVisitor.$$$reportNull$$$0(2);
            }
            this.pattern = _pattern;
            el.acceptChildren((PsiElementVisitor)this);
            this.pattern = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "el";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/handlers/MatchingHandler$ClearStateVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clearState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

