/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.api.actions.NotebookEditorRunActionsHandler;
import com.intellij.jupyter.core.core.impl.actions.JupyterCellData;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesDocumentUtils;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesEditorUtils;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.jupyter.core.core.impl.actions.RemoveOutputsUndoableAction;
import com.intellij.jupyter.core.core.impl.actions.SetOutputsUndoableAction;
import com.intellij.jupyter.core.core.impl.actions.UpdateCellUndoableAction;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.ActionDestination;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.core.api.psi.NotebookPsiFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001d\u0010\b\u001a\u0019\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\b\u000bJ4\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050\u000fH\u0086\b\u00f8\u0001\u0000J4\u0010\f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00072\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050\u000fH\u0086\b\u00f8\u0001\u0000J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J.\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J*\u0010 \u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ&\u0010#\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u001fJ.\u0010&\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010)\u001a\u0004\u0018\u00010*J.\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fJD\u0010/\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00112\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001c2\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000204J\u0018\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0011J\u0018\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0011J&\u0010:\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fJ0\u0010<\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00112\b\u0010?\u001a\u0004\u0018\u00010@J(\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\u0006\u0010D\u001a\u00020E2\u0006\u0010=\u001a\u00020\u001d2\b\u0010?\u001a\u0004\u0018\u00010@J$\u0010F\u001a\u00020\u001d2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001d0H2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006I"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionUtil;", "", "<init>", "()V", "withRunActionsHandler", "", "event", "Lcom/intellij/openapi/actionSystem/DataContext;", "handler", "Lkotlin/Function2;", "Lcom/intellij/jupyter/core/core/api/actions/NotebookEditorRunActionsHandler;", "Lkotlin/ExtensionFunctionType;", "withCellLinesAndSelection", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "func", "Lkotlin/Function3;", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "Lcom/intellij/notebooks/visualization/NotebookCellSelectionModel;", "dataContext", "updateCell", "editor", "Lcom/intellij/openapi/editor/Editor;", "index", "", "shiftCells", "cellLines", "shiftingCells", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "direction", "Lcom/intellij/jupyter/core/jupyter/actions/ActionDestination;", "moveCarets", "from", "to", "mergePrimaryCell", "cellSelection", "actionDest", "mergeCells", "target", "sources", "ptrFactory", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerFactory;", "pasteCell", "project", "Lcom/intellij/openapi/project/Project;", "selectionModel", "setCellData", "insertedCells", "clipboardJupyterCells", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterCellData;", "setCellId", "", "setCellType", "getUpdatedJupyterNotebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getUpdatedJupyterFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "expandSelection", "model", "trySplitCellAtOffset", "cell", "splitAtOffset", "editHelper", "Lcom/intellij/jupyter/core/core/api/actions/NotebookCellLinesEditHelper;", "makeCellWithText", "", "text", "document", "Lcom/intellij/openapi/editor/Document;", "findNewPrimaryCell", "removedCells", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCellLinesActionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellLinesActionUtil.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,386:1\n52#1:387\n53#1,2:389\n1#2:388\n1#2:391\n1586#3:392\n1661#3,3:393\n1915#3,2:396\n1915#3,2:398\n777#3:400\n873#3,2:401\n777#3:403\n873#3,2:404\n184#4,2:406\n184#4,2:408\n*S KotlinDebug\n*F\n+ 1 NotebookCellLinesActionUtil.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionUtil\n*L\n45#1:387\n45#1:389,2\n45#1:388\n103#1:392\n103#1:393,3\n112#1:396,2\n113#1:398,2\n166#1:400\n166#1:401,2\n167#1:403\n167#1:404,2\n377#1:406,2\n383#1:408,2\n*E\n"})
public final class NotebookCellLinesActionUtil {
    @NotNull
    public static final NotebookCellLinesActionUtil INSTANCE = new NotebookCellLinesActionUtil();

    private NotebookCellLinesActionUtil() {
    }

    public final void withRunActionsHandler(@NotNull DataContext event, @NotNull Function2<? super NotebookEditorRunActionsHandler, ? super DataContext, Unit> handler2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        NotebookPsiFile notebookPsiFile = JupyterDataContextExtensionsKt.getNotebookPsiFile(event);
        if (notebookPsiFile == null) {
            return;
        }
        NotebookPsiFile psiFile = notebookPsiFile;
        NotebookEditorRunActionsHandler notebookEditorRunActionsHandler = (NotebookEditorRunActionsHandler)NotebookEditorRunActionsHandler.Companion.forLanguage(psiFile.getLanguage());
        if (notebookEditorRunActionsHandler == null) {
            return;
        }
        NotebookEditorRunActionsHandler actionsHandler = notebookEditorRunActionsHandler;
        handler2.invoke((Object)actionsHandler, (Object)event);
    }

    public final void withCellLinesAndSelection(@NotNull AnActionEvent event, @NotNull Function3<? super EditorImpl, ? super NotebookCellLines, ? super NotebookCellSelectionModel, Unit> func) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        boolean $i$f$withCellLinesAndSelection = false;
        NotebookCellLinesActionUtil notebookCellLinesActionUtil = this;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext$iv = dataContext;
        boolean $i$f$withCellLinesAndSelection2 = false;
        Object object = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext$iv);
        if (object != null) {
            EditorImpl editorImpl;
            EditorImpl it$iv = editorImpl = object;
            boolean bl = false;
            object = NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it$iv)) ? editorImpl : null;
            if (object == null) {
            } else {
                EditorImpl editor$iv = object;
                NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor$iv));
                if (notebookCellSelectionModel != null) {
                    func.invoke((Object)editor$iv, (Object)NotebookCellLines.Companion.get((Editor)editor$iv), (Object)notebookCellSelectionModel);
                }
            }
        }
    }

    public final void withCellLinesAndSelection(@NotNull DataContext dataContext, @NotNull Function3<? super EditorImpl, ? super NotebookCellLines, ? super NotebookCellSelectionModel, Unit> func) {
        Object object;
        block5: {
            block4: {
                EditorImpl editorImpl;
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                Intrinsics.checkNotNullParameter(func, (String)"func");
                boolean $i$f$withCellLinesAndSelection = false;
                object = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
                if (object == null) break block4;
                EditorImpl it = editorImpl = object;
                boolean bl = false;
                object = NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it)) ? editorImpl : null;
                if (object != null) break block5;
            }
            return;
        }
        EditorImpl editor = object;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
        if (notebookCellSelectionModel == null) {
            return;
        }
        func.invoke((Object)editor, (Object)NotebookCellLines.Companion.get((Editor)editor), (Object)notebookCellSelectionModel);
    }

    public final void updateCell(@NotNull Editor editor, int index) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull(editor);
        if (jupyterNotebook == null) {
            return;
        }
        JupyterNotebook jupyterNotebook2 = jupyterNotebook;
        NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(editor);
        if (notebookIntervalPointerFactory == null) {
            return;
        }
        NotebookIntervalPointerFactory ptrFactory = notebookIntervalPointerFactory;
        NotebookIntervalPointer cellPointer = ptrFactory.getForOrdinalIfExists(index);
        if (cellPointer != null) {
            JupyterListenersKt.outputUpdated(jupyterNotebook2, cellPointer);
            JupyterListenersKt.executionInfoUpdated(jupyterNotebook2, cellPointer);
            JupyterListenersKt.tagsUpdated(jupyterNotebook2, cellPointer);
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    public final void shiftCells(@NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull List<NotebookCellLines.Interval> shiftingCells, @NotNull ActionDestination direction) {
        block11: {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
            Intrinsics.checkNotNullParameter(shiftingCells, (String)"shiftingCells");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            DocumentEx documentEx = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx document = documentEx;
            NotebookIntervalPointerFactory ptrFactory = NotebookIntervalPointerFactory.Companion.getOrNull((Editor)editor);
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)(((NotebookCellLines.Interval)CollectionsKt.first(shiftingCells)).getOrdinal() - 1));
                    if (interval == null) {
                        return;
                    }
                    pair = new Pair((Object)CollectionsKt.listOf((Object)interval), shiftingCells);
                    break;
                }
                case 2: {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)(((NotebookCellLines.Interval)CollectionsKt.last(shiftingCells)).getOrdinal() + 1));
                    if (interval == null) {
                        return;
                    }
                    pair = new Pair(shiftingCells, (Object)CollectionsKt.listOf((Object)interval));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            List upperCells = (List)pair2.component1();
            List lowerCells = (List)pair2.component2();
            NotebookCellsContents upperCellsContent = NotebookCellsContents.Companion.invoke((Editor)editor, upperCells);
            NotebookCellLinesEditHelper helper = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
            int targetOrdinal = ((NotebookCellLines.Interval)CollectionsKt.last((List)lowerCells)).getOrdinal() + 1;
            Object object = helper;
            if (object == null || (object = object.makeInsertedCells(upperCellsContent, targetOrdinal)) == null) {
                object = upperCellsContent.getRawText();
            }
            Object textToInsert = object;
            List insertedCells = NotebookCellLinesDocumentUtils.insertCells$default(NotebookCellLinesDocumentUtils.INSTANCE, (Document)document, cellLines, (String)textToInsert, targetOrdinal, false, 8, null);
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new UpdateCellUndoableAction((Editor)editor, upperCells, lowerCells));
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = ptrFactory;
            if (notebookIntervalPointerFactory != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = CollectionsKt.zip((Iterable)upperCells, (Iterable)insertedCells);
                NotebookIntervalPointerFactory notebookIntervalPointerFactory2 = notebookIntervalPointerFactory;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair3 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new NotebookIntervalPointerFactory.Swap(((NotebookCellLines.Interval)it.getFirst()).getOrdinal(), ((NotebookCellLines.Interval)it.getSecond()).getOrdinal()));
                }
                notebookIntervalPointerFactory2.modifyPointers((Iterable)((List)destination$iv$iv));
            }
            this.moveCarets((Editor)editor, upperCells, insertedCells);
            NotebookCellLinesDocumentUtils.INSTANCE.removeCells((Document)document, upperCells, ptrFactory);
            Iterable $this$forEach$iv = upperCells;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                boolean bl = false;
                INSTANCE.updateCell((Editor)editor, it.getOrdinal());
            }
            $this$forEach$iv = lowerCells;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                boolean bl = false;
                INSTANCE.updateCell((Editor)editor, it.getOrdinal());
            }
            NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
            if (notebookCellSelectionModel == null || (notebookCellSelectionModel = notebookCellSelectionModel.getPrimarySelectedCell()) == null || (notebookCellSelectionModel = notebookCellSelectionModel.getLines()) == null) break block11;
            int it = notebookCellSelectionModel.getFirst();
            boolean bl = false;
            NotebookCellLinesEditorUtils.INSTANCE.scrollTo((Editor)editor, it, ScrollType.MAKE_VISIBLE);
        }
    }

    public final void moveCarets(@NotNull Editor editor, @NotNull List<NotebookCellLines.Interval> from, @NotNull List<NotebookCellLines.Interval> to) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Map paired = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)from, (Iterable)to));
        editor.getCaretModel().runBatchCaretOperation(() -> NotebookCellLinesActionUtil.moveCarets$lambda$0(editor, from, paired));
    }

    public final void mergePrimaryCell(@NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel cellSelection, @NotNull ActionDestination actionDest) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
            Intrinsics.checkNotNullParameter((Object)cellSelection, (String)"cellSelection");
            Intrinsics.checkNotNullParameter((Object)((Object)actionDest), (String)"actionDest");
            NotebookCellLines.Interval target = cellSelection.getPrimarySelectedCell();
            int sourceIndex = switch (WhenMappings.$EnumSwitchMapping$0[actionDest.ordinal()]) {
                case 1 -> target.getOrdinal() - 1;
                case 2 -> target.getOrdinal() + 1;
                default -> throw new NoWhenBranchMatchedException();
            };
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)sourceIndex);
            if (interval == null) break block4;
            NotebookCellLines.Interval source = interval;
            boolean bl = false;
            cellSelection.selectSingleCell(target);
            INSTANCE.mergeCells(editor, target, CollectionsKt.listOf((Object)source), NotebookIntervalPointerFactory.Companion.getOrNull((Editor)editor));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeCells(@NotNull EditorImpl editor, @NotNull NotebookCellLines.Interval target, @NotNull List<NotebookCellLines.Interval> sources, @Nullable NotebookIntervalPointerFactory ptrFactory) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        Iterable $this$filter$iv = sources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv$iv;
            boolean bl = false;
            if (!(it.getOrdinal() < target.getOrdinal())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cellsAbove = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv2 = sources;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv$iv;
            boolean bl = false;
            if (!(it.getOrdinal() > target.getOrdinal())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List cellsBelow = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
        if (!((Collection)cellsBelow).isEmpty()) {
            String contentBelow = CollectionsKt.joinToString$default((Iterable)cellsBelow, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> NotebookCellLinesActionUtil.mergeCells$lambda$2(document, arg_0), (int)30, null);
            undoManager.undoableActionPerformed((UndoableAction)new RemoveOutputsUndoableAction((Editor)editor, cellsBelow));
            NotebookCellLinesDocumentUtils.INSTANCE.removeCells((Document)document, cellsBelow, ptrFactory);
            document.insertString(document.getLineEndOffset(target.getLastContentLine()), (CharSequence)("\n" + contentBelow));
        }
        if (!((Collection)cellsAbove).isEmpty()) {
            String contentAbove = CollectionsKt.joinToString$default((Iterable)cellsAbove, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> NotebookCellLinesActionUtil.mergeCells$lambda$3(document, arg_0), (int)30, null);
            document.insertString(document.getLineStartOffset(target.getFirstContentLine()), (CharSequence)(contentAbove + "\n"));
            undoManager.undoableActionPerformed((UndoableAction)new RemoveOutputsUndoableAction((Editor)editor, cellsAbove));
            NotebookCellLinesDocumentUtils.INSTANCE.removeCells((Document)document, cellsAbove, ptrFactory);
        }
    }

    public final void pasteCell(@NotNull Project project, @NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel selectionModel, @NotNull ActionDestination direction) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        NotebookCellsContents notebookCellsContents = NotebookCellsContents.Companion.getFromClipboard();
        if (notebookCellsContents == null) {
            return;
        }
        NotebookCellsContents cellsToInsert = notebookCellsContents;
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int targetOrdinal = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> ((NotebookCellLines.Interval)CollectionsKt.first((List)selectionModel.getPrimarySelectedRegion())).getOrdinal();
            case 2 -> {
                if (document.getTextLength() > 0) {
                    yield ((NotebookCellLines.Interval)CollectionsKt.last((List)selectionModel.getPrimarySelectedRegion())).getOrdinal() + 1;
                }
                yield 0;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
        String textToInsert = notebookCellLinesEditHelper != null && (string = notebookCellLinesEditHelper.makeInsertedCells(cellsToInsert, targetOrdinal)) != null ? string : cellsToInsert.getRawText();
        List insertedCells = NotebookCellLinesDocumentUtils.insertCells$default(NotebookCellLinesDocumentUtils.INSTANCE, (Document)document, cellLines, textToInsert, targetOrdinal, false, 8, null);
        selectionModel.selectSingleCell((NotebookCellLines.Interval)CollectionsKt.first((List)insertedCells));
        List<JupyterCellData> list = cellsToInsert.getJupyterCells();
        if (list != null) {
            List<JupyterCellData> outputData = list;
            boolean bl = false;
            NotebookCellLinesActionUtil.setCellData$default(INSTANCE, (Editor)editor, cellLines, insertedCells, outputData, false, false, 32, null);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new SetOutputsUndoableAction((Editor)editor, insertedCells, outputData));
        }
        NotebookCellLinesEditorUtils.INSTANCE.scrollTo((Editor)editor, ((NotebookCellLines.Interval)CollectionsKt.first((List)insertedCells)).getLines().getFirst(), ScrollType.MAKE_VISIBLE);
    }

    public final void setCellData(@NotNull Editor editor, @NotNull NotebookCellLines cellLines, @NotNull List<NotebookCellLines.Interval> insertedCells, @NotNull List<JupyterCellData> clipboardJupyterCells, boolean setCellId, boolean setCellType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter(insertedCells, (String)"insertedCells");
        Intrinsics.checkNotNullParameter(clipboardJupyterCells, (String)"clipboardJupyterCells");
        JupyterNotebook jupyterNotebook = this.getUpdatedJupyterNotebook(editor, cellLines);
        if (jupyterNotebook == null) {
            return;
        }
        JupyterNotebook jupyterNotebook2 = jupyterNotebook;
        for (Pair pair : CollectionsKt.zip((Iterable)clipboardJupyterCells, (Iterable)insertedCells)) {
            JupyterCellData jupyterData = (JupyterCellData)pair.component1();
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)pair.component2();
            int ordinal = interval.getOrdinal();
            JupyterCell cell = jupyterNotebook2.getCell(ordinal);
            jupyterData.setToCell(cell, setCellId, setCellType);
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(editor);
            if (notebookIntervalPointerFactory == null || (notebookIntervalPointerFactory = notebookIntervalPointerFactory.getForOrdinalIfExists(ordinal)) == null) continue;
            NotebookIntervalPointerFactory intervalPointer = notebookIntervalPointerFactory;
            JupyterListenersKt.outputUpdated(jupyterNotebook2, (NotebookIntervalPointer)intervalPointer);
            JupyterListenersKt.executionInfoUpdated(jupyterNotebook2, (NotebookIntervalPointer)intervalPointer);
            JupyterListenersKt.tagsUpdated(jupyterNotebook2, (NotebookIntervalPointer)intervalPointer);
            NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get(editor);
            if (notebookCellInlayManager == null || (notebookCellInlayManager = notebookCellInlayManager.getCell(ordinal)) == null) continue;
            notebookCellInlayManager.update();
        }
    }

    public static /* synthetic */ void setCellData$default(NotebookCellLinesActionUtil notebookCellLinesActionUtil, Editor editor, NotebookCellLines notebookCellLines, List list, List list2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        notebookCellLinesActionUtil.setCellData(editor, notebookCellLines, list, list2, bl, bl2);
    }

    @Nullable
    public final JupyterNotebook getUpdatedJupyterNotebook(@NotNull Editor editor, @NotNull NotebookCellLines cellLines) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        BackedNotebookVirtualFile backedNotebookVirtualFile = this.getUpdatedJupyterFile(editor, cellLines);
        return backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getNotebook() : null;
    }

    @Nullable
    public final BackedNotebookVirtualFile getUpdatedJupyterFile(@NotNull Editor editor, @NotNull NotebookCellLines cellLines) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile jupyterFile = backedNotebookVirtualFile;
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        boolean bl2 = bl = jupyterFile.getNotebook().cellsCount() == cellLines.getIntervals().size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Jupyter Notebook hasn't updated model yet";
            throw new AssertionError((Object)string);
        }
        return jupyterFile;
    }

    public final void expandSelection(@NotNull Editor editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel model, @NotNull ActionDestination direction) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        NotebookCellLines.Interval primaryCell = model.getPrimarySelectedCell();
        List primarySelectedRegion = model.getPrimarySelectedRegion();
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)CollectionsKt.last((List)primarySelectedRegion), (Object)primaryCell)) {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)(((NotebookCellLines.Interval)CollectionsKt.first((List)primarySelectedRegion)).getOrdinal() - 1));
                    if (interval != null) {
                        NotebookCellLines.Interval it = interval;
                        boolean bl = false;
                        NotebookCellSelectionModel.selectCell$default((NotebookCellSelectionModel)model, (NotebookCellLines.Interval)it, (boolean)false, (int)2, null);
                        NotebookCellLinesEditorUtils.INSTANCE.scrollTo(editor, it.getLines().getFirst(), ScrollType.MAKE_VISIBLE);
                    }
                    break;
                }
                model.removeSelection((NotebookCellLines.Interval)CollectionsKt.last((List)primarySelectedRegion));
                NotebookCellLinesEditorUtils.INSTANCE.scrollTo(editor, ((NotebookCellLines.Interval)primarySelectedRegion.get(CollectionsKt.getLastIndex((List)primarySelectedRegion) - 1)).getLines().getFirst(), ScrollType.MAKE_VISIBLE);
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)CollectionsKt.first((List)primarySelectedRegion), (Object)primaryCell)) {
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)(((NotebookCellLines.Interval)CollectionsKt.last((List)primarySelectedRegion)).getOrdinal() + 1));
                    if (interval != null) {
                        NotebookCellLines.Interval it = interval;
                        boolean bl = false;
                        NotebookCellSelectionModel.selectCell$default((NotebookCellSelectionModel)model, (NotebookCellLines.Interval)it, (boolean)false, (int)2, null);
                        NotebookCellLinesEditorUtils.INSTANCE.scrollTo(editor, it.getLines().getLast(), ScrollType.MAKE_VISIBLE);
                    }
                    break;
                }
                model.removeSelection((NotebookCellLines.Interval)CollectionsKt.first((List)primarySelectedRegion));
                NotebookCellLinesEditorUtils.INSTANCE.scrollTo(editor, ((NotebookCellLines.Interval)primarySelectedRegion.get(1)).getLines().getLast(), ScrollType.MAKE_VISIBLE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ((EditorEx)editor).getGutterComponentEx().repaint();
    }

    public final void trySplitCellAtOffset(@NotNull Editor editor, @NotNull NotebookCellLines.Interval cell, int splitAtOffset, @NotNull NotebookCellLines cellLines, @Nullable NotebookCellLinesEditHelper editHelper) {
        block9: {
            String string;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
            NotebookCellsContents oldCellsContent = NotebookCellsContents.Companion.invoke((Editor)((EditorImpl)editor), CollectionsKt.listOf((Object)cell));
            Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
            if (object == null || (object = object.getNotebook()) == null) {
                return;
            }
            Object notebook = object;
            DocumentEx documentEx = ((EditorImpl)editor).getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx document = documentEx;
            if (editHelper == null && !cell.getMarkers().getHasTopLine() && !cell.getMarkers().getHasBottomLine()) {
                return;
            }
            if (Math.max(1, document.getLineCount()) <= cell.getFirstContentLine()) {
                return;
            }
            int startOffset = document.getLineStartOffset(cell.getFirstContentLine());
            int endOffset = document.getLineEndOffset(cell.getLastContentLine());
            if (!(startOffset <= splitAtOffset ? splitAtOffset <= endOffset : false)) {
                return;
            }
            int splitAtLine = document.getLineNumber(splitAtOffset);
            boolean isAtLineStart = document.getLineStartOffset(splitAtLine) == splitAtOffset;
            boolean isAtLineEnd = document.getLineEndOffset(splitAtLine) == splitAtOffset;
            String it = document.getText(new TextRange(splitAtOffset, endOffset));
            boolean bl = false;
            if (isAtLineEnd && !isAtLineStart) {
                Intrinsics.checkNotNull((Object)it);
                string = StringsKt.drop((String)it, (int)1);
            } else {
                Intrinsics.checkNotNull((Object)it);
                string = it;
            }
            String textBelow = string;
            String newCellText = this.makeCellWithText(textBelow, (Document)document, cell, editHelper);
            List<NotebookCellLines.Interval> newCells = NotebookCellLinesDocumentUtils.INSTANCE.insertCells((Document)document, cellLines, newCellText, cell.getOrdinal() + 1, true);
            ((EditorImpl)editor).getCaretModel().getPrimaryCaret().moveToLogicalPosition(new LogicalPosition(((NotebookCellLines.Interval)CollectionsKt.first(newCells)).getFirstContentLine(), 0));
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.singleOrNull(newCells);
            if (interval != null) {
                NotebookCellLines.Interval newCell = interval;
                boolean bl2 = false;
                NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(editor);
                if (notebookIntervalPointerFactory != null) {
                    notebookIntervalPointerFactory.modifyPointers((Iterable)CollectionsKt.listOf((Object)new NotebookIntervalPointerFactory.Swap(cell.getOrdinal(), newCell.getOrdinal())));
                }
            }
            int deleteStartOffset = isAtLineStart && splitAtLine > cell.getFirstContentLine() ? splitAtOffset - 1 : splitAtOffset;
            document.deleteString(deleteStartOffset, endOffset);
            List<JupyterCellData> list = oldCellsContent.getJupyterCells();
            if (list != null) {
                List<JupyterCellData> outputData = list;
                boolean bl3 = false;
                NotebookCellLinesActionUtil.setCellData$default(INSTANCE, editor, cellLines, newCells, outputData, false, false, 32, null);
                Project project = ((EditorImpl)editor).getProject();
                Intrinsics.checkNotNull((Object)project);
                UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new SetOutputsUndoableAction(editor, newCells, outputData));
            }
            notebook.getCell(cell.getOrdinal()).setOutputs(null);
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(editor);
            if (notebookIntervalPointerFactory == null || (notebookIntervalPointerFactory = notebookIntervalPointerFactory.getForOrdinalIfExists(cell.getOrdinal())) == null) break block9;
            NotebookIntervalPointerFactory it2 = notebookIntervalPointerFactory;
            boolean bl4 = false;
            JupyterListenersKt.outputUpdated((JupyterNotebook)notebook, (NotebookIntervalPointer)it2);
            JupyterListenersKt.executionInfoUpdated((JupyterNotebook)notebook, (NotebookIntervalPointer)it2);
        }
    }

    @NotNull
    public final String makeCellWithText(@NotNull String text, @NotNull Document document, @NotNull NotebookCellLines.Interval cell, @Nullable NotebookCellLinesEditHelper editHelper) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Object object = editHelper;
        if (object == null || (object = NotebookCellLinesEditHelper.makeCell$default((NotebookCellLinesEditHelper)object, text, cell.getType(), null, 4, null)) == null) {
            Object[] objectArray = new String[]{cell.getTopMarker(document), text, cell.getBottomMarker(document)};
            object = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return object;
    }

    @NotNull
    public final NotebookCellLines.Interval findNewPrimaryCell(@NotNull Set<NotebookCellLines.Interval> removedCells, @NotNull NotebookCellSelectionModel selectionModel, @NotNull NotebookCellLines cellLines) {
        NotebookCellLines.Interval cellBeforePrimary;
        Object v1;
        block6: {
            Object v0;
            List allCells;
            NotebookCellLines.Interval currentPrimaryCell;
            block5: {
                Intrinsics.checkNotNullParameter(removedCells, (String)"removedCells");
                Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
                Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
                if (removedCells.size() == cellLines.getIntervals().size()) {
                    return (NotebookCellLines.Interval)CollectionsKt.first((List)cellLines.getIntervals());
                }
                currentPrimaryCell = selectionModel.getPrimarySelectedCell();
                if (!removedCells.contains(selectionModel.getPrimarySelectedCell())) {
                    return currentPrimaryCell;
                }
                allCells = cellLines.getIntervals();
                Sequence $this$firstOrNull$iv = SequencesKt.drop((Sequence)SequencesKt.asSequence((Iterator)allCells.listIterator(currentPrimaryCell.getOrdinal())), (int)1);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                    boolean bl = false;
                    if (!(!removedCells.contains(it))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            NotebookCellLines.Interval cellAfterPrimary = v0;
            if (cellAfterPrimary != null) {
                return cellAfterPrimary;
            }
            Sequence $this$firstOrNull$iv = SequencesKt.drop((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.asReversed((List)allCells).listIterator(CollectionsKt.getLastIndex((List)allCells) - currentPrimaryCell.getOrdinal())), (int)1);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                boolean bl = false;
                if (!(!removedCells.contains(it))) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        NotebookCellLines.Interval interval = cellBeforePrimary = (NotebookCellLines.Interval)v1;
        Intrinsics.checkNotNull((Object)interval);
        return interval;
    }

    private static final void moveCarets$lambda$0(Editor $editor, List $from, Map $paired) {
        for (Caret caret : $editor.getCaretModel().getAllCarets()) {
            NotebookCellLines.Interval toCell;
            NotebookCellLines.Interval fromCell;
            Object v1;
            LogicalPosition caretPos;
            int n;
            int n2;
            block2: {
                Intrinsics.checkNotNullExpressionValue((Object)caret.getLogicalPosition(), (String)"getLogicalPosition(...)");
                Iterable iterable = $from;
                for (Object t : iterable) {
                    NotebookCellLines.Interval it = (NotebookCellLines.Interval)t;
                    boolean bl = false;
                    IntRange intRange = it.getLines();
                    n2 = intRange.getFirst();
                    n = intRange.getLast();
                    int n3 = caretPos.line;
                    boolean bl2 = n2 <= n3 ? n3 <= n : false;
                    if (!bl2) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            if ((NotebookCellLines.Interval)v1 == null) continue;
            boolean bl = false;
            if ((NotebookCellLines.Interval)$paired.get(fromCell) == null) continue;
            boolean bl3 = false;
            IntRange intRange = fromCell.getContentLines();
            int n4 = intRange.getFirst();
            n2 = intRange.getLast();
            n = caretPos.line;
            int shift = (n4 <= n ? n <= n2 : false) ? toCell.getFirstContentLine() - fromCell.getFirstContentLine() : toCell.getLines().getFirst() - fromCell.getLines().getFirst();
            caret.moveToLogicalPosition(new LogicalPosition(caretPos.line + shift, caretPos.column));
        }
    }

    private static final CharSequence mergeCells$lambda$2(DocumentEx $document, NotebookCellLines.Interval it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContentText((Document)$document);
    }

    private static final CharSequence mergeCells$lambda$3(DocumentEx $document, NotebookCellLines.Interval it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContentText((Document)$document);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionDestination.values().length];
            try {
                nArray[ActionDestination.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionDestination.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

