/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.convert;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdaterKt;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverter;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtil;
import com.intellij.jupyter.core.fus.LoggableNotebookAction;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.lang.JupyterLangData;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellTypeProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0016B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertCellAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/notebooks/ui/editor/actions/JupyterEditorAction;", "Lcom/intellij/jupyter/core/fus/LoggableNotebookAction;", "jupyterCellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "popupPresentationTextKey", "", "<init>", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;Ljava/lang/String;)V", "actionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabledAndVisible", "", "actionPerformed", "createActionUpdater", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookConvertCellAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookConvertCellAction.kt\ncom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertCellAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 NotebookCellLinesActionUtil.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionUtil\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1807#2,3:87\n45#3,8:90\n53#3,2:99\n1#4:98\n*S KotlinDebug\n*F\n+ 1 NotebookConvertCellAction.kt\ncom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertCellAction\n*L\n57#1:87,3\n63#1:90,8\n63#1:99,2\n63#1:98\n*E\n"})
public class NotebookConvertCellAction
extends DumbAwareAction
implements JupyterEditorAction,
LoggableNotebookAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterCellType jupyterCellType;
    @NotNull
    private final String popupPresentationTextKey;
    @NotNull
    private final JupyterActonUpdater actionUpdater;

    public NotebookConvertCellAction(@NotNull JupyterCellType jupyterCellType, @NotNull String popupPresentationTextKey) {
        Intrinsics.checkNotNullParameter((Object)jupyterCellType, (String)"jupyterCellType");
        Intrinsics.checkNotNullParameter((Object)popupPresentationTextKey, (String)"popupPresentationTextKey");
        this.jupyterCellType = jupyterCellType;
        this.popupPresentationTextKey = popupPresentationTextKey;
        this.actionUpdater = this.createActionUpdater();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public final void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.actionUpdater.update(this, event, (Function1<? super AnActionEvent, Unit>)((Function1)arg_0 -> NotebookConvertCellAction.update$lambda$0(event, this, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEnabledAndVisible(AnActionEvent event) {
        boolean bl;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return false;
        }
        EditorImpl editor = editorImpl;
        if (!NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)editor))) {
            return false;
        }
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
        if (notebookCellLinesEditHelper == null) return false;
        if (!notebookCellLinesEditHelper.isChangingCellTypeAllowed()) return false;
        boolean bl2 = true;
        if (!bl2) {
            return false;
        }
        JupyterLangData jupyterLangData = JupyterLangData.Companion.getDataByJupyterCellType(JupyterEditorExtensionsKt.getNotebookFile((Editor)editor), JupyterCellTypeProvider.Companion.providerByType(this.jupyterCellType));
        if (jupyterLangData == null) {
            return false;
        }
        JupyterLangData cellTypeData = jupyterLangData;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
        Intrinsics.checkNotNull((Object)notebookCellSelectionModel);
        Iterable $this$any$iv = notebookCellSelectionModel.getSelectedCells();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(it), (Object)cellTypeData.getJupyterCellType())) {
                boolean bl4;
                JupyterCellTypeProvider jupyterCellTypeProvider = JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellTypeProvider(it);
                if (jupyterCellTypeProvider != null) {
                    if (jupyterCellTypeProvider.isConvertActionSupported()) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NotebookCellLinesActionUtil notebookCellLinesActionUtil = NotebookCellLinesActionUtil.INSTANCE;
        AnActionEvent event$iv = event;
        boolean $i$f$withCellLinesAndSelection = false;
        void var5_5 = this_$iv;
        DataContext dataContext = event$iv.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext$iv$iv = dataContext;
        boolean $i$f$withCellLinesAndSelection2 = false;
        Object object = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext$iv$iv);
        if (object != null) {
            EditorImpl editorImpl;
            EditorImpl it$iv$iv = editorImpl = object;
            boolean bl = false;
            object = NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it$iv$iv)) ? editorImpl : null;
            if (object == null) {
            } else {
                EditorImpl editor$iv$iv;
                NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor$iv$iv));
                if (notebookCellSelectionModel != null) {
                    void cellSelection;
                    void cellLines;
                    NotebookCellSelectionModel notebookCellSelectionModel2 = notebookCellSelectionModel;
                    NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get((Editor)editor$iv$iv);
                    EditorImpl editor = editor$iv$iv = object;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{Companion.makeName(this.jupyterCellType)};
                    String actionName = JupyterBundle.message("convert.cell.command.name", objectArray);
                    Project project = event.getProject();
                    if (project == null) {
                        return;
                    }
                    WriteCommandAction.writeCommandAction((Project)project).withName(actionName).run(() -> NotebookConvertCellAction.actionPerformed$lambda$0$0(editor, this, (NotebookCellLines)cellLines, (NotebookCellSelectionModel)cellSelection));
                }
            }
        }
    }

    @NotNull
    public JupyterActonUpdater createActionUpdater() {
        return JupyterActonUpdaterKt.getJupyterActionUpdater().derive((Function1<? super JupyterActonUpdater.Builder, Unit>)((Function1)arg_0 -> NotebookConvertCellAction.createActionUpdater$lambda$0(this, arg_0)));
    }

    private static final Unit update$lambda$0(AnActionEvent $event, NotebookConvertCellAction this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)$event.getPlace(), (Object)"popup")) {
            $event.getPresentation().setText(JupyterBundle.message(this$0.popupPresentationTextKey, new Object[0]));
        }
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$0$0(EditorImpl $editor, NotebookConvertCellAction this$0, NotebookCellLines $cellLines, NotebookCellSelectionModel $cellSelection) {
        JupyterLangData jupyterLangData = JupyterLangData.Companion.getDataByJupyterCellType(JupyterEditorExtensionsKt.getNotebookFile((Editor)$editor), JupyterCellTypeProvider.Companion.providerByType(this$0.jupyterCellType));
        if (jupyterLangData == null) {
            return;
        }
        JupyterLangData cellType = jupyterLangData;
        NotebookCellConverter.Companion.convertCells((Editor)$editor, $cellLines, $cellSelection, cellType);
        if (cellType.getCellType() == CellType.MARKDOWN) {
            NotebookEditorModeKt.setMode((Editor)((Editor)$editor), (NotebookEditorMode)NotebookEditorMode.COMMAND);
        }
    }

    private static final boolean createActionUpdater$lambda$0$0(NotebookConvertCellAction this$0, JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this$0.isEnabledAndVisible(event);
    }

    private static final Unit createActionUpdater$lambda$0(NotebookConvertCellAction this$0, JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)(arg_0, arg_1) -> NotebookConvertCellAction.createActionUpdater$lambda$0$0(this$0, arg_0, arg_1)));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/convert/NotebookConvertCellAction$Companion;", "", "<init>", "()V", "makeName", "", "cellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String makeName(@NotNull JupyterCellType cellType) {
            Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
            String string = cellType.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = Strings.capitalize((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

