/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0006R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/JupyterNotebookLanguageUtils;", "", "<init>", "()V", "NOTEBOOK_LANGUAGE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/Language;", "getNotebookLanguage", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "setNotebookLanguage", "", "language", "intellij.jupyter.core"})
public final class JupyterNotebookLanguageUtils {
    @NotNull
    public static final JupyterNotebookLanguageUtils INSTANCE = new JupyterNotebookLanguageUtils();
    @NotNull
    private static final Key<Language> NOTEBOOK_LANGUAGE = new Key("NOTEBOOK_LANGUAGE");

    private JupyterNotebookLanguageUtils() {
    }

    @Nullable
    public final Language getNotebookLanguage(@NotNull VirtualFile file) {
        Language savedNotebookLanguage;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile originalFile = JupyterFileUtils.INSTANCE.getOriginalFile(file);
        Language cachedUserDataLanguage = (Language)originalFile.getUserData(NOTEBOOK_LANGUAGE);
        if (cachedUserDataLanguage != null) {
            return cachedUserDataLanguage;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(originalFile);
        Object object = backedNotebookVirtualFile;
        Language language = object != null && (object = object.getNotebookOrNull()) != null ? object.getLanguage() : (savedNotebookLanguage = null);
        if (savedNotebookLanguage != null) {
            this.setNotebookLanguage(originalFile, savedNotebookLanguage);
            return savedNotebookLanguage;
        }
        return null;
    }

    public final void setNotebookLanguage(@NotNull VirtualFile file, @Nullable Language language) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile originalFile = JupyterFileUtils.INSTANCE.getOriginalFile(file);
        originalFile.putUserData(NOTEBOOK_LANGUAGE, (Object)language);
    }
}

