/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.handlers;

import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandler;
import com.intellij.lang.Language;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/editor/handlers/LanguageTableDataFileDropHandler;", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandler;", "language", "Lcom/intellij/lang/Language;", "commandName", "", "fileExtensions", "", "<init>", "(Lcom/intellij/lang/Language;Ljava/lang/String;Ljava/util/Set;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getCommandName", "()Ljava/lang/String;", "isApplicable", "", "fileExtension", "intellij.jupyter.core"})
public abstract class LanguageTableDataFileDropHandler
implements TableDataFileDropHandler {
    @NotNull
    private final Language language;
    @NotNull
    private final String commandName;
    @NotNull
    private final Set<String> fileExtensions;

    public LanguageTableDataFileDropHandler(@NotNull Language language, @Nls @NotNull String commandName, @NotNull Set<String> fileExtensions) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        Intrinsics.checkNotNullParameter(fileExtensions, (String)"fileExtensions");
        this.language = language;
        this.commandName = commandName;
        this.fileExtensions = fileExtensions;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @Override
    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public boolean isApplicable(@NotNull Language language, @NotNull String fileExtension) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        return language.isKindOf(this.language) && this.fileExtensions.contains(fileExtension);
    }
}

