/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.outputs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.core.jupyter.nbformat.outputs.JacksonUtil;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/outputs/JupyterMessageToOutputMapper;", "", "<init>", "()V", "DATA_KEY", "", "METADATA_KEY", "EXEC_COUNT_KEY", "TEXT_MIMETYPES", "", "createOutputJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "isExecuteResult", "", "transformTextToLines", "data", "convertToJupyterArray", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "text", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterMessageToOutputMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterMessageToOutputMapper.kt\ncom/intellij/jupyter/core/jupyter/nbformat/outputs/JupyterMessageToOutputMapper\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,65:1\n19#2:66\n*S KotlinDebug\n*F\n+ 1 JupyterMessageToOutputMapper.kt\ncom/intellij/jupyter/core/jupyter/nbformat/outputs/JupyterMessageToOutputMapper\n*L\n24#1:66\n*E\n"})
public final class JupyterMessageToOutputMapper {
    @NotNull
    public static final JupyterMessageToOutputMapper INSTANCE = new JupyterMessageToOutputMapper();
    @NotNull
    private static final String DATA_KEY = "data";
    @NotNull
    private static final String METADATA_KEY = "metadata";
    @NotNull
    private static final String EXEC_COUNT_KEY = "execution_count";
    @NotNull
    private static final Set<String> TEXT_MIMETYPES;

    private JupyterMessageToOutputMapper() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ObjectNode createOutputJson(@NotNull JupyterMessage message, boolean isExecuteResult) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$createOutputJson_u24lambda_u240 = var4_3 = JupyterJsonKt.getJackson().createObjectNode();
        $i$a$-apply-JupyterMessageToOutputMapper$createOutputJson$root$1 = false;
        v0 = message.getMessageContent().get("data");
        if (v0 == null) ** GOTO lbl-1000
        $this$asSafely$iv = v0;
        $i$f$asSafely = false;
        v1 = $this$asSafely$iv;
        if (!(v1 instanceof ObjectNode)) {
            v1 = null;
        }
        if ((v0 = (ObjectNode)v1) != null) {
            it = v0;
            $i$a$-let-JupyterMessageToOutputMapper$createOutputJson$root$1$dataNode$1 = false;
            v2 = JupyterMessageToOutputMapper.INSTANCE.transformTextToLines((ObjectNode)it);
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        dataNode = v2;
        $this$createOutputJson_u24lambda_u240.set("data", (JsonNode)dataNode);
        $this$createOutputJson_u24lambda_u240.set("metadata", message.getMessageContent().get("metadata"));
        if (isExecuteResult) {
            v3 = message.getMessageContent().get("execution_count");
            $this$createOutputJson_u24lambda_u240.put("execution_count", v3 != null ? v3.asLong() : 0L);
        }
        Intrinsics.checkNotNull((Object)$this$createOutputJson_u24lambda_u240);
        JacksonUtil.INSTANCE.setOutputType($this$createOutputJson_u24lambda_u240, message);
        root = var4_3;
        Intrinsics.checkNotNull((Object)root);
        return root;
    }

    public static /* synthetic */ ObjectNode createOutputJson$default(JupyterMessageToOutputMapper jupyterMessageToOutputMapper, JupyterMessage jupyterMessage, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jupyterMessageToOutputMapper.createOutputJson(jupyterMessage, bl);
    }

    private final ObjectNode transformTextToLines(ObjectNode data) {
        ObjectNode newNode = JupyterJsonKt.getJackson().createObjectNode();
        for (Map.Entry entry : data.properties()) {
            JsonNode jsonNode;
            Intrinsics.checkNotNull((Object)entry);
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (TEXT_MIMETYPES.contains(key) && value instanceof TextNode) {
                String string = ((TextNode)value).asText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
                jsonNode = newNode.set(key, (JsonNode)this.convertToJupyterArray(string));
                continue;
            }
            jsonNode = newNode.replace(key, value);
        }
        Intrinsics.checkNotNull((Object)newNode);
        return newNode;
    }

    private final ArrayNode convertToJupyterArray(String text) {
        ArrayNode array = JupyterJsonKt.getJackson().createArrayNode();
        int lastNewLineIndex = -1;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            String line;
            int i2 = i;
            char c = text.charAt(i);
            if (c != '\n' && i2 != StringsKt.getLastIndex((CharSequence)text)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)text.substring(lastNewLineIndex + 1, i2 + 1), (String)"substring(...)");
            array.add(line);
            lastNewLineIndex = i2;
        }
        Intrinsics.checkNotNull((Object)array);
        return array;
    }

    static {
        Object[] objectArray = new String[]{MimeType.TEXT_HTML.getMimeType(), MimeType.TEXT_PLAIN.getMimeType()};
        TEXT_MIMETYPES = SetsKt.setOf((Object[])objectArray);
    }
}

